/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rahas.TokenPersister;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.util.AxiomParserPool;
import org.opensaml.DefaultBootstrap;
import org.opensaml.XML;
import org.opensaml.xml.ConfigurationException;

public class Rahas
implements Module {
    private static final Log log = LogFactory.getLog(Rahas.class);
    private static TokenPersister tokenPersister = null;
    private static TokenStorage tokenStore = null;

    public void init(ConfigurationContext configurationContext, AxisModule axisModule) throws AxisFault {
        if (TrustUtil.isDoomParserPoolUsed()) {
            XML.parserPool = new AxiomParserPool();
            try {
                DefaultBootstrap.bootstrap();
            }
            catch (ConfigurationException ex) {
                throw new AxisFault("Failed to bootstrap OpenSAML", (Throwable)ex);
            }
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        if (tokenPersister != null && tokenStore != null) {
            try {
                tokenStore.handlePersistenceOnShutdown();
            }
            catch (TrustException e) {
                String errorMessage = "Error in token persistence when Rahas module shutting down.";
                log.error((Object)errorMessage, (Throwable)e);
                throw new AxisFault(errorMessage, (Throwable)e);
            }
        }
    }

    public static void setPersistanceStorage(TokenPersister persister, TokenStorage storage) {
        if (tokenPersister == null) {
            tokenPersister = persister;
        }
        if (tokenStore == null) {
            tokenStore = storage;
        }
    }
}

