/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.management;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.common.AbstractInboundEndpointManager;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointInfoDTO;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketChannelInitializer;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketEventExecutor;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketSourceHandler;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.PipelineHandlerBuilderUtil;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.SubprotocolBuilderUtil;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.configuration.NettyThreadPoolConfiguration;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketEventExecutorManager;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketSubscriberPathManager;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.ssl.InboundWebsocketSSLConfiguration;

public class WebsocketEndpointManager
extends AbstractInboundEndpointManager {
    private static WebsocketEndpointManager instance = null;
    private InboundWebsocketSourceHandler sourceHandler;
    private static final Log log = LogFactory.getLog(WebsocketEndpointManager.class);

    protected WebsocketEndpointManager() {
    }

    public static WebsocketEndpointManager getInstance() {
        if (instance == null) {
            instance = new WebsocketEndpointManager();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean startEndpoint(int port, String name, InboundProcessorParams params) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        String epName = this.dataStore.getListeningEndpointName(port, tenantDomain);
        if (epName != null) {
            if (epName.equalsIgnoreCase(name)) {
                log.info((Object)(epName + " Endpoint is already started in port : " + port));
                return true;
            }
            String msg = "Another endpoint named : " + epName + " is currently using this port: " + port;
            log.warn((Object)msg);
            throw new SynapseException(msg);
        }
        this.dataStore.registerListeningEndpoint(port, tenantDomain, "ws", name, params);
        boolean start = this.startListener(port, name, params);
        if (start) {
            return true;
        }
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean startSSLEndpoint(int port, String name, InboundProcessorParams params) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = carbonContext.getTenantDomain();
        String epName = this.dataStore.getListeningEndpointName(port, tenantDomain);
        if (epName != null) {
            if (epName.equalsIgnoreCase(name)) {
                log.info((Object)(epName + " Endpoint is already started in port : " + port));
                return true;
            }
            String msg = "Another endpoint named : " + epName + " is currently using this port: " + port;
            log.warn((Object)msg);
            throw new SynapseException(msg);
        }
        this.dataStore.registerListeningEndpoint(port, tenantDomain, "wss", name, params);
        boolean start = this.startSSLListener(port, name, params);
        if (start) {
            return true;
        }
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        return false;
    }

    @Override
    public boolean startListener(int port, String name, InboundProcessorParams params) {
        if (WebsocketEventExecutorManager.getInstance().isRegisteredExecutor(port)) {
            log.info((Object)("Netty Listener already started on port " + port));
            return true;
        }
        InboundWebsocketConfiguration config = this.buildConfiguration(port, name, params);
        NettyThreadPoolConfiguration threadPoolConfig = new NettyThreadPoolConfiguration(config.getBossThreadPoolSize(), config.getWorkerThreadPoolSize());
        InboundWebsocketEventExecutor eventExecutor = new InboundWebsocketEventExecutor(threadPoolConfig);
        WebsocketEventExecutorManager.getInstance().registerEventExecutor(port, eventExecutor);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(eventExecutor.getBossGroupThreadPool(), eventExecutor.getWorkerGroupThreadPool()).channel(NioServerSocketChannel.class);
        InboundWebsocketChannelInitializer handler = new InboundWebsocketChannelInitializer();
        handler.setClientBroadcastLevel(config.getBroadcastLevel());
        handler.setOutflowDispatchSequence(config.getOutFlowDispatchSequence());
        handler.setOutflowErrorSequence(config.getOutFlowErrorSequence());
        handler.setSubprotocolHandlers(SubprotocolBuilderUtil.stringToSubprotocolHandlers(config.getSubprotocolHandler()));
        handler.setPipelineHandler(PipelineHandlerBuilderUtil.stringToPipelineHandlers(config.getPipelineHandler()));
        handler.setDispatchToCustomSequence(config.getDispatchToCustomSequence());
        handler.setPortOffset(PersistenceUtils.getPortOffset((Properties)params.getProperties()));
        bootstrap.childHandler((ChannelHandler)handler);
        try {
            bootstrap.bind((SocketAddress)new InetSocketAddress(port)).sync();
            log.info((Object)("Netty Listener starting on port " + port));
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean startSSLListener(int port, String name, InboundProcessorParams params) {
        if (WebsocketEventExecutorManager.getInstance().isRegisteredExecutor(port)) {
            log.info((Object)("Netty Listener already started on port " + port));
            return true;
        }
        InboundWebsocketConfiguration config = this.buildConfiguration(port, name, params);
        InboundWebsocketSSLConfiguration sslConfiguration = this.buildSSLConfiguration(params);
        NettyThreadPoolConfiguration threadPoolConfig = new NettyThreadPoolConfiguration(config.getBossThreadPoolSize(), config.getWorkerThreadPoolSize());
        InboundWebsocketEventExecutor eventExecutor = new InboundWebsocketEventExecutor(threadPoolConfig);
        WebsocketEventExecutorManager.getInstance().registerEventExecutor(port, eventExecutor);
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(eventExecutor.getBossGroupThreadPool(), eventExecutor.getWorkerGroupThreadPool()).channel(NioServerSocketChannel.class);
        InboundWebsocketChannelInitializer handler = new InboundWebsocketChannelInitializer();
        handler.setSslConfiguration(sslConfiguration);
        handler.setClientBroadcastLevel(config.getBroadcastLevel());
        handler.setOutflowDispatchSequence(config.getOutFlowDispatchSequence());
        handler.setOutflowErrorSequence(config.getOutFlowErrorSequence());
        handler.setSubprotocolHandlers(SubprotocolBuilderUtil.stringToSubprotocolHandlers(config.getSubprotocolHandler()));
        handler.setPipelineHandler(PipelineHandlerBuilderUtil.stringToPipelineHandlers(config.getPipelineHandler()));
        handler.setDispatchToCustomSequence(config.getDispatchToCustomSequence());
        handler.setPortOffset(PersistenceUtils.getPortOffset((Properties)params.getProperties()));
        bootstrap.childHandler((ChannelHandler)handler);
        try {
            bootstrap.bind((SocketAddress)new InetSocketAddress(port)).sync();
            log.info((Object)("Netty SSL Listener starting on port " + port));
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void broadcastShutDownToSubscriber(String endpointName, InboundProcessorParams processorParams) {
        if (this.sourceHandler != null) {
            URI subscriber;
            WebsocketSubscriberPathManager pathManager = WebsocketSubscriberPathManager.getInstance();
            int shutdownStatusCode = 1001;
            String shutdownStatusMessage = null;
            String shutdownStatusCodeValue = null;
            InboundEndpoint endpoint = processorParams.getSynapseEnvironment().getSynapseConfiguration().getInboundEndpoint(endpointName);
            if (endpoint != null) {
                shutdownStatusMessage = (String)endpoint.getParametersMap().get("ws.shutdown.status.message");
                shutdownStatusCodeValue = (String)endpoint.getParametersMap().get("ws.shutdown.status.code");
            }
            if (shutdownStatusCodeValue != null) {
                try {
                    shutdownStatusCode = Integer.parseInt(shutdownStatusCodeValue);
                }
                catch (NumberFormatException ex) {
                    log.warn((Object)"Please specify a valid Integer for \"ws.shutdown.status.code\" parameter. Assigning the default value 1001");
                }
            }
            if (shutdownStatusMessage == null) {
                shutdownStatusMessage = "shutdown";
            }
            if ((subscriber = this.sourceHandler.getSubscriber()) != null) {
                pathManager.broadcastOnSubscriberPath((WebSocketFrame)new CloseWebSocketFrame(shutdownStatusCode, shutdownStatusMessage), endpointName, this.sourceHandler.getSubscriberPath());
            }
        }
    }

    @Override
    public void closeEndpoint(int port) {
        PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String tenantDomain = cc.getTenantDomain();
        this.dataStore.unregisterListeningEndpoint(port, tenantDomain);
        if (!WebsocketEventExecutorManager.getInstance().isRegisteredExecutor(port)) {
            log.info((Object)"Listener Endpoint is not started");
            return;
        }
        if (this.dataStore.isEndpointRegistryEmpty(port)) {
            WebsocketEventExecutorManager.getInstance().shutdownExecutor(port);
        }
    }

    public InboundWebsocketConfiguration buildConfiguration(int port, String name, InboundProcessorParams params) {
        return new InboundWebsocketConfiguration.InboundWebsocketConfigurationBuilder(port, name).bossThreadPoolSize(params.getProperties().getProperty("ws.boss.thread.pool.size")).workerThreadPoolSize(params.getProperties().getProperty("ws.worker.thread.pool.size")).broadcastLevel(this.validateBroadcastLevelParam(params.getProperties().getProperty("ws.client.side.broadcast.level"))).outFlowDispatchSequence(params.getProperties().getProperty("ws.outflow.dispatch.sequence")).outFlowErrorSequence(params.getProperties().getProperty("ws.outflow.dispatch.fault.sequence")).subprotocolHandler(params.getProperties().getProperty("ws.subprotocol.handler.class")).defaultContentType(params.getProperties().getProperty("ws.default.content.type")).pipelineHandler(params.getProperties().getProperty("ws.pipeline.handler.class")).dispatchToCustomSequence(params.getProperties().getProperty("dispatch.custom.sequence")).usePortOffset(Boolean.valueOf(params.getProperties().getProperty("ws.use.port.offset"))).build();
    }

    protected int validateBroadcastLevelParam(String broadcastLevelParam) {
        int broadcastLevel = 0;
        try {
            if (!(broadcastLevelParam == null || "".equals(broadcastLevelParam.trim()) || (broadcastLevel = Integer.parseInt(broadcastLevelParam)) >= 0 && broadcastLevel <= 2)) {
                String msg = "Validation failed. Unknown client broadcast level.";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        catch (NumberFormatException e) {
            String msg = "Validation failed. Broadcast level parameter should not contain any special characters";
            log.error((Object)msg);
            throw new SynapseException(msg, (Throwable)e);
        }
        return broadcastLevel;
    }

    public InboundWebsocketSSLConfiguration buildSSLConfiguration(InboundProcessorParams params) {
        return new InboundWebsocketSSLConfiguration.SSLConfigurationBuilder(params.getProperties().getProperty("wss.ssl.key.store.file"), params.getProperties().getProperty("wss.ssl.key.store.pass"), params.getProperties().getProperty("wss.ssl.trust.store.file"), params.getProperties().getProperty("wss.ssl.trust.store.pass"), params.getProperties().getProperty("wss.ssl.cert.pass"), params.getProperties().getProperty("wss.ssl.protocols"), params.getProperties().getProperty("wss.ssl.cipher.suites")).build();
    }

    public void loadEndpointListeners() {
        Map tenantData = this.dataStore.getAllListeningEndpointData();
        for (Map.Entry tenantInfoEntry : tenantData.entrySet()) {
            int port = (Integer)tenantInfoEntry.getKey();
            InboundEndpointInfoDTO inboundEndpointInfoDTO = (InboundEndpointInfoDTO)((ArrayList)tenantInfoEntry.getValue()).get(0);
            if (inboundEndpointInfoDTO.getProtocol().equals("ws")) {
                this.startListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
                continue;
            }
            if (!inboundEndpointInfoDTO.getProtocol().equals("wss")) continue;
            this.startSSLListener(port, inboundEndpointInfoDTO.getEndpointName(), inboundEndpointInfoDTO.getInboundParams());
        }
    }

    public InboundWebsocketSourceHandler getSourceHandler() {
        return this.sourceHandler;
    }

    public void setSourceHandler(InboundWebsocketSourceHandler sourceHandler) {
        this.sourceHandler = sourceHandler;
    }
}

