/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.kafka;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundTaskProcessor;
import org.apache.synapse.task.TaskStartupObserver;
import org.wso2.carbon.inbound.endpoint.common.InboundRequestProcessorImpl;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.KAFKAInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.KAFKAPollingConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.KAFKATask;

public class KAFKAProcessor
extends InboundRequestProcessorImpl
implements TaskStartupObserver,
InboundTaskProcessor {
    private static final Log log = LogFactory.getLog((String)KAFKAProcessor.class.getName());
    private static final String ENDPOINT_POSTFIX = "KAFKA--SYNAPSE_INBOUND_ENDPOINT";
    private KAFKAPollingConsumer pollingConsumer;
    private Properties kafkaProperties;
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;

    public KAFKAProcessor(InboundProcessorParams params) {
        this.name = params.getName();
        this.kafkaProperties = params.getProperties();
        String inboundEndpointInterval = this.kafkaProperties.getProperty("interval");
        if (inboundEndpointInterval != null) {
            try {
                this.interval = Long.parseLong(inboundEndpointInterval);
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("Invalid numeric value for interval." + nfe.getMessage()), (Throwable)nfe);
                throw new SynapseException("Invalid numeric value for interval.", (Throwable)nfe);
            }
        }
        this.sequential = true;
        String inboundEndpointSequential = this.kafkaProperties.getProperty("sequential");
        if (inboundEndpointSequential != null) {
            try {
                this.sequential = Boolean.parseBoolean(inboundEndpointSequential);
            }
            catch (Exception e) {
                log.error((Object)("The sequential value should be true or false." + e.getMessage()), (Throwable)e);
                throw new SynapseException("The sequential value should be true or false", (Throwable)e);
            }
        }
        this.coordination = true;
        String inboundCoordination = this.kafkaProperties.getProperty("coordination");
        if (inboundCoordination != null) {
            try {
                this.coordination = Boolean.parseBoolean(inboundCoordination);
            }
            catch (Exception e) {
                log.error((Object)("The Coordination value should be true or false." + e.getMessage()), (Throwable)e);
                throw new SynapseException("The Coordination value should be true or false", (Throwable)e);
            }
        }
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
    }

    public void init() {
        log.info((Object)("Initializing inbound KAFKA listener for destination " + this.name));
        try {
            this.pollingConsumer = new KAFKAPollingConsumer(this.kafkaProperties, this.interval, this.name);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        this.pollingConsumer.registerHandler(new KAFKAInjectHandler(this.injectingSeq, this.onErrorSeq, this.sequential, this.synapseEnvironment, this.kafkaProperties.getProperty("content.type")));
        try {
            this.pollingConsumer.startsMessageListener();
        }
        catch (Exception e) {
            log.error((Object)("Error initializing message listener " + e.getMessage()), (Throwable)e);
            throw new SynapseException("Error initializing message listener", (Throwable)e);
        }
        this.start();
    }

    public void start() {
        KAFKATask task = new KAFKATask(this.pollingConsumer, this.interval);
        this.start(task, ENDPOINT_POSTFIX);
    }

    public void update() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void destroy() {
        try {
            if (this.pollingConsumer != null && this.pollingConsumer.messageListener != null && this.pollingConsumer.messageListener.consumerConnector != null) {
                this.pollingConsumer.messageListener.consumerConnector.shutdown();
                log.info((Object)"Shutdown the kafka consumer connector");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while shutdown the consumer connector" + e.getMessage()), (Throwable)e);
        }
        super.destroy();
    }

    public void destroy(boolean removeTask) {
        if (removeTask) {
            this.destroy();
        }
    }
}

