/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.transform;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class STRTransformUtil {
    private static final Log log = LogFactory.getLog((String)STRTransformUtil.class.getName());

    public static Element dereferenceSTR(Document doc, SecurityTokenReference secRef, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element tokElement = null;
        if (secRef.containsReference()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"STR: Reference");
            }
            tokElement = secRef.getTokenElement(doc, wsDocInfo, null);
        } else if (secRef.containsX509Data() || secRef.containsX509IssuerSerial()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"STR: IssuerSerial");
            }
            X509Certificate cert = null;
            X509Certificate[] certs = secRef.getX509IssuerSerial(wsDocInfo.getCrypto());
            if (certs == null || certs.length == 0 || certs[0] == null) {
                throw new WSSecurityException(6);
            }
            cert = certs[0];
            tokElement = STRTransformUtil.createBSTX509(doc, cert, secRef.getElement());
        } else if (secRef.containsKeyIdentifier()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"STR: KeyIdentifier");
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType()) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                tokElement = secRef.getKeyIdentifierTokenElement(doc, wsDocInfo, null);
            } else {
                X509Certificate cert = null;
                X509Certificate[] certs = secRef.getKeyIdentifier(wsDocInfo.getCrypto());
                if (certs == null || certs.length == 0 || certs[0] == null) {
                    throw new WSSecurityException(6);
                }
                cert = certs[0];
                tokElement = STRTransformUtil.createBSTX509(doc, cert, secRef.getElement());
            }
        }
        return tokElement;
    }

    protected static Element createBSTX509(Document doc, X509Certificate cert, Element secRefE) throws WSSecurityException {
        byte[] data;
        try {
            data = cert.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError", null, e);
        }
        String prefix = WSSecurityUtil.getPrefixNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", secRefE);
        Element elem = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", prefix + ":BinarySecurityToken");
        WSSecurityUtil.setNamespace(elem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", prefix);
        elem.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        Text certText = doc.createTextNode(Base64.encode(data));
        elem.appendChild(certText);
        return elem;
    }

    private STRTransformUtil() {
    }
}

