/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.util.Calendar;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Element;

public class TimestampProcessor
implements Processor {
    private static final Log log = LogFactory.getLog((String)TimestampProcessor.class.getName());
    private WSSConfig wssConfig = null;
    private String tsId;
    private int ttlValue = 0;

    public void setTtlValue(int ttlValue) {
        this.ttlValue = ttlValue;
    }

    @Override
    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found Timestamp list element");
        }
        this.wssConfig = wsc;
        Timestamp timestamp = new Timestamp(elem);
        this.handleTimestamp(timestamp);
        returnResults.add(0, new WSSecurityEngineResult(32, timestamp));
        this.tsId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void handleTimestamp(Timestamp timestamp) throws WSSecurityException {
        Calendar exp;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing to verify the timestamp");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            log.debug((Object)("Current time: " + zulu.format(Calendar.getInstance().getTime())));
            if (timestamp.getCreated() != null) {
                log.debug((Object)("Timestamp created: " + zulu.format(timestamp.getCreated().getTime())));
            }
            if (timestamp.getExpires() != null) {
                log.debug((Object)("Timestamp expires: " + zulu.format(timestamp.getExpires().getTime())));
            }
        }
        if ((exp = timestamp.getExpires()) != null && this.wssConfig.isTimeStampStrict()) {
            Calendar rightNow = Calendar.getInstance();
            if (exp.before(rightNow)) {
                throw new WSSecurityException(8, "invalidTimestamp", new Object[]{"The security semantics of the message have expired"});
            }
            if (this.ttlValue > 0) {
                Calendar created = timestamp.getCreated();
                created.add(13, this.ttlValue);
                if (created.before(exp)) {
                    throw new WSSecurityException(8, "invalidTTL", new Object[]{"TTL validation for incoming messages enabled. Invalid TTL detected between created and expired timestamps"});
                }
            }
        }
    }

    @Override
    public String getId() {
        return this.tsId;
    }
}

