/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSParameterCallback;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.KerberosTokenProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.saml.SAML2KeyInfo;
import org.apache.ws.security.saml.SAML2Util;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceListProcessor
implements Processor {
    private static final Log log = LogFactory.getLog((String)ReferenceListProcessor.class.getName());
    private boolean debug = false;
    WSDocInfo wsDocInfo = null;
    Principal krbPricipal;

    @Override
    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wdi, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        this.debug = log.isDebugEnabled();
        if (this.debug) {
            log.debug((Object)"Found reference list element");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        this.wsDocInfo = wdi;
        ArrayList uris = this.handleReferenceList(elem, cb, decCrypto);
        if (this.krbPricipal != null) {
            WSSecurityEngineResult secResults = null;
            secResults = new WSSecurityEngineResult(5632, uris);
            secResults.put("principal", this.krbPricipal);
            returnResults.add(0, secResults);
        } else {
            returnResults.add(0, new WSSecurityEngineResult(4, uris));
        }
    }

    private ArrayList handleReferenceList(Element elem, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        Node tmpE = null;
        ArrayList<WSDataRef> dataRefUris = new ArrayList<WSDataRef>();
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
            String dataRefURI = ((Element)tmpE).getAttribute("URI");
            if (dataRefURI.charAt(0) == '#') {
                dataRefURI = dataRefURI.substring(1);
            }
            WSDataRef dataRef = this.decryptDataRefEmbedded(elem.getOwnerDocument(), dataRefURI, cb, crypto);
            dataRefUris.add(dataRef);
        }
        return dataRefUris;
    }

    private WSDataRef decryptDataRefEmbedded(Document doc, String dataRefURI, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found data reference: " + dataRefURI));
        }
        Element encryptedDataElement = ReferenceListProcessor.findEncryptedDataElement(doc, dataRefURI);
        String symEncAlgo = X509Util.getEncAlgo(encryptedDataElement);
        Element keyInfoElement = WSSecurityUtil.getDirectChildElement(encryptedDataElement, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (keyInfoElement == null) {
            throw new WSSecurityException(3, "noKeyinfo");
        }
        Element secRefToken = WSSecurityUtil.getDirectChildElement(keyInfoElement, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SecretKey symmetricKey = null;
        symmetricKey = secRefToken == null ? X509Util.getSharedKey(keyInfoElement, symEncAlgo, cb) : this.getKeyFromSecurityTokenReference(secRefToken, symEncAlgo, crypto, cb);
        return ReferenceListProcessor.decryptEncryptedData(doc, dataRefURI, encryptedDataElement, symmetricKey, symEncAlgo);
    }

    public static Element findEncryptedDataElement(Document doc, String dataRefURI) throws WSSecurityException {
        Element encryptedDataElement = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encryptedDataElement == null) {
            encryptedDataElement = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encryptedDataElement == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        return encryptedDataElement;
    }

    public static WSDataRef decryptEncryptedData(Document doc, String dataRefURI, Element encData, SecretKey symmetricKey, String symEncAlgo) throws WSSecurityException {
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(2, null, null, ex);
        }
        WSDataRef dataRef = new WSDataRef(dataRefURI);
        dataRef.setWsuId(dataRefURI);
        dataRef.setAlgorithm(symEncAlgo);
        boolean content = X509Util.isContent(encData);
        dataRef.setContent(content);
        Node parent = encData.getParentNode();
        Node previousSibling = encData.getPreviousSibling();
        if (content) {
            encData = (Element)encData.getParentNode();
            parent = encData.getParentNode();
        }
        try {
            xmlCipher.doFinal(doc, encData, content);
        }
        catch (Exception ex) {
            throw new WSSecurityException(6, null, null, ex);
        }
        if (parent.getLocalName().equals("EncryptedHeader") && parent.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
            Node decryptedHeader = parent.getFirstChild();
            Element decryptedHeaderClone = (Element)decryptedHeader.cloneNode(true);
            parent.getParentNode().appendChild(decryptedHeaderClone);
            parent.getParentNode().removeChild(parent);
            dataRef.setProtectedElement(decryptedHeaderClone);
            dataRef.setXpath(ReferenceListProcessor.getXPath(decryptedHeaderClone));
        } else if (content) {
            dataRef.setProtectedElement(encData);
            dataRef.setXpath(ReferenceListProcessor.getXPath(encData));
        } else {
            Node decryptedNode = previousSibling == null ? parent.getFirstChild() : previousSibling.getNextSibling();
            if (decryptedNode != null && 1 == decryptedNode.getNodeType()) {
                dataRef.setProtectedElement((Element)decryptedNode);
            }
            dataRef.setXpath(ReferenceListProcessor.getXPath(decryptedNode));
        }
        return dataRef;
    }

    private SecretKey getKeyFromSecurityTokenReference(Element secRefToken, String algorithm, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
        byte[] decryptedData = null;
        if (secRef.containsReference()) {
            Processor p;
            Reference reference = secRef.getReference();
            String uri = reference.getURI();
            String id = uri;
            if (id.charAt(0) == '#') {
                id = id.substring(1);
            }
            if ((p = this.wsDocInfo.getProcessor(id)) instanceof EncryptedKeyProcessor) {
                EncryptedKeyProcessor ekp = (EncryptedKeyProcessor)p;
                decryptedData = ekp.getDecryptedBytes();
            } else if (p instanceof DerivedKeyTokenProcessor) {
                DerivedKeyTokenProcessor dkp = (DerivedKeyTokenProcessor)p;
                decryptedData = dkp.getKeyBytes(WSSecurityUtil.getKeyLength(algorithm));
            } else if (p instanceof SAMLTokenProcessor) {
                SAMLTokenProcessor samlp = (SAMLTokenProcessor)p;
                SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
                decryptedData = keyInfo.getSecret();
            } else if (p instanceof KerberosTokenProcessor) {
                KerberosTokenProcessor krbp = (KerberosTokenProcessor)p;
                WSParameterCallback param = new WSParameterCallback(0);
                int factor = 0;
                try {
                    Callback[] callbacks = new Callback[]{param};
                    cb.handle(callbacks);
                    factor = param.getIntValue();
                }
                catch (Exception e) {
                    log.error((Object)"Error while executing parameter callback", (Throwable)e);
                }
                byte[] secret = krbp.getLastPrincipalFound().getSessionKey();
                if (factor > 1) {
                    byte[] newSecret = new byte[secret.length * factor];
                    int j = 0;
                    for (int i = 0; i < newSecret.length; ++i) {
                        newSecret[i] = secret[j++];
                        if (j != secret.length) continue;
                        j = 0;
                    }
                    decryptedData = newSecret;
                } else {
                    decryptedData = secret;
                }
                this.krbPricipal = krbp.getLastPrincipalFound();
            } else {
                WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                try {
                    Callback[] callbacks = new Callback[]{pwcb};
                    cb.handle(callbacks);
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                }
                decryptedData = pwcb.getKey();
                if (decryptedData == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId");
                }
            }
        } else if (secRef.containsKeyIdentifier()) {
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(secRef.getKeyIdentifierValueType())) {
                Element token = secRef.getKeyIdentifierTokenElement(secRefToken.getOwnerDocument(), this.wsDocInfo, cb);
                if (crypto == null) {
                    throw new WSSecurityException(0, "noSigCryptoFile");
                }
                SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(token, crypto, cb);
                decryptedData = keyInfo.getSecret();
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(secRef.getKeyIdentifierValueType())) {
                Element token = secRef.getKeyIdentifierTokenElement(secRefToken.getOwnerDocument(), this.wsDocInfo, cb);
                if (crypto == null) {
                    throw new WSSecurityException(0, "noSigCryptoFile");
                }
                SAML2KeyInfo keyInfo = SAML2Util.getSAML2KeyInfo(token, crypto, cb);
                decryptedData = keyInfo.getSecret();
            } else {
                String sha = secRef.getKeyIdentifierValue();
                WSPasswordCallback pwcb = new WSPasswordCallback(secRef.getKeyIdentifierValue(), null, secRef.getKeyIdentifierValueType(), 8);
                try {
                    Callback[] callbacks = new Callback[]{pwcb};
                    cb.handle(callbacks);
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{sha}, e);
                }
                decryptedData = pwcb.getKey();
            }
        } else {
            throw new WSSecurityException(6, "noReference");
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }

    @Override
    public String getId() {
        return null;
    }

    public static String getXPath(Node decryptedNode) {
        if (decryptedNode == null) {
            return null;
        }
        String result = "";
        if (1 == decryptedNode.getNodeType()) {
            result = decryptedNode.getNodeName();
            result = ReferenceListProcessor.prependFullPath(result, decryptedNode.getParentNode());
        } else if (2 == decryptedNode.getNodeType()) {
            result = "@" + decryptedNode.getNodeName();
            result = ReferenceListProcessor.prependFullPath(result, ((Attr)decryptedNode).getOwnerElement());
        } else {
            return null;
        }
        return result;
    }

    private static String prependFullPath(String xpath, Node node) {
        if (node == null) {
            return null;
        }
        if (1 == node.getNodeType()) {
            xpath = node.getNodeName() + "/" + xpath;
            return ReferenceListProcessor.prependFullPath(xpath, node.getParentNode());
        }
        if (9 == node.getNodeType()) {
            return "/" + xpath;
        }
        return ReferenceListProcessor.prependFullPath(xpath, node.getParentNode());
    }
}

