/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.security.NoSuchAlgorithmException;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.util.SecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KerberosSecurity
extends BinarySecurity {
    public static final String KERBEROS_TOKEN_PROFILE_1_1 = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1";
    public static final String GSS_KERBEROSv5_AP_REQ = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";
    public static final String GSS_KERBEROSv5_AP_REQ_SHA1 = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1";

    public KerberosSecurity(Element elem) throws WSSecurityException {
        super(elem);
        if (!this.getValueType().equals(GSS_KERBEROSv5_AP_REQ)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{GSS_KERBEROSv5_AP_REQ, this.getValueType()});
        }
    }

    public KerberosSecurity(Document doc) {
        super(doc);
        this.setValueType(GSS_KERBEROSv5_AP_REQ);
    }

    public void setKerberosToken(byte[] tokenData) {
        this.setToken(tokenData);
    }

    protected String getType() {
        return GSS_KERBEROSv5_AP_REQ;
    }

    public String getSHA1() throws WSSecurityException {
        try {
            return SecurityUtil.getSHA1(this.getToken());
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(2, null, null, e);
        }
    }
}

