/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecUsernameToken
extends WSSecBase {
    private static final Log log = LogFactory.getLog((String)WSSecUsernameToken.class.getName());
    private String passwordType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    private UsernameToken ut = null;
    private boolean nonce = false;
    private boolean created = false;
    private boolean useDerivedKey = false;
    private boolean useMac = false;
    private byte[] saltValue;
    private int iteration = 1000;
    private int secretKeyLength = 16;
    private boolean passwordsAreEncoded = false;

    public void setPasswordType(String pwType) {
        this.passwordType = pwType;
    }

    public void addNonce() {
        this.nonce = true;
    }

    public void addCreated() {
        this.created = true;
    }

    public void setSecretKeyLength(int length) {
        this.secretKeyLength = length;
    }

    public int getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public void addDerivedKey(boolean useMac, byte[] saltValue, int iteration) {
        this.passwordType = null;
        this.useDerivedKey = true;
        this.useMac = useMac;
        this.saltValue = saltValue;
        if (iteration > 0) {
            this.iteration = iteration;
        }
    }

    public byte[] getSecretKey() throws WSSecurityException {
        if (this.ut == null) {
            return null;
        }
        if (this.useDerivedKey) {
            if (this.passwordsAreEncoded) {
                return UsernameToken.generateDerivedKey(Base64.decode(this.password), this.saltValue, this.iteration);
            }
            return UsernameToken.generateDerivedKey(this.password, this.saltValue, this.iteration);
        }
        return this.ut.getSecretKey(this.secretKeyLength);
    }

    public byte[] getDerivedKey() throws WSSecurityException {
        if (this.ut == null || !this.useDerivedKey) {
            return null;
        }
        if (this.passwordsAreEncoded) {
            return UsernameToken.generateDerivedKey(Base64.decode(this.password), this.saltValue, this.iteration);
        }
        return UsernameToken.generateDerivedKey(this.password, this.saltValue, this.iteration);
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public String getId() {
        if (this.ut == null) {
            return null;
        }
        return this.ut.getID();
    }

    public void prepare(Document doc) {
        this.ut = new UsernameToken(this.wssConfig.isPrecisionInMilliSeconds(), doc, this.passwordType);
        this.ut.setPasswordsAreEncoded(this.passwordsAreEncoded);
        this.ut.setName(this.user);
        if (this.useDerivedKey) {
            this.saltValue = this.ut.addSalt(doc, this.saltValue, this.useMac);
            this.ut.addIteration(doc, this.iteration);
        } else {
            this.ut.setPassword(this.password);
        }
        if (this.nonce) {
            this.ut.addNonce(doc);
        }
        if (this.created) {
            this.ut.addCreated(this.wssConfig.isPrecisionInMilliSeconds(), doc);
        }
        this.ut.setID(this.wssConfig.getIdAllocator().createId("UsernameToken-", this.ut));
    }

    public void prependToHeader(WSSecHeader secHeader) {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.ut.getElement());
    }

    public void appendToHeader(WSSecHeader secHeader) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(this.ut.getElement());
    }

    public Document build(Document doc, WSSecHeader secHeader) {
        log.debug((Object)"Begin add username token...");
        this.prepare(doc);
        this.prependToHeader(secHeader);
        return doc;
    }

    public Element getUsernameTokenElement() {
        return this.ut.getElement();
    }
}

