/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.TimestampProcessor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecurityEngine {
    public static final String VALUE_TYPE = "ValueType";
    private static final Log log = LogFactory.getLog((String)WSSecurityEngine.class.getName());
    private static final Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    private static WSSecurityEngine engine = null;
    private WSSConfig wssConfig = null;
    private boolean doDebug = false;
    public static final QName binaryToken = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    public static final QName usernameToken = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    public static final QName timeStamp = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
    public static final QName signatureConfirmation = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation");
    public static final QName SIGNATURE = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    public static final QName ENCRYPTED_KEY = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    public static final QName ENCRYPTED_DATA = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    public static final QName REFERENCE_LIST = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    public static final QName SAML_TOKEN = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    public static final QName SAML2_TOKEN = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion", "saml");
    public static final QName DERIVED_KEY_TOKEN_05_02 = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
    public static final QName SECURITY_CONTEXT_TOKEN_05_02 = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
    public static final QName DERIVED_KEY_TOKEN_05_12 = new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "DerivedKeyToken");
    public static final QName SECURITY_CONTEXT_TOKEN_05_12 = new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "SecurityContextToken");

    public static synchronized WSSecurityEngine getInstance() {
        if (engine == null) {
            engine = new WSSecurityEngine();
        }
        return engine;
    }

    public final WSSConfig getWssConfig() {
        return this.wssConfig == null ? WSSConfig.getDefaultWSConfig() : this.wssConfig;
    }

    public final WSSConfig setWssConfig(WSSConfig cfg) {
        WSSConfig ret = this.wssConfig;
        this.wssConfig = cfg;
        return ret;
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.processSecurityHeader(doc, actor, cb, crypto, crypto);
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        return this.processSecurityHeader(doc, actor, cb, sigCrypto, decCrypto, -1);
    }

    public Vector processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto, int ttlValue) throws WSSecurityException {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)"enter processSecurityHeader()");
        }
        if (actor == null) {
            actor = "";
        }
        Vector wsResult = null;
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Element elem = WSSecurityUtil.getSecurityHeader(doc, actor, sc);
        if (elem != null) {
            if (this.doDebug) {
                log.debug((Object)("Processing WS-Security header for '" + actor + "' actor."));
            }
            wsResult = ttlValue != -1 ? this.processSecurityHeaderWithTTL(elem, cb, sigCrypto, decCrypto, ttlValue) : this.processSecurityHeader(elem, cb, sigCrypto, decCrypto);
        }
        return wsResult;
    }

    protected Vector processSecurityHeader(Element securityHeader, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument());
        wsDocInfo.setCrypto(sigCrypto);
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        Vector returnResults = new Vector();
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            if (elem.getNodeType() != 1) continue;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            WSSConfig cfg = this.getWssConfig();
            Processor p = cfg.getProcessor(el);
            if (p != null) {
                p.handleToken((Element)elem, sigCrypto, decCrypto, cb, wsDocInfo, returnResults, cfg);
                wsDocInfo.setProcessor(p);
                continue;
            }
            if (!this.doDebug) continue;
            log.debug((Object)("Unknown Element: " + elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader: total " + (t2 - t0) + ", prepare " + (t1 - t0) + ", handle " + (t2 - t1)));
        }
        return returnResults;
    }

    protected Vector processSecurityHeaderWithTTL(Element securityHeader, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto, int ttlValue) throws WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument());
        wsDocInfo.setCrypto(sigCrypto);
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        Vector returnResults = new Vector();
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            if (elem.getNodeType() != 1) continue;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            WSSConfig cfg = this.getWssConfig();
            Processor p = cfg.getProcessor(el);
            if (p instanceof TimestampProcessor) {
                TimestampProcessor timestampProcessor = (TimestampProcessor)p;
                timestampProcessor.setTtlValue(ttlValue);
            }
            if (p != null) {
                p.handleToken((Element)elem, sigCrypto, decCrypto, cb, wsDocInfo, returnResults, cfg);
                wsDocInfo.setProcessor(p);
                continue;
            }
            if (!this.doDebug) continue;
            log.debug((Object)("Unknown Element: " + elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (tlog.isDebugEnabled()) {
            t2 = System.currentTimeMillis();
            tlog.debug((Object)("processHeader: total " + (t2 - t0) + ", prepare " + (t1 - t0) + ", handle " + (t2 - t1)));
        }
        return returnResults;
    }
}

