/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.functions.library.mgt.dao.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.functions.library.mgt.dao.FunctionLibraryDAO;
import org.wso2.carbon.identity.functions.library.mgt.exception.FunctionLibraryManagementException;
import org.wso2.carbon.identity.functions.library.mgt.model.FunctionLibrary;
import org.wso2.carbon.identity.functions.library.mgt.util.FunctionLibraryExceptionManagementUtil;
import org.wso2.carbon.identity.functions.library.mgt.util.FunctionLibraryManagementConstants;

public class FunctionLibraryDAOImpl
implements FunctionLibraryDAO {
    private static final Log log = LogFactory.getLog(FunctionLibraryDAOImpl.class);

    @Override
    public void createFunctionLibrary(FunctionLibrary functionLibrary, String tenantDomain) throws FunctionLibraryManagementException {
        block32: {
            int tenantID = -1;
            if (tenantDomain != null) {
                tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
            }
            if (tenantID != -1) {
                try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
                    try (PreparedStatement addFunctionLibStmt = connection.prepareStatement("INSERT INTO IDN_FUNCTION_LIBRARY (NAME, DESCRIPTION, TYPE, TENANT_ID, DATA) VALUES (?,?,?,?,?)");){
                        addFunctionLibStmt.setString(1, functionLibrary.getFunctionLibraryName());
                        addFunctionLibStmt.setString(2, functionLibrary.getDescription());
                        addFunctionLibStmt.setString(3, "authentication");
                        addFunctionLibStmt.setInt(4, tenantID);
                        this.setBlobValue(functionLibrary.getFunctionLibraryScript(), addFunctionLibStmt, 5);
                        addFunctionLibStmt.executeUpdate();
                        IdentityDatabaseUtil.commitTransaction((Connection)connection);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("script Library stored successfully with script library name " + functionLibrary.getFunctionLibraryName()));
                        }
                        break block32;
                    }
                    catch (SQLException e1) {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_ADD_SCRIPT_LIBRARY, functionLibrary.getFunctionLibraryName(), e1);
                    }
                }
                catch (SQLException e) {
                    throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_ADD_SCRIPT_LIBRARY, functionLibrary.getFunctionLibraryName(), e);
                }
                catch (IOException e) {
                    throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_PROCESSING_CONTENT_STREAM_SCRIPT_LIBRARY, functionLibrary.getFunctionLibraryName(), e);
                }
            }
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_INVALID_TENANT);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public FunctionLibrary getFunctionLibrary(String functionLibraryName, String tenantDomain) throws FunctionLibraryManagementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<FunctionLibrary> listFunctionLibraries(String tenantDomain) throws FunctionLibraryManagementException {
        int tenantID = -1;
        if (tenantDomain != null) {
            tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        }
        ArrayList<FunctionLibrary> functionLibraries = new ArrayList<FunctionLibrary>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement getFunctionLibrariesStmt = connection.prepareStatement("SELECT NAME,DESCRIPTION,TYPE,DATA FROM IDN_FUNCTION_LIBRARY WHERE TENANT_ID = ?");){
                getFunctionLibrariesStmt.setInt(1, tenantID);
                try (ResultSet functionLibsResultSet = getFunctionLibrariesStmt.executeQuery();){
                    while (functionLibsResultSet.next()) {
                        FunctionLibrary functionlib = new FunctionLibrary();
                        functionlib.setFunctionLibraryName(functionLibsResultSet.getString("NAME"));
                        functionlib.setDescription(functionLibsResultSet.getString("DESCRIPTION"));
                        functionLibraries.add(functionlib);
                    }
                }
            }
            catch (SQLException e1) {
                throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_SCRIPT_LIBRARIES, e1);
            }
        }
        catch (SQLException e) {
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_SCRIPT_LIBRARIES, e);
        }
        catch (IdentityRuntimeException e) {
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_DATABASE_CONNECTION, e);
        }
        return functionLibraries;
    }

    @Override
    public void updateFunctionLibrary(String oldFunctionLibName, FunctionLibrary functionLibrary, String tenantDomain) throws FunctionLibraryManagementException {
        block32: {
            int tenantID = -1;
            if (tenantDomain != null) {
                tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
            }
            if (tenantID != -1) {
                try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
                    try (PreparedStatement updateFunctionLibStmt = connection.prepareStatement("UPDATE IDN_FUNCTION_LIBRARY SET NAME = ?, DESCRIPTION = ?, DATA = ? WHERE TENANT_ID = ? AND NAME = ?");){
                        updateFunctionLibStmt.setString(1, functionLibrary.getFunctionLibraryName());
                        updateFunctionLibStmt.setString(2, functionLibrary.getDescription());
                        this.setBlobValue(functionLibrary.getFunctionLibraryScript(), updateFunctionLibStmt, 3);
                        updateFunctionLibStmt.setInt(4, tenantID);
                        updateFunctionLibStmt.setString(5, oldFunctionLibName);
                        updateFunctionLibStmt.executeUpdate();
                        IdentityDatabaseUtil.commitTransaction((Connection)connection);
                        break block32;
                    }
                    catch (SQLException e1) {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_UPDATE_SCRIPT_LIBRARY, oldFunctionLibName, e1);
                    }
                }
                catch (SQLException e) {
                    throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_UPDATE_SCRIPT_LIBRARY, oldFunctionLibName, e);
                }
                catch (IOException e) {
                    throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_PROCESSING_CONTENT_STREAM_SCRIPT_LIBRARY, oldFunctionLibName, e);
                }
                catch (IdentityRuntimeException e) {
                    throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_DATABASE_CONNECTION, e);
                }
            }
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_INVALID_TENANT);
        }
    }

    @Override
    public void deleteFunctionLibrary(String functionLibraryName, String tenantDomain) throws FunctionLibraryManagementException {
        int tenantID = -1;
        if (tenantDomain != null) {
            tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement deleteFunctionLibStmt = connection.prepareStatement("DELETE FROM IDN_FUNCTION_LIBRARY WHERE TENANT_ID = ? AND NAME = ?");){
                deleteFunctionLibStmt.setInt(1, tenantID);
                deleteFunctionLibStmt.setString(2, functionLibraryName);
                deleteFunctionLibStmt.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removed the script library " + functionLibraryName + " successfully."));
                }
            }
            catch (SQLException e1) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_PROCESSING_CONTENT_STREAM_SCRIPT_LIBRARY, functionLibraryName, e1);
            }
        }
        catch (SQLException e) {
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_PROCESSING_CONTENT_STREAM_SCRIPT_LIBRARY, functionLibraryName, e);
        }
        catch (IdentityRuntimeException e) {
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_DATABASE_CONNECTION, e);
        }
    }

    @Override
    public boolean isFunctionLibraryExists(String functionLibraryName, String tenantDomain) throws FunctionLibraryManagementException {
        boolean isFunctionLibraryExists = false;
        int tenantID = -1234;
        if (tenantDomain != null) {
            tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement checkFunctionLibraryExistence = connection.prepareStatement("SELECT NAME,DESCRIPTION,TYPE,DATA FROM IDN_FUNCTION_LIBRARY WHERE TENANT_ID = ? AND NAME = ?");){
                checkFunctionLibraryExistence.setInt(1, tenantID);
                checkFunctionLibraryExistence.setString(2, functionLibraryName);
                try (ResultSet resultSet = checkFunctionLibraryExistence.executeQuery();){
                    if (resultSet.next()) {
                        isFunctionLibraryExists = true;
                    }
                }
            }
            catch (SQLException e1) {
                throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_FAILED_TO_CHECK_SCRIPT_LIBRARY, functionLibraryName, e1);
            }
        }
        catch (SQLException e) {
            throw FunctionLibraryExceptionManagementUtil.handleServerException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_FAILED_TO_CHECK_SCRIPT_LIBRARY, functionLibraryName, e);
        }
        return isFunctionLibraryExists;
    }

    private void setBlobValue(String value, PreparedStatement prepStmt, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            prepStmt.setBinaryStream(index, (InputStream)inputStream, ((InputStream)inputStream).available());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
        }
    }
}

