/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.functions.library.mgt;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.functions.library.mgt.FunctionLibraryManagementService;
import org.wso2.carbon.identity.functions.library.mgt.FunctionLibraryMgtUtil;
import org.wso2.carbon.identity.functions.library.mgt.dao.impl.FunctionLibraryDAOImpl;
import org.wso2.carbon.identity.functions.library.mgt.exception.FunctionLibraryManagementException;
import org.wso2.carbon.identity.functions.library.mgt.model.FunctionLibrary;
import org.wso2.carbon.identity.functions.library.mgt.util.FunctionLibraryExceptionManagementUtil;
import org.wso2.carbon.identity.functions.library.mgt.util.FunctionLibraryManagementConstants;

public class FunctionLibraryManagementServiceImpl
implements FunctionLibraryManagementService {
    private static final Log log = LogFactory.getLog(FunctionLibraryManagementServiceImpl.class);
    private static FunctionLibraryManagementServiceImpl functionLibMgtService = new FunctionLibraryManagementServiceImpl();

    private FunctionLibraryManagementServiceImpl() {
    }

    public static FunctionLibraryManagementServiceImpl getInstance() {
        return functionLibMgtService;
    }

    @Override
    public void createFunctionLibrary(FunctionLibrary functionLibrary, String tenantDomain) throws FunctionLibraryManagementException {
        this.validateInputs(functionLibrary);
        this.evaluateScript(functionLibrary);
        FunctionLibraryDAOImpl functionLibraryDAO = new FunctionLibraryDAOImpl();
        if (functionLibraryDAO.isFunctionLibraryExists(functionLibrary.getFunctionLibraryName(), tenantDomain)) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_ALREADY_EXIST_SCRIPT_LIBRARY, functionLibrary.getFunctionLibraryName());
        }
        String functionLibraryName = functionLibrary.getFunctionLibraryName();
        if (!FunctionLibraryMgtUtil.isRegexValidated(functionLibraryName)) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_INVALID_SCRIPT_LIBRARY_NAME, "^[a-zA-Z0-9 ._-]*$");
        }
        functionLibraryDAO.createFunctionLibrary(functionLibrary, tenantDomain);
    }

    @Override
    public List<FunctionLibrary> listFunctionLibraries(String tenantDomain) throws FunctionLibraryManagementException {
        FunctionLibraryDAOImpl functionLibraryDAO = new FunctionLibraryDAOImpl();
        return functionLibraryDAO.listFunctionLibraries(tenantDomain);
    }

    @Override
    public FunctionLibrary getFunctionLibrary(String functionLibraryName, String tenantDomain) throws FunctionLibraryManagementException {
        FunctionLibraryDAOImpl functionLibraryDAO = new FunctionLibraryDAOImpl();
        return functionLibraryDAO.getFunctionLibrary(functionLibraryName, tenantDomain);
    }

    @Override
    public void deleteFunctionLibrary(String functionLibraryName, String tenantDomain) throws FunctionLibraryManagementException {
        FunctionLibraryDAOImpl functionLibraryDAO = new FunctionLibraryDAOImpl();
        functionLibraryDAO.deleteFunctionLibrary(functionLibraryName, tenantDomain);
    }

    @Override
    public void updateFunctionLibrary(String oldFunctionLibraryName, FunctionLibrary functionLibrary, String tenantDomain) throws FunctionLibraryManagementException {
        this.validateInputs(functionLibrary);
        this.evaluateScript(functionLibrary);
        FunctionLibraryDAOImpl functionLibraryDAO = new FunctionLibraryDAOImpl();
        if (!functionLibrary.getFunctionLibraryName().equals(oldFunctionLibraryName) && functionLibraryDAO.isFunctionLibraryExists(functionLibrary.getFunctionLibraryName(), tenantDomain)) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_ALREADY_EXIST_SCRIPT_LIBRARY, functionLibrary.getFunctionLibraryName());
        }
        String functionLibraryName = functionLibrary.getFunctionLibraryName();
        if (!FunctionLibraryMgtUtil.isRegexValidated(functionLibraryName)) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_INVALID_SCRIPT_LIBRARY_NAME, "^[a-zA-Z0-9 ._-]*$");
        }
        functionLibraryDAO.updateFunctionLibrary(oldFunctionLibraryName, functionLibrary, tenantDomain);
    }

    @Override
    public boolean isFunctionLibraryExists(String functionLibraryName, String tenantDomain) throws FunctionLibraryManagementException {
        FunctionLibraryDAOImpl functionLibraryDAO = new FunctionLibraryDAOImpl();
        return functionLibraryDAO.isFunctionLibraryExists(functionLibraryName, tenantDomain);
    }

    private void validateInputs(FunctionLibrary functionLibrary) throws FunctionLibraryManagementException {
        if (StringUtils.isBlank((String)functionLibrary.getFunctionLibraryName())) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_REQUIRE_SCRIPT_LIBRARY_NAME);
        }
        if (StringUtils.isBlank((String)functionLibrary.getFunctionLibraryScript())) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_REQUIRE_SCRIPT_LIBRARY_SCRIPT);
        }
    }

    private void evaluateScript(FunctionLibrary functionLibrary) throws FunctionLibraryManagementException {
        try {
            ScriptEngine engine = new NashornScriptEngineFactory().getScriptEngine(new String[]{"--no-java"});
            String head = "var module = { exports:{} }; \nvar exports = {}; \nfunction require(name){};";
            String code = functionLibrary.getFunctionLibraryScript();
            code = head + code;
            engine.eval(code);
        }
        catch (ScriptException e) {
            log.error((Object)("Script library script of " + functionLibrary.getFunctionLibraryName() + " contains errors."), (Throwable)e);
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_VALIDATE_SCRIPT_LIBRARY_SCRIPT, functionLibrary.getFunctionLibraryName(), e);
        }
    }
}

