/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.functions.library.mgt;

import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.functions.library.mgt.FunctionLibraryManagementService;
import org.wso2.carbon.identity.functions.library.mgt.FunctionLibraryManagementServiceImpl;
import org.wso2.carbon.identity.functions.library.mgt.exception.FunctionLibraryManagementException;
import org.wso2.carbon.identity.functions.library.mgt.model.FunctionLibrary;
import org.wso2.carbon.identity.functions.library.mgt.util.FunctionLibraryExceptionManagementUtil;
import org.wso2.carbon.identity.functions.library.mgt.util.FunctionLibraryManagementConstants;

public class FunctionLibraryManagementAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(FunctionLibraryManagementAdminService.class);
    private FunctionLibraryManagementService functionLibMgtService;

    public void createFunctionLibrary(FunctionLibrary functionLibrary) throws FunctionLibraryManagementException {
        try {
            this.validateInputs(functionLibrary);
            this.evaluateScript(functionLibrary);
            this.functionLibMgtService = FunctionLibraryManagementServiceImpl.getInstance();
            this.functionLibMgtService.createFunctionLibrary(functionLibrary, this.getTenantDomain());
        }
        catch (FunctionLibraryManagementException e) {
            log.error((Object)("Error while creating script library " + functionLibrary.getFunctionLibraryName() + " for tenant domain " + this.getTenantDomain() + "."), (Throwable)((Object)e));
            throw e;
        }
    }

    public List<FunctionLibrary> listFunctionLibraries() throws FunctionLibraryManagementException {
        try {
            this.functionLibMgtService = FunctionLibraryManagementServiceImpl.getInstance();
            List<FunctionLibrary> functionLibraries = this.functionLibMgtService.listFunctionLibraries(this.getTenantDomain());
            return functionLibraries;
        }
        catch (FunctionLibraryManagementException e) {
            log.error((Object)("Error while retrieving script libraries for tenant: " + this.getTenantDomain() + "."), (Throwable)((Object)e));
            throw e;
        }
    }

    public FunctionLibrary getFunctionLibrary(String functionLibraryName) throws FunctionLibraryManagementException {
        try {
            this.functionLibMgtService = FunctionLibraryManagementServiceImpl.getInstance();
            FunctionLibrary functionLibrary = this.functionLibMgtService.getFunctionLibrary(functionLibraryName, this.getTenantDomain());
            return functionLibrary;
        }
        catch (FunctionLibraryManagementException e) {
            log.error((Object)("Error while retrieving script library " + functionLibraryName + " for tenant domain " + this.getTenantDomain() + "."), (Throwable)((Object)e));
            throw e;
        }
    }

    public void deleteFunctionLibrary(String functionLibraryName) throws FunctionLibraryManagementException {
        try {
            this.functionLibMgtService = FunctionLibraryManagementServiceImpl.getInstance();
            this.functionLibMgtService.deleteFunctionLibrary(functionLibraryName, this.getTenantDomain());
        }
        catch (FunctionLibraryManagementException e) {
            log.error((Object)("Error while deleting script library " + functionLibraryName + " for tenant domain " + this.getTenantDomain()), (Throwable)((Object)e));
            throw e;
        }
    }

    public void updateFunctionLibrary(String oldFunctionLibraryName, FunctionLibrary functionLibrary) throws FunctionLibraryManagementException {
        try {
            this.validateInputs(functionLibrary);
            this.evaluateScript(functionLibrary);
            this.functionLibMgtService = FunctionLibraryManagementServiceImpl.getInstance();
            this.functionLibMgtService.updateFunctionLibrary(oldFunctionLibraryName, functionLibrary, this.getTenantDomain());
        }
        catch (FunctionLibraryManagementException e) {
            log.error((Object)("Error while updating script library " + oldFunctionLibraryName + "for tenant domain " + this.getTenantDomain()), (Throwable)((Object)e));
            throw e;
        }
    }

    private void validateInputs(FunctionLibrary functionLibrary) throws FunctionLibraryManagementException {
        if (StringUtils.isBlank((String)functionLibrary.getFunctionLibraryName())) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_REQUIRE_SCRIPT_LIBRARY_NAME);
        }
        if (StringUtils.isBlank((String)functionLibrary.getFunctionLibraryScript())) {
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_REQUIRE_SCRIPT_LIBRARY_SCRIPT);
        }
    }

    private void evaluateScript(FunctionLibrary functionLibrary) throws FunctionLibraryManagementException {
        try {
            ScriptEngine engine = new NashornScriptEngineFactory().getScriptEngine(new String[]{"--no-java"});
            String head = "var module = { exports:{} }; \nvar exports = {}; \nfunction require(name){};";
            String code = functionLibrary.getFunctionLibraryScript();
            code = head + code;
            engine.eval(code);
        }
        catch (ScriptException e) {
            log.error((Object)("Script library script of " + functionLibrary.getFunctionLibraryName() + " contains errors."), (Throwable)e);
            throw FunctionLibraryExceptionManagementUtil.handleClientException(FunctionLibraryManagementConstants.ErrorMessage.ERROR_CODE_VALIDATE_SCRIPT_LIBRARY_SCRIPT, functionLibrary.getFunctionLibraryName(), e);
        }
    }
}

