/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.receiver.ui;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.event.receiver.stub.EventReceiverAdminServiceStub;
import org.wso2.carbon.event.stream.stub.EventStreamAdminServiceStub;
import org.wso2.carbon.event.stream.stub.types.EventStreamAttributeDto;
import org.wso2.carbon.event.stream.stub.types.EventStreamDefinitionDto;
import org.wso2.carbon.ui.CarbonUIUtil;

public class EventReceiverUIUtils {
    public static EventReceiverAdminServiceStub getEventReceiverAdminService(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "EventReceiverAdminService.EventReceiverAdminServiceHttpsSoap12Endpoint";
        EventReceiverAdminServiceStub stub = new EventReceiverAdminServiceStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static EventStreamAdminServiceStub getEventStreamAdminService(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "EventStreamAdminService.EventStreamAdminServiceHttpsSoap12Endpoint";
        EventStreamAdminServiceStub stub = new EventStreamAdminServiceStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static List<String> getAttributeListWithPrefix(EventStreamDefinitionDto streamDefinitionDto) {
        ArrayList<String> attributeList = new ArrayList<String>();
        if (streamDefinitionDto.getMetaData() != null) {
            for (EventStreamAttributeDto metaData : streamDefinitionDto.getMetaData()) {
                attributeList.add("meta_" + metaData.getAttributeName() + " " + metaData.getAttributeType());
            }
        }
        if (streamDefinitionDto.getCorrelationData() != null) {
            for (EventStreamAttributeDto correlationData : streamDefinitionDto.getCorrelationData()) {
                attributeList.add("correlation_" + correlationData.getAttributeName() + " " + correlationData.getAttributeType());
            }
        }
        if (streamDefinitionDto.getPayloadData() != null) {
            for (EventStreamAttributeDto payloadData : streamDefinitionDto.getPayloadData()) {
                attributeList.add(payloadData.getAttributeName() + " " + payloadData.getAttributeType());
            }
        }
        return attributeList;
    }
}

