/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.services.authentication.stats.LoginAttempt;
import org.wso2.carbon.core.services.authentication.stats.LoginStatDatabase;
import org.wso2.carbon.core.services.callback.LoginSubscriptionManagerServiceImpl;
import org.wso2.carbon.core.services.internal.CarbonServicesServiceComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ThriftSession;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;

public class CarbonAuthenticationUtil {
    private static final Log log = LogFactory.getLog(CarbonAuthenticationUtil.class);
    private static Log audit = CarbonConstants.AUDIT_LOG;
    public static String LOGGED_IN_DOMAIN = "logged_in_domain";

    public static void onFailedAdminLogin(HttpSession httpSess, String username, int tenantId, String remoteAddress, String reason) throws Exception {
        CarbonAuthenticationUtil.onFailedAdminLogin(httpSess, username, tenantId, null, remoteAddress, reason);
    }

    public static void onFailedAdminLogin(HttpSession httpSess, String username, int tenantId, String tenantDomain, String remoteAddress, String reason) throws Exception {
        if (httpSess != null) {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setUsername(username);
            carbonContext.setTenantId(tenantId);
            if (tenantDomain == null) {
                tenantDomain = carbonContext.getTenantDomain(true);
            }
            carbonContext.setTenantDomain(tenantDomain);
        }
        Date currentTime = Calendar.getInstance().getTime();
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSZ']'");
        String msg = "Login failed. Unauthorized login attempt '" + username + "[" + tenantId + "]' at " + date.format(currentTime);
        if (!CarbonUtils.isRunningOnLocalTransportMode()) {
            msg = msg + " from IP address " + remoteAddress;
        }
        log.warn((Object)msg);
        audit.warn((Object)msg);
        if (httpSess != null) {
            httpSess.invalidate();
        }
        LoginAttempt loginAttempt = new LoginAttempt(username, tenantId, remoteAddress, new Date(), false, reason);
        LoginStatDatabase.recordLoginAttempt(loginAttempt);
    }

    public static void onSuccessAdminLogin(HttpSession httpSess, String username, int tenantId, String tenantDomain, String remoteAddress) throws Exception {
        CarbonAuthenticationUtil.initializeLoggedInUserRegistry(httpSess, username, tenantId, tenantDomain);
        Date currentTime = Calendar.getInstance().getTime();
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSZ']'");
        String msg = "'" + username + "@" + tenantDomain + " [" + tenantId + "]' logged in at " + date.format(currentTime);
        if (!CarbonUtils.isRunningOnLocalTransportMode()) {
            msg = msg + " from IP address " + remoteAddress;
        }
        log.info((Object)msg);
        audit.info((Object)msg);
        LoginSubscriptionManagerServiceImpl loginSubscriptionManagerServiceImpl = CarbonServicesServiceComponent.getLoginSubscriptionManagerServiceImpl();
        UserRegistry configRegistry = CarbonServicesServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId);
        loginSubscriptionManagerServiceImpl.triggerEvent((Registry)configRegistry, username, tenantId, tenantDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Registry instance is set in the session for user " + username));
        }
        try {
            if (!"carbon.super".equals(tenantDomain)) {
                TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)CarbonServicesServiceComponent.getConfigurationContextService().getServerConfigContext());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error trying load tenant after successful login", (Throwable)e);
        }
        LoginAttempt loginAttempt = new LoginAttempt(username, tenantId, remoteAddress, new Date(), true, null);
        LoginStatDatabase.recordLoginAttempt(loginAttempt);
    }

    public static void initializeLoggedInUserRegistry(HttpSession httpSession, String username, int tenantId, String tenantDomain) throws Exception {
        RegistryService registryService = CarbonServicesServiceComponent.getRegistryService();
        UserRegistry userRegistry = registryService.getConfigUserRegistry(username, tenantId);
        UserRegistry governanceUserRegistry = registryService.getGovernanceUserRegistry(username, tenantId);
        UserRegistry systemRegistry = registryService.getConfigSystemRegistry(tenantId);
        UserRegistry governanceRegistry = registryService.getGovernanceSystemRegistry(tenantId);
        if (httpSession != null) {
            httpSession.setAttribute("wso2carbon.admin.logged.in", (Object)username);
            if (tenantDomain != null) {
                httpSession.setAttribute("tenantDomain", (Object)tenantDomain);
                if (tenantDomain.equals("carbon.super")) {
                    httpSession.setAttribute(MultitenantConstants.IS_SUPER_TENANT, (Object)"true");
                }
            } else {
                audit.info((Object)"User with null domain tried to login.");
                return;
            }
            httpSession.setAttribute("WSO2RegistryRoot", (Object)registryService.getRegistry(username, tenantId));
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setUsername(username);
            carbonContext.setTenantDomain(tenantDomain);
            carbonContext.setTenantId(tenantId);
            carbonContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, (org.wso2.carbon.registry.api.Registry)systemRegistry);
            carbonContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, (org.wso2.carbon.registry.api.Registry)governanceRegistry);
            carbonContext.setRegistry(RegistryType.USER_CONFIGURATION, (org.wso2.carbon.registry.api.Registry)userRegistry);
            carbonContext.setRegistry(RegistryType.USER_GOVERNANCE, (org.wso2.carbon.registry.api.Registry)governanceUserRegistry);
            carbonContext.setUserRealm((UserRealm)governanceUserRegistry.getUserRealm());
        }
    }

    public static void onSuccessAdminLogin(ThriftSession thriftSession, String username, int tenantId, String tenantDomain, String remoteAddress) throws Exception {
        RegistryService registryService = CarbonServicesServiceComponent.getRegistryService();
        UserRegistry userRegistry = registryService.getConfigUserRegistry(username, tenantId);
        UserRegistry governanceUserRegistry = registryService.getGovernanceUserRegistry(username, tenantId);
        UserRegistry systemRegistry = registryService.getConfigSystemRegistry(tenantId);
        UserRegistry governanceRegistry = registryService.getGovernanceSystemRegistry(tenantId);
        if (thriftSession != null) {
            thriftSession.setAttribute("wso2carbon.admin.logged.in", (Object)username);
            if (tenantDomain == null) {
                audit.info((Object)"User with null domain tried to login.");
                return;
            }
            thriftSession.setAttribute("tenantDomain", (Object)tenantDomain);
            thriftSession.setAttribute("WSO2RegistryRoot", (Object)registryService.getRegistry(username, tenantId));
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setUsername(username);
            carbonContext.setTenantDomain(tenantDomain);
            carbonContext.setTenantId(tenantId);
            carbonContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, (org.wso2.carbon.registry.api.Registry)systemRegistry);
            carbonContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, (org.wso2.carbon.registry.api.Registry)governanceRegistry);
            carbonContext.setRegistry(RegistryType.USER_CONFIGURATION, (org.wso2.carbon.registry.api.Registry)userRegistry);
            carbonContext.setRegistry(RegistryType.USER_GOVERNANCE, (org.wso2.carbon.registry.api.Registry)governanceUserRegistry);
            carbonContext.setUserRealm((UserRealm)governanceUserRegistry.getUserRealm());
            thriftSession.setAttribute("username", (Object)username);
            thriftSession.setAttribute("tenantDomain", (Object)tenantDomain);
            thriftSession.setAttribute("tenantId", (Object)tenantId);
        }
        Date currentTime = Calendar.getInstance().getTime();
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSZ']'");
        String msg = "'" + username + "@" + tenantDomain + " [" + tenantId + "]' logged in at " + date.format(currentTime) + " from IP address " + remoteAddress;
        log.info((Object)msg);
        audit.info((Object)msg);
        LoginSubscriptionManagerServiceImpl loginSubscriptionManagerServiceImpl = CarbonServicesServiceComponent.getLoginSubscriptionManagerServiceImpl();
        UserRegistry configRegistry = CarbonServicesServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId);
        loginSubscriptionManagerServiceImpl.triggerEvent((Registry)configRegistry, username, tenantId, tenantDomain);
        try {
            if (!"carbon.super".equals(tenantDomain)) {
                TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)CarbonServicesServiceComponent.getConfigurationContextService().getServerConfigContext());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error trying load tenant after successful login", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User Registry instance is set in the session for user " + username));
        }
        LoginAttempt loginAttempt = new LoginAttempt(username, tenantId, remoteAddress, new Date(), true, null);
        LoginStatDatabase.recordLoginAttempt(loginAttempt);
    }
}

