/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication.stats;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.services.authentication.stats.LoginAttempt;
import org.wso2.carbon.core.services.authentication.stats.UserAttempts;

public class LoginStatDatabase {
    private static final Log log = LogFactory.getLog(LoginStatDatabase.class);
    public static final int MAX_COUNT = 50000;
    private static Queue<LoginAttempt> attempts = new ConcurrentLinkedQueue<LoginAttempt>();
    private static Map<String, UserAttempts> attemptsByUsers = new ConcurrentHashMap<String, UserAttempts>();
    public static volatile int count = 0;
    public static volatile int failedCount = 0;

    public static void recordLoginAttempt(LoginAttempt loginAttempt) {
        if (count > 50000) {
            attempts.poll();
            --count;
        }
        try {
            attempts.add(loginAttempt);
            ++count;
            if (!loginAttempt.isSuccessful()) {
                ++failedCount;
            }
            LoginStatDatabase.addUserAttemp(loginAttempt);
        }
        catch (Exception e) {
            log.error((Object)("Error recording stats" + e.getMessage()), (Throwable)e);
        }
    }

    private static void addUserAttemp(LoginAttempt loginAttempt) {
        String userName = loginAttempt.getUserName();
        if (attemptsByUsers.containsKey(userName)) {
            UserAttempts userAttempts = attemptsByUsers.get(userName);
            if (loginAttempt.isSuccessful()) {
                userAttempts.setTotalLogins(userAttempts.getTotalLogins() + 1);
            } else {
                userAttempts.setTotalLogins(userAttempts.getTotalLogins() + 1);
                userAttempts.setFailedLogins(userAttempts.getFailedLogins() + 1);
            }
        } else if (loginAttempt.isSuccessful()) {
            UserAttempts userAttempts = new UserAttempts(userName, 1, 0);
            attemptsByUsers.put(userName, userAttempts);
        } else {
            UserAttempts userAttempts = new UserAttempts(userName, 1, 1);
            attemptsByUsers.put(userName, userAttempts);
        }
    }

    public static LoginAttempt[] getAllAttempts() {
        return attempts.toArray(new LoginAttempt[0]);
    }

    public static int getCount() {
        return count;
    }

    public static int getFailedCount() {
        return failedCount;
    }

    public static UserAttempts[] getUserBasedLoginDetails() {
        return attemptsByUsers.values().toArray(new UserAttempts[attemptsByUsers.values().size()]);
    }
}

