/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.services.authentication.AuthenticationUtil;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.core.services.authentication.RememberMeData;
import org.wso2.carbon.core.services.internal.CarbonServicesServiceComponent;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthenticationAdmin
implements CarbonServerAuthenticator {
    private static final Log log = LogFactory.getLog(AuthenticationAdmin.class);
    private static Log audit = CarbonConstants.AUDIT_LOG;
    protected static final String AUTHENTICATION_ADMIN_SERVICE = "AuthenticationAdminService";
    private static final int DEFAULT_PRIORITY_LEVEL = 5;
    private static final String AUTHENTICATOR_NAME = "DefaultCarbonAuthenticator";

    public boolean login(String username, String password, String remoteAddress) throws AuthenticationException {
        HttpSession httpSession = this.getHttpSession();
        try {
            if (username == null || password == null || username.trim().equals("") || password.trim().equals("")) {
                CarbonAuthenticationUtil.onFailedAdminLogin(httpSession, username, -1, remoteAddress, "Data");
                return false;
            }
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            if (remoteAddress != null) {
                AuthenticationUtil.validateRemoteAddress(remoteAddress);
            } else {
                remoteAddress = AuthenticationUtil.getRemoteAddress(MessageContext.getCurrentMessageContext());
            }
            RegistryService registryService = CarbonServicesServiceComponent.getRegistryService();
            RealmService realmService = CarbonServicesServiceComponent.getRealmService();
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            this.handleAuthenticationStarted(tenantId);
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain(tenantDomain);
            carbonContext.setTenantId(tenantId);
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            org.wso2.carbon.user.core.UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            if (realm == null) {
                throw new AuthenticationException("Invalid domain or unactivated tenant login");
            }
            boolean isAuthenticated = realm.getUserStoreManager().authenticate(username, (Object)password);
            boolean isAuthorized = false;
            if (isAuthenticated) {
                String domain;
                int index = username.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                if (index < 0 && (domain = UserCoreUtil.getDomainFromThreadLocal()) != null) {
                    username = domain + CarbonConstants.DOMAIN_SEPARATOR + username;
                }
                isAuthorized = realm.getAuthorizationManager().isUserAuthorized(username, "/permission/admin/login", "ui.execute");
            }
            if (isAuthenticated && isAuthorized) {
                CarbonAuthenticationUtil.onSuccessAdminLogin(httpSession, username, tenantId, tenantDomain, remoteAddress);
                this.handleAuthenticationCompleted(tenantId, true);
                return true;
            }
            CarbonAuthenticationUtil.onFailedAdminLogin(httpSession, username, tenantId, remoteAddress, "Invalid credential");
            this.handleAuthenticationCompleted(tenantId, false);
            return false;
        }
        catch (UserStoreException e) {
            if (this.isLoginFailureReasonEnabled()) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e);
            }
            String msg = "System error while Authenticating/Authorizing User : " + e.getMessage();
            log.error((Object)msg);
            return false;
        }
        catch (AuthenticationException e) {
            log.error((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            String msg = "System error while Authenticating/Authorizing User : " + e.getMessage();
            if (log.isDebugEnabled()) {
                log.error((Object)msg, (Throwable)e);
            } else {
                log.error((Object)msg);
            }
            return false;
        }
    }

    public RememberMeData loginWithRememberMeOption(String username, String password, String remoteAddress) throws AuthenticationException {
        boolean isLoggedIn = this.login(username, password, remoteAddress);
        RememberMeData data = null;
        try {
            if (isLoggedIn) {
                String uuid = UUID.randomUUID().toString();
                data = new RememberMeData();
                data.setMaxAge(604800);
                data.setValue(username + "-" + uuid);
                RealmService realmService = CarbonServicesServiceComponent.getRealmService();
                String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
                int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                UserRealm realm = realmService.getTenantUserRealm(tenantId);
                realm.getUserStoreManager().addRememberMe(MultitenantUtils.getTenantAwareUsername((String)username), uuid);
                data.setAuthenticated(true);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    public boolean loginWithRememberMeCookie(String cookie) {
        return this.createSessionForValidRememberMe(cookie, this.getHttpSession());
    }

    private void handleAuthenticationStarted(int tenantId) throws Exception {
        BundleContext bundleContext = CarbonServicesServiceComponent.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }

    private void handleAuthenticationCompleted(int tenantId, boolean isSuccessful) throws Exception {
        BundleContext bundleContext = CarbonServicesServiceComponent.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).completedAuthentication(tenantId, isSuccessful);
                }
            }
            tracker.close();
        }
    }

    public void logout() throws AuthenticationException {
        Date currentTime = Calendar.getInstance().getTime();
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
        HttpSession session = this.getHttpSession();
        if (session != null) {
            int tenantId;
            String loggedInUser = (String)session.getAttribute("wso2carbon.admin.logged.in");
            String delegatedBy = (String)session.getAttribute("DELEGATED_BY");
            String tenantDomain = (String)session.getAttribute("tenantDomain");
            try {
                tenantId = CarbonServicesServiceComponent.getRealmService().getTenantManager().getTenantId(tenantDomain);
            }
            catch (Exception e) {
                int tenantId2 = -1;
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AuthenticationException((Throwable)e);
            }
            if (delegatedBy == null && loggedInUser != null) {
                String logMsg = "'" + loggedInUser + "@" + tenantDomain + " [" + tenantId + "]' logged out at " + date.format(currentTime);
                log.info((Object)logMsg);
                audit.info((Object)logMsg);
            } else if (loggedInUser != null) {
                String logMsg = "'" + loggedInUser + "@" + tenantDomain + " [" + tenantId + "]' logged out at " + date.format(currentTime) + " delegated by " + delegatedBy;
                log.info((Object)logMsg);
                audit.info((Object)logMsg);
            }
            if (!this.isRequestedFromLocalTransport()) {
                session.invalidate();
            }
        }
    }

    private boolean isRequestedFromLocalTransport() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        if (msgCtx != null) {
            String incomingTransportName = msgCtx.getIncomingTransportName();
            return incomingTransportName.equals("local");
        }
        return false;
    }

    @Override
    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    @Override
    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 5;
    }

    @Override
    public boolean isAuthenticated(MessageContext messageContext) {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession();
        String userLoggedIn = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
        return userLoggedIn != null;
    }

    @Override
    public boolean authenticateWithRememberMe(MessageContext messageContext) {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!"wso2.carbon.rememberme".equals(name)) continue;
                return this.createSessionForValidRememberMe(cookie.getValue(), request.getSession());
            }
        }
        return false;
    }

    @Override
    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    @Override
    public boolean isHandle(MessageContext msgContext) {
        return true;
    }

    private boolean createSessionForValidRememberMe(String cookie, HttpSession httpSession) {
        boolean isValid = false;
        try {
            RealmService realmService = CarbonServicesServiceComponent.getRealmService();
            int index = cookie.indexOf(45);
            if (index < 1) {
                return false;
            }
            String userNameWithTenant = cookie.substring(0, index);
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userNameWithTenant);
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            this.handleAuthenticationStarted(tenantId);
            String userName = MultitenantUtils.getTenantAwareUsername((String)userNameWithTenant);
            String uuid = cookie.substring(index + 1);
            UserRealm realm = realmService.getTenantUserRealm(tenantId);
            if (realm == null) {
                return false;
            }
            boolean isAuthenticated = realm.getUserStoreManager().isValidRememberMeToken(userName, uuid);
            boolean isAuthorized = false;
            if (isAuthenticated) {
                isAuthorized = realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/login", "ui.execute");
            }
            if (isAuthenticated && isAuthorized) {
                CarbonAuthenticationUtil.onSuccessAdminLogin(httpSession, userName, tenantId, tenantDomain, "");
                this.handleAuthenticationCompleted(tenantId, true);
                isValid = true;
            } else {
                CarbonAuthenticationUtil.onFailedAdminLogin(httpSession, userName, tenantId, "", "Invalid credential");
                this.handleAuthenticationCompleted(tenantId, false);
            }
            return isValid;
        }
        catch (Exception e) {
            String msg = "Error while Authenticating/Authorizing User : " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    private HttpSession getHttpSession() {
        HttpServletRequest request;
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSession = null;
        if (msgCtx != null && (request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) != null) {
            httpSession = request.getSession();
        }
        return httpSession;
    }

    private boolean isLoginFailureReasonEnabled() {
        String enableLoginFailureReason = ServerConfiguration.getInstance().getFirstProperty("EnableLoginFailureReason");
        return enableLoginFailureReason != null && "true".equals(enableLoginFailureReason.trim());
    }
}

