/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.jaggeryjs.jaggery.app.mgt.JaggeryApplication;
import org.jaggeryjs.jaggery.app.mgt.JaggeryDeploymentUtil;
import org.jaggeryjs.jaggery.core.ScriptReader;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.JaggerySecurityDomain;
import org.jaggeryjs.jaggery.core.manager.WebAppManager;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityDomain;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionManager;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionPersistentManager;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class TomcatJaggeryWebappsDeployer
extends TomcatGenericWebappsDeployer {
    private static Log log = LogFactory.getLog(TomcatJaggeryWebappsDeployer.class);

    public TomcatJaggeryWebappsDeployer(String webContextPrefix, int tenantId, String tenantDomain, Map<String, WebApplicationsHolder> webApplicationsHolderMap, ConfigurationContext configurationContext) {
        super(webContextPrefix, tenantId, tenantDomain, webApplicationsHolderMap, configurationContext);
    }

    public void deploy(File webappFile, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        try {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.tenantDomain);
            long lastModifiedTime = webappFile.lastModified();
            long configLastModified = 0L;
            if (JaggeryDeploymentUtil.getConfig(webappFile) != null) {
                configLastModified = JaggeryDeploymentUtil.getConfig(webappFile).lastModified();
            }
            JaggeryApplication deployedWebapp = (JaggeryApplication)((Object)WebAppUtils.getWebappHolder((String)webappFile.getAbsolutePath(), (ConfigurationContext)this.configurationContext).getStartedWebapps().get(webappFile.getName()));
            JaggeryApplication undeployedWebapp = (JaggeryApplication)((Object)WebAppUtils.getWebappHolder((String)webappFile.getAbsolutePath(), (ConfigurationContext)this.configurationContext).getStoppedWebapps().get(webappFile.getName()));
            JaggeryApplication faultyWebapp = (JaggeryApplication)((Object)WebAppUtils.getWebappHolder((String)webappFile.getAbsolutePath(), (ConfigurationContext)this.configurationContext).getFaultyWebapps().get(webappFile.getName()));
            if (deployedWebapp == null && faultyWebapp == null && undeployedWebapp == null) {
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            } else if (deployedWebapp != null && deployedWebapp.getLastModifiedTime() != lastModifiedTime && configLastModified != 0L && deployedWebapp.getConfigDirLastModifiedTime() != configLastModified) {
                this.undeploy(webappFile);
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            } else if (faultyWebapp != null && faultyWebapp.getLastModifiedTime() != lastModifiedTime && configLastModified != 0L && faultyWebapp.getConfigDirLastModifiedTime() != configLastModified) {
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error while Tomact jaggery web apps Deployment ", t);
        }
    }

    public void undeploy(File webappFile) throws CarbonException {
        super.undeploy(webappFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    protected void handleZipWebappDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        TomcatJaggeryWebappsDeployer tomcatJaggeryWebappsDeployer = this;
        synchronized (tomcatJaggeryWebappsDeployer) {
            String appPath = webapp.getAbsolutePath().substring(0, webapp.getAbsolutePath().indexOf(".zip"));
            JSONObject jsonConf = null;
            File webAppRoot = null;
            boolean doUnzip = true;
            try {
                block7: for (Map.Entry entry : this.webApplicationsHolderMap.entrySet()) {
                    WebApplicationsHolder value = (WebApplicationsHolder)entry.getValue();
                    for (Map.Entry holder : value.getStartedWebapps().entrySet()) {
                        WebApplication holderValue = (WebApplication)holder.getValue();
                        webAppRoot = holderValue.getWebappFile();
                        if (!appPath.contains(webAppRoot.getAbsolutePath())) continue;
                        jsonConf = this.readJaggeryConfig(webAppRoot);
                        continue block7;
                    }
                }
                if (jsonConf != null) {
                    List dirListToExclude;
                    Object excludedDirListJson = jsonConf.get((Object)"excludeFromDeployment");
                    List list = dirListToExclude = excludedDirListJson == null ? null : (List)excludedDirListJson;
                    if (dirListToExclude != null) {
                        for (String excludedDir : dirListToExclude) {
                            String relativePath = appPath.substring(webAppRoot.getAbsolutePath().length(), appPath.length());
                            if (!relativePath.contains(excludedDir)) continue;
                            doUnzip = false;
                            break;
                        }
                    }
                }
                if (doUnzip) {
                    JaggeryDeploymentUtil.unZip(new FileInputStream(webapp), appPath);
                    if (!webapp.delete()) {
                        throw new CarbonException(appPath + "could not be deleted");
                    }
                }
            }
            catch (IOException e) {
                throw new CarbonException((Throwable)e);
            }
            catch (ClassCastException e) {
                throw new CarbonException((Throwable)e);
            }
            catch (NullPointerException e) {
                throw new CarbonException((Throwable)e);
            }
            if (doUnzip) {
                File unzippedWebapp = new File(appPath);
                this.handleExplodedWebappDeployment(unzippedWebapp, webContextParams, applicationEventListeners);
            }
        }
    }

    private void registerApplicationEventListeners(List<Object> applicationEventListeners, Context context) {
        Object[] originalEventListeners = context.getApplicationEventListeners();
        Object[] newEventListeners = new Object[originalEventListeners.length + applicationEventListeners.size()];
        if (originalEventListeners.length != 0) {
            System.arraycopy(originalEventListeners, 0, newEventListeners, 0, originalEventListeners.length);
            int i = originalEventListeners.length;
            for (Object eventListener : applicationEventListeners) {
                newEventListeners[i++] = eventListener;
            }
        } else {
            newEventListeners = applicationEventListeners.toArray(new Object[applicationEventListeners.size()]);
        }
        context.setApplicationEventListeners(newEventListeners);
    }

    protected void handleWebappDeployment(File webappFile, String contextStr, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappFile.getName();
        ArrayList listeners = new ArrayList(1);
        SecurityConstraint securityConstraint = new SecurityConstraint();
        securityConstraint.setAuthConstraint(true);
        SecurityCollection securityCollection = new SecurityCollection();
        securityCollection.setName("ConfigDir");
        securityCollection.setDescription("Jaggery Configuration Dir");
        securityCollection.addPattern("/jaggery.conf");
        securityConstraint.addCollection(securityCollection);
        WebApplicationsHolder webApplicationsHolder = WebAppUtils.getWebappHolder((String)webappFile.getAbsolutePath(), (ConfigurationContext)this.configurationContext);
        try {
            JSONObject jaggeryConfigObj = this.readJaggeryConfig(webappFile);
            Context context = DataHolder.getCarbonTomcatService().addWebApp(contextStr, webappFile.getAbsolutePath(), (LifecycleListener)new JaggeryConfListener(jaggeryConfigObj, securityConstraint));
            Manager manager = context.getManager();
            if (TomcatJaggeryWebappsDeployer.isDistributable(context, jaggeryConfigObj)) {
                CarbonTomcatClusterableSessionManager sessionManager;
                context.setDistributable(true);
                if (manager instanceof CarbonTomcatClusterableSessionManager) {
                    sessionManager = (CarbonTomcatClusterableSessionManager)manager;
                    sessionManager.setOwnerTenantId(this.tenantId);
                } else {
                    sessionManager = new CarbonTomcatClusterableSessionManager(this.tenantId);
                    context.setManager((Manager)sessionManager);
                }
                Object alreadyinsertedSMMap = this.configurationContext.getProperty("CarbonTomcatSessionManagerMap");
                if (alreadyinsertedSMMap != null) {
                    ((Map)alreadyinsertedSMMap).put(context.getName(), sessionManager);
                } else {
                    this.sessionManagerMap.put(context.getName(), sessionManager);
                    this.configurationContext.setProperty("CarbonTomcatSessionManagerMap", (Object)this.sessionManagerMap);
                }
            } else if (manager instanceof CarbonTomcatSessionManager) {
                ((CarbonTomcatSessionManager)manager).setOwnerTenantId(this.tenantId);
            } else if (manager instanceof CarbonTomcatSessionPersistentManager) {
                ((CarbonTomcatSessionPersistentManager)manager).setOwnerTenantId(this.tenantId);
                log.debug((Object)(((CarbonTomcatSessionPersistentManager)manager).getName() + " enabled Tomcat HTTP Session Persistent mode using " + ((CarbonTomcatSessionPersistentManager)manager).getStore().toString()));
            } else {
                context.setManager((Manager)new CarbonTomcatSessionManager(this.tenantId));
            }
            context.setReloadable(false);
            JaggeryApplication webapp = new JaggeryApplication(this, context, webappFile);
            webapp.setServletContextParameters(webContextParams);
            webapp.setState("Started");
            webApplicationsHolder.getStartedWebapps().put(filename, webapp);
            webApplicationsHolder.getFaultyWebapps().remove(filename);
            this.registerApplicationEventListeners(applicationEventListeners, context);
            log.info((Object)("Deployed webapp: " + (Object)((Object)webapp)));
        }
        catch (Throwable e) {
            StandardContext context = new StandardContext();
            context.setName(webappFile.getName());
            context.addParameter("faulty.webapp", "true");
            JaggeryApplication webapp = new JaggeryApplication(this, (Context)context, webappFile);
            webapp.setProperty("webappFilter", "jaggeryWebapp");
            String msg = "Error while deploying webapp: " + (Object)((Object)webapp);
            log.error((Object)msg, e);
            webapp.setFaultReason(new Exception(msg, e));
            webApplicationsHolder.getFaultyWebapps().put(filename, webapp);
            webApplicationsHolder.getStartedWebapps().remove(filename);
            throw new CarbonException(msg, e);
        }
    }

    private static void initJaggeryappDefaults(Context ctx, JSONObject jaggeryConfig, SecurityConstraint securityConstraint) {
        Tomcat.addServlet((Context)ctx, (String)"JaggeryServlet", (String)"org.jaggeryjs.jaggery.core.JaggeryServlet");
        TomcatJaggeryWebappsDeployer.addContextParams(ctx, jaggeryConfig);
        TomcatJaggeryWebappsDeployer.addListeners(ctx, jaggeryConfig);
        TomcatJaggeryWebappsDeployer.addServlets(ctx, jaggeryConfig);
        TomcatJaggeryWebappsDeployer.addFilters(ctx, jaggeryConfig);
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName("JaggeryFilter");
        filterDef.setFilterClass("org.jaggeryjs.jaggery.core.JaggeryFilter");
        ctx.addFilterDef(filterDef);
        FilterMap filterMapping = new FilterMap();
        filterMapping.setFilterName("JaggeryFilter");
        filterMapping.addURLPattern("*.jag");
        ctx.addFilterMap(filterMapping);
        ctx.addApplicationListener("org.jaggeryjs.jaggery.core.listeners.WebAppSessionListener");
        ctx.addConstraint(securityConstraint);
        TomcatJaggeryWebappsDeployer.addWelcomeFiles(ctx, jaggeryConfig);
        if (jaggeryConfig != null) {
            TomcatJaggeryWebappsDeployer.setDisplayName(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addErrorPages(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addSecurityConstraints(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.setLoginConfig(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addSecurityRoles(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addParameters(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addLogLevel(ctx, jaggeryConfig);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private JSONObject readJaggeryConfig(File file) throws IOException {
        File confFile = new File(file.getAbsolutePath() + File.separator + "jaggery.conf");
        if (!confFile.exists()) {
            return null;
        }
        String jsonString = "";
        if (!confFile.isDirectory()) {
            FileInputStream fis = new FileInputStream(confFile);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)fis, (Writer)writer, null);
            jsonString = writer.toString();
        }
        return (JSONObject)JSONValue.parse((String)jsonString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSessionCreatedListners(Context context, JSONArray arr) {
        if (arr != null) {
            try {
                Object[] scripts;
                JaggeryContext sharedContext = WebAppManager.sharedJaggeryContext((ServletContext)context.getServletContext());
                CommonManager.setJaggeryContext((JaggeryContext)sharedContext);
                RhinoEngine engine = sharedContext.getEngine();
                org.mozilla.javascript.Context cx = engine.enterContext();
                ServletContext servletContext = (ServletContext)sharedContext.getProperty("jaggery.servlet.context");
                ArrayList<String> jsListeners = new ArrayList<String>();
                for (Object script : scripts = arr.toArray()) {
                    if (!(script instanceof String)) {
                        log.error((Object)("Invalid value for initScripts/destroyScripts in jaggery.conf : " + script));
                        continue;
                    }
                    String path = (String)script;
                    path = path.startsWith("/") ? path : "/" + path;
                    Stack callstack = CommonManager.getCallstack((JaggeryContext)sharedContext);
                    callstack.push(path);
                    jsListeners.add(path);
                }
                servletContext.setAttribute("js.created.listeners", jsListeners);
            }
            finally {
                if (org.mozilla.javascript.Context.getCurrentContext() != null) {
                    RhinoEngine.exitContext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSessionDestroyedListners(Context context, JSONArray arr) {
        if (arr != null) {
            try {
                Object[] scripts;
                JaggeryContext sharedContext = WebAppManager.sharedJaggeryContext((ServletContext)context.getServletContext());
                CommonManager.setJaggeryContext((JaggeryContext)sharedContext);
                RhinoEngine engine = sharedContext.getEngine();
                org.mozilla.javascript.Context cx = engine.enterContext();
                ServletContext servletContext = (ServletContext)sharedContext.getProperty("jaggery.servlet.context");
                ArrayList<String> jsListeners = new ArrayList<String>();
                for (Object script : scripts = arr.toArray()) {
                    if (!(script instanceof String)) {
                        log.error((Object)("Invalid value for initScripts/destroyScripts in jaggery.conf : " + script));
                        continue;
                    }
                    String path = (String)script;
                    path = path.startsWith("/") ? path : "/" + path;
                    Stack callstack = CommonManager.getCallstack((JaggeryContext)sharedContext);
                    callstack.push(path);
                    jsListeners.add(path);
                }
                servletContext.setAttribute("js.destroyed.listeners", jsListeners);
            }
            finally {
                if (org.mozilla.javascript.Context.getCurrentContext() != null) {
                    RhinoEngine.exitContext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeScripts(Context context, JSONArray arr) {
        if (arr != null) {
            try {
                Object[] scripts;
                JaggeryContext sharedContext = WebAppManager.sharedJaggeryContext((ServletContext)context.getServletContext());
                CommonManager.setJaggeryContext((JaggeryContext)sharedContext);
                RhinoEngine engine = sharedContext.getEngine();
                org.mozilla.javascript.Context cx = engine.enterContext();
                ServletContext servletContext = (ServletContext)sharedContext.getProperty("jaggery.servlet.context");
                ScriptableObject sharedScope = sharedContext.getScope();
                for (Object script : scripts = arr.toArray()) {
                    if (!(script instanceof String)) {
                        log.error((Object)("Invalid value for initScripts/destroyScripts in jaggery.conf : " + script));
                        continue;
                    }
                    String path = (String)script;
                    path = path.startsWith("/") ? path : "/" + path;
                    Stack callstack = CommonManager.getCallstack((JaggeryContext)sharedContext);
                    callstack.push(path);
                    String[] parts = WebAppManager.getKeys((String)servletContext.getContextPath(), (String)path, (String)path);
                    ScriptCachingContext sctx = new ScriptCachingContext(sharedContext.getTenantId(), parts[0], parts[1], parts[2]);
                    sctx.setSecurityDomain((RhinoSecurityDomain)new JaggerySecurityDomain(path, servletContext));
                    engine.exec((Reader)new ScriptReader(servletContext.getResourceAsStream(path)){

                        protected void build() throws IOException {
                            try {
                                this.sourceReader = new StringReader(HostObjectUtil.streamToString((InputStream)this.sourceIn));
                            }
                            catch (ScriptException e) {
                                throw new IOException(e);
                            }
                        }
                    }, sharedScope, sctx);
                }
            }
            catch (ScriptException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (org.mozilla.javascript.Context.getCurrentContext() != null) {
                    RhinoEngine.exitContext();
                }
            }
        }
    }

    private static void addErrorPages(Context context, JSONObject obj) {
        JSONObject arr = (JSONObject)obj.get((Object)"errorPages");
        if (arr != null) {
            for (Object keys : arr.keySet()) {
                ErrorPage errPage = new ErrorPage();
                errPage.setErrorCode((String)keys);
                errPage.setLocation((String)arr.get(keys));
                context.addErrorPage(errPage);
            }
        }
    }

    private static void setLoginConfig(Context context, JSONObject obj) {
        JSONObject loginObj = (JSONObject)obj.get((Object)"loginConfig");
        if (loginObj != null) {
            if (loginObj.get((Object)"authMethod").equals("FORM")) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod("FORM");
                loginConfig.setLoginPage((String)((JSONObject)loginObj.get((Object)"formLoginConfig")).get((Object)"formLoginPage"));
                loginConfig.setErrorPage((String)((JSONObject)loginObj.get((Object)"formLoginConfig")).get((Object)"formErrorPage"));
                context.setLoginConfig(loginConfig);
            } else if (loginObj.get((Object)"authMethod").equals("BASIC")) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod("BASIC");
                context.setLoginConfig(loginConfig);
            }
        }
    }

    private static void addSecurityConstraints(Context context, JSONObject obj) {
        JSONArray arr = (JSONArray)obj.get((Object)"securityConstraints");
        if (arr != null) {
            for (Object anArr : arr) {
                JSONObject o = (JSONObject)anArr;
                SecurityConstraint securityConstraint = new SecurityConstraint();
                if (((JSONObject)o.get((Object)"securityConstraint")).get((Object)"webResourceCollection") != null) {
                    JSONObject resCollection = (JSONObject)((JSONObject)o.get((Object)"securityConstraint")).get((Object)"webResourceCollection");
                    SecurityCollection secCollection = new SecurityCollection();
                    secCollection.setName((String)resCollection.get((Object)"name"));
                    JSONArray arrPattern = (JSONArray)resCollection.get((Object)"urlPatterns");
                    for (Object anArrPattern : arrPattern) {
                        secCollection.addPattern((String)anArrPattern);
                    }
                    JSONArray methods = (JSONArray)resCollection.get((Object)"methods");
                    if (methods != null) {
                        for (Object method : methods) {
                            secCollection.addMethod((String)method);
                        }
                    }
                    securityConstraint.addCollection(secCollection);
                }
                if (((JSONObject)o.get((Object)"securityConstraint")).get((Object)"authRoles") != null) {
                    JSONArray roles = (JSONArray)((JSONObject)o.get((Object)"securityConstraint")).get((Object)"authRoles");
                    for (Object role : roles) {
                        securityConstraint.addAuthRole((String)role);
                    }
                    securityConstraint.setAuthConstraint(true);
                }
                if (((JSONObject)o.get((Object)"securityConstraint")).get((Object)"userDataConstraint") != null) {
                    JSONObject userDataConstraint = (JSONObject)((JSONObject)o.get((Object)"securityConstraint")).get((Object)"userDataConstraint");
                    String transportGuarantee = (String)userDataConstraint.get((Object)"transportGuarantee");
                    securityConstraint.setUserConstraint(transportGuarantee);
                }
                context.addConstraint(securityConstraint);
            }
        }
    }

    private static void addSecurityRoles(Context context, JSONObject obj) {
        JSONArray arr = (JSONArray)obj.get((Object)"securityRoles");
        if (arr != null) {
            for (Object role : arr) {
                context.addSecurityRole((String)role);
            }
        }
    }

    private static void setDisplayName(Context context, JSONObject obj) {
        if (obj == null) {
            return;
        }
        String dName = (String)obj.get((Object)"displayName");
        if (dName != null) {
            context.setDisplayName(dName);
        }
    }

    private static boolean isDistributable(Context context, JSONObject obj) {
        if (obj != null) {
            if (obj.get((Object)"distributable") instanceof Boolean) {
                Boolean isDistributable = (Boolean)obj.get((Object)"distributable");
                if (isDistributable != null) {
                    return isDistributable;
                }
            } else if (obj.get((Object)"distributable") instanceof String) {
                String distributable = (String)obj.get((Object)"distributable");
                return distributable != null && distributable.equalsIgnoreCase("true");
            }
        }
        return false;
    }

    private static void addParameters(Context context, JSONObject obj) {
        if (obj != null) {
            for (String key : obj.keySet()) {
                if (!(obj.get((Object)key) instanceof String)) continue;
                context.addParameter(key, (String)obj.get((Object)key));
            }
        }
    }

    private static void addWelcomeFiles(Context context, JSONObject obj) {
        if (obj != null) {
            JSONArray arr = (JSONArray)obj.get((Object)"welcomeFiles");
            if (arr != null) {
                for (Object role : arr) {
                    context.addWelcomeFile((String)role);
                }
            } else {
                context.addWelcomeFile("index.jag");
                context.addWelcomeFile("index.html");
            }
        } else {
            context.addWelcomeFile("index.jag");
            context.addWelcomeFile("index.html");
        }
    }

    private static void addUrlMappings(Context context, JSONObject obj) {
        Object test = context.getServletContext().getAttribute("org.jaggeryjs.serveFunction");
        JSONArray arr = null;
        if (test != null) {
            arr = new JSONArray();
            JSONObject js1 = new JSONObject();
            JSONObject js2 = new JSONObject();
            js1.put((Object)"url", (Object)"/*");
            js1.put((Object)"path", (Object)"/index.jag");
            arr.add((Object)js1);
        } else {
            arr = (JSONArray)obj.get((Object)"urlMappings");
        }
        if (arr != null) {
            HashMap<String, Object> urlMappings = new HashMap<String, Object>();
            for (Object mapObj : arr) {
                JSONObject mapping = (JSONObject)mapObj;
                String url = (String)mapping.get((Object)"url");
                String path = (String)mapping.get((Object)"path");
                if (url != null && path != null) {
                    path = path.startsWith("/") ? path : "/" + path;
                    FilterMap filterMap = new FilterMap();
                    filterMap.setFilterName("JaggeryFilter");
                    filterMap.addURLPattern(url);
                    context.addFilterMap(filterMap);
                    if (url.equals("/")) {
                        urlMappings.put("/", path);
                        continue;
                    }
                    url = url.startsWith("/") ? url.substring(1) : url;
                    ArrayList<String> parts = new ArrayList<String>(Arrays.asList(url.split("/", -1)));
                    TomcatJaggeryWebappsDeployer.addMappings(urlMappings, parts, path);
                    continue;
                }
                log.error((Object)("Invalid url mapping in jaggery.conf url : " + url + ", path : " + path));
            }
            context.getServletContext().setAttribute("jaggery.urls.map", urlMappings);
        }
    }

    private static void addLogLevel(Context cx, JSONObject jaggeryConfig) {
        String level = (String)jaggeryConfig.get((Object)"logLevel");
        if (level == null) {
            return;
        }
        ServletContext context = cx.getServletContext();
        context.setAttribute("hostobject.log.loglevel", (Object)level);
    }

    private static void addMappings(Map<String, Object> map, List<String> parts, String path) {
        HashMap<String, Object> childMap;
        String part = parts.remove(0);
        if (parts.isEmpty()) {
            Object obj = map.get(part);
            if (obj != null) {
                log.error((Object)("Conflicting url patterns for the path : " + path));
                return;
            }
            if (part.startsWith("*")) {
                int dotIndex = part.lastIndexOf(".");
                if (dotIndex != -1) {
                    HashMap<String, String> extsMap;
                    if (part.length() == dotIndex + 1) {
                        log.error((Object)("Extension cannot be found for the url pattern for " + path));
                        return;
                    }
                    String ext = part.substring(dotIndex + 1);
                    Object exts = map.get("*");
                    if (exts instanceof String) {
                        log.error((Object)("* wildcard mapping is already existing for " + path));
                        return;
                    }
                    if (exts == null) {
                        extsMap = new HashMap<String, String>();
                    } else {
                        extsMap = (HashMap<String, String>)exts;
                        if (extsMap.get(ext) != null) {
                            log.error((Object)("Url mapping is already existing for " + path));
                            return;
                        }
                    }
                    extsMap.put(ext, path);
                    map.put(part, extsMap);
                    return;
                }
                map.put(part, path);
                return;
            }
            map.put(part, path);
            return;
        }
        Object obj = map.get(part);
        if (obj instanceof Map) {
            childMap = (HashMap<String, Object>)obj;
        } else {
            childMap = new HashMap<String, Object>();
            map.put(part, childMap);
            if (obj instanceof String) {
                childMap.put("/", obj);
            }
        }
        TomcatJaggeryWebappsDeployer.addMappings(childMap, parts, path);
    }

    private static void addFilters(Context ctx, JSONObject jaggeryConfig) {
        if (jaggeryConfig != null) {
            String name;
            JSONArray arrFilters = (JSONArray)jaggeryConfig.get((Object)"filters");
            JSONArray arrFilterMappings = (JSONArray)jaggeryConfig.get((Object)"filterMappings");
            if (arrFilters != null) {
                for (Object filterObj : arrFilters) {
                    JSONObject filter = (JSONObject)filterObj;
                    name = (String)filter.get((Object)"name");
                    String clazz = (String)filter.get((Object)"class");
                    FilterDef filterDef = new FilterDef();
                    filterDef.setFilterName(name);
                    filterDef.setFilterClass(clazz);
                    JSONArray arrParams = (JSONArray)filter.get((Object)"params");
                    if (arrParams != null) {
                        for (Object paramObj : arrParams) {
                            JSONObject param = (JSONObject)paramObj;
                            String paramName = (String)param.get((Object)"name");
                            String paramValue = (String)param.get((Object)"value");
                            filterDef.addInitParameter(paramName, paramValue);
                        }
                    }
                    ctx.addFilterDef(filterDef);
                }
            }
            if (arrFilterMappings != null) {
                for (Object filterMappingObj : arrFilterMappings) {
                    JSONObject mapping = (JSONObject)filterMappingObj;
                    name = (String)mapping.get((Object)"name");
                    String url = (String)mapping.get((Object)"url");
                    FilterMap filterMapping = new FilterMap();
                    filterMapping.setFilterName(name);
                    filterMapping.addURLPattern(url);
                    ctx.addFilterMap(filterMapping);
                }
            }
        }
    }

    private static void addContextParams(Context ctx, JSONObject jaggeryConfig) {
        JSONArray arrContextParams;
        if (jaggeryConfig != null && (arrContextParams = (JSONArray)jaggeryConfig.get((Object)"contextParams")) != null) {
            for (Object contextParamObj : arrContextParams) {
                JSONObject contextParam = (JSONObject)contextParamObj;
                String name = (String)contextParam.get((Object)"name");
                String value = (String)contextParam.get((Object)"value");
                ctx.addParameter(name, value);
            }
        }
    }

    private static void addListeners(Context ctx, JSONObject jaggeryConfig) {
        JSONArray arrListeners;
        if (jaggeryConfig != null && (arrListeners = (JSONArray)jaggeryConfig.get((Object)"listeners")) != null) {
            for (Object listenerObj : arrListeners) {
                JSONObject listener = (JSONObject)listenerObj;
                String clazz = (String)listener.get((Object)"class");
                ctx.addApplicationListener(clazz);
            }
        }
    }

    private static void addServlets(Context ctx, JSONObject jaggeryConfig) {
        if (jaggeryConfig != null) {
            String name;
            JSONArray arrServlets = (JSONArray)jaggeryConfig.get((Object)"servlets");
            JSONArray arrServletMappings = (JSONArray)jaggeryConfig.get((Object)"servletMappings");
            if (arrServlets != null) {
                for (Object servletObj : arrServlets) {
                    JSONObject servlet = (JSONObject)servletObj;
                    name = (String)servlet.get((Object)"name");
                    String clazz = (String)servlet.get((Object)"class");
                    Wrapper servletWrapper = Tomcat.addServlet((Context)ctx, (String)name, (String)clazz);
                    JSONArray arrParams = (JSONArray)servlet.get((Object)"params");
                    if (arrParams == null) continue;
                    for (Object paramObj : arrParams) {
                        JSONObject param = (JSONObject)paramObj;
                        String paramName = (String)param.get((Object)"name");
                        String paramValue = (String)param.get((Object)"value");
                        servletWrapper.addInitParameter(paramName, paramValue);
                    }
                }
            }
            if (arrServletMappings != null) {
                for (Object servletMappingObj : arrServletMappings) {
                    JSONObject mapping = (JSONObject)servletMappingObj;
                    name = (String)mapping.get((Object)"name");
                    String url = (String)mapping.get((Object)"url");
                    ctx.addServletMappingDecoded(url, name);
                }
            }
        }
    }

    private static class JaggeryConfListener
    implements LifecycleListener {
        private JSONObject jaggeryConfig;
        private SecurityConstraint securityConstraint;

        private JaggeryConfListener(JSONObject jaggeryConfig, SecurityConstraint securityConstraint) {
            this.jaggeryConfig = jaggeryConfig;
            this.securityConstraint = securityConstraint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lifecycleEvent(LifecycleEvent event) {
            if ("before_start".equals(event.getType())) {
                TomcatJaggeryWebappsDeployer.initJaggeryappDefaults((Context)event.getLifecycle(), this.jaggeryConfig, this.securityConstraint);
                return;
            }
            if ("start".equals(event.getType())) {
                Context context = (Context)event.getLifecycle();
                try {
                    WebAppManager.getEngine().enterContext();
                    WebAppManager.deploy((Context)context);
                    TomcatJaggeryWebappsDeployer.setDisplayName(context, this.jaggeryConfig);
                    if (this.jaggeryConfig != null) {
                        TomcatJaggeryWebappsDeployer.addSessionCreatedListners(context, (JSONArray)this.jaggeryConfig.get((Object)"sessionCreatedListeners"));
                        TomcatJaggeryWebappsDeployer.addSessionDestroyedListners(context, (JSONArray)this.jaggeryConfig.get((Object)"sessionDestroyedListeners"));
                        TomcatJaggeryWebappsDeployer.executeScripts(context, (JSONArray)this.jaggeryConfig.get((Object)"initScripts"));
                        TomcatJaggeryWebappsDeployer.addUrlMappings(context, this.jaggeryConfig);
                    }
                }
                catch (ScriptException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    try {
                        context.destroy();
                    }
                    catch (LifecycleException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
                finally {
                    RhinoEngine.exitContext();
                }
                return;
            }
            if ("stop".equals(event.getType())) {
                Context context = (Context)event.getLifecycle();
                try {
                    WebAppManager.getEngine().enterContext();
                    WebAppManager.undeploy((Context)context);
                    if (this.jaggeryConfig != null) {
                        TomcatJaggeryWebappsDeployer.executeScripts(context, (JSONArray)this.jaggeryConfig.get((Object)"destroyScripts"));
                    }
                }
                catch (ScriptException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    RhinoEngine.exitContext();
                }
                return;
            }
        }
    }
}

