/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JaggeryDeploymentUtil {
    private static final Log log = LogFactory.getLog(JaggeryDeploymentUtil.class);
    private static final int BYTE_BUFFER_SIZE = 8192;

    private JaggeryDeploymentUtil() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    static File getConfig(File webAppFile) {
        File f;
        if (webAppFile.isDirectory() && (f = new File(webAppFile + File.separator + "jaggery.conf")).exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT"})
    static void unZip(InputStream is, String destDir) {
        try {
            ZipEntry entry;
            File unzipDestinationDirectory = new File(destDir);
            if (!unzipDestinationDirectory.mkdir()) {
                log.error((Object)("could not create " + destDir));
            }
            FilterOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File entryDir = new File(unzipDestinationDirectory.getAbsolutePath() + File.separator + entry.getName());
                    boolean created = entryDir.mkdir();
                    if (created) continue;
                    log.error((Object)("Could not create DIR : " + unzipDestinationDirectory.getAbsolutePath() + File.separator + entry.getName()));
                    continue;
                }
                byte[] data = new byte[8192];
                FileOutputStream fos = null;
                try {
                    int count;
                    fos = new FileOutputStream(unzipDestinationDirectory.getAbsolutePath() + File.separator + entry.getName());
                    dest = new BufferedOutputStream(fos, 8192);
                    while ((count = zis.read(data, 0, 8192)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                }
                catch (IOException e) {
                    log.error((Object)("Error opening output stream " + entry.getName()), (Throwable)e);
                }
                finally {
                    try {
                        if (dest == null) continue;
                        dest.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Error closing output stream " + entry.getName()), (Throwable)e);
                    }
                }
            }
            zis.close();
        }
        catch (IOException e) {
            log.error((Object)"Could not unzip the Jaggery App Archive", (Throwable)e);
        }
    }
}

