/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebappAdmin;
import org.wso2.carbon.webapp.mgt.WebappUploadData;

public class JaggeryAppAdmin
extends WebappAdmin {
    private static final int BYTE_BUFFER_SIZE = 8192;
    private static final Log log = LogFactory.getLog(JaggeryAppAdmin.class);

    public JaggeryAppAdmin() {
    }

    public JaggeryAppAdmin(AxisConfiguration axisConfig) throws Exception {
        super(axisConfig);
    }

    protected boolean isWebappRelevant(WebApplication webapp) {
        String filterProp = (String)webapp.getProperty("webappFilter");
        return "jaggeryWebapp".equals(filterProp);
    }

    protected String getWebappDeploymentDirPath() {
        String directory = "jaggeryapps";
        if (System.getProperty("jaggery.home") != null) {
            directory = "apps";
        }
        return this.getAxisConfig().getRepository().getPath() + File.separator + directory;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_IN"})
    public boolean uploadWebapp(WebappUploadData[] webappUploadDataList) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfig();
        String repoPath = axisConfig.getRepository().getPath();
        String jaggeryAppsPath = this.getWebappDeploymentDirPath();
        for (WebappUploadData uploadData : webappUploadDataList) {
            String fName = uploadData.getFileName();
            if (fName.contains(".")) {
                fName = fName.split("\\.")[0];
            }
            File webappsDir = new File(jaggeryAppsPath + File.separator + fName);
            File jaggeryAppsFile = new File(jaggeryAppsPath);
            if (webappsDir.exists()) {
                String msg = "Jaggery app with the same name already exists";
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
            if (!jaggeryAppsFile.exists() && !jaggeryAppsFile.mkdir()) {
                String error = "Jaggery deployment directory not found and cannot be created when uploading";
                log.error((Object)error);
                throw new AxisFault(error);
            }
            ArchiveManipulator archiveManipulator = new ArchiveManipulator();
            try {
                archiveManipulator.extractFromStream(uploadData.getDataHandler().getInputStream(), jaggeryAppsPath + File.separator + fName);
            }
            catch (IOException e) {
                log.error((Object)"Could not unzip the Jaggery App Archive", (Throwable)e);
                throw new AxisFault(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }
}

