/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.validators;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class AttributeExistenceValidator
implements CustomValidations {
    private static final Log log = LogFactory.getLog(AttributeExistenceValidator.class);
    private String[] attributes = new String[0];

    @Override
    public void init(Map parameterMap) {
        String temp;
        if (parameterMap != null && (temp = (String)parameterMap.get("attributes")) != null) {
            this.attributes = temp.split(",");
        }
    }

    @Override
    public boolean validate(RequestContext context) {
        if (this.attributes.length == 0) {
            return true;
        }
        String resourcePath = context.getResourcePath().getPath();
        int index = resourcePath.indexOf("/_system/governance");
        if (index < 0) {
            log.warn((Object)("Unable to use Validator For Resource Path: " + resourcePath));
            return false;
        }
        if (resourcePath.length() <= (index += "/_system/governance".length())) {
            log.warn((Object)("Unable to use Validator For Resource Path: " + resourcePath));
            return false;
        }
        resourcePath = resourcePath.substring(index);
        try {
            UserRegistry registry = (UserRegistry)context.getSystemRegistry();
            if (!registry.resourceExists(resourcePath)) {
                registry = ((UserRegistry)context.getSystemRegistry()).getChrootedRegistry("/_system/governance");
            }
            GovernanceArtifact governanceArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)resourcePath);
            for (String attribute : this.attributes) {
                if (this.validateAttribute(governanceArtifact, attribute)) continue;
                return false;
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to obtain registry instance", (Throwable)e);
        }
        return true;
    }

    protected boolean validateAttribute(GovernanceArtifact governanceArtifact, String attribute) throws GovernanceException {
        return governanceArtifact.getAttribute(attribute) != null;
    }
}

