/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathService;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathServiceImpl;
import org.wso2.carbon.registry.indexing.bean.RxtUnboundedEntryBean;
import org.wso2.carbon.registry.indexing.service.RxtUnboundedFieldManagerService;
import org.wso2.carbon.registry.indexing.utils.RxtUnboundedDataLoadUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;
import org.xml.sax.SAXException;

public class CommonUtil {
    private static final Log log = LogFactory.getLog(CommonUtil.class);
    private static final Map<String, HashMap<String, String>> associationConfigMap = new HashMap<String, HashMap<String, String>>();
    private static final Map<String, HashMap<String, String>> reverseAssociationConfigMap = new HashMap<String, HashMap<String, String>>();
    private static final Map<String, HashMap<String, String>> associationTypeIconConfigMap = new HashMap<String, HashMap<String, String>>();
    public static final String REVERSE_ASSOCIATION = "reverseAssociation";
    public static final String TYPE = "type";
    public static final String ASSOCIATION_CONFIG = "AssociationConfig";
    public static final String ICON_CLASS = "iconClass";
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static int dependencyGraphMaxDepth = -1;
    private static RXTStoragePathService rxtSPService;
    private static ThreadLocal<Boolean> clearMetaDataInProgress;

    public static RXTStoragePathService getRxtStoragePathService() {
        return rxtSPService;
    }

    public static void setRxtStoragePathService(RXTStoragePathService rxtSPService) {
        CommonUtil.rxtSPService = rxtSPService;
    }

    public static String[] getAllLifeCycleStates(Registry registry, String lifeCycleName) throws RegistryException {
        boolean isLiteral = true;
        ArrayList<String> stateList = new ArrayList<String>();
        String[] allAspects = registry.getAvailableAspects();
        if (!Arrays.asList(allAspects).contains(lifeCycleName)) {
            String msg = "There are no lifecycles with the given name";
            throw new RegistryException(msg);
        }
        Resource resource = null;
        if (!registry.resourceExists("/_system/config/repository/components/org.wso2.carbon.governance/lifecycles/" + lifeCycleName)) {
            String msg = "The given lifecycle configuration is an static configuration. Unable to read the registry.xml";
            throw new RegistryException(msg);
        }
        resource = registry.get("/_system/config/repository/components/org.wso2.carbon.governance/lifecycles/" + lifeCycleName);
        try {
            Iterator statesElement;
            String xmlContent = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            OMElement configurationElement = AXIOMUtil.stringToOM((String)xmlContent);
            if (isLiteral) {
                OMElement typeElement = configurationElement.getFirstElement();
                configurationElement = typeElement.getFirstElement();
            }
            if ((statesElement = configurationElement.getChildrenWithName(new QName("scxml"))).hasNext()) {
                while (statesElement.hasNext()) {
                    OMElement scxmlElement = (OMElement)statesElement.next();
                    Iterator stateElements = scxmlElement.getChildrenWithName(new QName("state"));
                    while (stateElements.hasNext()) {
                        OMElement next = (OMElement)stateElements.next();
                        stateList.add(next.getAttributeValue(new QName("id")));
                    }
                }
            } else {
                Iterator states = configurationElement.getChildElements();
                while (states.hasNext()) {
                    OMElement next = (OMElement)states.next();
                    stateList.add(next.getAttributeValue(new QName("name")));
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RegistryException("", (Throwable)e);
        }
        String[] retArray = new String[stateList.size()];
        return stateList.toArray(retArray);
    }

    public static void addRxtConfigs(Registry systemRegistry, int tenantId) throws RegistryException {
        CommonUtil.loadAssociationConfig();
        Cache rxtConfigCache = GovernanceUtils.getRXTConfigCache((String)"RXT_CONFIG_CACHE");
        String rxtDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(rxtDir);
        if (!file.exists()) {
            return;
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rxt");
            }
        };
        String[] rxtFilePaths = file.list(filenameFilter);
        if (rxtFilePaths.length == 0) {
            return;
        }
        for (String rxtPath : rxtFilePaths) {
            String msg;
            String resourcePath = "/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
            int currentTenantId = CurrentSession.getTenantId();
            CurrentSession.setTenantId((int)tenantId);
            RegistryContext registryContext = systemRegistry.getRegistryContext();
            String absolutePath = RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)resourcePath);
            if (registryContext.isSystemResourcePathRegistered(absolutePath)) {
                CurrentSession.setTenantId((int)currentTenantId);
                continue;
            }
            registryContext.registerSystemResourcePath(absolutePath);
            CurrentSession.setTenantId((int)currentTenantId);
            try {
                String storagePath;
                String mediaType;
                GovernanceArtifactConfiguration configuration;
                String rxtConfigRelativePath = RegistryUtils.getRelativePathToOriginal((String)"/_system/governance/repository/components/org.wso2.carbon.governance/types", (String)"/_system/governance");
                if (!systemRegistry.resourceExists(rxtConfigRelativePath)) {
                    Collection collection = systemRegistry.newCollection();
                    systemRegistry.put(rxtConfigRelativePath, (Resource)collection);
                }
                Resource rxtCollection = systemRegistry.get(rxtConfigRelativePath);
                String rxtName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1).split("\\.")[0];
                if (!systemRegistry.resourceExists(resourcePath)) {
                    String propertyName = "registry." + rxtName;
                    if (rxtCollection.getProperty(propertyName) != null) continue;
                    rxtCollection.setProperty(propertyName, "true");
                    String rxt = FileUtil.readFileToString((String)(rxtDir + File.separator + rxtPath));
                    Resource resource = systemRegistry.newResource();
                    resource.setContent((Object)rxt.getBytes());
                    resource.setMediaType("application/vnd.wso2.registry-ext-type+xml");
                    systemRegistry.put(resourcePath, resource);
                    rxtConfigCache.put((Object)resourcePath, (Object)true);
                    configuration = GovernanceUtils.getGovernanceArtifactConfiguration((String)rxt);
                    mediaType = configuration.getMediaType();
                    storagePath = configuration.getPathExpression();
                    CommonUtil.addStoragePath(mediaType, storagePath);
                    CommonUtil.updateTenantsUnboundedFieldMap(configuration);
                    continue;
                }
                Resource resource = systemRegistry.get(resourcePath);
                Object content = resource.getContent();
                String elementString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
                configuration = GovernanceUtils.getGovernanceArtifactConfiguration((String)elementString);
                mediaType = configuration.getMediaType();
                storagePath = configuration.getPathExpression();
                CommonUtil.addStoragePath(mediaType, storagePath);
                CommonUtil.updateTenantsUnboundedFieldMap(configuration);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("RXT " + rxtName + " already exists."));
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new RegistryException(msg, (Throwable)e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new RegistryException(msg, (Throwable)e);
            }
        }
    }

    private static void updateTenantsUnboundedFieldMap(GovernanceArtifactConfiguration rxtConfiguration) throws RegistryException {
        if (rxtConfiguration.getMediaType().matches("application/vnd.(.)+\\+xml")) {
            CommonUtil.updateTenantsUnboundedFieldMap(rxtConfiguration.getContentDefinition().getParent().toString());
        }
    }

    public static void loadAssociationConfig() {
        String associationConfigFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "governance.xml";
        DocumentBuilderFactory dbFactory = CommonUtil.getSecuredDocumentBuilder();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new File(associationConfigFile));
            doc.getDocumentElement().normalize();
            NodeList associationConfigNode = doc.getElementsByTagName(ASSOCIATION_CONFIG);
            NodeList nodeList = associationConfigNode.item(0).getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node association = nodeList.item(i);
                if (association.getNodeType() != 1) continue;
                HashMap<String, String> associationMap = new HashMap<String, String>();
                HashMap<String, String> reverseAssociationMap = new HashMap<String, String>();
                LinkedHashMap<String, String> iconClassMap = new LinkedHashMap<String, String>();
                NodeList childNodeList = association.getChildNodes();
                if (childNodeList != null) {
                    for (int j = 0; j < childNodeList.getLength(); ++j) {
                        Node types = childNodeList.item(j);
                        if (types.getNodeType() != 1) continue;
                        associationMap.put(types.getNodeName(), types.getFirstChild().getNodeValue());
                        if (((Element)types).hasAttribute(REVERSE_ASSOCIATION)) {
                            reverseAssociationMap.put(types.getNodeName(), ((Element)types).getAttribute(REVERSE_ASSOCIATION));
                        }
                        if (!((Element)types).hasAttribute(ICON_CLASS)) continue;
                        iconClassMap.put(types.getNodeName(), ((Element)types).getAttribute(ICON_CLASS));
                    }
                }
                associationConfigMap.put(((Element)association).getAttribute(TYPE), associationMap);
                reverseAssociationConfigMap.put(((Element)association).getAttribute(TYPE), reverseAssociationMap);
                associationTypeIconConfigMap.put(((Element)association).getAttribute(TYPE), iconClassMap);
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Failed to find the governance.xml", (Throwable)e);
        }
        catch (ParserConfigurationException | SAXException e) {
            log.error((Object)"Failed to parse the governance.xml", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while reading the governance.xml", (Throwable)e);
        }
    }

    public static HashMap<String, String> getAssociationConfig(String shortName) {
        if (associationConfigMap.size() == 0) {
            log.warn((Object)"Failed to find association mappings");
            return null;
        }
        if (associationConfigMap.containsKey(shortName)) {
            return associationConfigMap.get(shortName);
        }
        return null;
    }

    public static String getReverseAssociationType(String shortName, String associationType) {
        if (reverseAssociationConfigMap.size() == 0) {
            log.warn((Object)"Failed to find reverse association mappings");
            return null;
        }
        if (reverseAssociationConfigMap.containsKey(shortName) && reverseAssociationConfigMap.get(shortName).containsKey(associationType)) {
            return reverseAssociationConfigMap.get(shortName).get(associationType);
        }
        return null;
    }

    public static String getAssociationTypeForRemoveOperation(String shortName, String associationType) {
        if (reverseAssociationConfigMap.size() == 0) {
            log.warn((Object)"Failed to find association mappings");
            return null;
        }
        String reverseAssociationType = null;
        if (reverseAssociationConfigMap.containsKey(shortName)) {
            for (Map.Entry<String, String> entry : reverseAssociationConfigMap.get(shortName).entrySet()) {
                if (!associationType.equals(entry.getValue())) continue;
                reverseAssociationType = entry.getKey();
                break;
            }
            return reverseAssociationType;
        }
        return null;
    }

    public static HashMap<String, String> getAssociationWithIcons(String shortName) {
        if (associationTypeIconConfigMap.size() == 0) {
            log.warn((Object)"Failed to find association mappings");
            return null;
        }
        if (associationTypeIconConfigMap.containsKey(shortName)) {
            return associationTypeIconConfigMap.get(shortName);
        }
        return null;
    }

    public static void loadDependencyGraphMaxDepthConfig() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(CommonUtil.getConfigFile());
            StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)fileInputStream));
            OMElement configElement = builder.getDocumentElement();
            OMElement dependencyGraphMaxDepthConfig = configElement.getFirstChildWithName(new QName("dependencyGraphMaxDepth"));
            if (dependencyGraphMaxDepthConfig != null) {
                dependencyGraphMaxDepth = Integer.parseInt(dependencyGraphMaxDepthConfig.getText());
            }
        }
        catch (FileNotFoundException | GovernanceException e) {
            log.error((Object)"Failed to find the registry.xml", e);
        }
        catch (CarbonException e) {
            log.error((Object)"Could not replace system variables in registry.xml", (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"could not build registry.xml OM", (Throwable)e);
        }
    }

    private static File getConfigFile() throws GovernanceException {
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null) {
            File registryXML = new File(configPath);
            if (!registryXML.exists()) {
                String msg = "Registry configuration file (registry.xml) file does not exist in the path " + configPath;
                throw new GovernanceException(msg);
            }
            return registryXML;
        }
        String msg = "Cannot find registry.xml";
        throw new GovernanceException(msg);
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd", (Throwable)e);
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    public static int getDependencyGraphMaxDepth() {
        return dependencyGraphMaxDepth;
    }

    public static void addStoragePath(String mediaType, String storagePath) {
        RXTStoragePathServiceImpl service = (RXTStoragePathServiceImpl)CommonUtil.getRxtStoragePathService();
        service.addStoragePath(mediaType, storagePath);
    }

    public static void removeStoragePath(String mediaType) {
        RXTStoragePathServiceImpl service = (RXTStoragePathServiceImpl)CommonUtil.getRxtStoragePathService();
        service.removeStoragePath(mediaType);
    }

    public static boolean isMetaDataClearLockAvailable() {
        return clearMetaDataInProgress.get() == false;
    }

    public static void acquireMetaDataClearLock() {
        clearMetaDataInProgress.set(true);
    }

    public static void releaseMetaDataClearLock() {
        clearMetaDataInProgress.set(false);
    }

    public static void updateTenantsUnboundedFieldMap(String elementString) throws RegistryException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        RxtUnboundedEntryBean rxtUnboundedFields = RxtUnboundedDataLoadUtils.getRxtUnboundedEntries((String)elementString);
        if (rxtUnboundedFields != null) {
            ConcurrentHashMap<String, List> currentTenantUnboundedFields = (ConcurrentHashMap<String, List>)RxtUnboundedFieldManagerService.getInstance().getTenantsUnboundedFields().get(tenantId);
            if (currentTenantUnboundedFields == null) {
                currentTenantUnboundedFields = new ConcurrentHashMap<String, List>();
            }
            currentTenantUnboundedFields.put(rxtUnboundedFields.getMediaType(), rxtUnboundedFields.getFields());
            RxtUnboundedFieldManagerService.getInstance().setTenantsUnboundedFields(Integer.valueOf(tenantId), currentTenantUnboundedFields);
        }
    }

    static {
        clearMetaDataInProgress = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }
}

