/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.common.GovernanceConfigurationService;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.governance.registry.extensions.listeners.RxtLoader;
import org.wso2.carbon.governance.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathService;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

@Component(name="org.wso2.governance.registry.extensions.services", immediate=true)
public class GovernanceRegistryExtensionsComponent {
    private static final Log log = LogFactory.getLog(GovernanceRegistryExtensionsComponent.class);
    private static SecretCallbackHandlerService secretCallbackHandlerService = null;
    private GovernanceRegistryExtensionsDataHolder dataHolder = GovernanceRegistryExtensionsDataHolder.getInstance();

    @Activate
    protected void activate(ComponentContext componentContext) throws RegistryException {
        BundleContext bundleCtx = componentContext.getBundleContext();
        RxtLoader rxtLoader = new RxtLoader();
        CommonUtil.loadDependencyGraphMaxDepthConfig();
        ServiceRegistration tenantMgtListenerSR = bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)rxtLoader, null);
        if (tenantMgtListenerSR != null) {
            log.debug((Object)"Identity Provider Management - RXTLoader registered");
        } else {
            log.error((Object)"Identity Provider Management - RXTLoader could not be registered");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"GovernanceRegistryExtensionsComponent activated");
        }
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        RegistryService service = RegistryCoreServiceComponent.getRegistryService();
        try {
            CommonUtil.addRxtConfigs((Registry)service.getGovernanceSystemRegistry(tenantId), tenantId);
        }
        catch (RegistryException e) {
            throw new RegistryException("Failed to add rxt to registry", (Throwable)e);
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry service initialized");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    @Reference(name="secret.callback.handler.service", service=SecretCallbackHandlerService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecretCallbackHandlerService")
    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting SecretCallbackHandlerService");
        }
        GovernanceRegistryExtensionsComponent.secretCallbackHandlerService = secretCallbackHandlerService;
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        GovernanceRegistryExtensionsComponent.secretCallbackHandlerService = null;
    }

    public static SecretCallbackHandlerService getSecretCallbackHandlerService() {
        return secretCallbackHandlerService;
    }

    @Reference(name="extensions.service", service=RXTStoragePathService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRxtStoragePathService")
    protected void setRxtStoragePathService(RXTStoragePathService rxtStoragePathService) {
        CommonUtil.setRxtStoragePathService(rxtStoragePathService);
    }

    protected void unsetRxtStoragePathService(RXTStoragePathService rxtSPService) {
        CommonUtil.setRxtStoragePathService(null);
    }

    @Reference(name="governanceconfiguration.service", service=GovernanceConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetGovernanceConfiguration")
    protected void setGovernanceConfigurationService(GovernanceConfigurationService govConfigService) {
        this.dataHolder.setGovernanceConfiguration(govConfigService.getGovernanceConfiguration());
    }

    protected void unsetGovernanceConfiguration(GovernanceConfigurationService govConfigService) {
        this.dataHolder.setGovernanceConfiguration(null);
    }
}

