/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class ProjectHandler
extends Handler {
    private static Log log = LogFactory.getLog(ProjectHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
        OMElement durationElement;
        OMElement remainingCostElement;
        OMElement remainingWorkElement;
        OMElement payload;
        Resource resource = requestContext.getResource();
        Object content = resource.getContent();
        String contentString = content instanceof String ? (String)content : RegistryUtils.decodeBytes((byte[])((byte[])content));
        try {
            payload = AXIOMUtil.stringToOM((String)contentString);
        }
        catch (XMLStreamException e) {
            String msg = "Unable to serialize resource content";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        OMNamespace namespace = payload.getNamespace();
        String namespaceURI = namespace.getNamespaceURI();
        OMElement definition = payload.getFirstChildWithName(new QName(namespaceURI, "definition"));
        OMElement projectPath = definition.getFirstChildWithName(new QName(namespaceURI, "projectPath"));
        String projectMetadataPath = null;
        if (projectPath != null) {
            projectMetadataPath = "/_system/governance" + projectPath.getText();
        }
        Resource metadataResource = requestContext.getRegistry().get(projectMetadataPath);
        String remainingWork = metadataResource.getProperty("Remaining Work");
        String scheduledWork = metadataResource.getProperty("Scheduled Work");
        String actualWork = metadataResource.getProperty("Actual Work");
        String remainingCost = metadataResource.getProperty("Remaining Cost");
        String scheduledCost = metadataResource.getProperty("Scheduled Cost");
        String actualCost = metadataResource.getProperty("Actual Cost");
        String duration = metadataResource.getProperty("Duration");
        String startDate = metadataResource.getProperty("Start Date");
        String endDate = metadataResource.getProperty("Finish Date");
        OMFactory factory = payload.getOMFactory();
        OMElement work = payload.getFirstChildWithName(new QName(namespaceURI, "work"));
        if (work == null) {
            work = factory.createOMElement("work", namespace, (OMContainer)payload);
        }
        if ((remainingWorkElement = work.getFirstChildWithName(new QName(namespaceURI, "remaining"))) == null) {
            remainingWorkElement = factory.createOMElement("remaining", namespace, (OMContainer)work);
        }
        remainingWorkElement.setText(remainingWork);
        OMElement actualWorkElement = work.getFirstChildWithName(new QName(namespaceURI, "actual"));
        if (actualWorkElement == null) {
            actualWorkElement = factory.createOMElement("actual", namespace, (OMContainer)work);
        }
        actualWorkElement.setText(remainingWork);
        OMElement scheduledWorkElement = work.getFirstChildWithName(new QName(namespaceURI, "scheduled"));
        if (scheduledWorkElement == null) {
            scheduledWorkElement = factory.createOMElement("scheduled", namespace, (OMContainer)work);
        }
        scheduledWorkElement.setText(remainingWork);
        OMElement cost = payload.getFirstChildWithName(new QName(namespaceURI, "cost"));
        if (cost == null) {
            cost = factory.createOMElement("cost", namespace, (OMContainer)payload);
        }
        if ((remainingCostElement = cost.getFirstChildWithName(new QName(namespaceURI, "remaining"))) == null) {
            remainingCostElement = factory.createOMElement("remaining", namespace, (OMContainer)cost);
        }
        remainingCostElement.setText(remainingCost);
        OMElement actualCostElement = cost.getFirstChildWithName(new QName(namespaceURI, "actual"));
        if (actualCostElement == null) {
            actualCostElement = factory.createOMElement("actual", namespace, (OMContainer)cost);
        }
        actualCostElement.setText(remainingCost);
        OMElement scheduledCostElement = cost.getFirstChildWithName(new QName(namespaceURI, "scheduled"));
        if (scheduledCostElement == null) {
            scheduledCostElement = factory.createOMElement("scheduled", namespace, (OMContainer)cost);
        }
        scheduledCostElement.setText(remainingCost);
        OMElement timeline = payload.getFirstChildWithName(new QName(namespaceURI, "timeline"));
        if (timeline == null) {
            timeline = factory.createOMElement("timeline", namespace, (OMContainer)payload);
        }
        if ((durationElement = timeline.getFirstChildWithName(new QName(namespaceURI, "duration"))) == null) {
            durationElement = factory.createOMElement("duration", namespace, (OMContainer)timeline);
        }
        durationElement.setText(duration);
        OMElement startDateElement = timeline.getFirstChildWithName(new QName(namespaceURI, "startDate"));
        if (startDateElement == null) {
            startDateElement = factory.createOMElement("startDate", namespace, (OMContainer)timeline);
        }
        startDateElement.setText(startDate);
        OMElement endDateElement = timeline.getFirstChildWithName(new QName(namespaceURI, "endDate"));
        if (endDateElement == null) {
            endDateElement = factory.createOMElement("endDate", namespace, (OMContainer)timeline);
        }
        endDateElement.setText(endDate);
        resource.setContent((Object)payload.toString());
    }
}

