/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.cache.ArtifactCache;
import org.wso2.carbon.governance.api.cache.ArtifactCacheManager;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class MetaDataCacheHandler
extends Handler {
    private static final Log log = LogFactory.getLog(MetaDataCacheHandler.class);

    public void put(RequestContext requestContext) throws RegistryException {
        this.clearPreFetchArtifact(requestContext);
    }

    public void delete(RequestContext requestContext) throws RegistryException {
        this.clearPreFetchArtifact(requestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPreFetchArtifact(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isMetaDataClearLockAvailable()) {
            return;
        }
        CommonUtil.acquireMetaDataClearLock();
        try {
            Resource resource = requestContext.getResource();
            if (resource == null || resource.getUUID() == null) {
                return;
            }
            String mediaType = resource.getMediaType();
            String artifactPath = null;
            try {
                artifactPath = GovernanceUtils.getDirectArtifactPath((Registry)requestContext.getRegistry(), (String)resource.getUUID());
            }
            catch (GovernanceException e) {
                String msg = "Failed to get path of artifact id = " + resource.getUUID();
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            if (mediaType == null || artifactPath == null) {
                return;
            }
            if (mediaType.matches("application/.[a-zA-Z0-9.-]+\\+xml")) {
                ArtifactCache artifactCache = ArtifactCacheManager.getCacheManager().getTenantArtifactCache(CurrentSession.getTenantId());
                String cachePath = RegistryUtils.getRelativePathToOriginal((String)artifactPath, (String)"/_system/governance");
                if (artifactCache != null && artifactCache.getArtifact(cachePath) != null) {
                    artifactCache.invalidateArtifact(cachePath);
                }
            }
        }
        finally {
            CommonUtil.releaseMetaDataClearLock();
        }
    }
}

