/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static String formatPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void addNewId(Registry registry, Resource newResource, String newPath) throws RegistryException {
        String artifactID = UUID.randomUUID().toString();
        newResource.setUUID(artifactID);
    }

    public static String getResourceContent(Resource tempResource) throws RegistryException {
        if (tempResource.getContent() instanceof String) {
            return (String)tempResource.getContent();
        }
        if (tempResource.getContent() instanceof byte[]) {
            return RegistryUtils.decodeBytes((byte[])((byte[])tempResource.getContent()));
        }
        return null;
    }

    public static OMElement getServiceOMElement(Resource newResource) {
        try {
            String content = Utils.getResourceContent(newResource);
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            OMElement serviceElement = builder.getDocumentElement();
            serviceElement.build();
            return serviceElement;
        }
        catch (Exception e) {
            log.error((Object)"Error in parsing the resource content");
            return null;
        }
    }

    public static boolean populateParameterMap(RequestContext requestContext, Map<String, String> currentParameterMap) {
        Set parameterMapKeySet = (Set)requestContext.getProperty("parameterNames");
        if (parameterMapKeySet == null) {
            log.warn((Object)"No parameters where found");
            return true;
        }
        for (Object entry : parameterMapKeySet) {
            String key = (String)entry;
            if (key.equals("preserveOriginal")) continue;
            currentParameterMap.put(key, (String)requestContext.getProperty(key));
        }
        return true;
    }

    public static void copyAssociations(Registry registry, String newPath, String path) throws RegistryException {
        Association[] associations;
        for (Association association : associations = registry.getAllAssociations(path)) {
            if (association.getAssociationType().equals("depends")) continue;
            if (association.getSourcePath().equals(path)) {
                registry.addAssociation(newPath, association.getDestinationPath(), association.getAssociationType());
                continue;
            }
            registry.addAssociation(association.getSourcePath(), newPath, association.getAssociationType());
        }
    }

    public static void copyRatings(Registry registry, String newPath, String path) throws RegistryException {
        float averageRating = registry.getAverageRating(path);
        registry.rateResource(newPath, new Float(averageRating).intValue());
    }

    public static void copyTags(Registry registry, String newPath, String path) throws RegistryException {
        Tag[] tags;
        for (Tag tag : tags = registry.getTags(path)) {
            registry.applyTag(newPath, tag.getTagName());
        }
    }

    public static void copyComments(Registry registry, String newPath, String path) throws RegistryException {
        Comment[] comments;
        for (Comment comment : comments = registry.getComments(path)) {
            registry.addComment(newPath, comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDependencies(RequestContext requestContext, Map<String, String> parameterMap, Map<String, String> oldPathNewPathMap) throws RegistryException {
        Registry registry = requestContext.getRegistry();
        if (!CommonUtil.isAddingAssociationLockAvailable()) {
            return;
        }
        CommonUtil.acquireAddingAssociationLock();
        try {
            Association[] associations;
            for (Map.Entry<String, String> entry : oldPathNewPathMap.entrySet()) {
                for (Association association : associations = registry.getAllAssociations(entry.getValue())) {
                    if (oldPathNewPathMap.containsValue(association.getSourcePath()) && oldPathNewPathMap.containsValue(association.getDestinationPath())) continue;
                    registry.removeAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
                }
            }
            for (Map.Entry<String, String> keyValueSet : parameterMap.entrySet()) {
                for (Association association : associations = registry.getAllAssociations(keyValueSet.getKey())) {
                    if (!oldPathNewPathMap.containsKey(association.getDestinationPath()) || !oldPathNewPathMap.containsKey(association.getSourcePath())) continue;
                    registry.addAssociation(oldPathNewPathMap.get(association.getSourcePath()), oldPathNewPathMap.get(association.getDestinationPath()), association.getAssociationType());
                }
            }
        }
        finally {
            CommonUtil.releaseAddingAssociationLock();
        }
    }

    public static void makeOtherDependencies(RequestContext requestContext, Map<String, String> oldPathNewPathMap, List<String> otherDependencies) throws RegistryException {
        Registry registry = requestContext.getRegistry();
        for (Map.Entry<String, String> entry : oldPathNewPathMap.entrySet()) {
            Association[] associations;
            for (Association association : associations = registry.getAllAssociations(entry.getKey())) {
                for (String dependency : otherDependencies) {
                    if (association.getDestinationPath().equals(dependency)) {
                        registry.addAssociation(entry.getValue(), dependency, association.getAssociationType());
                    }
                    if (!association.getSourcePath().equals(dependency)) continue;
                    registry.addAssociation(dependency, entry.getValue(), association.getAssociationType());
                }
            }
        }
    }

    public static List evaluateXpath(OMElement contentElement, String xpathString) {
        ArrayList ret = new ArrayList();
        try {
            AXIOMXPath xpath = new AXIOMXPath(xpathString);
            Iterator nsIterator = contentElement.getAllDeclaredNamespaces();
            while (nsIterator.hasNext()) {
                OMNamespace next = (OMNamespace)nsIterator.next();
                xpath.addNamespace("x", next.getNamespaceURI());
                ret.addAll(xpath.selectNodes((Object)contentElement));
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static void authenticateAPIM(HttpContext httpContext, String apimEndpoint, String apimUsername, String apimPassword) throws RegistryException {
        String loginEP = apimEndpoint + "publisher/site/blocks/user/login/ajax/login.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(loginEP);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
            params.add(new BasicNameValuePair("action", "login"));
            params.add(new BasicNameValuePair("username", apimUsername));
            params.add(new BasicNameValuePair("password", apimPassword));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException(" Authentication with API Manager failed: HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RegistryException("Failed when encoding the parameter list. ", (Throwable)e);
        }
        catch (IOException e) {
            throw new RegistryException("Failed to send the http POST request to API Manager. ", (Throwable)e);
        }
    }
}

