/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.apistore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsComponent;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.governance.registry.extensions.utils.APIUtils;
import org.wso2.carbon.governance.registry.extensions.utils.ResponseAPIM;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class ServiceToAPIExecutor
implements Execution {
    private static final Log LOG = LogFactory.getLog(ServiceToAPIExecutor.class);
    private String soapServiceMediaType = "application/vnd.wso2-soap-service+xml";
    private String apimEndpoint = null;
    private String apimUsername = null;
    private String apimPassword = null;
    private String defaultTier = "Unlimited";
    private String apimEnv = null;
    private String apiThrottlingTier = "Unlimited,Unlimited,Unlimited,Unlimited,Unlimited";
    private Registry registry;
    private GenericArtifact artifact;

    @Override
    public void init(Map parameterMap) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        secretResolver.init(GovernanceRegistryExtensionsComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        if (secretResolver.isInitialized()) {
            this.apimUsername = secretResolver.resolve("apim.username");
            this.apimPassword = secretResolver.resolve("apim.password");
        }
        if (parameterMap.get("apim.endpoint") != null) {
            this.apimEndpoint = parameterMap.get("apim.endpoint").toString();
        }
        if (parameterMap.get("apim.username") != null) {
            this.apimUsername = parameterMap.get("apim.username").toString();
        }
        if (parameterMap.get("apim.password") != null) {
            this.apimPassword = parameterMap.get("apim.password").toString();
        }
        if (parameterMap.get("apim.env") != null) {
            this.apimEnv = parameterMap.get("apim.env").toString();
        }
        if (parameterMap.get("default.tier") != null) {
            this.defaultTier = parameterMap.get("default.tier").toString();
        }
        if (parameterMap.get("throttlingTier") != null) {
            this.apiThrottlingTier = parameterMap.get("throttlingTier").toString();
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        String apiName;
        ArrayList publishedEnvList = new ArrayList();
        ArrayList failedEnvList = new ArrayList();
        Resource resource = context.getResource();
        try {
            String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
            this.registry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(user, CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String artifactAbsolutePath = resource.getPath();
            String artifactRelativePath = artifactAbsolutePath.substring("/_system/governance".length());
            Resource apiArtifact = this.registry.get(artifactRelativePath);
            GenericArtifactManager artifactManager = resource.getMediaType().equals(this.soapServiceMediaType) ? new GenericArtifactManager(this.registry, "soapservice") : new GenericArtifactManager(this.registry, "service");
            String artifactId = apiArtifact.getUUID();
            this.artifact = artifactManager.getGenericArtifact(artifactId);
            apiName = this.artifact.getAttribute("overview_name");
        }
        catch (RegistryException e) {
            LOG.error((Object)"Failed to convert service to xml content", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to convert service to xml content", (Throwable)e);
            return false;
        }
        try {
            this.publishDataToAPIM(resource, apiName);
        }
        catch (GovernanceException e) {
            LOG.error((Object)"Failed to convert service to xml content", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to convert service to xml content", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean publishDataToAPIM(Resource resource, String serviceName) throws GovernanceException {
        boolean valid = true;
        if (this.apimEndpoint == null || this.apimUsername == null || this.apimPassword == null || this.apimEnv == null) {
            throw new GovernanceException("APIManager login credentials are not defined");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        APIUtils.authenticateAPIM((HttpContext)httpContext, this.apimEndpoint, this.apimUsername, this.apimPassword);
        String addAPIendpoint = this.apimEndpoint + "publisher/site/blocks/item-add/ajax/add.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(addAPIendpoint);
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            String[] endPoints = this.artifact.getAttributes("endpoints_entry");
            if (endPoints == null || endPoints.length == 0) {
                String msg = "Service Endpoint is a must attribute to create an API definition at the APIStore";
                throw new GovernanceException(msg);
            }
            List<String> endPointsList = Arrays.asList(endPoints);
            if (endPointsList == null) {
                String msg = "Service Endpoint is a must attribute to create an API definition at the APIStore";
                throw new GovernanceException(msg);
            }
            this.addParameters(params, resource, serviceName);
            LOG.info((Object)new UrlEncodedFormEntity(params, "UTF-8"));
            ResponseAPIM responseAPIM = APIUtils.callAPIMToPublishAPI((HttpClient)httpclient, httppost, params, (HttpContext)httpContext);
            if (responseAPIM.getError().equalsIgnoreCase("true")) {
                LOG.error((Object)responseAPIM.getMessage());
                throw new GovernanceException("Error occurred while adding the api to API Manager.");
            }
        }
        catch (Exception e) {
            throw new GovernanceException(e.getMessage(), (Throwable)e);
        }
        return valid;
    }

    private void addParameters(List<NameValuePair> params, Resource resource, String serviceName) throws GovernanceException {
        String[] endPoints = this.artifact.getAttributes("endpoints_entry");
        List<String> endPointsList = Arrays.asList(endPoints);
        params.add((NameValuePair)new BasicNameValuePair("action", "addAPI"));
        params.add((NameValuePair)new BasicNameValuePair("name", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("context", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("version", this.artifact.getAttribute("overview_version")));
        params.add((NameValuePair)new BasicNameValuePair("tiersCollection", this.defaultTier));
        params.add((NameValuePair)new BasicNameValuePair("uriTemplate-0", "/*"));
        params.add((NameValuePair)new BasicNameValuePair("resourceMethod-0", "POST"));
        params.add((NameValuePair)new BasicNameValuePair("resourceMethodAuthType-0", "Any"));
        params.add((NameValuePair)new BasicNameValuePair("visibility", "public"));
        params.add((NameValuePair)new BasicNameValuePair("resourceMethodThrottlingTier-0", this.apiThrottlingTier));
        params.add((NameValuePair)new BasicNameValuePair("http_checked", "http"));
        params.add((NameValuePair)new BasicNameValuePair("https_checked", "https"));
        params.add((NameValuePair)new BasicNameValuePair("responseCache", "disabled"));
        params.add((NameValuePair)new BasicNameValuePair("endpointType", "nonsecured"));
        params.add((NameValuePair)new BasicNameValuePair("tags", this.artifact.getAttribute("overview_businessUnit")));
        if (endPointsList.size() > 0) {
            String endpointConfigJson = "{\"production_endpoints\":{\"url\":\"" + this.getEnvironmentUrl(endPointsList) + "\",\"config\":null},\"endpoint_type\":\"http\"}";
            params.add((NameValuePair)new BasicNameValuePair("endpoint_config", endpointConfigJson));
        }
        params.add((NameValuePair)new BasicNameValuePair("subscriptions", "current_tenant"));
    }

    private String getEnvironmentUrl(List<String> endpointsEntry) throws GovernanceException {
        for (String att : endpointsEntry) {
            if (!att.substring(0, att.indexOf(":")).equalsIgnoreCase(this.apimEnv)) continue;
            return att.substring(att.indexOf(":") + 1);
        }
        throw new GovernanceException("Related url is not available");
    }
}

