/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.apistore;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactFilter;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsComponent;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.governance.registry.extensions.utils.APIUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class ApiStore2Executor
implements Execution {
    private static final Log LOG = LogFactory.getLog(ApiStore2Executor.class);
    private String soapServiceMediaType = "application/vnd.wso2-soap-service+xml";
    private String apimEndpoint = null;
    private String apimUsername = null;
    private String apimPassword = null;
    private String defaultTier = "Unlimited";
    private String apimEnv = null;
    private String apimPublisher = null;
    private String apiThrottlingTier = "Unlimited,Unlimited,Unlimited,Unlimited,Unlimited";
    private Registry registry;
    private GenericArtifact artifact;

    @Override
    public void init(Map parameterMap) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        secretResolver.init(GovernanceRegistryExtensionsComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        if (parameterMap.get("apim.endpoint") != null) {
            this.apimEndpoint = parameterMap.get("apim.endpoint").toString();
        }
        if (parameterMap.get("apim.username") != null) {
            this.apimUsername = parameterMap.get("apim.username").toString();
            if (secretResolver.isInitialized()) {
                this.apimUsername = secretResolver.isTokenProtected("apim.username") ? secretResolver.resolve("apim.username") : MiscellaneousUtil.resolve((String)this.apimUsername, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("apim.password") != null) {
            this.apimPassword = parameterMap.get("apim.password").toString();
            if (secretResolver.isInitialized()) {
                this.apimPassword = secretResolver.isTokenProtected("apim.password") ? secretResolver.resolve("apim.password") : MiscellaneousUtil.resolve((String)this.apimPassword, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("apim.env") != null) {
            this.apimEnv = parameterMap.get("apim.env").toString();
        }
        if (parameterMap.get("default.tier") != null) {
            this.defaultTier = parameterMap.get("default.tier").toString();
        }
        if (parameterMap.get("throttlingTier") != null) {
            this.apiThrottlingTier = parameterMap.get("throttlingTier").toString();
        }
        if (parameterMap.get("apim.publisher") != null) {
            this.apimPublisher = parameterMap.get("apim.publisher").toString();
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        String apiName;
        ArrayList publishedEnvList = new ArrayList();
        ArrayList failedEnvList = new ArrayList();
        Resource resource = context.getResource();
        try {
            String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
            this.registry = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceUserRegistry(user, CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String artifactAbsolutePath = resource.getPath();
            String artifactRelativePath = artifactAbsolutePath.substring("/_system/governance".length());
            Resource apiArtifact = this.registry.get(artifactRelativePath);
            GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)this.registry), (List)GovernanceUtils.findGovernanceArtifactConfigurations((Registry)this.registry));
            GenericArtifactManager artifactManager = resource.getMediaType().equals(this.soapServiceMediaType) ? new GenericArtifactManager(this.registry, "soapservice") : new GenericArtifactManager(this.registry, "restservice");
            String artifactId = apiArtifact.getUUID();
            this.artifact = artifactManager.getGenericArtifact(artifactId);
            apiName = this.artifact.getAttribute("overview_name");
        }
        catch (RegistryException e) {
            LOG.error((Object)"Failed to convert service to xml content", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception ocurred while getting rest service artifact", (Throwable)e);
            return false;
        }
        try {
            this.publishDataToAPIM(resource, apiName);
        }
        catch (GovernanceException e) {
            LOG.error((Object)"Exception occurred while publishing to APIM", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while publishing to APIM", (Throwable)e);
            return false;
        }
        if (this.apimPublisher != null && this.apimPublisher.equalsIgnoreCase("local")) {
            try {
                this.createAssociation();
            }
            catch (RegistryException e) {
                LOG.error((Object)"Exception occurred while creating association between rest service and api", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean publishDataToAPIM(Resource resource, String serviceName) throws GovernanceException {
        boolean valid = true;
        if (this.apimEndpoint == null || this.apimUsername == null || this.apimPassword == null || this.apimEnv == null) {
            throw new GovernanceException("APIManager login credentials are not defined");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        String sessionCookie = APIUtils.authenticateAPIM_2((HttpContext)httpContext, this.apimEndpoint, this.apimUsername, this.apimPassword);
        String addAPIendpoint = this.apimEndpoint + "/publisher/apis/assets?type=api";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(addAPIendpoint);
            httppost.setHeader("Cookie", "JSESSIONID=" + sessionCookie);
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            this.addParameters(params, resource, serviceName);
            LOG.info((Object)new UrlEncodedFormEntity(params, "UTF-8"));
            APIUtils.callAPIMToPublishAPI2((HttpClient)httpclient, httppost, params, (HttpContext)httpContext);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while publishing to APIM", (Throwable)e);
            throw new GovernanceException(e.getMessage(), (Throwable)e);
        }
        return valid;
    }

    private void addParameters(List<NameValuePair> params, Resource resource, String serviceName) throws GovernanceException {
        int i;
        String[] endPoints = this.artifact.getAttributes("endpoints_entry");
        String[] urlPatterns = this.artifact.getAttributes("uritemplate_urlPattern");
        String[] httpVerbs = this.artifact.getAttributes("uritemplate_httpVerb");
        String[] urlAuthType = this.artifact.getAttributes("security_authenticationType");
        params.add((NameValuePair)new BasicNameValuePair("overview_name", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("action", "design"));
        params.add((NameValuePair)new BasicNameValuePair("overview_description", ""));
        params.add((NameValuePair)new BasicNameValuePair("overview_thumbnail", ""));
        params.add((NameValuePair)new BasicNameValuePair("roles", ""));
        params.add((NameValuePair)new BasicNameValuePair("overview_context", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("overview_version", this.artifact.getAttribute("overview_version")));
        params.add((NameValuePair)new BasicNameValuePair("overview_tags", this.artifact.getAttribute("overview_businessUnit")));
        params.add((NameValuePair)new BasicNameValuePair("visibility", "public"));
        params.add((NameValuePair)new BasicNameValuePair("overview_provider", CarbonContext.getThreadLocalCarbonContext().getUsername()));
        if (urlPatterns != null && urlPatterns.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("{\"paths\":{");
            for (i = 0; i < urlPatterns.length; ++i) {
                sb.append("\"");
                sb.append(urlPatterns[i]);
                sb.append("\":{\"");
                sb.append(httpVerbs[i]);
                sb.append("\":{\"responses\":{\"200\":{}}}");
                sb.append("}");
                if (urlPatterns.length <= 1 || i == urlPatterns.length - 1) continue;
                sb.append(",");
            }
            sb.append("},");
            sb.append("\"swagger\":\"2.0\",");
            sb.append("\"info\":{\"title\":\"\",\"version\":\"\"}}\n");
            params.add((NameValuePair)new BasicNameValuePair("swagger", sb.toString()));
        } else {
            params.add((NameValuePair)new BasicNameValuePair("swagger", "{\"paths\":{\"/*\":{\"put\":{\"responses\":{\"200\":{}}},\"post\":{\"responses\":{\"200\":{}}},\"get\":{\"responses\":{\"200\":{}}},\"delete\":{\"responses\":{\"200\":{}}},\"head\":{\"responses\":{\"200\":{}}}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"\",\"version\":\"\"}}\n"));
        }
        String endpointConfigJson = "";
        if (endPoints != null && endPoints.length > 0) {
            for (i = 0; i < endPoints.length; ++i) {
                if (endPoints[i] == null || !endPoints[i].startsWith("Default")) continue;
                String url = endPoints[i].split(":")[1];
                endpointConfigJson = "{\"production_endpoints\":{\"url\":\"" + url + "\",\"config\":null},\"endpoint_type\":\"http\"}";
                break;
            }
        }
        if (!endpointConfigJson.equals("")) {
            params.add((NameValuePair)new BasicNameValuePair("endpoint_config", endpointConfigJson));
        } else {
            params.add((NameValuePair)new BasicNameValuePair("endpoint_config", null));
        }
    }

    private String getEnvironmentUrl(List<String> endpointsEntry) throws GovernanceException {
        for (String att : endpointsEntry) {
            if (!att.substring(0, att.indexOf(":")).equalsIgnoreCase(this.apimEnv)) continue;
            return att.substring(att.indexOf(":") + 1);
        }
        throw new GovernanceException("Related url is not available");
    }

    private void createAssociation() throws GovernanceException, RegistryException {
        GenericArtifactManager artifactManager = new GenericArtifactManager(this.registry, "api");
        GenericArtifact[] artifacts = artifactManager.findGenericArtifacts(new GenericArtifactFilter(){

            public boolean matches(GenericArtifact apiArtifact) throws GovernanceException {
                String attributeVal = apiArtifact.getAttribute("overview_name");
                return attributeVal != null && attributeVal.equals(ApiStore2Executor.this.artifact.getAttribute("overview_name"));
            }
        });
        if (artifacts != null && artifacts.length > 0) {
            GenericArtifact api = artifacts[0];
            api.addAssociation("createdBy", (GovernanceArtifact)this.artifact);
            this.artifact.addAssociation("promotedTo", (GovernanceArtifact)api);
        }
    }
}

