/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors.apistore;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.executors.utils.ExecutorConstants;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsComponent;
import org.wso2.carbon.governance.registry.extensions.utils.ResponseAPIM;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class APIDeleteExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(APIDeleteExecutor.class);
    private String apimEndpoint = null;
    private String apimUsername = null;
    private String apimPassword = null;

    @Override
    public void init(Map parameterMap) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        secretResolver.init(GovernanceRegistryExtensionsComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        if (parameterMap.get("apim.endpoint") != null) {
            this.apimEndpoint = parameterMap.get("apim.endpoint").toString();
        }
        if (parameterMap.get("apim.username") != null) {
            this.apimUsername = parameterMap.get("apim.username").toString();
            if (secretResolver.isInitialized()) {
                this.apimUsername = secretResolver.isTokenProtected("apim.username") ? secretResolver.resolve("apim.username") : MiscellaneousUtil.resolve((String)this.apimUsername, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("apim.password") != null) {
            this.apimPassword = parameterMap.get("apim.password").toString();
            if (secretResolver.isInitialized()) {
                this.apimPassword = secretResolver.isTokenProtected("apim.password") ? secretResolver.resolve("apim.password") : MiscellaneousUtil.resolve((String)this.apimPassword, (SecretResolver)secretResolver);
            }
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        boolean valid;
        Resource resource = context.getResource();
        try {
            String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
            String artifactString = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            OMElement xmlContent = AXIOMUtil.stringToOM((String)artifactString);
            String serviceName = CommonUtil.getServiceName((OMElement)xmlContent);
            UserRegistry registry = RegistryCoreServiceComponent.getRegistryService().getGovernanceUserRegistry(user, CarbonContext.getThreadLocalCarbonContext().getTenantId());
            GenericArtifactManager manager = resource.getMediaType().equals(ExecutorConstants.SOAP_MEDIA_TYPE) ? new GenericArtifactManager((Registry)registry, "soapservice") : new GenericArtifactManager((Registry)registry, "restservice");
            GenericArtifact genericArtifact = manager.getGenericArtifact(context.getResource().getUUID());
            valid = this.deleteAPIFromAPIM(genericArtifact, serviceName);
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete API from API Publisher ", (Throwable)e);
            valid = false;
        }
        return valid;
    }

    private boolean deleteAPIFromAPIM(GenericArtifact genericArtifact, String serviceName) throws GovernanceException {
        if (this.apimEndpoint == null || this.apimUsername == null || this.apimPassword == null) {
            String msg = "APIManager login credentials are not defined";
            throw new RuntimeException(msg + "API delete might fail");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        this.authenticateAPIM((HttpContext)httpContext);
        String addAPIendpoint = this.apimEndpoint + "publisher/site/blocks/item-add/ajax/remove.jag";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(addAPIendpoint);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("action", "removeAPI"));
        params.add((NameValuePair)new BasicNameValuePair("name", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("provider", this.apimUsername));
        params.add((NameValuePair)new BasicNameValuePair("version", genericArtifact.getAttribute("overview_version")));
        ResponseAPIM responseAPIM = APIDeleteExecutor.callAPIMToPublishAPI((HttpClient)httpclient, httppost, params, (HttpContext)httpContext);
        if (responseAPIM.getError().equalsIgnoreCase("true")) {
            throw new RuntimeException("Error occured while deleting the api from API Manager. " + responseAPIM.getMessage());
        }
        return true;
    }

    private void authenticateAPIM(HttpContext httpContext) throws GovernanceException {
        String loginEP = this.apimEndpoint + "publisher/site/blocks/user/login/ajax/login.jag";
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(loginEP);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
            params.add(new BasicNameValuePair("action", "login"));
            params.add(new BasicNameValuePair("username", this.apimUsername));
            params.add(new BasicNameValuePair("password", this.apimPassword));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new GovernanceException(" Authentication with APIM failed: HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (IOException e) {
            throw new GovernanceException("Authentication with APIM fails", (Throwable)e);
        }
    }

    public static ResponseAPIM callAPIMToPublishAPI(HttpClient httpclient, HttpPost httppost, List<NameValuePair> params, HttpContext httpContext) throws GovernanceException {
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            Gson gson = new Gson();
            return (ResponseAPIM)gson.fromJson(responseString, ResponseAPIM.class);
        }
        catch (SocketTimeoutException e) {
            throw new GovernanceException("Connection timed out, Please check the network availability", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GovernanceException("Unsupported encode exception.", (Throwable)e);
        }
        catch (IOException e) {
            throw new GovernanceException("IO Exception occurred.", (Throwable)e);
        }
        catch (Exception e) {
            throw new GovernanceException(e.getMessage(), (Throwable)e);
        }
    }
}

