/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class WSExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(WSExecutor.class);
    private boolean isWSSuccessful;
    private boolean isAsynchronous = false;
    private String wsPayload;
    private String EPR;
    private String saveResponseAs = "attribute";
    private String responseName;
    private String responseDestinationPath;
    private String responseXpath;
    private String responseNamespace;
    private String responseNamespacePrefix;
    private Map parameterMap = new HashMap();

    @Override
    public void init(Map parameterMap) {
        this.parameterMap = parameterMap;
        this.isWSSuccessful = false;
        if (parameterMap.get("payload") != null) {
            this.wsPayload = parameterMap.get("payload").toString();
        }
        if (parameterMap.get("epr") != null) {
            this.EPR = parameterMap.get("epr").toString();
        }
        if (parameterMap.get("async") != null) {
            this.isAsynchronous = Boolean.parseBoolean(parameterMap.get("async").toString());
        }
        if (parameterMap.get("response.destination") != null) {
            this.responseDestinationPath = parameterMap.get("response.destination").toString();
        }
        if (parameterMap.get("save.type") != null) {
            this.saveResponseAs = parameterMap.get("save.type").toString();
        }
        if (parameterMap.get("save.name") != null) {
            this.responseName = parameterMap.get("save.name").toString();
        }
        if (parameterMap.get("response.xpath") != null) {
            this.responseXpath = parameterMap.get("response.xpath").toString();
        }
        if (parameterMap.get("response.namespace") != null) {
            this.responseNamespace = parameterMap.get("response.namespace").toString();
        }
        if (parameterMap.get("response.namespace.prefix") != null) {
            this.responseNamespacePrefix = parameterMap.get("response.namespace.prefix").toString();
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        if (this.EPR == null || this.wsPayload == null) {
            log.error((Object)"The parameters 'epr' and 'payload' must be specified");
            return false;
        }
        if (!this.isAsynchronous) {
            try {
                AXIOMXPath xpathExpression;
                if (this.responseXpath != null && this.responseNamespacePrefix != null && this.responseNamespace != null) {
                    xpathExpression = new AXIOMXPath(this.responseXpath);
                    xpathExpression.addNamespace(this.responseNamespacePrefix, this.responseNamespace);
                } else {
                    xpathExpression = null;
                }
                this.synchronousExecuteWS(this.getEPR(context), this.getParameterizedPayload(context), context, xpathExpression);
            }
            catch (JaxenException e) {
                log.error((Object)e);
                return false;
            }
        } else {
            this.asynchronousExecuteWS(this.getEPR(context), this.getParameterizedPayload(context));
        }
        return this.isWSSuccessful;
    }

    private String getEPR(RequestContext context) {
        String finalEPR = "";
        finalEPR = GovernanceUtils.parameterizeString((RequestContext)context, (String)this.EPR);
        return finalEPR;
    }

    private OMElement getParameterizedPayload(RequestContext context) {
        OMElement finalPayload = null;
        try {
            OMElement currentPayload = this.getPayload();
            String payloadString = currentPayload.toString();
            String newPayloadString = "";
            newPayloadString = GovernanceUtils.parameterizeString((RequestContext)context, (String)payloadString);
            finalPayload = AXIOMUtil.stringToOM((String)newPayloadString);
            finalPayload.toString();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Invalid XML payload found", (Throwable)e);
        }
        return finalPayload;
    }

    private void synchronousExecuteWS(final String endPointReferance, final OMElement payload, RequestContext context, AXIOMXPath xpathExpression) {
        block20: {
            final ArrayList arrayList = new ArrayList();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServiceClient client = new ServiceClient();
                        client.getOptions().setTo(new EndpointReference(endPointReferance));
                        arrayList.add(0, client.sendReceive(payload));
                    }
                    catch (AxisFault e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (this.responseName == null) {
                this.isWSSuccessful = true;
                log.warn((Object)"The reponse was not saved since the parameter save.name was not defined");
                return;
            }
            try {
                OMElement response;
                if (arrayList.isEmpty()) {
                    this.isWSSuccessful = false;
                    log.error((Object)"Service invocation was not successful");
                    return;
                }
                OMElement value = response = (OMElement)arrayList.get(0);
                if (xpathExpression != null) {
                    value = (OMElement)xpathExpression.selectSingleNode((Object)response);
                }
                Registry registry = context.getSystemRegistry();
                GenericArtifact genericArtifact = null;
                String resourcePath = context.getResourcePath().getPath();
                String destinationPath = this.responseDestinationPath != null ? GovernanceUtils.parameterizeString((RequestContext)context, (String)this.responseDestinationPath) : resourcePath;
                String finalValue = value.getFirstElement() != null ? value.getFirstElement().toString() : value.getText();
                if (this.saveResponseAs.equals("attribute")) {
                    try {
                        genericArtifact = (GenericArtifact)GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)context.getSystemRegistry(), (String)destinationPath);
                        if (genericArtifact != null) {
                            GovernanceArtifactConfiguration governanceArtifactConfiguration = GovernanceUtils.findGovernanceArtifactConfigurationByMediaType((String)genericArtifact.getMediaType(), (Registry)registry);
                            GenericArtifactManager genericArtifactManager = new GenericArtifactManager(registry, governanceArtifactConfiguration.getKey());
                            if (genericArtifact.getAttribute(this.responseName) != null) {
                                genericArtifact.setAttribute(this.responseName, finalValue);
                            } else {
                                genericArtifact.addAttribute(this.responseName, finalValue);
                            }
                            genericArtifactManager.updateGenericArtifact(genericArtifact);
                            if (destinationPath.equals(context.getResourcePath().getPath())) {
                                context.setResource(registry.get(destinationPath));
                            }
                            this.isWSSuccessful = true;
                            break block20;
                        }
                        log.error((Object)"Unable to locate registry governance artifact for the given destination path");
                    }
                    catch (RegistryException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    break block20;
                }
                Resource resource = registry.get(destinationPath);
                if (resource != null) {
                    if (resource.getProperty(this.responseName) != null) {
                        resource.setProperty(this.responseName, finalValue);
                    } else {
                        resource.addProperty(this.responseName, finalValue);
                    }
                    registry.put(destinationPath, resource);
                    if (destinationPath.equals(context.getResourcePath().getPath())) {
                        context.setResource(resource);
                    }
                    this.isWSSuccessful = true;
                } else {
                    log.error((Object)"Unable to locate registry resource for the given destination path");
                }
            }
            catch (RegistryException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (JaxenException e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private void asynchronousExecuteWS(final String endPointReferance, final OMElement payload) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceClient client = new ServiceClient();
                    client.getOptions().setTo(new EndpointReference(endPointReferance));
                    client.sendRobust(payload);
                    WSExecutor.this.isWSSuccessful = true;
                }
                catch (AxisFault e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private OMElement getPayload() throws XMLStreamException {
        OMElement wsPayloadOM = AXIOMUtil.stringToOM((String)this.wsPayload);
        wsPayloadOM.toString();
        OMElement payload = wsPayloadOM;
        if (wsPayloadOM.getLocalName().equals("Envelope")) {
            Iterator childs = wsPayloadOM.getChildElements();
            while (childs.hasNext()) {
                OMElement child = (OMElement)childs.next();
                if (child.getLocalName().equals("Body")) {
                    payload = child.getFirstElement();
                    continue;
                }
                payload = null;
            }
            if (payload == null) {
                log.error((Object)"The SOAP body could not be found within the SOAP envelope");
            }
        } else {
            payload = wsPayloadOM;
        }
        return payload;
    }
}

