/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatCollection;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatWriter;
import org.wso2.carbon.governance.registry.extensions.executors.utils.Utils;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ServiceVersionExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(ServiceVersionExecutor.class);
    private String serviceMediaType = "application/vnd.wso2-service+xml";
    private boolean copyComments = false;
    private boolean copyTags = false;
    private boolean copyRatings = false;
    private boolean copyAllAssociations = false;
    private boolean copyDependencies = true;
    private boolean override = false;
    private static final String ASSOCIATION = "association";
    private static final String LIFECYCLE_ASPECT_NAME = "registry.LC.name";
    private boolean isAuditEnabled = true;
    private Map parameterMap = new HashMap();

    @Override
    public void init(Map parameterMap) {
        this.parameterMap = parameterMap;
        if (parameterMap.get("service.mediatype") != null) {
            this.serviceMediaType = parameterMap.get("service.mediatype").toString();
        }
        if (parameterMap.get("copyComments") != null) {
            this.copyComments = Boolean.parseBoolean((String)parameterMap.get("copyComments"));
        }
        if (parameterMap.get("copyTags") != null) {
            this.copyTags = Boolean.parseBoolean((String)parameterMap.get("copyTags"));
        }
        if (parameterMap.get("copyRatings") != null) {
            this.copyRatings = Boolean.parseBoolean((String)parameterMap.get("copyRatings"));
        }
        if (parameterMap.get("copyAssociations") != null) {
            this.copyAllAssociations = Boolean.parseBoolean((String)parameterMap.get("copyAssociations"));
        }
        if (parameterMap.get("copyDependencies") != null) {
            this.copyDependencies = Boolean.parseBoolean((String)parameterMap.get("copyDependencies"));
        }
        if (parameterMap.get("override") != null) {
            this.override = Boolean.parseBoolean((String)parameterMap.get("override"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(RequestContext requestContext, String currentState, String targetState) {
        boolean transactionStatus = false;
        OMElement historyOperation = null;
        ArrayList<String> otherDependencyList = new ArrayList<String>();
        try {
            historyOperation = AXIOMUtil.stringToOM((String)"<operation></operation>");
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
        }
        Resource resource = requestContext.getResource();
        Registry registry = requestContext.getRegistry();
        String resourcePath = requestContext.getResourcePath().getPath();
        HashMap<String, String> currentParameterMap = new HashMap<String, String>();
        if (resource instanceof Collection) {
            return true;
        }
        if (resource.getMediaType() == null || "".equals(resource.getMediaType().trim())) {
            log.warn((Object)("The media-type of the resource '" + resourcePath + "' is undefined. Hence exiting the service version executor."));
            return true;
        }
        if (!resource.getMediaType().equals(this.serviceMediaType)) {
            return true;
        }
        String targetEnvironment = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)((String)this.parameterMap.get("targetEnvironment")));
        String currentEnvironment = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)((String)this.parameterMap.get("currentEnvironment")));
        if (targetEnvironment == null || currentEnvironment == null || currentEnvironment.isEmpty() || targetEnvironment.isEmpty()) {
            log.warn((Object)"Current environment and the Target environment has not been defined to the state");
            return true;
        }
        if (!this.populateParameterMap(requestContext, currentParameterMap)) {
            log.error((Object)"Failed to populate the parameter map");
            return false;
        }
        try {
            registry.beginTransaction();
            Resource newResource = registry.newResource();
            Map<String, String> newPathMappings = this.getNewPathMappings(targetEnvironment, currentEnvironment, currentParameterMap, otherDependencyList);
            if (!CommonUtil.isUpdateLockAvailable()) {
                boolean bl = false;
                return bl;
            }
            CommonUtil.acquireUpdateLock();
            try {
                for (Map.Entry currentParameterMapEntry : currentParameterMap.entrySet()) {
                    if (!registry.resourceExists((String)currentParameterMapEntry.getKey())) continue;
                    Resource tempResource = registry.get((String)currentParameterMapEntry.getKey());
                    if (!(tempResource instanceof Collection) && tempResource.getMediaType() != null) {
                        this.updateNewPathMappings(tempResource.getMediaType(), currentEnvironment, targetEnvironment, newPathMappings, (String)currentParameterMapEntry.getKey(), (String)currentParameterMapEntry.getValue());
                    }
                    StringBuilder resourceContent = new StringBuilder(Utils.getResourceContent(tempResource));
                    for (Map.Entry<String, String> newPathMappingsEntry : newPathMappings.entrySet()) {
                        if (resourceContent == null || "application/vnd.wso2-endpoint+xml".equals(tempResource.getMediaType())) continue;
                        int index = resourceContent.indexOf(newPathMappingsEntry.getKey());
                        if (index > -1) {
                            resourceContent.replace(index, index + newPathMappingsEntry.getKey().length(), newPathMappingsEntry.getValue());
                            continue;
                        }
                        if ("application/x-xsd+xml".equals(tempResource.getMediaType())) {
                            this.updateSchemaRelativePaths(targetEnvironment, currentEnvironment, resourceContent, newPathMappingsEntry);
                            continue;
                        }
                        if (!"application/wsdl+xml".equals(tempResource.getMediaType())) continue;
                        this.updateWSDLRelativePaths(targetEnvironment, currentEnvironment, resourceContent, newPathMappingsEntry);
                    }
                    tempResource.setContent((Object)resourceContent.toString());
                    String newTempResourcePath = newPathMappings.get(tempResource.getPath());
                    if (tempResource.getMediaType() != null && tempResource.getMediaType().equals(this.serviceMediaType)) {
                        newResource = tempResource;
                        OMElement serviceElement = Utils.getServiceOMElement(newResource);
                        OMFactory fac = OMAbstractFactory.getOMFactory();
                        Iterator it = serviceElement.getChildrenWithLocalName("newServicePath");
                        if (it.hasNext()) {
                            OMElement next = (OMElement)it.next();
                            next.setText(newTempResourcePath);
                        } else {
                            OMElement operation = fac.createOMElement("newServicePath", serviceElement.getNamespace(), (OMContainer)serviceElement);
                            operation.setText(newTempResourcePath);
                        }
                        CommonUtil.setServiceVersion((OMElement)serviceElement, (String)((String)currentParameterMap.get(tempResource.getPath())));
                        serviceElement.build();
                        resourceContent = new StringBuilder(serviceElement.toString());
                        newResource.setContent((Object)resourceContent.toString());
                        Utils.addNewId(registry, newResource, newTempResourcePath);
                        continue;
                    }
                    Utils.addNewId(registry, tempResource, newTempResourcePath);
                    if (tempResource.getPath().equals(resourcePath)) continue;
                    historyOperation.addChild((OMNode)org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils.getHistoryInfoElement(newTempResourcePath + " created"));
                    registry.put(newTempResourcePath, tempResource);
                    this.copyComments(registry, newTempResourcePath, (String)currentParameterMapEntry.getKey(), historyOperation);
                    this.copyRatings(requestContext.getSystemRegistry(), newTempResourcePath, (String)currentParameterMapEntry.getKey(), historyOperation);
                    this.copyAllAssociations(registry, newTempResourcePath, (String)currentParameterMapEntry.getKey(), historyOperation);
                }
                if (registry.resourceExists(newPathMappings.get(resourcePath)) & !this.override) {
                    String message = "A resource exists with the given version";
                    requestContext.setProperty("executorMessage", (Object)message);
                    throw new RegistryException(message);
                }
                registry.put(newPathMappings.get(resourcePath), newResource);
                historyOperation.addChild((OMNode)org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils.getHistoryInfoElement(newPathMappings.get(resourcePath) + " created"));
                StatCollection statCollection = new StatCollection();
                statCollection.setActionType(ASSOCIATION);
                statCollection.setAction("");
                statCollection.setRegistry((Registry)registry.getRegistryContext().getEmbeddedRegistryService().getSystemRegistry(CurrentSession.getTenantId()));
                statCollection.setTimeMillis(System.currentTimeMillis());
                statCollection.setState(currentState);
                statCollection.setResourcePath(newPathMappings.get(resourcePath));
                statCollection.setUserName(CurrentSession.getUser());
                statCollection.setOriginalPath(newPathMappings.get(resourcePath));
                statCollection.setTargetState(targetState);
                statCollection.setAspectName(resource.getProperty(LIFECYCLE_ASPECT_NAME));
                if (this.isAuditEnabled) {
                    StatWriter.writeHistory(statCollection);
                }
            }
            finally {
                CommonUtil.releaseUpdateLock();
            }
            String aspectName = resource.getProperty(LIFECYCLE_ASPECT_NAME);
            registry.associateAspect(newPathMappings.get(resourcePath), aspectName);
            Utils.makeDependencies(requestContext, currentParameterMap, newPathMappings);
            Utils.makeOtherDependencies(requestContext, newPathMappings, otherDependencyList);
            this.copyCommunityFeatures(requestContext, registry, resourcePath, newPathMappings, historyOperation);
            this.addSubscriptionAvailableProperty(newResource);
            requestContext.setResource(newResource);
            requestContext.setOldResource(resource);
            requestContext.setResourcePath(new ResourcePath(newPathMappings.get(resourcePath)));
            StatCollection statCollection = (StatCollection)requestContext.getProperty("statCollection");
            newResource.setProperty("registry.lifecycle_history.originalPath" + aspectName, statCollection.getOriginalPath());
            statCollection.addExecutors(this.getClass().getName(), historyOperation);
            transactionStatus = true;
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to perform registry operation", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (transactionStatus) {
                    registry.commitTransaction();
                } else {
                    registry.rollbackTransaction();
                }
            }
            catch (RegistryException e) {
                log.error((Object)"Unable to finish the transaction", (Throwable)e);
            }
        }
        return true;
    }

    private void copyCommunityFeatures(RequestContext requestContext, Registry registry, String resourcePath, Map<String, String> newPathMappings, OMElement historyOperation) throws RegistryException {
        this.copyComments(registry, newPathMappings.get(resourcePath), resourcePath, historyOperation);
        this.copyTags(registry, newPathMappings.get(resourcePath), resourcePath, historyOperation);
        this.copyRatings(requestContext.getSystemRegistry(), newPathMappings.get(resourcePath), resourcePath, historyOperation);
        this.copyAllAssociations(registry, newPathMappings.get(resourcePath), resourcePath, historyOperation);
    }

    private void addSubscriptionAvailableProperty(Resource newResource) throws RegistryException {
        newResource.setProperty("registry.is.environment.change.property", "true");
    }

    private void copyAllAssociations(Registry registry, String newPath, String path, OMElement historyOperation) throws RegistryException {
        if (this.copyAllAssociations) {
            Utils.copyAssociations(registry, newPath, path);
            historyOperation.addChild((OMNode)org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils.getHistoryInfoElement("All associations copied"));
        }
    }

    private void copyRatings(Registry registry, String newPath, String path, OMElement historyOperation) throws RegistryException {
        if (this.copyRatings) {
            Utils.copyRatings(registry, newPath, path);
            historyOperation.addChild((OMNode)org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils.getHistoryInfoElement("Average rating copied"));
        }
    }

    private void copyTags(Registry registry, String newPath, String path, OMElement historyOperation) throws RegistryException {
        if (this.copyTags) {
            Utils.copyTags(registry, newPath, path);
            historyOperation.addChild((OMNode)org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils.getHistoryInfoElement("Tags copied"));
        }
    }

    private void copyComments(Registry registry, String newPath, String path, OMElement historyOperation) throws RegistryException {
        if (this.copyComments) {
            Utils.copyComments(registry, newPath, path);
            historyOperation.addChild((OMNode)org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils.getHistoryInfoElement("Comments copied"));
        }
    }

    private void updateNewPathMappings(String mediaType, String currentExpression, String targetExpression, Map<String, String> newPathMappingsMap, String resourcePath, String version) throws RegistryException {
        boolean hasValue = false;
        if (this.parameterMap.containsKey(mediaType + ":" + "currentEnvironment")) {
            hasValue = true;
            currentExpression = (String)this.parameterMap.get(mediaType + ":" + "currentEnvironment");
        }
        if (this.parameterMap.containsKey(mediaType + ":" + "targetEnvironment")) {
            hasValue = true;
            targetExpression = (String)this.parameterMap.get(mediaType + ":" + "targetEnvironment");
        }
        if (hasValue) {
            String path = this.reformatPath(resourcePath, currentExpression, targetExpression, version);
            newPathMappingsMap.put(resourcePath, path);
        }
    }

    private void updateSchemaRelativePaths(String targetEnvironment, String currentEnvironment, StringBuilder resourceContent, Map.Entry<String, String> newPathMappingsEntry) {
        try {
            OMElement contentElement = AXIOMUtil.stringToOM((String)resourceContent.toString());
            this.updateRelativePath(targetEnvironment, currentEnvironment, contentElement, newPathMappingsEntry);
            resourceContent.replace(0, resourceContent.length(), contentElement.toString());
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
        }
    }

    private OMElement updateRelativePath(String targetEnvironment, String currentEnvironment, OMElement contentElement, Map.Entry<String, String> newPathMappingsEntry) throws XMLStreamException {
        List importNodes = Utils.evaluateXpath(contentElement, "//x:import");
        for (Object node : importNodes) {
            OMElement nodeElement = (OMElement)node;
            this.updateRelativePathContent(targetEnvironment, currentEnvironment, newPathMappingsEntry, nodeElement);
        }
        return contentElement;
    }

    private void updateWSDLRelativePaths(String targetEnvironment, String currentEnvironment, StringBuilder resourceContent, Map.Entry<String, String> newPathMappingsEntry) {
        try {
            OMElement contentElement = AXIOMUtil.stringToOM((String)resourceContent.toString());
            this.updateRelativePath(targetEnvironment, currentEnvironment, contentElement, newPathMappingsEntry);
            List SchemaNodes = Utils.evaluateXpath(contentElement, "//x:schema");
            for (Object schemaNode : SchemaNodes) {
                OMElement schema = (OMElement)schemaNode;
                this.updateRelativePath(targetEnvironment, currentEnvironment, schema, newPathMappingsEntry);
            }
            resourceContent.replace(0, resourceContent.length(), contentElement.toString());
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
        }
    }

    private void updateRelativePathContent(String targetEnvironment, String currentEnvironment, Map.Entry<String, String> newPathMappingsEntry, OMElement nodeElement) {
        Iterator it = nodeElement.getAllAttributes();
        while (it.hasNext()) {
            OMAttribute next = (OMAttribute)it.next();
            if (!next.getLocalName().equals("location") && !next.getLocalName().equals("schemaLocation")) continue;
            String relativePath = next.getAttributeValue();
            String originalRelativePath = this.getOriginalRelativePath(currentEnvironment, newPathMappingsEntry);
            String newRelativePath = null;
            if (relativePath.equals(originalRelativePath)) {
                newRelativePath = this.getNewRelativePath(targetEnvironment, newPathMappingsEntry, null);
            } else if (relativePath.endsWith(originalRelativePath)) {
                String prefix = relativePath.replace(originalRelativePath, "");
                newRelativePath = prefix + this.getNewRelativePath(targetEnvironment, newPathMappingsEntry, null);
            } else {
                boolean contains = false;
                String[] relativePathSegments = relativePath.split("/");
                String[] originalSegments = originalRelativePath.split("/");
                String temp = originalRelativePath;
                for (int i = 0; i < originalSegments.length; ++i) {
                    if (!relativePath.endsWith(temp = temp.substring(temp.indexOf("/") + 1))) continue;
                    contains = true;
                    break;
                }
                if (contains) {
                    ArrayList<String> unwantedSegments = new ArrayList<String>();
                    for (String segment : originalSegments) {
                        if (!(!relativePath.contains("/" + segment + "/") & !relativePath.endsWith(segment))) continue;
                        unwantedSegments.add(segment);
                    }
                    newRelativePath = this.getNewRelativePath(targetEnvironment, newPathMappingsEntry, unwantedSegments);
                    if (originalSegments.length > relativePathSegments.length) {
                        for (int i = 0; i < originalSegments.length - relativePathSegments.length; ++i) {
                            newRelativePath = newRelativePath.substring(newRelativePath.indexOf("/") + 1);
                        }
                    }
                }
            }
            if (newRelativePath == null) continue;
            next.setAttributeValue(newRelativePath);
        }
    }

    private String getNewRelativePath(String targetEnvironment, Map.Entry<String, String> newPathMappingsEntry, List<String> unwantedSegments) {
        StringBuilder targetBuffer = new StringBuilder();
        String targetPrefix = targetEnvironment.substring(0, targetEnvironment.indexOf("{@resourcePath}"));
        String replacementValue = newPathMappingsEntry.getValue().replace(targetPrefix, "");
        targetPrefix = targetPrefix.substring("/_system/governance".length() + 1);
        int targetPrefixPathSegments = targetPrefix.split("/").length;
        for (int i = 1; i < targetPrefixPathSegments; ++i) {
            targetBuffer.append("../");
        }
        if (unwantedSegments != null) {
            for (String unwantedSegment : unwantedSegments) {
                replacementValue = replacementValue.replaceFirst(unwantedSegment, "..");
            }
        }
        return targetBuffer.toString() + replacementValue;
    }

    private String getOriginalRelativePath(String currentEnvironment, Map.Entry<String, String> newPathMappingsEntry) {
        String prefix = currentEnvironment.substring(0, currentEnvironment.indexOf("{@resourcePath}"));
        String pathSuffix = newPathMappingsEntry.getKey().replace(prefix, "");
        StringBuilder sourceBuffer = new StringBuilder();
        prefix = prefix.substring("/_system/governance".length() + 1);
        int prefixPathSegments = prefix.split("/").length;
        for (int i = 1; i < prefixPathSegments; ++i) {
            sourceBuffer.append("../");
        }
        return sourceBuffer.toString() + pathSuffix;
    }

    private Map<String, String> getNewPathMappings(String targetEnvironment, String currentEnvironment, Map<String, String> currentParameterMap, List<String> otherDependencyList) throws RegistryException {
        HashMap<String, String> newPathMappingsMap = new HashMap<String, String>();
        for (Map.Entry<String, String> keyValueSet : currentParameterMap.entrySet()) {
            String path = this.reformatPath(keyValueSet.getKey(), currentEnvironment, targetEnvironment, keyValueSet.getValue());
            if (path.equals(keyValueSet.getKey())) {
                log.info((Object)("Resource " + path + " is not in the given environment"));
                otherDependencyList.add(path);
                continue;
            }
            newPathMappingsMap.put(keyValueSet.getKey(), path);
        }
        for (String otherDependency : otherDependencyList) {
            currentParameterMap.remove(otherDependency);
        }
        return newPathMappingsMap;
    }

    private boolean populateParameterMap(RequestContext requestContext, Map<String, String> currentParameterMap) {
        Set parameterMapKeySet = (Set)requestContext.getProperty("parameterNames");
        if (parameterMapKeySet == null) {
            if (this.serviceMediaType.equals(requestContext.getResource().getMediaType()) && Utils.getServiceOMElement(requestContext.getResource()) != null) {
                currentParameterMap.put(requestContext.getResource().getPath(), org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)Utils.getServiceOMElement(requestContext.getResource())));
                return true;
            }
            return false;
        }
        for (Object entry : parameterMapKeySet) {
            String key = (String)entry;
            if (key.equals("preserveOriginal") || key.endsWith(".item")) continue;
            currentParameterMap.put(key, (String)requestContext.getProperty(key));
        }
        if (currentParameterMap.isEmpty() && this.serviceMediaType.equals(requestContext.getResource().getMediaType()) && Utils.getServiceOMElement(requestContext.getResource()) != null) {
            currentParameterMap.put(requestContext.getResource().getPath(), org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)Utils.getServiceOMElement(requestContext.getResource())));
            if (this.copyDependencies) {
                try {
                    Association[] associations = requestContext.getRegistry().getAllAssociations(requestContext.getResource().getPath());
                    if (associations != null && associations.length != 0) {
                        for (Association association : associations) {
                            if (!association.getAssociationType().equals("depends") || !requestContext.getResource().getPath().equals(association.getSourcePath())) continue;
                            currentParameterMap.put(association.getDestinationPath(), org.wso2.carbon.registry.common.utils.CommonUtil.getServiceVersion((OMElement)Utils.getServiceOMElement(requestContext.getResource())));
                        }
                    }
                }
                catch (RegistryException e) {
                    log.error((Object)e);
                }
            }
        }
        return true;
    }

    private String reformatPath(String path, String currentExpression, String targetExpression, String newResourceVersion) throws RegistryException {
        TreeMap<Integer, String> indexMap = new TreeMap<Integer, String>();
        String returnPath = targetExpression;
        if (currentExpression.equals(targetExpression)) {
            return path;
        }
        indexMap.put(currentExpression.indexOf("{@resourceName}"), "{@resourceName}");
        indexMap.put(currentExpression.indexOf("{@resourcePath}"), "{@resourcePath}");
        indexMap.put(currentExpression.indexOf("{@version}"), "{@version}");
        String tempExpression = currentExpression;
        while ((Integer)indexMap.lastKey() < tempExpression.lastIndexOf("/")) {
            tempExpression = tempExpression.substring(0, tempExpression.lastIndexOf("/"));
            path = path.substring(0, path.lastIndexOf("/"));
        }
        String prefix = currentExpression.substring(0, currentExpression.indexOf((String)indexMap.get(indexMap.higherKey(-1))));
        if (!path.startsWith(prefix)) {
            return path;
        }
        path = path.replace(prefix, "");
        while ((Integer)indexMap.firstKey() < 0) {
            indexMap.pollFirstEntry();
        }
        while (indexMap.size() != 0) {
            Map.Entry lastEntry = indexMap.pollLastEntry();
            if (lastEntry.getValue().equals("{@resourcePath}")) {
                String pathValue = path;
                for (int i = 0; i < indexMap.size(); ++i) {
                    pathValue = Utils.formatPath(pathValue.substring(pathValue.indexOf("/")));
                }
                if (!pathValue.equals("")) {
                    returnPath = returnPath.replace("{@resourcePath}", Utils.formatPath(pathValue));
                    path = path.replace(pathValue, "");
                    continue;
                }
                returnPath = returnPath.replace("/" + lastEntry.getValue(), "");
                continue;
            }
            if (lastEntry.getValue().equals("{@version}")) {
                returnPath = returnPath.replace("{@version}", newResourceVersion);
                if (path.contains("/")) {
                    path = path.substring(0, path.lastIndexOf("/"));
                    continue;
                }
                path = "";
                continue;
            }
            String tempPath = path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
            if (!tempPath.equals("")) {
                returnPath = returnPath.replace((String)lastEntry.getValue(), Utils.formatPath(tempPath));
                if (path.contains("/")) {
                    path = path.substring(0, path.lastIndexOf("/"));
                    continue;
                }
                path = "";
                continue;
            }
            returnPath = returnPath.replace("/" + lastEntry.getValue(), "");
            if (!path.contains("/")) continue;
            path = path.substring(0, path.lastIndexOf("/"));
        }
        if (!newResourceVersion.matches("^\\d+[.]\\d+[.]\\d+(-[a-zA-Z0-9]+)?$")) {
            String message = "Invalid version found for " + RegistryUtils.getResourceName((String)path);
            log.error((Object)message);
            throw new RegistryException(message);
        }
        if (returnPath.contains("{@version}")) {
            return returnPath.replace("{@version}", newResourceVersion);
        }
        return returnPath;
    }
}

