/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class PermissionGrantExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(PermissionGrantExecutor.class);
    private UserRealm userRealm;
    private int tenantId;
    private List<RolePermission> list = new ArrayList<RolePermission>();
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final String DELETE = "delete";
    private static final String ADD = "add";

    @Override
    public void init(Map parameterMap) {
        this.obtainTenantId();
        this.obtainUserRealm();
        this.populateValues(parameterMap);
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        String resourcePath = context.getResourcePath().getPath();
        boolean isErrorOccurred = false;
        block2: for (RolePermission role : this.list) {
            for (String rule : role.getPermission()) {
                String action = null;
                if (rule.equalsIgnoreCase(READ)) {
                    action = "http://www.wso2.org/projects/registry/actions/get";
                } else if (rule.equalsIgnoreCase(WRITE)) {
                    action = "http://www.wso2.org/projects/registry/actions/add";
                } else {
                    if (!rule.equalsIgnoreCase(DELETE)) continue block2;
                    action = "http://www.wso2.org/projects/registry/actions/delete";
                }
                try {
                    this.executePermission(role.getAction(), this.userRealm, role.getRole(), resourcePath, action);
                }
                catch (UserStoreException e) {
                    isErrorOccurred = true;
                }
            }
        }
        return !isErrorOccurred;
    }

    private void obtainTenantId() {
        String stringTenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        }
        catch (Exception e) {
            String errorMessage = "Failed to obtain Tenant id";
            log.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void obtainUserRealm() {
        try {
            this.userRealm = GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getUserRealm(this.tenantId);
        }
        catch (RegistryException e) {
            String errorMessage = "Failed to load User Realm Manager.";
            log.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void executePermission(int opType, UserRealm user, String role, String target, String rule) throws UserStoreException {
        switch (opType) {
            case 1: {
                this.addPermission(user, role, target, rule);
                break;
            }
            case 2: {
                this.removePermission(user, role, target, rule);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Ignoring " + opType));
            }
        }
    }

    private void addPermission(UserRealm user, String role, String target, String rule) throws UserStoreException {
        if (role == null || target == null || rule == null) {
            return;
        }
        user.getAuthorizationManager().authorizeRole(role, target, rule);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Permission " + rule + " ADDED to role: " + role + " for " + target));
        }
    }

    private void removePermission(UserRealm user, String role, String target, String rule) throws UserStoreException {
        if (role == null || target == null || rule == null) {
            return;
        }
        user.getAuthorizationManager().denyRole(role, target, rule);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Permission: " + rule + " REMOVED from role: " + role + " for " + target));
        }
    }

    private void populateValues(Map parameterMap) {
        for (String key : parameterMap.keySet()) {
            String value = (String)parameterMap.get(key);
            String[] values = key.split(":");
            String[] permissions = value.split(",");
            RolePermission role = new RolePermission();
            if (values[1].equalsIgnoreCase(ADD)) {
                role.setAction(1);
            } else {
                role.setAction(2);
            }
            role.setPermission(permissions);
            role.setRole(values[0]);
            this.list.add(role);
        }
    }

    private class RolePermission {
        private String role;
        private int action;
        private String[] permission;

        private RolePermission() {
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public int getAction() {
            return this.action;
        }

        public void setAction(int action) {
            this.action = action;
        }

        public String[] getPermission() {
            return this.permission;
        }

        public void setPermission(String[] permission) {
            this.permission = permission;
        }
    }
}

