/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.executors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.executors.utils.Utils;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.internal.RegistryCoreServiceComponent;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class APIPublishExecutor
implements Execution {
    private static final Log log = LogFactory.getLog(APIPublishExecutor.class);
    private static final String URI_TEMPLATE = "uritemplate";
    private static final String URL_PATTERN = "urlPattern";
    private static final String HTTP_VERB = "httpVerb";
    private static final String AUTH_TYPE = "authType";
    private static final String API_PROVIDER = "API_PROVIDER";
    private String apimEndpoint = null;
    private String apimUsername = null;
    private String apimPassword = null;
    private String defaultTier = "Unlimited";
    private String apiThrottlingTier = "Unlimited,Unlimited,Unlimited,Unlimited,Unlimited";

    @Override
    public void init(Map parameterMap) {
        SecretResolver secretResolver = SecretResolverFactory.create((OMElement)null, (boolean)false);
        secretResolver.init(GovernanceRegistryExtensionsComponent.getSecretCallbackHandlerService().getSecretCallbackHandler());
        if (parameterMap.get("apim.endpoint") != null) {
            this.apimEndpoint = parameterMap.get("apim.endpoint").toString();
        }
        if (parameterMap.get("apim.username") != null) {
            this.apimUsername = parameterMap.get("apim.username").toString();
            if (secretResolver.isInitialized()) {
                this.apimUsername = secretResolver.isTokenProtected("apim.username") ? secretResolver.resolve("apim.username") : MiscellaneousUtil.resolve((String)this.apimUsername, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("apim.password") != null) {
            this.apimPassword = parameterMap.get("apim.password").toString();
            if (secretResolver.isInitialized()) {
                this.apimPassword = secretResolver.isTokenProtected("apim.password") ? secretResolver.resolve("apim.password") : MiscellaneousUtil.resolve((String)this.apimPassword, (SecretResolver)secretResolver);
            }
        }
        if (parameterMap.get("default.tier") != null) {
            this.defaultTier = parameterMap.get("default.tier").toString();
        }
        if (parameterMap.get("throttlingTier") != null) {
            this.apiThrottlingTier = parameterMap.get("throttlingTier").toString();
        }
    }

    @Override
    public boolean execute(RequestContext context, String currentState, String targetState) {
        Resource resource = context.getResource();
        try {
            String artifactString = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
            OMElement xmlContent = AXIOMUtil.stringToOM((String)artifactString);
            GenericArtifactManager manager = new GenericArtifactManager((Registry)RegistryCoreServiceComponent.getRegistryService().getGovernanceUserRegistry(user, CarbonContext.getThreadLocalCarbonContext().getTenantId()), "restservice");
            GenericArtifact api = manager.getGenericArtifact(context.getResource().getUUID());
            this.publishData(api, xmlContent);
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to publish service to API store ", (Throwable)e);
            return false;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Failed to convert service to xml content", (Throwable)e);
            return false;
        }
        return true;
    }

    private void publishData(GenericArtifact api, OMElement xmlContent) throws RegistryException {
        if (this.apimEndpoint == null || this.apimUsername == null || this.apimPassword == null) {
            throw new RuntimeException("APIManager login credentials are not defined");
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        Utils.authenticateAPIM((HttpContext)httpContext, this.apimEndpoint, this.apimUsername, this.apimPassword);
        String publishEndpoint = this.apimEndpoint + "publisher/site/blocks/item-add/ajax/add.jag";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(publishEndpoint);
        List<NameValuePair> params = this.getRequestParameters(api, xmlContent);
        if (api.getAttribute("overview_endpointURL") != null && api.getAttribute("overview_endpointURL").isEmpty()) {
            log.warn((Object)"Service Endpoint is empty.");
        }
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost, (HttpContext)httpContext);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RegistryException("Failed when encoding the parameter list. ", (Throwable)e);
        }
        catch (IOException e) {
            throw new RegistryException("Failed to send the http POST request to API Manager. ", (Throwable)e);
        }
    }

    private List<NameValuePair> getRequestParameters(GenericArtifact api, OMElement xmlContent) throws GovernanceException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        String serviceName = api.getAttribute("overview_name");
        String serviceVersion = api.getAttribute("overview_version");
        params.add((NameValuePair)new BasicNameValuePair("endpoint", api.getAttribute("overview_endpointURL")));
        params.add((NameValuePair)new BasicNameValuePair("action", "addAPI"));
        params.add((NameValuePair)new BasicNameValuePair("name", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("context", serviceName));
        params.add((NameValuePair)new BasicNameValuePair("version", serviceVersion));
        params.add((NameValuePair)new BasicNameValuePair(API_PROVIDER, CarbonContext.getThreadLocalCarbonContext().getUsername()));
        params.add((NameValuePair)new BasicNameValuePair("tiersCollection", this.defaultTier));
        Iterator resources = xmlContent.getChildrenWithLocalName(URI_TEMPLATE);
        if (!resources.hasNext()) {
            log.warn((Object)"Resources list is empty. Publishing to API Manager might fail.");
        }
        int resourceCount = 0;
        while (resources.hasNext()) {
            OMElement resource = (OMElement)resources.next();
            OMElement urlPattern = resource.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", URL_PATTERN));
            OMElement httpVerb = resource.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", HTTP_VERB));
            OMElement authType = resource.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", AUTH_TYPE));
            String urlPatternText = urlPattern.getText();
            String httpVerbText = httpVerb.getText();
            String authTypeText = authType.getText();
            if (urlPatternText == null || httpVerbText == null) continue;
            authTypeText = authTypeText.isEmpty() ? "Any" : authTypeText;
            params.add((NameValuePair)new BasicNameValuePair("uriTemplate-0" + resourceCount, urlPatternText));
            params.add((NameValuePair)new BasicNameValuePair("resourceMethod-0" + resourceCount, httpVerbText.toUpperCase()));
            params.add((NameValuePair)new BasicNameValuePair("resourceMethodAuthType-0" + resourceCount, authTypeText));
            params.add((NameValuePair)new BasicNameValuePair("resourceMethodThrottlingTier-0" + resourceCount, this.apiThrottlingTier));
            ++resourceCount;
        }
        if (resourceCount > 0) {
            params.add((NameValuePair)new BasicNameValuePair("resourceCount", Integer.toString(resourceCount)));
        }
        params.add((NameValuePair)new BasicNameValuePair("visibility", "public"));
        String endpointConfigJson = "{\"production_endpoints\":{\"url\":\"" + api.getAttribute("overview_endpointURL") + "\",\"config\":null},\"endpoint_type\":\"http\"}";
        params.add((NameValuePair)new BasicNameValuePair("endpoint_config", endpointConfigJson));
        return params;
    }
}

