/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.discoveryagents;

import java.util.List;
import java.util.Map;
import org.wso2.carbon.governance.api.generic.dataobjects.DetachedGenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentException;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentExecutor;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentExecutorSupport;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.ExistArtifactStrategy;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.OrphanArtifactStrategy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class ServerDiscoveryService
extends DiscoveryAgentExecutorSupport {
    public Map<String, List<DetachedGenericArtifact>> discoverArtifacts(GenericArtifact server) throws DiscoveryAgentException {
        DiscoveryAgentExecutor discoveryAgentExecutor = DiscoveryAgentExecutor.getInstance();
        return discoveryAgentExecutor.executeDiscoveryAgent(server);
    }

    public Map<String, List<String>> persistArtifacts(Map<String, List<DetachedGenericArtifact>> discoveredArtifacts, GenericArtifact server, String existArtifactStrategy, String orphanArtifactStrategy) throws DiscoveryAgentException {
        this.setExistArtifactStrategy(ExistArtifactStrategy.valueOf(existArtifactStrategy.toUpperCase()));
        this.setOrphanArtifactStrategy(OrphanArtifactStrategy.valueOf(orphanArtifactStrategy));
        try {
            Registry govRegistry = this.getGovRegistry();
            String originProperty = this.getOriginProperty(server);
            String seqNo = this.getSequenceNo();
            Map<String, List<String>> feedback = this.persistDiscoveredArtifacts(govRegistry, discoveredArtifacts, server, seqNo, originProperty);
            this.handleOrphanArtifacts(govRegistry, discoveredArtifacts, seqNo, originProperty);
            return feedback;
        }
        catch (RegistryException e) {
            throw new DiscoveryAgentException("Exception occurred while accessing registry", e);
        }
    }
}

