/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.discoveryagents;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.DetachedGenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.common.GovernanceConfiguration;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgent;
import org.wso2.carbon.governance.registry.extensions.discoveryagents.DiscoveryAgentException;
import org.wso2.carbon.governance.registry.extensions.internal.GovernanceRegistryExtensionsDataHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class DiscoveryAgentExecutor {
    public static final String SERVER_RXT_OVERVIEW_TYPE = "overview_type";
    public static final String DISCOVERY_STATUS = "discovery_status";
    public static final String DISCOVERY_STATUS_EXISTING = "existing";
    public static final String DISCOVERY_STATUS_NEW = "new";
    public static final String AGENT_CLASS = "AgentClass";
    private final Log log = LogFactory.getLog(DiscoveryAgentExecutor.class);
    private static DiscoveryAgentExecutor executor = new DiscoveryAgentExecutor();
    private Map<String, DiscoveryAgent> agentMap;

    public static DiscoveryAgentExecutor getInstance() {
        return executor;
    }

    public Map<String, List<DetachedGenericArtifact>> executeDiscoveryAgent(GenericArtifact serverArtifact) throws DiscoveryAgentException {
        if (!this.isAgentMapInitialized()) {
            this.initializeAgentMap();
        }
        String serverTypeId = this.getServerTypeId(serverArtifact);
        DiscoveryAgent agent = this.findDiscoveryAgent(serverTypeId);
        Map<String, List<DetachedGenericArtifact>> discoveredArtifacts = agent.discoverArtifacts(serverArtifact);
        try {
            this.markExistingArtifacts(discoveredArtifacts, this.getGovRegistry());
        }
        catch (RegistryException e) {
            throw new DiscoveryAgentException("Exception occurred accessing Registry", e);
        }
        return discoveredArtifacts;
    }

    private void markExistingArtifacts(Map<String, List<DetachedGenericArtifact>> artifacts, Registry registry) throws RegistryException {
        for (Map.Entry<String, List<DetachedGenericArtifact>> entry : artifacts.entrySet()) {
            String shortName = entry.getKey();
            GenericArtifactManager manager = new GenericArtifactManager(registry, shortName);
            for (GenericArtifact genericArtifact : entry.getValue()) {
                if (manager.isExists((GovernanceArtifact)genericArtifact)) {
                    genericArtifact.addAttribute(DISCOVERY_STATUS, DISCOVERY_STATUS_EXISTING);
                    continue;
                }
                genericArtifact.addAttribute(DISCOVERY_STATUS, DISCOVERY_STATUS_NEW);
            }
        }
    }

    private boolean isAgentMapInitialized() {
        return this.agentMap != null;
    }

    protected void initializeAgentMap() {
        this.agentMap = new HashMap<String, DiscoveryAgent>();
        GovernanceConfiguration configuration = GovernanceRegistryExtensionsDataHolder.getInstance().getGovernanceConfiguration();
        for (Map.Entry configEntry : configuration.getDiscoveryAgentConfigs().entrySet()) {
            String serverType = (String)configEntry.getKey();
            Map properties = (Map)configEntry.getValue();
            String agentClass = (String)properties.get(AGENT_CLASS);
            DiscoveryAgent thisAgent = this.loadDiscoveryAgent(agentClass);
            if (thisAgent == null) continue;
            thisAgent.init(properties);
            this.agentMap.put(serverType, thisAgent);
        }
    }

    private DiscoveryAgent loadDiscoveryAgent(String agentClass) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(agentClass);
            return (DiscoveryAgent)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Can't load DiscoveryAgent class " + agentClass));
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.error((Object)("Can't Instantiate DiscoveryAgent class " + agentClass));
        }
        return null;
    }

    private DiscoveryAgent findDiscoveryAgent(String serverTypeId) throws DiscoveryAgentException {
        DiscoveryAgent agent = this.agentMap.get(serverTypeId);
        if (agent == null) {
            throw new DiscoveryAgentException("Can't find DiscoveryAgent associated to server type :" + serverTypeId);
        }
        return agent;
    }

    private String getServerTypeId(GenericArtifact serverArtifact) throws DiscoveryAgentException {
        try {
            String serverTypeId = serverArtifact.getAttribute(SERVER_RXT_OVERVIEW_TYPE);
            if (serverTypeId == null) {
                throw new DiscoveryAgentException("ServerTypeId value is null, can't proceed");
            }
            return serverTypeId;
        }
        catch (GovernanceException e) {
            throw new DiscoveryAgentException("ServerTypeId issue", e);
        }
    }

    private Registry getGovRegistry() throws RegistryException {
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("wso2.system.user");
        return GovernanceRegistryExtensionsDataHolder.getInstance().getRegistryService().getGovernanceSystemRegistry();
    }
}

