/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.aspects.utils;

import java.io.StringReader;
import java.sql.Timestamp;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatCollection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class StatWriter {
    private static final Log log = LogFactory.getLog(StatWriter.class);
    private static final String LOG_DEFAULT_PATH = "/repository/components/org.wso2.carbon.governance/lifecycles/history";
    private static final String REGISTRY_LIFECYCLE_HISTORY_ORDER = "registry.lifecycle_history.order";
    private static OMFactory factory = OMAbstractFactory.getOMFactory();

    public static void writeHistory(StatCollection currentCollection) {
        try {
            Resource statResource;
            Registry systemRegistry;
            try {
                systemRegistry = currentCollection.getRegistry().getRegistryContext().getEmbeddedRegistryService().getGovernanceSystemRegistry(CurrentSession.getTenantId());
            }
            catch (RegistryException ex) {
                systemRegistry = currentCollection.getRegistry();
            }
            String resourcePath = currentCollection.getResourcePath();
            String statResourcePath = currentCollection.getOriginalPath().equals(resourcePath) ? StatWriter.getStatResourcePath(resourcePath) : StatWriter.getStatResourcePath(currentCollection.getOriginalPath());
            if (systemRegistry.resourceExists(statResourcePath)) {
                statResource = systemRegistry.get(statResourcePath);
            } else {
                statResource = systemRegistry.newResource();
                statResource.setMediaType("application/xml");
            }
            statResource.setContent((Object)StatWriter.buildOMContent(statResource, currentCollection));
            systemRegistry.put(statResourcePath, statResource);
        }
        catch (Exception e) {
            log.error((Object)"Failed to add lifecycle history", (Throwable)e);
        }
    }

    private static String getStatResourcePath(String resourcePath) {
        return "/repository/components/org.wso2.carbon.governance/lifecycles/history/" + resourcePath.replace("/", "_");
    }

    private static String buildOMContent(Resource resource, StatCollection currentCollection) throws Exception {
        String content = null;
        String property = resource.getProperty(REGISTRY_LIFECYCLE_HISTORY_ORDER);
        int newOrder = 0;
        if (property != null) {
            newOrder = Integer.parseInt(property) + 1;
        }
        resource.setProperty(REGISTRY_LIFECYCLE_HISTORY_ORDER, "" + newOrder);
        if (resource.getContent() != null) {
            if (resource.getContent() instanceof String) {
                content = (String)resource.getContent();
            } else if (resource.getContent() instanceof byte[]) {
                content = RegistryUtils.decodeBytes((byte[])((byte[])resource.getContent()));
            }
        }
        if (content == null) {
            content = StatWriter.buildInitialOMElement().toString();
        }
        return StatWriter.addNewContentElement(content, currentCollection, newOrder);
    }

    private static String addNewContentElement(String currentContent, StatCollection currentCollection, int order) throws Exception {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(currentContent));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        OMElement currentOmElement = builder.getDocumentElement();
        OMElement itemChildElement = factory.createOMElement("item", currentOmElement.getNamespace(), (OMContainer)currentOmElement);
        itemChildElement.addAttribute("order", "" + order, null);
        itemChildElement.addAttribute("user", currentCollection.getUserName(), null);
        if (currentCollection.getAspectName() != null) {
            itemChildElement.addAttribute("aspect", currentCollection.getAspectName(), null);
        }
        itemChildElement.addAttribute("state", currentCollection.getState(), null);
        if (currentCollection.getTargetState() != null) {
            itemChildElement.addAttribute("targetState", currentCollection.getTargetState(), null);
        }
        itemChildElement.addAttribute("originalPath", currentCollection.getResourcePath(), null);
        itemChildElement.addAttribute("timestamp", new Timestamp(currentCollection.getTimeMillis()).toString(), null);
        OMElement actionElement = factory.createOMElement("action", itemChildElement.getNamespace(), (OMContainer)itemChildElement);
        actionElement.addAttribute("type", currentCollection.getActionType(), null);
        actionElement.addAttribute("name", currentCollection.getAction(), null);
        if (currentCollection.getValidations() != null) {
            OMElement actionValidationsElement = factory.createOMElement("validations", actionElement.getNamespace(), (OMContainer)actionElement);
            Map<String, OMElement> validations = currentCollection.getValidations();
            for (Map.Entry<String, OMElement> validation : validations.entrySet()) {
                OMElement validationElement = factory.createOMElement("validation", actionValidationsElement.getNamespace(), (OMContainer)actionValidationsElement);
                validationElement.addAttribute("name", validation.getKey(), null);
                if (validation.getValue() == null) continue;
                OMElement validationsInfoElement = factory.createOMElement("operations", validationElement.getNamespace(), (OMContainer)validationElement);
                validationsInfoElement.addChild((OMNode)validation.getValue());
            }
        }
        if (currentCollection.getExecutors() != null) {
            OMElement actionExecutors = factory.createOMElement("executors", actionElement.getNamespace(), (OMContainer)actionElement);
            Map<String, OMElement> executors = currentCollection.getExecutors();
            for (Map.Entry<String, OMElement> executor : executors.entrySet()) {
                OMElement executorElement = factory.createOMElement("executor", actionExecutors.getNamespace(), (OMContainer)actionExecutors);
                executorElement.addAttribute("name", executor.getKey(), null);
                if (executor.getValue() == null) continue;
                OMElement executorInfoElement = factory.createOMElement("operations", executorElement.getNamespace(), (OMContainer)executorElement);
                executorInfoElement.addChild((OMNode)executor.getValue());
            }
        }
        if (currentCollection.getActionValue() != null) {
            OMElement actionValueElement = factory.createOMElement("value", actionElement.getNamespace(), (OMContainer)actionElement);
            actionValueElement.setText(currentCollection.getActionValue());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)currentOmElement.getFirstElement().toString());
        }
        return currentOmElement.toString();
    }

    private static OMElement buildInitialOMElement() {
        OMElement initialOMElement = factory.createOMElement(new QName("lifecycleHistory"));
        return initialOMElement;
    }
}

