/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.aspects.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;

public class LifecycleCheckpointUtils {
    private static final Log log = LogFactory.getLog(LifecycleCheckpointUtils.class);

    public static List evaluateXpath(OMElement contentElement, String xpathString, String nsPrefix) {
        ArrayList resultsList = new ArrayList();
        try {
            AXIOMXPath xpath = new AXIOMXPath(xpathString);
            Iterator nsIterator = contentElement.getAllDeclaredNamespaces();
            if (nsIterator.hasNext()) {
                while (nsIterator.hasNext()) {
                    OMNamespace next = (OMNamespace)nsIterator.next();
                    xpath.addNamespace(nsPrefix, next.getNamespaceURI());
                    resultsList.addAll(xpath.selectNodes((Object)contentElement));
                }
            } else if (contentElement.getDefaultNamespace() != null) {
                xpath.addNamespace(nsPrefix, contentElement.getDefaultNamespace().getNamespaceURI());
                resultsList.addAll(xpath.selectNodes((Object)contentElement));
            } else if (nsPrefix != null) {
                xpathString = xpathString.replace(nsPrefix + ":", "");
                xpath = new AXIOMXPath(xpathString);
                resultsList.addAll(xpath.selectNodes((Object)contentElement));
            } else {
                xpath = new AXIOMXPath(xpathString);
                resultsList.addAll(xpath.selectNodes((Object)contentElement));
            }
            return resultsList;
        }
        catch (JaxenException e) {
            log.error((Object)("Error while evaluating xPath: '" + xpathString + "'."), (Throwable)e);
            return null;
        }
    }

    public static String getLCInitialStateId(OMElement configurationElement) {
        if (configurationElement == null) {
            return null;
        }
        String xpathString = "/aspect/configuration/lifecycle/*[name()='scxml']/*[name()='state']";
        List checkpoints = LifecycleCheckpointUtils.evaluateXpath(configurationElement, xpathString, null);
        if (!checkpoints.isEmpty()) {
            OMElement initialStateElement = (OMElement)checkpoints.get(0);
            return initialStateElement.getAttributeValue(new QName("id"));
        }
        return null;
    }

    public static String getCurrentTime() {
        Date currentTimeStamp = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(currentTimeStamp);
    }
}

