/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.registry.extensions.aspects;

import java.io.CharArrayReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.io.SCXMLParser;
import org.apache.commons.scxml.model.Data;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Element;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.LifecycleCheckpointUtils;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatCollection;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.StatWriter;
import org.wso2.carbon.governance.registry.extensions.aspects.utils.Utils;
import org.wso2.carbon.governance.registry.extensions.beans.ApprovalBean;
import org.wso2.carbon.governance.registry.extensions.beans.CheckItemBean;
import org.wso2.carbon.governance.registry.extensions.beans.CustomCodeBean;
import org.wso2.carbon.governance.registry.extensions.beans.InputBean;
import org.wso2.carbon.governance.registry.extensions.beans.PermissionsBean;
import org.wso2.carbon.governance.registry.extensions.beans.ScriptBean;
import org.wso2.carbon.governance.registry.extensions.interfaces.CustomValidations;
import org.wso2.carbon.governance.registry.extensions.interfaces.Execution;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.CollectionHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.RegistryHostObject;
import org.wso2.carbon.mashup.javascript.hostobjects.registry.ResourceHostObject;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserStoreException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultLifeCycle
extends Aspect {
    private static final Log log = LogFactory.getLog(DefaultLifeCycle.class);
    private String lifecycleProperty = "registry.LC.name";
    private String stateProperty = "registry.lifecycle.SoftwareProjectLifecycle.state";
    private String stateVoteProperty = "registry.LC.currentVotes";
    private String ASSOCIATION = "association";
    private List<String> states;
    private Map<String, List<CheckItemBean>> checkListItems;
    private Map<String, List<CustomCodeBean>> transitionValidations;
    private Map<String, List<CustomCodeBean>> transitionExecution;
    private Map<String, List<PermissionsBean>> transitionPermission;
    private Map<String, List<String>> stateEvents;
    private Map<String, List<ScriptBean>> scriptElements;
    private Map<String, Map<String, String>> transitionUIs;
    private Map<String, List<InputBean>> transitionInputs;
    private Map<String, List<ApprovalBean>> transitionApproval;
    private boolean isConfigurationFromResource;
    private String configurationResourcePath;
    private OMElement configurationElement;
    private String aspectName;
    private boolean isAuditEnabled;
    private SCXML scxml;

    public DefaultLifeCycle(OMElement config) throws RegistryException {
        String currentAspectName;
        this.initialize();
        this.aspectName = currentAspectName = config.getAttributeValue(new QName("name"));
        currentAspectName = currentAspectName.replaceAll("\\s", "");
        this.stateProperty = "registry.lifecycle." + currentAspectName + ".state";
        this.lifecycleProperty = this.lifecycleProperty + "." + currentAspectName;
        Iterator configChildElements = config.getChildElements();
        while (configChildElements.hasNext()) {
            OMElement configChildEl = (OMElement)configChildElements.next();
            if (configChildEl.getAttribute(new QName("type")) == null) continue;
            String type = configChildEl.getAttributeValue(new QName("type"));
            if (type.equalsIgnoreCase("resource")) {
                this.isConfigurationFromResource = true;
                this.configurationResourcePath = RegistryUtils.getAbsolutePath((RegistryContext)RegistryContext.getBaseInstance(), (String)configChildEl.getText());
                this.clearAll();
                break;
            }
            if (!type.equalsIgnoreCase("literal")) continue;
            this.isConfigurationFromResource = false;
            this.configurationElement = configChildEl.getFirstElement();
            this.clearAll();
            break;
        }
    }

    private void clearAll() {
        this.states.clear();
        this.checkListItems.clear();
        this.transitionPermission.clear();
        this.transitionValidations.clear();
        this.transitionExecution.clear();
        this.transitionUIs.clear();
        this.transitionApproval.clear();
        this.transitionInputs.clear();
    }

    private void initialize() {
        this.states = new ArrayList<String>();
        this.checkListItems = new HashMap<String, List<CheckItemBean>>();
        this.transitionValidations = new HashMap<String, List<CustomCodeBean>>();
        this.transitionExecution = new HashMap<String, List<CustomCodeBean>>();
        this.transitionPermission = new HashMap<String, List<PermissionsBean>>();
        this.stateEvents = new HashMap<String, List<String>>();
        this.scriptElements = new HashMap<String, List<ScriptBean>>();
        this.transitionUIs = new HashMap<String, Map<String, String>>();
        this.transitionInputs = new HashMap<String, List<InputBean>>();
        this.transitionApproval = new HashMap<String, List<ApprovalBean>>();
        this.isAuditEnabled = true;
    }

    private void setSCXMLConfiguration(Registry registry) throws RegistryException, XMLStreamException, IOException, SAXException, ModelException {
        if (this.isConfigurationFromResource) {
            if (registry.resourceExists(this.configurationResourcePath)) {
                try {
                    Resource configurationResource = registry.get(this.configurationResourcePath);
                    String xmlContent = RegistryUtils.decodeBytes((byte[])((byte[])configurationResource.getContent()));
                    this.configurationElement = AXIOMUtil.stringToOM((String)xmlContent);
                    this.configurationElement.toString();
                }
                catch (Exception e) {
                    String msg = "Invalid lifecycle configuration found at " + this.configurationResourcePath;
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
            } else {
                String msg = "Unable to find the lifecycle configuration from the given path: " + this.configurationResourcePath;
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
        }
        try {
            if (this.configurationElement.getAttributeValue(new QName("audit")) != null) {
                this.isAuditEnabled = Boolean.parseBoolean(this.configurationElement.getAttributeValue(new QName("audit")));
            }
            OMElement scxmlElement = this.configurationElement.getFirstElement();
            this.scxml = SCXMLParser.parse((InputSource)new InputSource(new CharArrayReader(scxmlElement.toString().toCharArray())), null);
        }
        catch (Exception e) {
            String msg = "Invalid SCXML configuration found";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
    }

    public void associate(Resource resource, Registry registry) throws RegistryException {
        this.clearAll();
        try {
            this.setSCXMLConfiguration(registry);
            if (this.configurationElement == null) {
                return;
            }
            resource.setProperty("registry.LC.name", this.aspectName);
            List propertyValues = resource.getPropertyValues(this.lifecycleProperty);
            this.addCheckPointProperties(resource, null);
            if (propertyValues != null && propertyValues.size() > 0) {
                return;
            }
            if (this.states.size() == 0) {
                this.populateItems();
            }
            String initialState = this.scxml.getInitial();
            Utils.addCheckItems(resource, this.checkListItems.get(initialState), initialState, this.aspectName);
            Utils.addTransitionApprovalItems(resource, this.transitionApproval.get(initialState), initialState, this.aspectName);
            Utils.addScripts(initialState, resource, this.scriptElements.get(initialState), this.aspectName);
            Utils.addTransitionUI(resource, this.transitionUIs.get(initialState), this.aspectName);
            Utils.addTransitionInputs(initialState, resource, this.transitionInputs.get(initialState), this.aspectName);
        }
        catch (Exception e) {
            String message = "Resource does not contain a valid XML configuration: " + e.toString();
            log.error((Object)message);
            return;
        }
        resource.setProperty(this.stateProperty, this.scxml.getInitial().replace(".", " "));
        resource.setProperty(this.lifecycleProperty, this.aspectName);
        StatCollection statCollection = new StatCollection();
        statCollection.setActionType(this.ASSOCIATION);
        statCollection.setAction("");
        statCollection.setRegistry((Registry)registry.getRegistryContext().getEmbeddedRegistryService().getSystemRegistry(CurrentSession.getTenantId()));
        statCollection.setTimeMillis(System.currentTimeMillis());
        statCollection.setState(this.scxml.getInitial());
        statCollection.setResourcePath(resource.getPath());
        statCollection.setUserName(CurrentSession.getUser());
        statCollection.setOriginalPath(resource.getPath());
        statCollection.setAspectName(this.aspectName);
        if (this.isAuditEnabled) {
            StatWriter.writeHistory(statCollection);
        }
    }

    public String[] getAvailableActions(RequestContext context) {
        Resource resource = context.getResource();
        if (resource.getProperty(this.stateProperty) == null) {
            return new String[0];
        }
        String currentState = resource.getProperty(this.stateProperty).replace(" ", ".");
        this.initializeAspect(context, currentState);
        ArrayList<String> actions = new ArrayList<String>();
        String user = CurrentSession.getUser();
        State currentExecutionState = (State)this.scxml.getChildren().get(currentState);
        List currentTransitions = currentExecutionState.getTransitionsList();
        try {
            List<PermissionsBean> permissionsBeans = this.transitionPermission.get(currentState);
            String[] roles = CurrentSession.getUserRealm().getUserStoreManager().getRoleListOfUser(user);
            for (Object currentTransition : currentTransitions) {
                Transition t = (Transition)currentTransition;
                String transitionName = t.getEvent();
                List<String> possibleActions = this.getPossibleActions(resource, currentState);
                if (!Utils.isTransitionAllowed(roles, permissionsBeans, transitionName) && permissionsBeans != null || !possibleActions.contains(transitionName)) continue;
                actions.add(transitionName);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Failed to get the current user role :", (Throwable)e);
            return new String[0];
        }
        return actions.toArray(new String[actions.size()]);
    }

    private void initializeAspect(RequestContext context, String currentState) {
        try {
            if (this.states.size() == 0 || !this.states.contains(currentState)) {
                this.clearAll();
                Registry registry = context.getRegistry();
                this.setSCXMLConfiguration(registry);
                this.populateItems();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Resource does not contain a valid XML configuration: " + e.toString());
        }
    }

    public void invoke(RequestContext context, String action) throws RegistryException {
        this.invoke(context, action, Collections.emptyMap());
    }

    public void invoke(RequestContext requestContext, String action, Map<String, String> parameterMap) throws RegistryException {
        String[] roles;
        String user;
        boolean preserveOldResource = !Boolean.toString(false).equals(parameterMap.remove("preserveOriginal"));
        Resource resource = requestContext.getResource();
        String currentState = resource.getProperty(this.stateProperty).replace(" ", ".");
        String resourcePath = requestContext.getResourcePath().getPath();
        this.initializeAspect(requestContext, currentState);
        String nextState = currentState;
        if (nextState == null || "".equals(nextState)) {
            throw new GovernanceException("Next state is not defined ");
        }
        try {
            user = CurrentSession.getUser();
            roles = CurrentSession.getUserRealm().getUserStoreManager().getRoleListOfUser(user);
        }
        catch (UserStoreException e) {
            String message = "Unable to get user information";
            log.error((Object)message);
            throw new RegistryException(message, (Throwable)e);
        }
        this.lifeCycleActionValidation(resource, requestContext, currentState, action);
        State currentExecutionState = (State)this.scxml.getChildren().get(currentState);
        StatCollection statCollection = new StatCollection();
        requestContext.setProperty("statCollection", (Object)statCollection);
        statCollection.setAction(action);
        statCollection.setRegistry(requestContext.getSystemRegistry());
        statCollection.setTimeMillis(System.currentTimeMillis());
        statCollection.setState(currentState);
        statCollection.setResourcePath(resourcePath);
        statCollection.setUserName(user);
        statCollection.setOriginalPath(resourcePath);
        statCollection.setAspectName(this.aspectName);
        if ("voteClick".equals(action)) {
            this.handleApprovalClick(resource, currentState, Utils.extractVotesValues(parameterMap), user, roles, requestContext);
        } else {
            this.handleItemClick(resource, currentState, Utils.extractCheckItemValues(parameterMap), roles, requestContext);
        }
        List transitions = currentExecutionState.getTransitionsList();
        try {
            List<String> possibleEvents = this.getPossibleActions(resource, currentState);
            if (possibleEvents.size() > 0) {
                for (Object o : transitions) {
                    String eventName = ((Transition)o).getEvent();
                    if (!possibleEvents.contains(eventName) || !eventName.equals(action) || !Utils.isTransitionAllowed(roles, this.transitionPermission.get(currentState), eventName)) continue;
                    if (this.doAllCustomValidations(requestContext, currentState, eventName)) {
                        statCollection.setActionType("transition");
                        if (resource.getProperty("registry.lifecycle_history.originalPath" + this.aspectName) != null) {
                            statCollection.setOriginalPath(resource.getProperty("registry.lifecycle_history.originalPath" + this.aspectName));
                        }
                        nextState = ((Transition)o).getNext();
                        this.runCustomExecutorsCode(action, requestContext, this.transitionExecution.get(currentState), currentState, nextState);
                        this.updateCheckpointProperties(resource, nextState);
                        List<ScriptBean> scriptElement = this.scriptElements.get(currentState);
                        try {
                            if (scriptElement == null) break;
                            for (ScriptBean scriptBean : scriptElement) {
                                if (!scriptBean.getEventName().equals(eventName) || scriptBean.isConsole()) continue;
                                this.executeJS(AXIOMUtil.stringToOM((String)scriptBean.getScript()).getText() + "\n" + scriptBean.getFunctionName() + "()");
                            }
                            break;
                        }
                        catch (Exception e) {
                            String msg = "JavaScript execution failed.";
                            log.error((Object)msg);
                            throw new RegistryException(msg);
                        }
                    }
                    String msg = "Transition validations failed.";
                    log.info((Object)msg);
                    throw new RegistryException(msg);
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)e);
            throw new RegistryException(e.getMessage());
        }
        if (requestContext.getResource() == null) {
            requestContext.setResource(resource);
            requestContext.setProcessingComplete(true);
            return;
        }
        if (!requestContext.getResourcePath().getPath().equals(resourcePath) && !requestContext.getResource().equals(resource)) {
            requestContext.getRegistry().put(resourcePath, resource);
        }
        resource = requestContext.getResource();
        String newResourcePath = requestContext.getResourcePath().getPath();
        if (!currentState.equals(nextState)) {
            State state = (State)this.scxml.getChildren().get(nextState);
            resource.setProperty(this.stateProperty, state.getId().replace(".", " "));
            resource.setProperty("registry.LC.name", this.aspectName);
            Utils.clearCheckItems(resource, this.aspectName);
            Utils.clearTransitionApprovals(resource, this.aspectName);
            Utils.addCheckItems(resource, this.checkListItems.get(state.getId()), state.getId(), this.aspectName);
            Utils.addTransitionApprovalItems(resource, this.transitionApproval.get(state.getId()), state.getId(), this.aspectName);
            Utils.addScripts(state.getId(), resource, this.scriptElements.get(state.getId()), this.aspectName);
            Utils.addTransitionUI(resource, this.transitionUIs.get(state.getId()), this.aspectName);
            Utils.addTransitionInputs(state.getId(), resource, this.transitionInputs.get(state.getId()), this.aspectName);
            statCollection.setTargetState(nextState);
        }
        if (!preserveOldResource) {
            requestContext.getRegistry().delete(resourcePath);
        }
        requestContext.getRegistry().put(newResourcePath, resource);
        if (this.isAuditEnabled) {
            StatWriter.writeHistory(statCollection);
        }
    }

    public void dissociate(RequestContext requestContext) {
        Resource resource = requestContext.getResource();
        if (resource != null) {
            resource.removeProperty(this.stateProperty);
            resource.removeProperty(this.lifecycleProperty);
        }
    }

    private void populateItems() throws Exception {
        Map stateList = this.scxml.getChildren();
        Iterator iterator = stateList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry stateObject;
            Map.Entry state = stateObject = iterator.next();
            String currentStateName = (String)state.getKey();
            State currentState = (State)state.getValue();
            Datamodel model = currentState.getDatamodel();
            this.states.add(currentStateName);
            if (model != null) {
                List dataList = model.getData();
                for (Object dataObject : dataList) {
                    Data data = (Data)dataObject;
                    OMElement node = XMLUtils.toOM((Element)((Element)data.getNode()));
                    Utils.populateCheckItems(currentStateName, node, this.checkListItems);
                    Utils.populateTransitionValidations(currentStateName, node, this.transitionValidations);
                    Utils.populateTransitionPermissions(currentStateName, node, this.transitionPermission);
                    Utils.populateTransitionScripts(currentStateName, node, this.scriptElements);
                    Utils.populateTransitionUIs(currentStateName, node, this.transitionUIs);
                    Utils.populateTransitionExecutors(currentStateName, node, this.transitionExecution);
                    Utils.populateTransitionApprovals(currentStateName, node, this.transitionApproval);
                    Utils.populateTransitionInputs(currentStateName, node, this.transitionInputs);
                }
            }
            ArrayList<String> events = new ArrayList<String>();
            for (Object t : currentState.getTransitionsList()) {
                Transition transition = (Transition)t;
                events.add(transition.getEvent());
            }
            this.stateEvents.put(currentStateName, events);
        }
    }

    private List<String> getPossibleActions(Resource resource, String currentState) {
        Properties propertyNameValues = resource.getProperties();
        Iterator<Map.Entry<Object, Object>> propIterator = propertyNameValues.entrySet().iterator();
        List<CheckItemBean> checkItems = this.checkListItems.get(currentState);
        ArrayList<String> events = new ArrayList<String>((Collection)this.stateEvents.get(currentState));
        if (checkItems != null && checkItems.size() > 0) {
            while (propIterator.hasNext()) {
                Map.Entry<Object, Object> entry = propIterator.next();
                String propertyName = (String)entry.getKey();
                if (!propertyName.startsWith("registry.custom_lifecycle.checklist.option." + this.aspectName)) continue;
                List propValues = (List)entry.getValue();
                for (String propValue : propValues) {
                    if (!propValue.startsWith("name:")) continue;
                    for (CheckItemBean checkItem : checkItems) {
                        if (!checkItem.getName().equals(propValue.substring(propValue.indexOf(":") + 1)) || checkItem.getEvents() == null || !propValues.contains("value:false")) continue;
                        events.removeAll(checkItem.getEvents());
                    }
                }
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJS(String script) throws Exception {
        Context cx = Context.enter();
        try {
            ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
            cx.putThreadLocal((Object)"axisConfigurationContext", (Object)configurationContext);
            AxisService service = new AxisService();
            service.addParameter("mashupAuthor", (Object)CurrentSession.getUser());
            cx.putThreadLocal((Object)"axisService", (Object)service);
            ScriptableObject scope = cx.initStandardObjects();
            ScriptableObject.defineClass((Scriptable)scope, ResourceHostObject.class);
            ScriptableObject.defineClass((Scriptable)scope, CollectionHostObject.class);
            ScriptableObject.defineClass((Scriptable)scope, RegistryHostObject.class);
            Object result = cx.evaluateString((Scriptable)scope, script, "<cmd>", 1, null);
            if (result != null && log.isInfoEnabled()) {
                log.info((Object)("JavaScript Result: " + Context.toString((Object)result)));
            }
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to defining registry host objects.";
            throw new Exception(msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Unable to instantiate the given registry host object.";
            throw new Exception(msg, e);
        }
        catch (InvocationTargetException e) {
            String msg = "An exception occurred while creating registry host objects.";
            throw new Exception(msg, e);
        }
        catch (AxisFault e) {
            String msg = "Failed to set user name parameter.";
            throw new Exception(msg, e);
        }
        catch (SecurityException securityException) {
        }
        finally {
            Context.exit();
        }
    }

    private boolean doAllCustomValidations(RequestContext context, String currentState, String action) throws RegistryException {
        List<CheckItemBean> currentStateCheckItems = this.checkListItems.get(currentState);
        if (currentStateCheckItems != null) {
            for (CheckItemBean currentStateCheckItem : currentStateCheckItems) {
                try {
                    this.runCustomValidationsCode(context, currentStateCheckItem.getValidationBeans(), action);
                }
                catch (RegistryException registryException) {
                    throw new RegistryException("Validation failed for check item : " + currentStateCheckItem.getName());
                }
            }
        }
        try {
            return this.runCustomValidationsCode(context, this.transitionValidations.get(currentState), action);
        }
        catch (RegistryException e) {
            throw new RegistryException("Validation failed for check item : " + action);
        }
    }

    private boolean runCustomValidationsCode(RequestContext context, List<CustomCodeBean> customCodeBeans, String action) throws RegistryException {
        if (customCodeBeans != null) {
            for (CustomCodeBean customCodeBean : customCodeBeans) {
                if (!customCodeBean.getEventName().equals(action)) continue;
                CustomValidations customValidations = (CustomValidations)customCodeBean.getClassObeject();
                StatCollection statCollection = (StatCollection)context.getProperty("statCollection");
                statCollection.addValidations(customCodeBean.getClass().getName(), null);
                if (customValidations.validate(context)) continue;
                statCollection.addValidations(customCodeBean.getClass().getName(), Utils.getHistoryInfoElement("validation failed"));
                String userMsg = (String)context.getProperty("validationsMessage");
                String message = "Validation : " + customCodeBean.getClassObeject().getClass().getName() + " failed for action : " + customCodeBean.getEventName();
                if (userMsg != null) {
                    message = message + " Embedded error : " + userMsg;
                }
                throw new RegistryException(message);
            }
        }
        return true;
    }

    private boolean runCustomExecutorsCode(String action, RequestContext context, List<CustomCodeBean> customCodeBeans, String currentState, String nextState) throws RegistryException {
        if (customCodeBeans != null) {
            for (CustomCodeBean customCodeBean : customCodeBeans) {
                if (!customCodeBean.getEventName().equals(action)) continue;
                Execution customExecutor = (Execution)customCodeBean.getClassObeject();
                StatCollection statCollection = (StatCollection)context.getProperty("statCollection");
                statCollection.addExecutors(customExecutor.getClass().getName(), null);
                if (customExecutor.execute(context, currentState, nextState)) continue;
                statCollection.addExecutors(customExecutor.getClass().getName(), Utils.getHistoryInfoElement("executor failed"));
                String userMsg = (String)context.getProperty("executorMessage");
                String message = "Execution failed for action : " + customCodeBean.getEventName();
                if (userMsg != null) {
                    message = message + " Embedded error : " + userMsg;
                }
                throw new RegistryException(message);
            }
        }
        return true;
    }

    private void handleItemClick(Resource resource, String state, Map<String, String> itemParameterMap, String[] roles, RequestContext context) throws RegistryException {
        for (Map.Entry<String, String> entry : itemParameterMap.entrySet()) {
            List propertyValues = resource.getPropertyValues("registry.custom_lifecycle.checklist.option." + this.aspectName + "." + entry.getKey());
            if (propertyValues == null) continue;
            String name = null;
            for (String propertyValue : propertyValues) {
                if (!propertyValue.startsWith("name:")) continue;
                name = propertyValue.replace("name:", "");
                break;
            }
            for (String propertyValue : propertyValues) {
                if (!propertyValue.startsWith("value:") || propertyValue.contains(entry.getValue())) continue;
                ArrayList<String> newProps = new ArrayList<String>(propertyValues);
                newProps.remove(propertyValue);
                if (Boolean.parseBoolean(entry.getValue())) {
                    List<CheckItemBean> checkItemBeans = this.checkListItems.get(state);
                    for (CheckItemBean checkItemBean : checkItemBeans) {
                        if (!checkItemBean.getName().equals(name) || Utils.isCheckItemClickAllowed(roles, checkItemBean.getPermissionsBeans())) continue;
                        String message = "User is not authorized to check item :" + name;
                        log.error((Object)message);
                        throw new RegistryException(message);
                    }
                }
                String replace = propertyValue.replace(Boolean.toString(Boolean.valueOf(entry.getValue()) == false), entry.getValue());
                newProps.add(replace);
                resource.removeProperty("registry.custom_lifecycle.checklist.option." + this.aspectName + "." + entry.getKey());
                resource.setProperty("registry.custom_lifecycle.checklist.option." + this.aspectName + "." + entry.getKey(), newProps);
                StatCollection statCollection = (StatCollection)context.getProperty("statCollection");
                statCollection.setAction(Utils.getCheckItemName(propertyValues));
                statCollection.setActionType("itemClick");
                statCollection.setActionValue(replace);
                if (resource.getProperty("registry.lifecycle_history.originalPath" + this.aspectName) == null) continue;
                statCollection.setOriginalPath(resource.getProperty("registry.lifecycle_history.originalPath" + this.aspectName));
            }
        }
    }

    private void handleApprovalClick(Resource resource, String currentState, Map<String, String> itemParameterMap, String user, String[] roles, RequestContext requestContext) {
        block0: for (Map.Entry<String, String> entry : itemParameterMap.entrySet()) {
            List propertyValues = resource.getPropertyValues("registry.custom_lifecycle.votes.option." + this.aspectName + "." + entry.getKey());
            String userPropertyValue = "";
            boolean userVoted = false;
            List<Object> userList = new ArrayList();
            for (String propertyValue : propertyValues) {
                if (!propertyValue.startsWith("users:")) continue;
                userPropertyValue = propertyValue;
                String users = propertyValue.replace("users:", "");
                String[] votedUsers = users.split(",");
                userList = Arrays.asList(votedUsers);
                if (userList != null && !userList.isEmpty()) {
                    userVoted = Arrays.asList(votedUsers).contains(user);
                    break;
                }
                if (userList != null) break;
                userList = new ArrayList();
                break;
            }
            if (!userVoted && (userVoted || !Boolean.valueOf(entry.getValue()).booleanValue())) continue;
            for (String propertyValue : propertyValues) {
                if (!propertyValue.startsWith("current:") || propertyValue.contains(entry.getValue())) continue;
                ArrayList<String> newProps = new ArrayList<String>(propertyValues);
                String approvals = (String)newProps.get(newProps.indexOf(propertyValue));
                approvals = approvals.replace("current:", "");
                int approvalCount = Integer.parseInt(approvals);
                ArrayList<Object> list = new ArrayList<Object>(userList);
                if (Boolean.valueOf(entry.getValue()).booleanValue() && !userVoted) {
                    ++approvalCount;
                    list.add(user);
                } else if (!Boolean.valueOf(entry.getValue()).booleanValue() && userVoted) {
                    --approvalCount;
                    list.remove(user);
                }
                newProps.remove(propertyValue);
                newProps.add("current:" + approvalCount);
                StringBuilder sb = new StringBuilder();
                for (String string : list) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(string);
                }
                newProps.remove(userPropertyValue);
                newProps.add("users:" + sb.toString());
                resource.removeProperty("registry.custom_lifecycle.votes.option." + this.aspectName + "." + entry.getKey());
                resource.setProperty("registry.custom_lifecycle.votes.option." + this.aspectName + "." + entry.getKey(), newProps);
                StatCollection statCollection = (StatCollection)requestContext.getProperty("statCollection");
                statCollection.setAction(Utils.getCheckItemName(propertyValues));
                statCollection.setActionType(".vote");
                statCollection.setActionValue(entry.getValue());
                if (resource.getProperty("registry.lifecycle_history.originalPath" + this.aspectName) == null) continue block0;
                statCollection.setOriginalPath(resource.getProperty("registry.lifecycle_history.originalPath" + this.aspectName));
                continue block0;
            }
        }
    }

    private void lifeCycleActionValidation(Resource resource, RequestContext requestContext, String currentState, String action) throws RegistryException {
        if (!action.equals("voteClick") && !action.equals("itemClick") && this.transitionApproval.get(currentState) != null) {
            int order = 0;
            for (ApprovalBean approvalBean : this.transitionApproval.get(currentState)) {
                if (action.equals(approvalBean.getForEvent())) {
                    String resourcePropertyNameForItem = "registry.custom_lifecycle.votes.option." + this.aspectName + "." + order + ".vote";
                    List list = resource.getPropertyValues(resourcePropertyNameForItem);
                    for (String value : list) {
                        int currentVotes;
                        if (!value.startsWith("current:") || (currentVotes = Integer.parseInt(value = value.replace("current:", ""))) >= approvalBean.getVotes()) continue;
                        String message = "Unable to " + action + " the lifecycle with available Approvals. Required Votes: " + approvalBean.getVotes() + ", Current Votes: " + currentVotes;
                        log.error((Object)message);
                        throw new RegistryException(message);
                    }
                }
                ++order;
            }
        }
        String[] vailableActions = this.getAvailableActions(requestContext);
        List<String> actionsList = Arrays.asList(vailableActions);
        if (!(action.equals("voteClick") || action.equals("itemClick") || actionsList.contains(action))) {
            String message = "Preprequest action must be completed before " + action + "";
            log.error((Object)message);
            throw new RegistryException(message);
        }
    }

    private void addCheckPointProperties(Resource resource, String nextState) throws RegistryException {
        String xpathString;
        List checkpoints;
        if (nextState == null) {
            nextState = LifecycleCheckpointUtils.getLCInitialStateId(this.configurationElement);
        }
        if (nextState != null && !(checkpoints = LifecycleCheckpointUtils.evaluateXpath(this.configurationElement, xpathString = "/aspect/configuration/lifecycle/*[name()='scxml']/*[name()='state'][@id='" + nextState + "']" + "/*[name()='checkpoints']/*[name()='checkpoint']", null)).isEmpty()) {
            for (Object checkpoint : checkpoints) {
                OMElement checkpointOMElement = (OMElement)checkpoint;
                String checkpointId = checkpointOMElement.getAttributeValue(new QName("id"));
                String checkpointDurationColour = checkpointOMElement.getAttributeValue(new QName("durationColour"));
                String checkpointDurationMinBoundary = checkpointOMElement.getFirstElement().getAttributeValue(new QName("min"));
                String checkpointDurationMaxBoundary = checkpointOMElement.getFirstElement().getAttributeValue(new QName("max"));
                resource.addProperty("registry.lifecycle." + this.aspectName + ".checkpoint", checkpointId);
                ArrayList<String> lcCheckpointProperties1 = new ArrayList<String>();
                lcCheckpointProperties1.add(0, checkpointId);
                lcCheckpointProperties1.add(1, checkpointDurationMinBoundary);
                lcCheckpointProperties1.add(2, checkpointDurationMaxBoundary);
                lcCheckpointProperties1.add(3, LifecycleCheckpointUtils.getCurrentTime());
                lcCheckpointProperties1.add(4, checkpointDurationColour);
                String checkpointPropertyKey = "registry.lifecycle." + this.aspectName + ".checkpoint" + "." + checkpointId;
                resource.removeProperty(checkpointPropertyKey);
                resource.setProperty(checkpointPropertyKey, lcCheckpointProperties1);
            }
        }
        resource.setProperty("registry.lifecycle." + this.aspectName + ".lastStateUpdatedTime", LifecycleCheckpointUtils.getCurrentTime());
    }

    private void updateCheckpointProperties(Resource resource, String nextState) throws RegistryException {
        String checkpointProperty = "registry.lifecycle." + this.aspectName + ".checkpoint";
        List checkpoints = resource.getPropertyValues(checkpointProperty);
        if (checkpoints != null && !checkpoints.isEmpty()) {
            for (String checkpoint : checkpoints) {
                resource.removeProperty(checkpointProperty + "." + checkpoint);
            }
        }
        resource.removeProperty(checkpointProperty);
        this.addCheckPointProperties(resource, nextState);
    }
}

