/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.stream.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.analytics.stream.persistence.stub.EventStreamPersistenceAdminServiceStub;
import org.wso2.carbon.analytics.stream.persistence.stub.dto.AnalyticsTableRecord;
import org.wso2.carbon.event.stream.stub.EventStreamAdminServiceStub;
import org.wso2.carbon.event.stream.stub.types.EventStreamAttributeDto;
import org.wso2.carbon.event.stream.stub.types.EventStreamDefinitionDto;
import org.wso2.carbon.ui.CarbonUIUtil;

public class EventStreamUIUtils {
    public static EventStreamAdminServiceStub getEventStreamAdminService(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "EventStreamAdminService.EventStreamAdminServiceHttpsSoap12Endpoint";
        EventStreamAdminServiceStub stub = new EventStreamAdminServiceStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static EventStreamPersistenceAdminServiceStub getEventStreamPersistenceAdminService(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session) + "EventStreamPersistenceAdminService";
        EventStreamPersistenceAdminServiceStub stub = new EventStreamPersistenceAdminServiceStub(configContext, serverURL);
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        return stub;
    }

    public static boolean isEventStreamPersistenceAdminServiceAvailable(EventStreamPersistenceAdminServiceStub eventStreamPersistenceAdminServiceStub) {
        try {
            return eventStreamPersistenceAdminServiceStub.isBackendServicePresent();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public static EventStreamDefinitionDto getEventStreamInfoDtoFrom(String jsonStreamDef) {
        JsonElement jsonElement = new JsonParser().parse(jsonStreamDef);
        JsonObject rootObject = jsonElement.getAsJsonObject();
        String streamName = rootObject.getAsJsonPrimitive("name").getAsString();
        String streamVersion = rootObject.getAsJsonPrimitive("version").getAsString();
        EventStreamDefinitionDto eventStreamInfoDto = new EventStreamDefinitionDto();
        eventStreamInfoDto.setName(streamName);
        eventStreamInfoDto.setVersion(streamVersion);
        JsonArray metaData = rootObject.getAsJsonArray("metaData");
        JsonArray correlationData = rootObject.getAsJsonArray("correlationData");
        JsonArray payloadData = rootObject.getAsJsonArray("payloadData");
        ArrayList<EventStreamAttributeDto> metaAttributeDtos = new ArrayList<EventStreamAttributeDto>();
        for (Object metaAttribute : metaData) {
            JsonObject metaAttributeObj = metaAttribute.getAsJsonObject();
            EventStreamAttributeDto eventStreamAttributeDto = new EventStreamAttributeDto();
            eventStreamAttributeDto.setAttributeName(metaAttributeObj.getAsJsonPrimitive("name").getAsString());
            eventStreamAttributeDto.setAttributeType(metaAttributeObj.getAsJsonPrimitive("type").getAsString());
            metaAttributeDtos.add(eventStreamAttributeDto);
        }
        ArrayList<EventStreamAttributeDto> correlationAttributeDtos = new ArrayList<EventStreamAttributeDto>();
        for (JsonElement correlationAttribute : correlationData) {
            JsonObject metaAttributeObj = correlationAttribute.getAsJsonObject();
            EventStreamAttributeDto eventStreamAttributeDto = new EventStreamAttributeDto();
            eventStreamAttributeDto.setAttributeName(metaAttributeObj.getAsJsonPrimitive("name").getAsString());
            eventStreamAttributeDto.setAttributeType(metaAttributeObj.getAsJsonPrimitive("type").getAsString());
            correlationAttributeDtos.add(eventStreamAttributeDto);
        }
        ArrayList<EventStreamAttributeDto> payloadAttributeDtos = new ArrayList<EventStreamAttributeDto>();
        for (JsonElement payloadAttribute : payloadData) {
            JsonObject metaAttributeObj = payloadAttribute.getAsJsonObject();
            EventStreamAttributeDto eventStreamAttributeDto = new EventStreamAttributeDto();
            eventStreamAttributeDto.setAttributeName(metaAttributeObj.getAsJsonPrimitive("name").getAsString());
            eventStreamAttributeDto.setAttributeType(metaAttributeObj.getAsJsonPrimitive("type").getAsString());
            payloadAttributeDtos.add(eventStreamAttributeDto);
        }
        if (metaAttributeDtos.size() > 0) {
            eventStreamInfoDto.setMetaData(metaAttributeDtos.toArray(new EventStreamAttributeDto[metaAttributeDtos.size()]));
        }
        if (correlationAttributeDtos.size() > 0) {
            eventStreamInfoDto.setCorrelationData(correlationAttributeDtos.toArray(new EventStreamAttributeDto[correlationAttributeDtos.size()]));
        }
        if (payloadAttributeDtos.size() > 0) {
            eventStreamInfoDto.setPayloadData(payloadAttributeDtos.toArray(new EventStreamAttributeDto[payloadAttributeDtos.size()]));
        }
        return eventStreamInfoDto;
    }

    public static List<AnalyticsTableRecord> getArbitraryRecordList(String[] properties) {
        ArrayList<AnalyticsTableRecord> analyticsTableColumns = new ArrayList<AnalyticsTableRecord>();
        for (String property : properties) {
            String[] propertyConfiguration = property.split("\\^=");
            AnalyticsTableRecord analyticsTableColumn = new AnalyticsTableRecord();
            analyticsTableColumn.setPersist(true);
            analyticsTableColumn.setColumnName("_" + propertyConfiguration[0]);
            analyticsTableColumn.setColumnType(propertyConfiguration[1]);
            analyticsTableColumn.setPrimaryKey(Boolean.parseBoolean(propertyConfiguration[2]));
            analyticsTableColumn.setIndexed(Boolean.parseBoolean(propertyConfiguration[3]));
            analyticsTableColumn.setScoreParam(Boolean.parseBoolean(propertyConfiguration[4]));
            analyticsTableColumn.setFacet(Boolean.parseBoolean(propertyConfiguration[5]));
            analyticsTableColumns.add(analyticsTableColumn);
        }
        return analyticsTableColumns;
    }

    public static List<AnalyticsTableRecord> getAnalyticsRecordList(String[] properties, String type) {
        ArrayList<AnalyticsTableRecord> analyticsTableColumns = new ArrayList<AnalyticsTableRecord>();
        for (String property : properties) {
            String[] propertyConfiguration = property.split("\\^=");
            AnalyticsTableRecord analyticsTableColumn = new AnalyticsTableRecord();
            analyticsTableColumn.setPersist(Boolean.parseBoolean(propertyConfiguration[0]));
            analyticsTableColumn.setColumnName(type + propertyConfiguration[1]);
            analyticsTableColumn.setColumnType(propertyConfiguration[2]);
            analyticsTableColumn.setPrimaryKey(Boolean.parseBoolean(propertyConfiguration[3]));
            analyticsTableColumn.setIndexed(Boolean.parseBoolean(propertyConfiguration[4]));
            analyticsTableColumn.setScoreParam(Boolean.parseBoolean(propertyConfiguration[5]));
            analyticsTableColumn.setFacet(Boolean.parseBoolean(propertyConfiguration[6]));
            analyticsTableColumns.add(analyticsTableColumn);
        }
        return analyticsTableColumns;
    }
}

