/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitOfWorkTransactionContext {
    private static final Log log = LogFactory.getLog(UnitOfWorkTransactionContext.class);
    private HashMap<DataSource, Connection> activeConnection = new HashMap();
    private int transactionDepth = 0;
    private boolean errorOccurred = false;

    void commitAllConnection() {
        Object commitErrorHandling = null;
        ArrayList<DataSource> listOfCommittedDataSource = null;
        HashMap<DataSource, Connection> rollBackConnections = null;
        for (Map.Entry<DataSource, Connection> entry : this.activeConnection.entrySet()) {
            try {
                Connection connection = entry.getValue();
                if (connection == null) continue;
                connection.commit();
            }
            catch (SQLException e) {
                if (commitErrorHandling.equals(null)) {
                    commitErrorHandling = new StringBuilder();
                }
                if (listOfCommittedDataSource.equals(null)) {
                    listOfCommittedDataSource = new ArrayList<DataSource>();
                }
                if (rollBackConnections.equals(null)) {
                    rollBackConnections = new HashMap<DataSource, Connection>();
                }
                for (Map.Entry<DataSource, Connection> activeEntry : this.activeConnection.entrySet()) {
                    if (entry.getKey().equals(activeEntry.getKey())) break;
                    listOfCommittedDataSource.add(activeEntry.getKey());
                }
                ((StringBuilder)commitErrorHandling).append("Error occurred while committing the connection. Connection: ").append(entry.getValue()).append(". We have committed few transaction before error occurred. Committed dataSource : ").append(((Object)listOfCommittedDataSource).toString()).append(". ");
                for (Map.Entry<DataSource, Connection> activeEntry : this.activeConnection.entrySet()) {
                    if (listOfCommittedDataSource.contains(activeEntry.getKey())) continue;
                    rollBackConnections.put(activeEntry.getKey(), activeEntry.getValue());
                }
                this.internalRollbackConnection(rollBackConnections, (StringBuilder)commitErrorHandling);
                log.error((Object)((StringBuilder)commitErrorHandling).toString(), (Throwable)e);
            }
        }
    }

    private void internalRollbackConnection(HashMap<DataSource, Connection> rollBackConnections, StringBuilder commitErrorHandling) {
        boolean internalRollback = false;
        for (Map.Entry<DataSource, Connection> entry : rollBackConnections.entrySet()) {
            try {
                Connection connection = entry.getValue();
                if (connection == null) continue;
                connection.rollback();
            }
            catch (SQLException e) {
                commitErrorHandling.append("Error occurred while rollback the connection for dataSource: ").append(entry.getKey()).append(", ").append(e).append(". ");
                internalRollback = true;
            }
        }
        if (!internalRollback) {
            commitErrorHandling.append("Successfully rollback the remaining open connection due to this commit error. ");
        }
    }

    void rollbackAllConnection() {
        Object rollbackErrorHandling = null;
        boolean rollbackErrorOccurred = false;
        for (Map.Entry<DataSource, Connection> entry : this.activeConnection.entrySet()) {
            try {
                Connection connection = entry.getValue();
                if (connection == null) continue;
                connection.rollback();
            }
            catch (SQLException e) {
                if (rollbackErrorHandling.equals(null)) {
                    rollbackErrorHandling = new StringBuilder();
                }
                ((StringBuilder)rollbackErrorHandling).append("Error occurred while rollback the connection for dataSource: ").append(entry.getKey()).append(", ").append(e).append(". ");
                rollbackErrorOccurred = true;
            }
        }
        if (rollbackErrorOccurred) {
            log.error(rollbackErrorHandling);
        }
    }

    public Connection getDBConnection(DataSource dataSource) throws SQLException {
        Connection currentConnectionForDataSource = this.activeConnection.get(dataSource);
        if (currentConnectionForDataSource == null) {
            currentConnectionForDataSource = dataSource.getConnection();
            this.activeConnection.put(dataSource, currentConnectionForDataSource);
        }
        return currentConnectionForDataSource;
    }

    int getTransactionDepth() {
        return this.transactionDepth;
    }

    boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    void setErrorOccurred() {
        this.errorOccurred = true;
    }

    void incrementTransactionDepth() {
        ++this.transactionDepth;
    }

    void decrementTransactionDepth() {
        --this.transactionDepth;
    }

    void closeConnection() {
        boolean connectionErrorOccurred = false;
        Object connectionErrorHandling = null;
        for (Map.Entry<DataSource, Connection> entry : this.activeConnection.entrySet()) {
            Connection connection = entry.getValue();
            try {
                connection.close();
            }
            catch (SQLException e) {
                if (connectionErrorHandling.equals(null)) {
                    connectionErrorHandling = new StringBuilder();
                }
                connectionErrorOccurred = true;
                ((StringBuilder)connectionErrorHandling).append("Error occurred while close the connection:  ").append((CharSequence)connectionErrorHandling).append(", Error was : ").append(e).append(". ");
            }
        }
        if (connectionErrorOccurred) {
            log.error(connectionErrorHandling);
        }
    }
}

