/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.util.UnitOfWorkException;
import org.wso2.carbon.user.core.util.UnitOfWorkTransactionContext;

public class UnitOfWork {
    private static final Log log = LogFactory.getLog(UnitOfWork.class);
    private static ThreadLocal<UnitOfWorkTransactionContext> transactionContextThreadLocal = new ThreadLocal();

    public static UnitOfWork beginTransaction() {
        UnitOfWorkTransactionContext UnitOfWorkTransactionContext2 = transactionContextThreadLocal.get();
        if (UnitOfWorkTransactionContext2 == null) {
            UnitOfWorkTransactionContext2 = new UnitOfWorkTransactionContext();
            transactionContextThreadLocal.set(UnitOfWorkTransactionContext2);
        }
        UnitOfWorkTransactionContext2.incrementTransactionDepth();
        return new UnitOfWork();
    }

    @Deprecated
    public Connection getDBConnection(DataSource dataSource) throws SQLException {
        return this.getDBConnection(dataSource, true);
    }

    public Connection getDBConnection(DataSource dataSource, boolean autoCommit) throws SQLException {
        UnitOfWorkTransactionContext unitOfWorkTransactionContext = transactionContextThreadLocal.get();
        if (unitOfWorkTransactionContext == null) {
            throw new UnitOfWorkException("Can not get a connection as Transaction context is not started for dataSource : " + dataSource);
        }
        Connection connection = unitOfWorkTransactionContext.getDBConnection(dataSource);
        if (!autoCommit && connection.getAutoCommit()) {
            connection.setAutoCommit(autoCommit);
        }
        return connection;
    }

    public void commitTransaction() {
        try {
            UnitOfWorkTransactionContext unitOfWorkTransactionContext = transactionContextThreadLocal.get();
            if (unitOfWorkTransactionContext == null) {
                throw new UnitOfWorkException("Can not get a connection as Transaction context is not started");
            }
            unitOfWorkTransactionContext.decrementTransactionDepth();
            if (unitOfWorkTransactionContext.getTransactionDepth() == 0 && !unitOfWorkTransactionContext.isErrorOccurred()) {
                unitOfWorkTransactionContext.commitAllConnection();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error occurred while commit connection", (Throwable)e);
        }
    }

    public void rollbackTransaction() {
        try {
            UnitOfWorkTransactionContext unitOfWorkTransactionContext = transactionContextThreadLocal.get();
            unitOfWorkTransactionContext.setErrorOccurred();
            if (unitOfWorkTransactionContext == null) {
                throw new UnitOfWorkException("Can not get a connection as Transaction context is not started");
            }
            unitOfWorkTransactionContext.decrementTransactionDepth();
            if (unitOfWorkTransactionContext.getTransactionDepth() == 0 && unitOfWorkTransactionContext.isErrorOccurred()) {
                unitOfWorkTransactionContext.rollbackAllConnection();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error occurred while rollback connection", (Throwable)e);
        }
    }

    public void closeTransaction() {
        try {
            UnitOfWorkTransactionContext unitOfWorkTransactionContext = transactionContextThreadLocal.get();
            if (unitOfWorkTransactionContext == null) {
                throw new UnitOfWorkException("Can not get a connection as Transaction context is not started");
            }
            unitOfWorkTransactionContext.closeConnection();
            transactionContextThreadLocal.remove();
        }
        catch (SQLException e) {
            log.error((Object)"Error occurred while close all the transaction and connection", (Throwable)e);
        }
    }
}

