/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.util.Map;

public class JDBCRealmUtil {
    public static Map<String, String> getSQL(Map<String, String> properties) {
        if (!properties.containsKey("SelectUserSQL")) {
            properties.put("SelectUserSQL", "SELECT * FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserIDSQL")) {
            properties.put("SelectUserIDSQL", "SELECT UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserNameSQL")) {
            properties.put("SelectUserNameSQL", "SELECT UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserIDWithIDSQL")) {
            properties.put("SelectUserIDWithIDSQL", "SELECT UM_USER.UM_REQUIRE_CHANGE, UM_USER.UM_CHANGED_TIME FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserWithIDSQL")) {
            properties.put("SelectUserWithIDSQL", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME, UM_USER.UM_USER_PASSWORD, UM_USER.UM_SALT_VALUE, UM_USER.UM_REQUIRE_CHANGE, UM_USER.UM_CHANGED_TIME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE =? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserIDFromUserNameSQL")) {
            properties.put("SelectUserIDFromUserNameSQL", "SELECT UM_USER_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserNameFromUserIDSQL")) {
            properties.put("SelectUserNameFromUserIDSQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetRoleListSQL")) {
            properties.put("GetRoleListSQL", "SELECT UM_ROLE_NAME, UM_TENANT_ID, UM_SHARED_ROLE FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID=? AND UM_SHARED_ROLE ='0' ORDER BY UM_ROLE_NAME");
        }
        if (!properties.containsKey("GetSharedRoleListSQL")) {
            properties.put("GetSharedRoleListSQL", "SELECT UM_ROLE_NAME, UM_TENANT_ID, UM_SHARED_ROLE FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_SHARED_ROLE ='1' ORDER BY UM_ROLE_NAME");
        }
        if (!properties.containsKey("UserRoleSQL")) {
            properties.put("UserRoleSQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserRoleWithIDSQL")) {
            properties.put("UserRoleWithIDSQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_ID=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserRoleExistSQL")) {
            properties.put("UserRoleExistSQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? AND UM_ROLE_NAME LIKE ?");
        }
        if (!properties.containsKey("UserRoleExistWithIDSQL")) {
            properties.put("UserRoleExistWithIDSQL", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_ID=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? AND UM_ROLE_NAME LIKE ?");
        }
        if (!properties.containsKey("UsersRoleSQL")) {
            properties.put("UsersRoleSQL", "SELECT UM_USER_NAME,UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME IN (?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UsersRoleWithIDSQL")) {
            properties.put("UsersRoleWithIDSQL", "SELECT UM_USER.UM_USER_ID,UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_ID IN (?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserSharedRoleSQL")) {
            properties.put("UserSharedRoleSQL", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME = ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ");
        }
        if (!properties.containsKey("UserSharedRoleWithIDSQL")) {
            properties.put("UserSharedRoleWithIDSQL", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_ID = ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ");
        }
        if (!properties.containsKey("UserFilterSQL")) {
            properties.put("UserFilterSQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME");
        }
        if (!properties.containsKey("UserFilterWithIDSQL")) {
            properties.put("UserFilterWithIDSQL", "SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME");
        }
        if (!properties.containsKey("UserFilterSQLWithEscape")) {
            properties.put("UserFilterSQLWithEscape", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? ESCAPE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME");
        }
        if (!properties.containsKey("UserFilterPaginatedSQL")) {
            properties.put("UserFilterPaginatedSQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?");
        }
        if (!properties.containsKey("UserFilterPaginatedWithIDSQL")) {
            properties.put("UserFilterPaginatedWithIDSQL", "SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQL-db2")) {
            properties.put("UserFilterPaginatedSQL-db2", "SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, U.*  FROM UM_USER AS U) WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID = ? AND rn BETWEEN ? AND ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQL-oracle")) {
            properties.put("UserFilterPaginatedSQL-oracle", "SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, UM_TENANT_ID, rownum AS rnum FROM (SELECT UM_USER_NAME, UM_TENANT_ID FROM UM_USER ORDER BY UM_USER_NAME) WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? AND rownum <= ?) WHERE  rnum > ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQL-mssql")) {
            properties.put("UserFilterPaginatedSQL-mssql", "SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME,UM_TENANT_ID, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM UM_USER) AS P WHERE P.UM_USER_NAME LIKE ? AND P.UM_TENANT_ID= ? AND P.RowNum BETWEEN ? AND ?");
        }
        if (!properties.containsKey("UserFilterPaginatedCountSQL")) {
            properties.put("UserFilterPaginatedCountSQL", "SELECT COUNT(UM_USER_NAME) FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserFilterPaginatedCountWithIDSQL")) {
            properties.put("UserFilterPaginatedCountWithIDSQL", "SELECT COUNT(UM_USER_ID) FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsRoleExistingSQL")) {
            properties.put("IsRoleExistingSQL", "SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserListOfRoleSQL")) {
            properties.put("GetUserListOfRoleSQL", "SELECT UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserListOfRoleFilterSQL")) {
            properties.put("GetUserListOfRoleFilterSQL", "SELECT UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserListOfRoleFilterWithIDSQL")) {
            properties.put("GetUserListOfRoleFilterWithIDSQL", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsUserExistingSQL")) {
            properties.put("IsUserExistingSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsUserExistingWithIDSQL")) {
            properties.put("IsUserExistingWithIDSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsUserNameExistingSQL")) {
            properties.put("IsUserNameExistingSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserPropertiesForProfileSQL")) {
            properties.put("GetUserPropertiesForProfileSQL", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserPropertiesForProfileWithIDSQL")) {
            properties.put("GetUserPropertiesForProfileWithIDSQL", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_ID=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUsersPropertiesForProfileSQL")) {
            properties.put("GetUsersPropertiesForProfileSQL", "SELECT UM_USER_NAME,UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME IN (?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUsersPropertiesForProfileWithIDSQL")) {
            properties.put("GetUsersPropertiesForProfileWithIDSQL", "SELECT UM_USER.UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_ID IN (?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserPropertyForProfileSQL")) {
            properties.put("GetUserPropertyForProfileSQL", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME=? AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserPropertyForProfileWithIDSQL")) {
            properties.put("GetUserPropertyForProfileWithIDSQL", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_ID=? AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserLisForPropertySQL")) {
            properties.put("GetUserLisForPropertySQL", "SELECT DISTINCT UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserLisForPropertyWithIDSQL")) {
            properties.put("GetUserLisForPropertyWithIDSQL", "SELECT DISTINCT UM_USER.UM_USER_ID FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetPaginatedUserLisForPropertySQL")) {
            properties.put("GetPaginatedUserLisForPropertySQL", "SELECT UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?");
        }
        if (!properties.containsKey("GetPaginatedUserLisForPropertyWithIDSQL")) {
            properties.put("GetPaginatedUserLisForPropertyWithIDSQL", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?");
        }
        if (!properties.containsKey("GetPaginatedUserLisForPropertySQL-db2")) {
            properties.put("GetPaginatedUserLisForPropertySQL-db2", "SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? ) WHERE rn BETWEEN ? AND ?");
        }
        if (!properties.containsKey("GetPaginatedUserLisForPropertySQL-oracle")) {
            properties.put("GetPaginatedUserLisForPropertySQL-oracle", "SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME, rownum AS rnum FROM (SELECT DISTINCT UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? ORDER BY UM_USER_NAME )WHERE rownum <= ?) WHERE  rnum > ?");
        }
        if (!properties.containsKey("GetPaginatedUserLisForPropertySQL-mssql")) {
            properties.put("GetPaginatedUserLisForPropertySQL-mssql", "SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME,ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM UM_USER,UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME=? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?) AS P WHERE P.RowNum BETWEEN ? AND ?");
        }
        if (!properties.containsKey("GetPaginatedUserCountForPropertySQL")) {
            properties.put("GetPaginatedUserCountForPropertySQL", "SELECT COUNT (UM_USER_NAME) FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetPaginatedUserCountForPropertyWithIDSQL")) {
            properties.put("GetPaginatedUserCountForPropertyWithIDSQL", "SELECT COUNT (UM_USER.UM_USER_ID) FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE LIKE ? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetProfileNamesSQL")) {
            properties.put("GetProfileNamesSQL", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserProfileNamesSQL")) {
            properties.put("GetUserProfileNamesSQL", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserProfileNamesWithIDSQL")) {
            properties.put("GetUserProfileNamesWithIDSQL", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserIDFromUserNameSQL")) {
            properties.put("GetUserIDFromUserNameSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserIDFromUserNameWithIDSQL")) {
            properties.put("GetUserIDFromUserNameWithIDSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetTenantIDFromUserNameSQL")) {
            properties.put("GetTenantIDFromUserNameSQL", "SELECT UM_TENANT_ID FROM UM_USER WHERE UM_USER_NAME=?");
        }
        if (!properties.containsKey("AddUserSQL")) {
            properties.put("AddUserSQL", "INSERT INTO UM_USER (UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME, UM_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)");
        }
        if (!properties.containsKey("AddUserWithIDSQL")) {
            properties.put("AddUserWithIDSQL", "INSERT INTO UM_USER (UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME, UM_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?, ?)");
        }
        if (!properties.containsKey("AddUserToRoleSQL")) {
            properties.put("AddUserToRoleSQL", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)");
        }
        if (!properties.containsKey("AddUserToRoleWithIDSQL")) {
            properties.put("AddUserToRoleWithIDSQL", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)");
        }
        if (!properties.containsKey("AddUserPermissionSQL")) {
            properties.put("AddUserPermissionSQL", "AddUserPermission");
        }
        if (!properties.containsKey("AddRoleSQL")) {
            properties.put("AddRoleSQL", "INSERT INTO UM_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)");
        }
        if (!properties.containsKey("AddSharedRoleSQL")) {
            properties.put("AddSharedRoleSQL", "UPDATE UM_ROLE SET UM_SHARED_ROLE = ? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID = ?");
        }
        if (!properties.containsKey("AddSharedRoleSQL")) {
            properties.put("AddSharedRoleSQL", "UPDATE UM_ROLE SET UM_SHARED_ROLE = ? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID = ?");
        }
        if (!properties.containsKey("AddRoleToUserSQL")) {
            properties.put("AddRoleToUserSQL", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?)");
        }
        if (!properties.containsKey("AddRoleToUserWithIDSQL")) {
            properties.put("AddRoleToUserWithIDSQL", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?), ?)");
        }
        if (!properties.containsKey("AddSharedRoleToUserSQL")) {
            properties.put("AddSharedRoleToUserSQL", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?, ?)");
        }
        if (!properties.containsKey("AddSharedRoleToUserWithIDSQL")) {
            properties.put("AddSharedRoleToUserWithIDSQL", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?), ?, ?)");
        }
        if (!properties.containsKey("AddRolePermissionSQL")) {
            properties.put("AddRolePermissionSQL", "AddRolePermissionSQL");
        }
        if (!properties.containsKey("RemoveUserFromRoleSQL")) {
            properties.put("RemoveUserFromRoleSQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("RemoveUserFromRoleWithIDSQL")) {
            properties.put("RemoveUserFromRoleWithIDSQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("RemoveUserFromSharedRoleSQL")) {
            properties.put("RemoveUserFromSharedRoleSQL", "DELETE FROM UM_SHARED_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_USER_TENANT_ID=? AND UM_ROLE_TENANT_ID = ?");
        }
        if (!properties.containsKey("RemoveUserFromSharedRoleWithIDSQL")) {
            properties.put("RemoveUserFromSharedRoleWithIDSQL", "DELETE FROM UM_SHARED_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_USER_TENANT_ID=? AND UM_ROLE_TENANT_ID = ?");
        }
        if (!properties.containsKey("RemoveRoleFromUserSQL")) {
            properties.put("RemoveRoleFromUserSQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("RemoveRoleFromUserWithIDSQL")) {
            properties.put("RemoveRoleFromUserWithIDSQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("DeleteRoleSQL")) {
            properties.put("DeleteRoleSQL", "DELETE FROM UM_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteRoleRemoveUserRoleMappingSQL")) {
            properties.put("OnDeleteRoleRemoveUserRoleMappingSQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteRoleRemovePermissionsSQL")) {
            properties.put("OnDeleteRoleRemovePermissionsSQL", "OnDeleteRoleRemovePermissionsSQL");
        }
        if (!properties.containsKey("DeleteUserSQL")) {
            properties.put("DeleteUserSQL", "DELETE FROM UM_USER WHERE UM_USER_NAME = ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("DeleteUserWithIDSQL")) {
            properties.put("DeleteUserWithIDSQL", "DELETE FROM UM_USER WHERE UM_USER_ID = ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteUserRemoveUserRoleMappingSQL")) {
            properties.put("OnDeleteUserRemoveUserRoleMappingSQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteUserRemoveUserRoleMappingWithIDSQL")) {
            properties.put("OnDeleteUserRemoveUserRoleMappingWithIDSQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("CountUsersWithClaimSQL")) {
            properties.put("CountUsersWithClaimSQL", "SELECT COUNT(UM_USER_ID) AS RESULT FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME = ? AND UM_TENANT_ID = ? AND UM_ATTR_VALUE LIKE ? AND UM_PROFILE_ID = ?");
        }
        if (!properties.containsKey("CountUsersSQL")) {
            properties.put("CountUsersSQL", "SELECT COUNT(UM_USER_NAME) AS RESULT FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID = ?");
        }
        if (!properties.containsKey("CountInternalRolesSQL")) {
            properties.put("CountInternalRolesSQL", "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME NOT LIKE 'Application%' AND UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?");
        }
        if (!properties.containsKey("CountApplicationRolesSQL")) {
            properties.put("CountApplicationRolesSQL", "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?");
        }
        if (!properties.containsKey("CountRolesSQL")) {
            properties.put("CountRolesSQL", "SELECT COUNT(UM_ROLE_NAME) AS RESULT FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?");
        }
        if (!properties.containsKey("OnDeleteUserRemoveUserAttributeSQL")) {
            properties.put("OnDeleteUserRemoveUserAttributeSQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteUserRemoveUserAttributeWithIDSQL")) {
            properties.put("OnDeleteUserRemoveUserAttributeWithIDSQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteUserRemovePermissionsSQL")) {
            properties.put("OnDeleteUserRemovePermissionsSQL", "OnDeleteUserRemovePermissionsSQL");
        }
        if (!properties.containsKey("UpdateUserPasswordSQL")) {
            properties.put("UpdateUserPasswordSQL", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE UM_USER_NAME= ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UpdateUserPasswordWithIDSQL")) {
            properties.put("UpdateUserPasswordWithIDSQL", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE UM_USER_ID= ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddUserPropertySQL")) {
            properties.put("AddUserPropertySQL", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?, ?, ?, ?)");
        }
        if (!properties.containsKey("AddUserPropertyWithIDSQL")) {
            properties.put("AddUserPropertyWithIDSQL", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?), ?, ?, ?, ?)");
        }
        if (!properties.containsKey("UserNameUniqueAcrossTenantsSQL")) {
            properties.put("UserNameUniqueAcrossTenantsSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=?");
        }
        if (!properties.containsKey("UserIDUniqueAcrossTenantsSQLWithID")) {
            properties.put("UserIDUniqueAcrossTenantsSQLWithID", "SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=?");
        }
        if (!properties.containsKey("UserNameUniqueAcrossTenantsSQLWithID")) {
            properties.put("UserNameUniqueAcrossTenantsSQLWithID", "SELECT UM_ID FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME=? AND UM_ATTR_VALUE=?");
        }
        if (!properties.containsKey("UpdateUserPropertySQL")) {
            properties.put("UpdateUserPropertySQL", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UpdateUserPropertyWithIDSQL")) {
            properties.put("UpdateUserPropertyWithIDSQL", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("DeleteUserPropertySQL")) {
            properties.put("DeleteUserPropertySQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("DeleteUserPropertyWWithIDSQL")) {
            properties.put("DeleteUserPropertyWWithIDSQL", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_ID=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UpdateRoleNameSQL")) {
            properties.put("UpdateRoleNameSQL", "UPDATE UM_ROLE set UM_ROLE_NAME=? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddUserToRoleSQL-mssql")) {
            properties.put("AddUserToRoleSQL-mssql", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(?)");
        }
        if (!properties.containsKey("AddRoleToUserSQL-mssql")) {
            properties.put("AddRoleToUserSQL-mssql", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), (?)");
        }
        if (!properties.containsKey("AddUserPropertySQL-mssql")) {
            properties.put("AddUserPropertySQL-mssql", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), (?), (?), (?), (?)");
        }
        if (!properties.containsKey("GetUserListOfSharedRoleSQL")) {
            properties.put("GetUserListOfSharedRoleSQL", "SELECT UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID");
        }
        if (!properties.containsKey("GetUserListOfSharedRoleFilterSQL")) {
            properties.put("GetUserListOfSharedRoleFilterSQL", "SELECT UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID");
        }
        if (!properties.containsKey("GetUserListOfSharedRoleFilterWithIDSQL")) {
            properties.put("GetUserListOfSharedRoleFilterWithIDSQL", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME LIKE ? AND UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID");
        }
        if (!properties.containsKey("UsersRoleSQL")) {
            properties.put("UsersRoleSQL", "SELECT UM_USER_NAME,UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME IN (?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UsersRoleWithIDSQL")) {
            properties.put("UsersRoleWithIDSQL", "SELECT UM_USER.UM_USER_ID,UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_ID IN (?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUsersPropertiesForProfileSQL")) {
            properties.put("GetUsersPropertiesForProfileSQL", "SELECT UM_USER_NAME,UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME IN (?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUsersPropertiesForProfileWithIDSQL")) {
            properties.put("GetUsersPropertiesForProfileWithIDSQL", "SELECT UM_USER.UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_ID IN (?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUsersPropertiesForProfileSQLCaseInsensitive")) {
            properties.put("GetUsersPropertiesForProfileSQLCaseInsensitive", "SELECT UM_USER_NAME,UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND LOWER(UM_USER.UM_USER_NAME) IN (?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UsersRoleSQLCaseInsensitive")) {
            properties.put("UsersRoleSQLCaseInsensitive", "SELECT UM_USER_NAME,UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE,UM_USER WHERE LOWER(UM_USER.UM_USER_NAME) IN(?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddUserToRoleSQL-openedge")) {
            properties.put("AddUserToRoleSQL-openedge", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT UU.UM_ID, UR.UM_ID, ? FROM UM_USER UU, UM_ROLE UR WHERE UU.UM_USER_NAME=? AND UU.UM_TENANT_ID=? AND UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddRoleToUserSQL-openedge")) {
            properties.put("AddRoleToUserSQL-openedge", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT UR.UM_ID, UU.UM_ID, ? FROM UM_ROLE UR, UM_USER UU WHERE UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=? AND UU.UM_USER_NAME=? AND UU.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddUserPropertySQL-openedge")) {
            properties.put("AddUserPropertySQL-openedge", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT UM_ID, ?, ?, ?, ? FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserSQLCaseInsensitive")) {
            properties.put("SelectUserSQLCaseInsensitive", "SELECT * FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserNameSQLCaseInsensitive")) {
            properties.put("SelectUserNameSQLCaseInsensitive", "SELECT UM_USER_ID, UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserWithIDSQLCaseInsensitive")) {
            properties.put("SelectUserWithIDSQLCaseInsensitive", "SELECT UM_USER.UM_USER_ID, UM_USER.UM_USER_NAME, UM_USER.UM_USER_PASSWORD, UM_USER.UM_SALT_VALUE, UM_USER.UM_REQUIRE_CHANGE, UM_USER.UM_CHANGED_TIME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND LOWER(UM_USER_ATTRIBUTE.UM_ATTR_VALUE) =LOWER(?) AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("SelectUserIDFromUserNameSQLCaseInsensitive")) {
            properties.put("SelectUserIDFromUserNameSQLCaseInsensitive", "SELECT UM_USER_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserRoleSQLCaseInsensitive")) {
            properties.put("UserRoleSQLCaseInsensitive", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsUserRoleExistSQLCaseInsensitive")) {
            properties.put("IsUserRoleExistSQLCaseInsensitive", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=? AND UM_ROLE_NAME LIKE ?");
        }
        if (!properties.containsKey("UsersRoleSQLCaseInsensitive")) {
            properties.put("UsersRoleSQLCaseInsensitive", "SELECT UM_USER_NAME,UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE,UM_USER WHERE LOWER(UM_USER.UM_USER_NAME) IN(?) AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserSharedRoleSQLCaseInsensitive")) {
            properties.put("UserSharedRoleSQLCaseInsensitive", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE LOWER(UM_USER.UM_USER_NAME) = LOWER(?) AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ");
        }
        if (!properties.containsKey("UserFilterSQLCaseInsensitive")) {
            properties.put("UserFilterSQLCaseInsensitive", "SELECT UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=? ORDER BY UM_USER_NAME");
        }
        if (!properties.containsKey("UserFilterWithIDSQLCaseInsensitive")) {
            properties.put("UserFilterWithIDSQLCaseInsensitive", "SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=? ORDER BY UM_USER_NAME");
        }
        if (!properties.containsKey("UserFilterSQLCaseInsensitiveWithEscape")) {
            properties.put("UserFilterSQLCaseInsensitiveWithEscape", "SELECT UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) ESCAPE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME");
        }
        if (!properties.containsKey("UserFilterPaginatedSQLCaseInsensitive")) {
            properties.put("UserFilterPaginatedSQLCaseInsensitive", "SELECT UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=? ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?");
        }
        if (!properties.containsKey("UserFilterPaginatedWithIDSQLCaseInsensitive")) {
            properties.put("UserFilterPaginatedWithIDSQLCaseInsensitive", "SELECT UM_USER_ID, UM_USER_NAME FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=? ORDER BY UM_USER_NAME ASC LIMIT ? OFFSET ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQLCaseInsensitive-db2")) {
            properties.put("UserFilterPaginatedSQLCaseInsensitive-db2", "SELECT UM_USER_NAME FROM (SELECT ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS rn, U.*  FROM UM_USER AS U) WHERE UM_USER_NAME LIKE LOWER(?) AND UM_TENANT_ID = ? AND rn BETWEEN ? AND ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQLCaseInsensitive-mssql")) {
            properties.put("UserFilterPaginatedSQLCaseInsensitive-mssql", "SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME,UM_TENANT_ID, ROW_NUMBER() OVER (ORDER BY UM_USER_NAME) AS RowNum FROM UM_USER) AS P WHERE P.UM_USER_NAME LIKE LOWER(?) AND P.UM_TENANT_ID= ? AND P.RowNum BETWEEN ? AND ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQLCaseInsensitive-oracle")) {
            properties.put("UserFilterPaginatedSQLCaseInsensitive-oracle", "SELECT UM_USER_NAME FROM (SELECT UM_USER_NAME,UM_TENANT_ID, rownum AS rnum FROM (SELECT UM_USER_NAME, UM_TENANT_ID FROM UM_USER ORDER BY  UM_USER_NAME) WHERE UM_USER_NAME LIKE LOWER(?) AND UM_TENANT_ID=? AND rownum <= ?) WHERE  rnum > ?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQLCaseInsensitiveCount")) {
            properties.put("UserFilterPaginatedSQLCaseInsensitiveCount", "SELECT COUNT (UM_USER_NAME) FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserFilterPaginatedSQLCaseInsensitiveCountWithID")) {
            properties.put("UserFilterPaginatedSQLCaseInsensitiveCountWithID", "SELECT COUNT (UM_USER_ID) FROM UM_USER WHERE LOWER(UM_USER_NAME) LIKE LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsUserExistingSQLCaseInsensitive")) {
            properties.put("IsUserExistingSQLCaseInsensitive", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("IsUserNameExistingSQLCaseInsensitive")) {
            properties.put("IsUserNameExistingSQLCaseInsensitive", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserPropertiesForProfileSQLCaseInsensitive")) {
            properties.put("GetUserPropertiesForProfileSQLCaseInsensitive", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUsersPropertiesForProfileSQLCaseInsensitive")) {
            properties.put("GetUsersPropertiesForProfileSQLCaseInsensitive", "SELECT UM_USER_NAME,UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND LOWER(UM_USER.UM_USER_NAME) IN (?) AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserPropertyForProfileSQLCaseInsensitive")) {
            properties.put("GetUserPropertyForProfileSQLCaseInsensitive", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND LOWER(UM_USER.UM_USER_NAME)=LOWER(?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserProfileNamesSQLCaseInsensitive")) {
            properties.put("GetUserProfileNamesSQLCaseInsensitive", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetUserIDFromUserNameSQLCaseInsensitive")) {
            properties.put("GetUserIDFromUserNameSQLCaseInsensitive", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("GetTenantIDFromUserNameSQLCaseInsensitive")) {
            properties.put("GetTenantIDFromUserNameSQLCaseInsensitive", "SELECT UM_TENANT_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?)");
        }
        if (!properties.containsKey("AddUserToRoleSQLCaseInsensitive")) {
            properties.put("AddUserToRoleSQLCaseInsensitive", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)");
        }
        if (!properties.containsKey("AddRoleToUserSQLCaseInsensitive")) {
            properties.put("AddRoleToUserSQLCaseInsensitive", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), ?)");
        }
        if (!properties.containsKey("AddSharedRoleToUserSQLCaseInsensitive")) {
            properties.put("AddSharedRoleToUserSQLCaseInsensitive", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), ?, ?)");
        }
        if (!properties.containsKey("RemoveUserFromRoleSQLCaseInsensitive")) {
            properties.put("RemoveUserFromRoleSQLCaseInsensitive", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("RemoveUserFromSharedRoleSQLCaseInsensitive")) {
            properties.put("RemoveUserFromSharedRoleSQLCaseInsensitive", "DELETE FROM UM_SHARED_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_USER_TENANT_ID=? AND UM_ROLE_TENANT_ID = ?");
        }
        if (!properties.containsKey("RemoveRoleFromUserSQLCaseInsensitive")) {
            properties.put("RemoveRoleFromUserSQLCaseInsensitive", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("DeleteUserSQLCaseInsensitive")) {
            properties.put("DeleteUserSQLCaseInsensitive", "DELETE FROM UM_USER WHERE LOWER(UM_USER_NAME) = LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteUserRemoveUserRoleMappingSQLCaseInsensitive")) {
            properties.put("OnDeleteUserRemoveUserRoleMappingSQLCaseInsensitive", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("OnDeleteUserRemoveUserAttributeSQLCaseInsensitive")) {
            properties.put("OnDeleteUserRemoveUserAttributeSQLCaseInsensitive", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UpdateUserPasswordSQLCaseInsensitive")) {
            properties.put("UpdateUserPasswordSQLCaseInsensitive", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE LOWER(UM_USER_NAME)= LOWER(?) AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("UserNameUniqueAcrossTenantsSQLCaseInsensitive")) {
            properties.put("UserNameUniqueAcrossTenantsSQLCaseInsensitive", "SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?)");
        }
        if (!properties.containsKey("UserNameUniqueAcrossTenantsSQLCaseInsensitiveWithID")) {
            properties.put("UserNameUniqueAcrossTenantsSQLCaseInsensitiveWithID", "SELECT UM_ID FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME=? AND LOWER(UM_ATTR_VALUE)=LOWER(?)");
        }
        if (!properties.containsKey("UpdateUserPropertySQLCaseInsensitive")) {
            properties.put("UpdateUserPropertySQLCaseInsensitive", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("DeleteUserPropertySQLCaseInsensitive")) {
            properties.put("DeleteUserPropertySQLCaseInsensitive", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddUserToRoleSQLCaseInsensitive-mssql")) {
            properties.put("AddUserToRoleSQLCaseInsensitive-mssql", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(?)");
        }
        if (!properties.containsKey("AddRoleToUserSQLCaseInsensitive-mssql")) {
            properties.put("AddRoleToUserSQLCaseInsensitive-mssql", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), (?)");
        }
        if (!properties.containsKey("AddUserPropertySQLCaseInsensitive-mssql")) {
            properties.put("AddUserPropertySQLCaseInsensitive-mssql", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?), (?), (?), (?), (?)");
        }
        if (!properties.containsKey("AddUserToRoleSQLCaseInsensitive-openedge")) {
            properties.put("AddUserToRoleSQLCaseInsensitive-openedge", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT UU.UM_ID, UR.UM_ID, ? FROM UM_USER UU, UM_ROLE UR WHERE LOWER(UU.UM_USER_NAME)=LOWER(?) AND UU.UM_TENANT_ID=? AND UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddRoleToUserSQLCaseInsensitive-openedge")) {
            properties.put("AddRoleToUserSQLCaseInsensitive-openedge", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT UR.UM_ID, UU.UM_ID, ? FROM UM_ROLE UR, UM_USER UU WHERE UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=? AND LOWER(UU.UM_USER_NAME)=LOWER(?) AND UU.UM_TENANT_ID=?");
        }
        if (!properties.containsKey("AddUserPropertySQLCaseInsensitive-openedge")) {
            properties.put("AddUserPropertySQLCaseInsensitive-openedge", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT UM_ID, ?, ?, ?, ? FROM UM_USER WHERE LOWER(UM_USER_NAME)=LOWER(?) AND UM_TENANT_ID=?");
        }
        return properties;
    }
}

