/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.constants.UserCoreErrorConstants;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class DatabaseUtil {
    private static final int DEFAULT_MAX_ACTIVE = 40;
    private static final int DEFAULT_MAX_WAIT = 60000;
    private static final int DEFAULT_MIN_IDLE = 5;
    private static final int DEFAULT_MAX_IDLE = 6;
    private static Log log = LogFactory.getLog(DatabaseUtil.class);
    private static javax.sql.DataSource dataSource = null;
    private static final String VALIDATION_INTERVAL = "validationInterval";
    private static final long DEFAULT_VALIDATION_INTERVAL = 30000L;
    private static final String SQL_STATEMENT_PARAMETER_PLACEHOLDER = "?";
    private static final String DISABLED = "Disabled";

    public static synchronized javax.sql.DataSource getRealmDataSource(RealmConfiguration realmConfig) {
        if (dataSource == null) {
            return DatabaseUtil.createRealmDataSource(realmConfig);
        }
        return dataSource;
    }

    public static synchronized void closeDatabasePoolConnection() {
        if (dataSource != null && dataSource instanceof DataSource) {
            ((DataSource)dataSource).close();
            dataSource = null;
        }
    }

    private static javax.sql.DataSource lookupDataSource(String dataSourceName) {
        try {
            return (javax.sql.DataSource)InitialContext.doLookup(dataSourceName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in looking up data source: " + e.getMessage(), e);
        }
    }

    public static javax.sql.DataSource createUserStoreDataSource(RealmConfiguration realmConfig) {
        String dataSourceName = realmConfig.getUserStoreProperty("dataSource");
        if (dataSourceName != null) {
            return DatabaseUtil.lookupDataSource(dataSourceName);
        }
        PoolProperties poolProperties = new PoolProperties();
        if (realmConfig.getUserStoreProperty("driverName") == null) {
            return null;
        }
        poolProperties.setDriverClassName(realmConfig.getUserStoreProperty("driverName"));
        poolProperties.setUrl(realmConfig.getUserStoreProperty("url"));
        poolProperties.setUsername(realmConfig.getUserStoreProperty("userName"));
        poolProperties.setPassword(realmConfig.getUserStoreProperty("password"));
        if (realmConfig.getUserStoreProperty("maxActive") != null && !realmConfig.getUserStoreProperty("maxActive").trim().equals("")) {
            poolProperties.setMaxActive(Integer.parseInt(realmConfig.getUserStoreProperty("maxActive")));
        } else {
            poolProperties.setMaxActive(40);
        }
        if (realmConfig.getUserStoreProperty("minIdle") != null && !realmConfig.getUserStoreProperty("minIdle").trim().equals("")) {
            poolProperties.setMinIdle(Integer.parseInt(realmConfig.getUserStoreProperty("minIdle")));
        } else {
            poolProperties.setMinIdle(5);
        }
        if (realmConfig.getUserStoreProperty("maxIdle") != null && !realmConfig.getUserStoreProperty("maxIdle").trim().equals("")) {
            poolProperties.setMaxIdle(Integer.parseInt(realmConfig.getUserStoreProperty("maxIdle")));
        } else {
            poolProperties.setMaxIdle(6);
        }
        if (realmConfig.getUserStoreProperty("maxWait") != null && !realmConfig.getUserStoreProperty("maxWait").trim().equals("")) {
            poolProperties.setMaxWait(Integer.parseInt(realmConfig.getUserStoreProperty("maxWait")));
        } else {
            poolProperties.setMaxWait(60000);
        }
        if (realmConfig.getUserStoreProperty("testWhileIdle") != null && !realmConfig.getUserStoreProperty("testWhileIdle").trim().equals("")) {
            poolProperties.setTestWhileIdle(Boolean.parseBoolean(realmConfig.getUserStoreProperty("testWhileIdle")));
        }
        if (realmConfig.getUserStoreProperty("timeBetweenEvictionRunsMillis") != null && !realmConfig.getUserStoreProperty("timeBetweenEvictionRunsMillis").trim().equals("")) {
            poolProperties.setTimeBetweenEvictionRunsMillis(Integer.parseInt(realmConfig.getUserStoreProperty("timeBetweenEvictionRunsMillis")));
        }
        if (realmConfig.getUserStoreProperty("minEvictableIdleTimeMillis") != null && !realmConfig.getUserStoreProperty("minEvictableIdleTimeMillis").trim().equals("")) {
            poolProperties.setMinEvictableIdleTimeMillis(Integer.parseInt(realmConfig.getUserStoreProperty("minEvictableIdleTimeMillis")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("validationQuery")) && !realmConfig.getUserStoreProperty("validationQuery").trim().isEmpty()) {
            poolProperties.setValidationQuery(realmConfig.getUserStoreProperty("validationQuery"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty(VALIDATION_INTERVAL)) && StringUtils.isNumeric((String)realmConfig.getUserStoreProperty(VALIDATION_INTERVAL))) {
            poolProperties.setValidationInterval(Long.parseLong(realmConfig.getUserStoreProperty(VALIDATION_INTERVAL)));
        } else {
            poolProperties.setValidationInterval(30000L);
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("defaultAutoCommit")) && !realmConfig.getUserStoreProperty("defaultAutoCommit").trim().isEmpty()) {
            poolProperties.setDefaultAutoCommit(Boolean.valueOf(Boolean.parseBoolean(realmConfig.getUserStoreProperty("defaultAutoCommit"))));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("defaultReadOnly")) && !realmConfig.getUserStoreProperty("defaultReadOnly").trim().isEmpty()) {
            poolProperties.setDefaultReadOnly(Boolean.valueOf(Boolean.parseBoolean(realmConfig.getUserStoreProperty("defaultReadOnly"))));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("defaultCatalog")) && !realmConfig.getUserStoreProperty("defaultCatalog").trim().isEmpty()) {
            poolProperties.setDefaultCatalog(realmConfig.getUserStoreProperty("defaultCatalog"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("initialSize")) && StringUtils.isNumeric((String)"initialSize")) {
            poolProperties.setInitialSize(Integer.parseInt(realmConfig.getUserStoreProperty("initialSize")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("testOnReturn")) && !realmConfig.getUserStoreProperty("testOnReturn").trim().isEmpty()) {
            poolProperties.setTestOnReturn(Boolean.parseBoolean(realmConfig.getUserStoreProperty("testOnReturn")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("testOnBorrow")) && !realmConfig.getUserStoreProperty("testOnBorrow").trim().isEmpty()) {
            poolProperties.setTestOnBorrow(Boolean.parseBoolean(realmConfig.getUserStoreProperty("testOnBorrow")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("validatorClassName")) && !realmConfig.getUserStoreProperty("validatorClassName").trim().isEmpty()) {
            poolProperties.setValidatorClassName(realmConfig.getUserStoreProperty("validatorClassName"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("numTestsPerEvictionRun")) && StringUtils.isNumeric((String)"numTestsPerEvictionRun")) {
            poolProperties.setNumTestsPerEvictionRun(Integer.parseInt(realmConfig.getUserStoreProperty("numTestsPerEvictionRun")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("accessToUnderlyingConnectionAllowed")) && !realmConfig.getUserStoreProperty("accessToUnderlyingConnectionAllowed").trim().isEmpty()) {
            poolProperties.setAccessToUnderlyingConnectionAllowed(Boolean.parseBoolean(realmConfig.getUserStoreProperty("accessToUnderlyingConnectionAllowed")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("removeAbandoned")) && !realmConfig.getUserStoreProperty("removeAbandoned").trim().isEmpty()) {
            poolProperties.setRemoveAbandoned(Boolean.parseBoolean(realmConfig.getUserStoreProperty("removeAbandoned")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("removeAbandonedTimeout")) && StringUtils.isNumeric((String)"removeAbandonedTimeout")) {
            poolProperties.setRemoveAbandonedTimeout(Integer.parseInt(realmConfig.getUserStoreProperty("removeAbandonedTimeout")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("logAbandoned")) && !realmConfig.getUserStoreProperty("logAbandoned").trim().isEmpty()) {
            poolProperties.setLogAbandoned(Boolean.parseBoolean(realmConfig.getUserStoreProperty("logAbandoned")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("connectionProperties")) && !realmConfig.getUserStoreProperty("connectionProperties").trim().isEmpty()) {
            poolProperties.setConnectionProperties(realmConfig.getUserStoreProperty("connectionProperties"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("initSQL")) && !realmConfig.getUserStoreProperty("initSQL").trim().isEmpty()) {
            poolProperties.setInitSQL(realmConfig.getUserStoreProperty("initSQL"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("jdbcInterceptors")) && !realmConfig.getUserStoreProperty("jdbcInterceptors").trim().isEmpty()) {
            poolProperties.setJdbcInterceptors(realmConfig.getUserStoreProperty("jdbcInterceptors"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("jmxEnabled")) && !realmConfig.getUserStoreProperty("jmxEnabled").trim().isEmpty()) {
            poolProperties.setJmxEnabled(Boolean.parseBoolean(realmConfig.getUserStoreProperty("jmxEnabled")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("fairQueue")) && !realmConfig.getUserStoreProperty("fairQueue").trim().isEmpty()) {
            poolProperties.setFairQueue(Boolean.parseBoolean(realmConfig.getUserStoreProperty("fairQueue")));
        }
        if (StringUtils.isNumeric((String)"abandonWhenPercentageFull")) {
            poolProperties.setAbandonWhenPercentageFull(Integer.parseInt(realmConfig.getUserStoreProperty("abandonWhenPercentageFull")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("maxAge")) && StringUtils.isNumeric((String)"maxAge")) {
            poolProperties.setMaxAge((long)Integer.parseInt(realmConfig.getUserStoreProperty("maxAge")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("useEquals")) && !realmConfig.getUserStoreProperty("useEquals").trim().isEmpty()) {
            poolProperties.setUseEquals(Boolean.parseBoolean(realmConfig.getUserStoreProperty("useEquals")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("suspectTimeout")) && StringUtils.isNumeric((String)"suspectTimeout")) {
            poolProperties.setSuspectTimeout(Integer.parseInt(realmConfig.getUserStoreProperty("suspectTimeout")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("validationQueryTimeout")) && StringUtils.isNumeric((String)"validationQueryTimeout")) {
            poolProperties.setValidationQueryTimeout(Integer.parseInt(realmConfig.getUserStoreProperty("validationQueryTimeout")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("alternateUsernameAllowed")) && !realmConfig.getUserStoreProperty("alternateUsernameAllowed").trim().isEmpty()) {
            poolProperties.setAlternateUsernameAllowed(Boolean.parseBoolean(realmConfig.getUserStoreProperty("alternateUsernameAllowed")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("commitOnReturn")) && !realmConfig.getUserStoreProperty("commitOnReturn").trim().isEmpty()) {
            poolProperties.setCommitOnReturn(Boolean.parseBoolean(realmConfig.getUserStoreProperty("commitOnReturn")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("rollbackOnReturn")) && !realmConfig.getUserStoreProperty("rollbackOnReturn").trim().isEmpty()) {
            poolProperties.setRollbackOnReturn(Boolean.parseBoolean(realmConfig.getUserStoreProperty("rollbackOnReturn")));
        }
        DatabaseUtil.setIsolationLevel(poolProperties, realmConfig.getUserStoreProperty("defaultTransactionIsolation"));
        return new DataSource((PoolConfiguration)poolProperties);
    }

    private static javax.sql.DataSource createRealmDataSource(RealmConfiguration realmConfig) {
        String dataSourceName = realmConfig.getRealmProperty("dataSource");
        if (dataSourceName != null) {
            return DatabaseUtil.lookupDataSource(dataSourceName);
        }
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setDriverClassName(realmConfig.getRealmProperty("driverName"));
        poolProperties.setUrl(realmConfig.getRealmProperty("url"));
        poolProperties.setUsername(realmConfig.getRealmProperty("userName"));
        poolProperties.setPassword(realmConfig.getRealmProperty("password"));
        if (realmConfig.getRealmProperty("maxActive") != null && !realmConfig.getRealmProperty("maxActive").trim().equals("")) {
            poolProperties.setMaxActive(Integer.parseInt(realmConfig.getRealmProperty("maxActive")));
        } else {
            poolProperties.setMaxActive(40);
        }
        if (realmConfig.getRealmProperty("minIdle") != null && !realmConfig.getRealmProperty("minIdle").trim().equals("")) {
            poolProperties.setMinIdle(Integer.parseInt(realmConfig.getRealmProperty("minIdle")));
        } else {
            poolProperties.setMinIdle(5);
        }
        if (realmConfig.getRealmProperty("maxIdle") != null && !realmConfig.getRealmProperty("maxIdle").trim().equals("")) {
            poolProperties.setMaxIdle(Integer.parseInt(realmConfig.getRealmProperty("maxIdle")));
        } else {
            poolProperties.setMaxIdle(6);
        }
        if (realmConfig.getRealmProperty("maxWait") != null && !realmConfig.getRealmProperty("maxWait").trim().equals("")) {
            poolProperties.setMaxWait(Integer.parseInt(realmConfig.getRealmProperty("maxWait")));
        } else {
            poolProperties.setMaxWait(60000);
        }
        if (realmConfig.getRealmProperty("testWhileIdle") != null && !realmConfig.getRealmProperty("testWhileIdle").trim().equals("")) {
            poolProperties.setTestWhileIdle(Boolean.parseBoolean(realmConfig.getRealmProperty("testWhileIdle")));
        }
        if (realmConfig.getRealmProperty("timeBetweenEvictionRunsMillis") != null && !realmConfig.getRealmProperty("timeBetweenEvictionRunsMillis").trim().equals("")) {
            poolProperties.setTimeBetweenEvictionRunsMillis(Integer.parseInt(realmConfig.getRealmProperty("timeBetweenEvictionRunsMillis")));
        }
        if (realmConfig.getRealmProperty("minEvictableIdleTimeMillis") != null && !realmConfig.getRealmProperty("minEvictableIdleTimeMillis").trim().equals("")) {
            poolProperties.setMinEvictableIdleTimeMillis(Integer.parseInt(realmConfig.getRealmProperty("minEvictableIdleTimeMillis")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("validationQuery")) && !realmConfig.getRealmProperty("validationQuery").trim().isEmpty()) {
            poolProperties.setValidationQuery(realmConfig.getRealmProperty("validationQuery"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty(VALIDATION_INTERVAL)) && StringUtils.isNumeric((String)realmConfig.getRealmProperty(VALIDATION_INTERVAL))) {
            poolProperties.setValidationInterval(Long.parseLong(realmConfig.getRealmProperty(VALIDATION_INTERVAL)));
        } else {
            poolProperties.setValidationInterval(30000L);
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("defaultAutoCommit")) && !realmConfig.getRealmProperty("defaultAutoCommit").trim().isEmpty()) {
            poolProperties.setDefaultAutoCommit(Boolean.valueOf(Boolean.parseBoolean(realmConfig.getRealmProperty("defaultAutoCommit"))));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("defaultReadOnly")) && !realmConfig.getRealmProperty("defaultReadOnly").trim().isEmpty()) {
            poolProperties.setDefaultReadOnly(Boolean.valueOf(Boolean.parseBoolean(realmConfig.getRealmProperty("defaultReadOnly"))));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("defaultCatalog")) && !realmConfig.getRealmProperty("defaultCatalog").trim().isEmpty()) {
            poolProperties.setDefaultCatalog(realmConfig.getRealmProperty("defaultCatalog"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("initialSize")) && StringUtils.isNumeric((String)"initialSize")) {
            poolProperties.setInitialSize(Integer.parseInt(realmConfig.getRealmProperty("initialSize")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("testOnReturn")) && !realmConfig.getRealmProperty("testOnReturn").trim().isEmpty()) {
            poolProperties.setTestOnReturn(Boolean.parseBoolean(realmConfig.getRealmProperty("testOnReturn")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("testOnBorrow")) && !realmConfig.getRealmProperty("testOnBorrow").trim().isEmpty()) {
            poolProperties.setTestOnBorrow(Boolean.parseBoolean(realmConfig.getRealmProperty("testOnBorrow")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("validatorClassName")) && !realmConfig.getRealmProperty("validatorClassName").trim().isEmpty()) {
            poolProperties.setValidatorClassName(realmConfig.getRealmProperty("validatorClassName"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("numTestsPerEvictionRun")) && StringUtils.isNumeric((String)"numTestsPerEvictionRun")) {
            poolProperties.setNumTestsPerEvictionRun(Integer.parseInt(realmConfig.getRealmProperty("numTestsPerEvictionRun")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("accessToUnderlyingConnectionAllowed")) && !realmConfig.getRealmProperty("accessToUnderlyingConnectionAllowed").trim().isEmpty()) {
            poolProperties.setAccessToUnderlyingConnectionAllowed(Boolean.parseBoolean(realmConfig.getRealmProperty("accessToUnderlyingConnectionAllowed")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("removeAbandoned")) && !realmConfig.getRealmProperty("removeAbandoned").trim().isEmpty()) {
            poolProperties.setRemoveAbandoned(Boolean.parseBoolean(realmConfig.getRealmProperty("removeAbandoned")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("removeAbandonedTimeout")) && StringUtils.isNumeric((String)"removeAbandonedTimeout")) {
            poolProperties.setRemoveAbandonedTimeout(Integer.parseInt(realmConfig.getRealmProperty("removeAbandonedTimeout")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("logAbandoned")) && !realmConfig.getRealmProperty("logAbandoned").trim().isEmpty()) {
            poolProperties.setLogAbandoned(Boolean.parseBoolean(realmConfig.getRealmProperty("logAbandoned")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("connectionProperties")) && !realmConfig.getRealmProperty("connectionProperties").trim().isEmpty()) {
            poolProperties.setConnectionProperties(realmConfig.getRealmProperty("connectionProperties"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("initSQL")) && !realmConfig.getRealmProperty("initSQL").trim().isEmpty()) {
            poolProperties.setInitSQL(realmConfig.getRealmProperty("initSQL"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("jdbcInterceptors")) && !realmConfig.getRealmProperty("jdbcInterceptors").trim().isEmpty()) {
            poolProperties.setJdbcInterceptors(realmConfig.getRealmProperty("jdbcInterceptors"));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("jmxEnabled")) && !realmConfig.getRealmProperty("jmxEnabled").trim().isEmpty()) {
            poolProperties.setJmxEnabled(Boolean.parseBoolean(realmConfig.getRealmProperty("jmxEnabled")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("fairQueue")) && !realmConfig.getRealmProperty("fairQueue").trim().isEmpty()) {
            poolProperties.setFairQueue(Boolean.parseBoolean(realmConfig.getRealmProperty("fairQueue")));
        }
        if (StringUtils.isNumeric((String)"abandonWhenPercentageFull")) {
            poolProperties.setAbandonWhenPercentageFull(Integer.parseInt(realmConfig.getRealmProperty("abandonWhenPercentageFull")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("maxAge")) && StringUtils.isNumeric((String)"maxAge")) {
            poolProperties.setMaxAge((long)Integer.parseInt(realmConfig.getRealmProperty("maxAge")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("useEquals")) && !realmConfig.getRealmProperty("useEquals").trim().isEmpty()) {
            poolProperties.setUseEquals(Boolean.parseBoolean(realmConfig.getRealmProperty("useEquals")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("suspectTimeout")) && StringUtils.isNumeric((String)"suspectTimeout")) {
            poolProperties.setSuspectTimeout(Integer.parseInt(realmConfig.getRealmProperty("suspectTimeout")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("validationQueryTimeout")) && StringUtils.isNumeric((String)"validationQueryTimeout")) {
            poolProperties.setValidationQueryTimeout(Integer.parseInt(realmConfig.getRealmProperty("validationQueryTimeout")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getRealmProperty("alternateUsernameAllowed")) && !realmConfig.getRealmProperty("alternateUsernameAllowed").trim().isEmpty()) {
            poolProperties.setAlternateUsernameAllowed(Boolean.parseBoolean(realmConfig.getRealmProperty("alternateUsernameAllowed")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("commitOnReturn")) && !realmConfig.getUserStoreProperty("commitOnReturn").trim().isEmpty()) {
            poolProperties.setCommitOnReturn(Boolean.parseBoolean(realmConfig.getUserStoreProperty("commitOnReturn")));
        }
        if (StringUtils.isNotEmpty((String)realmConfig.getUserStoreProperty("rollbackOnReturn")) && !realmConfig.getUserStoreProperty("rollbackOnReturn").trim().isEmpty()) {
            poolProperties.setRollbackOnReturn(Boolean.parseBoolean(realmConfig.getUserStoreProperty("rollbackOnReturn")));
        }
        DatabaseUtil.setIsolationLevel(poolProperties, realmConfig.getRealmProperty("defaultTransactionIsolation"));
        dataSource = new DataSource((PoolConfiguration)poolProperties);
        return dataSource;
    }

    private static void setIsolationLevel(PoolProperties poolProperties, String isolationLevelString) {
        if (StringUtils.isNotEmpty((String)isolationLevelString)) {
            if ("NONE".equals(isolationLevelString)) {
                poolProperties.setDefaultTransactionIsolation(0);
            } else if ("READ_UNCOMMITTED".equals(isolationLevelString)) {
                poolProperties.setDefaultTransactionIsolation(1);
            } else if ("READ_COMMITTED".equals(isolationLevelString)) {
                poolProperties.setDefaultTransactionIsolation(2);
            } else if ("REPEATABLE_READ".equals(isolationLevelString)) {
                poolProperties.setDefaultTransactionIsolation(4);
            } else if ("SERIALIZABLE".equals(isolationLevelString)) {
                poolProperties.setDefaultTransactionIsolation(8);
            }
        }
    }

    public static String[] getStringValuesFromDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        String[] name;
        String[] values = new String[]{};
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        prepStmt.setString(i + 1, null);
                        continue;
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (!(param instanceof Integer)) continue;
                    prepStmt.setInt(i + 1, (Integer)param);
                }
            }
            rs = prepStmt.executeQuery();
            ArrayList<String[]> lst = new ArrayList<String[]>();
            while (rs.next()) {
                name = rs.getString(1);
                lst.add(name);
            }
            if (lst.size() > 0) {
                values = lst.toArray(new String[lst.size()]);
            }
            name = values;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return name;
    }

    public static String[] getStringValuesFromDatabaseWithConstraints(Connection dbConnection, String sqlStmt, int maxRows, int queryTimeout, Object ... params) throws UserStoreException {
        String[] stringArray;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            String[] values = null;
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                DatabaseUtil.validateParameterCount(sqlStmt, params);
                DatabaseUtil.populatePreparedStatementParameters(prepStmt, params);
            }
            if (maxRows >= 0) {
                prepStmt.setMaxRows(maxRows);
            }
            if (queryTimeout >= 0) {
                prepStmt.setQueryTimeout(queryTimeout);
            }
            rs = prepStmt.executeQuery();
            ArrayList<String> lst = new ArrayList<String>();
            while (rs.next()) {
                String name = rs.getString(1);
                lst.add(name);
            }
            if (lst.size() > 0) {
                values = lst.toArray(new String[lst.size()]);
            }
            stringArray = values == null ? ArrayUtils.EMPTY_STRING_ARRAY : values;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error while getting values from the database using " + DatabaseUtil.getLoggableSqlString(sqlStmt, params) + " and maxRows: " + maxRows + " and queryTimeout: " + queryTimeout;
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return stringArray;
    }

    public static List<User> getUsersFromDatabaseWithConstraints(UserStoreManager userStoreManager, Connection dbConnection, String sqlStmt, int maxRows, int queryTimeout, Object ... params) throws UserStoreException {
        List<User> list;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            ArrayList values = null;
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                DatabaseUtil.validateParameterCount(sqlStmt, params);
                DatabaseUtil.populatePreparedStatementParameters(prepStmt, params);
            }
            if (maxRows >= 0) {
                prepStmt.setMaxRows(maxRows);
            }
            if (queryTimeout >= 0) {
                prepStmt.setQueryTimeout(queryTimeout);
            }
            rs = prepStmt.executeQuery();
            ArrayList users = new ArrayList();
            while (rs.next()) {
                String userID = rs.getString(1);
                String userName = rs.getString(2);
                User user = DatabaseUtil.getUser(userStoreManager, userID, userName);
                users.add(user);
            }
            if (users.size() > 0) {
                values = users;
            }
            list = values == null ? Collections.emptyList() : values;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Error while getting values from the database using " + DatabaseUtil.getLoggableSqlString(sqlStmt, params) + " and maxRows: " + maxRows + " and queryTimeout: " + queryTimeout;
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return list;
    }

    public static String[] getStringValuesFromDatabaseForInternalRoles(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        Object name;
        String[] values = new String[]{};
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        List<String> disabledDomainName = DatabaseUtil.getDisabledDomainNames();
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Null data provided.");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (!(param instanceof Integer)) continue;
                    prepStmt.setInt(i + 1, (Integer)param);
                }
            }
            rs = prepStmt.executeQuery();
            ArrayList<String[]> lst = new ArrayList<String[]>();
            while (rs.next()) {
                name = rs.getString(1);
                String domain = rs.getString(2);
                if (disabledDomainName.contains(domain)) continue;
                if (StringUtils.isNotEmpty((String)domain)) {
                    name = UserCoreUtil.addDomainToName((String)name, domain);
                }
                lst.add((String[])name);
            }
            if (lst.size() > 0) {
                values = lst.toArray(new String[lst.size()]);
            }
            name = values;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return name;
    }

    private static List<String> getDisabledDomainNames() throws UserStoreException {
        RealmConfiguration secondaryRealmConfiguration = null;
        try {
            if (CarbonContext.getThreadLocalCarbonContext().getUserRealm() == null || CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration() == null) {
                return new ArrayList<String>();
            }
            secondaryRealmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getSecondaryRealmConfig();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error while retrieving user store configurations", e);
        }
        ArrayList<String> disableDomainName = new ArrayList<String>();
        if (secondaryRealmConfiguration != null) {
            do {
                if (!Boolean.parseBoolean(secondaryRealmConfiguration.getUserStoreProperty(DISABLED))) continue;
                String domainName = secondaryRealmConfiguration.getUserStoreProperty("DomainName");
                disableDomainName.add(domainName.toUpperCase());
            } while ((secondaryRealmConfiguration = secondaryRealmConfiguration.getSecondaryRealmConfig()) != null);
        }
        return disableDomainName;
    }

    public static int getIntegerValueFromDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        int i;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int value = -1;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        throw new UserStoreException("Null data provided.");
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (!(param instanceof Integer)) continue;
                    prepStmt.setInt(i + 1, (Integer)param);
                }
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                value = rs.getInt(1);
            }
            i = value;
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, rs, prepStmt);
        return i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void udpateUserRoleMappingInBatchModeForInternalRoles(Connection dbConnection, String sqlStmt, String primaryDomain, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block15: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                int batchParamIndex = -1;
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Null data provided.");
                        }
                        if (param instanceof String[]) {
                            batchParamIndex = i;
                            continue;
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (!(param instanceof Integer)) continue;
                        prepStmt.setInt(i + 1, (Integer)param);
                    }
                }
                if (batchParamIndex != -1) {
                    String[] values;
                    String[] stringArray = values = (String[])params[batchParamIndex];
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String value;
                        String strParam = value = stringArray[i];
                        String domainParam = UserCoreUtil.extractDomainFromName(strParam = UserCoreUtil.addDomainToName(strParam, primaryDomain));
                        if (domainParam != null) {
                            domainParam = domainParam.toUpperCase();
                        }
                        prepStmt.setString(params.length + 1, domainParam);
                        String nameWithoutDomain = UserCoreUtil.removeDomainFromName(strParam);
                        prepStmt.setString(batchParamIndex + 1, nameWithoutDomain);
                        prepStmt.addBatch();
                    }
                }
                int[] count = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed a batch update. Query is : " + sqlStmt + ": and result is" + Arrays.toString(count)));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block15;
            }
            catch (SQLException e) {
                try {
                    String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e);
                    log.debug((Object)errorMessage, (Throwable)e);
                    throw new UserStoreException(errorMessage, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void udpateUserRoleMappingWithExactParams(Connection dbConnection, String sqlStmt, String[] roles, String userName, Integer[] tenantIds, int currentTenantId) throws UserStoreException {
        PreparedStatement ps;
        block8: {
            ps = null;
            boolean localConnection = false;
            try {
                ps = dbConnection.prepareStatement(sqlStmt);
                int count = 0;
                int index = 0;
                String[] stringArray = roles;
                int n = stringArray.length;
                for (int n2 = 0; n2 < n; count = (int)((byte)(count + 1)), index = (int)((byte)(index + 1)), ++n2) {
                    String role = stringArray[n2];
                    count = 0;
                    count = (byte)(count + 1);
                    ps.setString(count, role);
                    count = (byte)(count + 1);
                    ps.setInt(count, tenantIds[index]);
                    count = (byte)(count + 1);
                    ps.setString(count, userName);
                    count = (byte)(count + 1);
                    ps.setInt(count, currentTenantId);
                    count = (byte)(count + 1);
                    ps.setInt(count, currentTenantId);
                    ps.setInt(count, tenantIds[index]);
                    ps.addBatch();
                }
                int[] cnt = ps.executeBatch();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed a batch update. Query is : " + sqlStmt + ": and result is" + Arrays.toString(cnt)));
                }
                if (localConnection) {
                    dbConnection.commit();
                }
                if (!localConnection) break block8;
            }
            catch (SQLException e) {
                try {
                    String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e);
                    log.debug((Object)errorMessage, (Throwable)e);
                    throw new UserStoreException(errorMessage, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, ps);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, ps);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void udpateUserRoleMappingInBatchMode(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt;
        block13: {
            prepStmt = null;
            boolean localConnection = false;
            try {
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                int batchParamIndex = -1;
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        Object param = params[i];
                        if (param == null) {
                            throw new UserStoreException("Null data provided.");
                        }
                        if (param instanceof String[]) {
                            batchParamIndex = i;
                            continue;
                        }
                        if (param instanceof String) {
                            prepStmt.setString(i + 1, (String)param);
                            continue;
                        }
                        if (!(param instanceof Integer)) continue;
                        prepStmt.setInt(i + 1, (Integer)param);
                    }
                }
                if (batchParamIndex != -1) {
                    String[] values;
                    for (String value : values = (String[])params[batchParamIndex]) {
                        prepStmt.setString(batchParamIndex + 1, value);
                        prepStmt.addBatch();
                    }
                }
                int[] count = prepStmt.executeBatch();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed a batch update. Query is : " + sqlStmt + ": and result is" + Arrays.toString(count)));
                }
                dbConnection.commit();
                if (!localConnection) break block13;
            }
            catch (SQLException e) {
                try {
                    String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMessage, e);
                    log.debug((Object)errorMessage, (Throwable)e);
                    throw new UserStoreException(errorMessage, e);
                }
                catch (Throwable throwable) {
                    if (localConnection) {
                        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                    }
                    DatabaseUtil.closeAllConnections(null, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public static void updateDatabase(Connection dbConnection, String sqlStmt, Object ... params) throws UserStoreException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    Object param = params[i];
                    if (param == null) {
                        prepStmt.setString(i + 1, null);
                        continue;
                    }
                    if (param instanceof String) {
                        prepStmt.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        prepStmt.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Short) {
                        prepStmt.setShort(i + 1, (Short)param);
                        continue;
                    }
                    if (!(param instanceof Date)) continue;
                    Date date = (Date)param;
                    Timestamp time = new Timestamp(date.getTime());
                    prepStmt.setTimestamp(i + 1, time);
                }
            }
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Using sql : " + sqlStmt + " " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                if (e instanceof SQLIntegrityConstraintViolationException) {
                    throw new UserStoreException(e.getMessage(), UserCoreErrorConstants.ErrorMessages.ERROR_CODE_DUPLICATE_WHILE_WRITING_TO_DATABASE.getCode(), e);
                }
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public static Connection getDBConnection(javax.sql.DataSource dataSource) throws SQLException {
        Connection dbConnection = dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        if (dbConnection.getTransactionIsolation() != 2) {
            dbConnection.setTransactionIsolation(2);
        }
        return dbConnection;
    }

    public static void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close result set  - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)("Database error. Could not close statement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeStatements(PreparedStatement ... prepStmts) {
        if (prepStmts != null && prepStmts.length > 0) {
            for (PreparedStatement stmt : prepStmts) {
                DatabaseUtil.closeStatement(stmt);
            }
        }
    }

    public static void closeAllConnections(Connection dbConnection, PreparedStatement ... prepStmts) {
        DatabaseUtil.closeStatements(prepStmts);
        DatabaseUtil.closeConnection(dbConnection);
    }

    public static void closeAllConnections(Connection dbConnection, ResultSet rs, PreparedStatement ... prepStmts) {
        DatabaseUtil.closeResultSet(rs);
        DatabaseUtil.closeStatements(prepStmts);
        DatabaseUtil.closeConnection(dbConnection);
    }

    public static void closeAllConnections(Connection dbConnection, ResultSet rs1, ResultSet rs2, PreparedStatement ... prepStmts) {
        DatabaseUtil.closeResultSet(rs1);
        DatabaseUtil.closeResultSet(rs2);
        DatabaseUtil.closeStatements(prepStmts);
        DatabaseUtil.closeConnection(dbConnection);
    }

    public static void rollBack(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }

    public static String getLoggableSqlString(String sqlStmt, Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("query: \"" + sqlStmt + "\" ");
        sb.append("with parameters: {");
        String prefix = "";
        for (int i = 0; i < params.length; ++i) {
            sb.append(prefix);
            prefix = ", ";
            Object param = params[i];
            sb.append("Input_Value_" + i + ": " + param);
        }
        sb.append("}");
        return sb.toString();
    }

    private static void populatePreparedStatementParameters(PreparedStatement prepStmt, Object[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            int queryParamIndex = i + 1;
            if (param == null) {
                prepStmt.setString(queryParamIndex, null);
                continue;
            }
            if (param instanceof String) {
                prepStmt.setString(queryParamIndex, (String)param);
                continue;
            }
            if (!(param instanceof Integer)) continue;
            prepStmt.setInt(queryParamIndex, (Integer)param);
        }
    }

    private static void validateParameterCount(String sqlStmt, Object[] params) throws UserStoreException {
        int placeholderCount;
        if (params != null && sqlStmt != null && (placeholderCount = StringUtils.countMatches((String)sqlStmt, (String)SQL_STATEMENT_PARAMETER_PLACEHOLDER)) != params.length) {
            String errMsg = "Parameter count: " + params.length + ", mismatches with the number of placeholders: " + placeholderCount;
            throw new UserStoreException(errMsg);
        }
    }

    private static String getTenantDomain(int tenantID) throws UserStoreException {
        String tenantDomain;
        RealmService realmService = UserCoreUtil.getRealmService();
        try {
            tenantDomain = realmService != null ? realmService.getTenantManager().getDomain(tenantID) : CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error occurred while getting the tenant domain.", e);
        }
        return tenantDomain;
    }

    private static User getUser(UserStoreManager userStoreManager, String userID, String userName) throws UserStoreException {
        String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        User user = new User(userID);
        user.setUsername(userName);
        user.setUserStoreDomain(domainName);
        user.setTenantDomain(DatabaseUtil.getTenantDomain(userStoreManager.getTenantId()));
        return user;
    }
}

