/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.core.tenant.TenantDomainKey;
import org.wso2.carbon.user.core.tenant.TenantIdEntry;

class TenantIdCache {
    private static final String TENANT_ID_CACHE_MANAGER = "TENANT_ID_CACHE_MANAGER";
    private static final String TENANT_ID_CACHE = "TENANT_ID_CACHE";
    private static Log log = LogFactory.getLog(TenantIdCache.class);
    private static TenantIdCache tenantIdCache = new TenantIdCache();

    private TenantIdCache() {
    }

    public static synchronized TenantIdCache getInstance() {
        return tenantIdCache;
    }

    private Cache<TenantDomainKey, TenantIdEntry> getTenantIdCache() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(TENANT_ID_CACHE_MANAGER);
            Cache cache = cacheManager.getCache(TENANT_ID_CACHE);
            return cache;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(TenantDomainKey key, TenantIdEntry entry) {
        try {
            this.startSuperTenantFlow();
            Cache<TenantDomainKey, TenantIdEntry> cache = this.getTenantIdCache();
            if (cache != null) {
                cache.put((Object)key, (Object)entry);
                log.debug((Object)("TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER, added the entry : " + entry + " for the key : " + key + " successfully"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TenantIdEntry getValueFromCache(TenantDomainKey key) {
        try {
            this.startSuperTenantFlow();
            Cache<TenantDomainKey, TenantIdEntry> cache = this.getTenantIdCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    TenantIdEntry entry = (TenantIdEntry)cache.get((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER, found the entry : " + entry + " for the key : " + key + " successfully"));
                    }
                    TenantIdEntry tenantIdEntry = entry;
                    return tenantIdEntry;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER, doesn't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER");
            }
            TenantIdEntry tenantIdEntry = null;
            return tenantIdEntry;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clearCacheEntry(TenantDomainKey key) {
        try {
            this.startSuperTenantFlow();
            Cache<TenantDomainKey, TenantIdEntry> cache = this.getTenantIdCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    cache.remove((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER,vis removed entry for the key : " + key + " successfully"));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER, doen't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clear() {
        try {
            this.startSuperTenantFlow();
            Cache<TenantDomainKey, TenantIdEntry> cache = this.getTenantIdCache();
            if (cache != null) {
                cache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER, is cleared successfully");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_ID_CACHE which is under TENANT_ID_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startSuperTenantFlow() {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
    }
}

