/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.CacheManagerFactory;
import javax.cache.Caching;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.impl.TenantCacheManager;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.core.tenant.TenantIdKey;

public class TenantCache {
    public static final String TENANT_CACHE_MANAGER = "TENANT_CACHE_MANAGER";
    public static final String TENANT_CACHE = "TENANT_CACHE";
    private static Log log = LogFactory.getLog(TenantCache.class);
    private static TenantCache tenantCache = new TenantCache();

    private TenantCache() {
    }

    public static synchronized TenantCache getInstance() {
        return tenantCache;
    }

    private <T> Cache<TenantIdKey, T> getTenantCache() {
        Cache cache = null;
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(TENANT_CACHE_MANAGER);
        cache = cacheManager.getCache(TENANT_CACHE);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addToCache(TenantIdKey key, T entry) {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            this.clearCacheEntry(key);
            Cache<TenantIdKey, T> cache = this.getTenantCache();
            if (cache != null) {
                cache.put((Object)key, entry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, added the entry : " + entry + " for the key : " + key + " successfully"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getValueFromCache(TenantIdKey key) {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<TenantIdKey, T> cache = this.getTenantCache();
            if (cache != null) {
                if (cache.containsKey((Object)key)) {
                    Object entry = cache.get((Object)key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, found the entry : " + entry + " for the key : " + key + " successfully"));
                    }
                    Object object = entry;
                    return (T)object;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, doesn't contain the key : " + key));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
            }
            T t = null;
            return t;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheEntry(TenantIdKey key) {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache cache = this.getTenantCache();
            if (cache != null) {
                cache.remove((Object)key);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TENANT_CACHE which is under TENANT_CACHE_MANAGER, is removed entry for the key : " + key + " successfully"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clear() {
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache cache = this.getTenantCache();
            if (cache != null) {
                cache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"TENANT_CACHE which is under TENANT_CACHE_MANAGER, is cleared successfully");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Error while getting the cache : TENANT_CACHE which is under TENANT_CACHE_MANAGER");
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void removeGlobalCacheEntry(String tenantDomain) {
        CacheManagerFactory cacheManagerFactory = Caching.getCacheManagerFactory();
        if (cacheManagerFactory instanceof TenantCacheManager) {
            TenantCacheManager tenantCacheManager = (TenantCacheManager)cacheManagerFactory;
            tenantCacheManager.removeCacheManagerMap(tenantDomain);
        }
    }
}

