/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.tenant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.cache.Caching;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.caching.impl.CacheManagerFactoryImpl;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.RealmCache;
import org.wso2.carbon.user.core.common.UserStoreDeploymentManager;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.internal.UserStoreMgtDSComponent;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantCache;
import org.wso2.carbon.user.core.tenant.TenantCacheEntry;
import org.wso2.carbon.user.core.tenant.TenantDomainCache;
import org.wso2.carbon.user.core.tenant.TenantDomainEntry;
import org.wso2.carbon.user.core.tenant.TenantDomainKey;
import org.wso2.carbon.user.core.tenant.TenantIdCache;
import org.wso2.carbon.user.core.tenant.TenantIdEntry;
import org.wso2.carbon.user.core.tenant.TenantIdKey;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.user.core.tenant.TenantSearchResult;
import org.wso2.carbon.user.core.tenant.TenantUniqueIDKey;
import org.wso2.carbon.user.core.tenant.TenantUniqueIdCache;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCTenantManager
implements TenantManager {
    public static final String COLUMN_NAME_UM_ID = "UM_ID";
    public static final String COLUMN_NAME_UM_DOMAIN_NAME = "UM_DOMAIN_NAME";
    public static final String COLUMN_NAME_UM_EMAIL = "UM_EMAIL";
    public static final String COLUMN_NAME_UM_ACTIVE = "UM_ACTIVE";
    public static final String COLUMN_NAME_UM_CREATED_DATE = "UM_CREATED_DATE";
    public static final String COLUMN_NAME_UM_USER_CONFIG = "UM_USER_CONFIG";
    public static final String COLUMN_NAME_UM_TENANT_UUID = "UM_TENANT_UUID";
    private static Log log = LogFactory.getLog(TenantManager.class);
    protected BundleContext bundleContext;
    protected TenantCache tenantCacheManager = TenantCache.getInstance();
    DataSource dataSource;
    private static Boolean tenantUniqueIdColumnAvailable;
    private TenantIdCache tenantIdCache = TenantIdCache.getInstance();
    private TenantUniqueIdCache tenantUniqueIdCache = TenantUniqueIdCache.getInstance();
    private TenantDomainCache tenantDomainCache = TenantDomainCache.getInstance();

    public JDBCTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            throw new Exception("Data Source is null");
        }
        this.tenantCacheManager.clear();
        this.tenantIdCache.clear();
        this.tenantDomainCache.clear();
        this.tenantUniqueIdCache.clear();
    }

    public JDBCTenantManager(DataSource dataSource, String superTenantDomain) {
        this.dataSource = dataSource;
    }

    public int addTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        if (tenant.getId() > 0) {
            return this.addTenantWithGivenId(tenant);
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        int id = 0;
        String tenantDomain = tenant.getDomain().toLowerCase();
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "INSERT INTO UM_TENANT (UM_DOMAIN_NAME,UM_EMAIL, UM_CREATED_DATE, UM_USER_CONFIG) VALUES(?,?,?,?)";
            String tenantUniqueID = tenant.getTenantUniqueID();
            if (this.isTenantUniqueIdColumnAvailable()) {
                sqlStmt = "INSERT INTO UM_TENANT (UM_DOMAIN_NAME,UM_EMAIL, UM_CREATED_DATE, UM_USER_CONFIG, UM_TENANT_UUID) VALUES(?,?,?,?,?)";
            }
            String dbProductName = dbConnection.getMetaData().getDatabaseProductName();
            prepStmt = dbConnection.prepareStatement(sqlStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)COLUMN_NAME_UM_ID)});
            prepStmt.setString(1, tenantDomain);
            prepStmt.setString(2, tenant.getEmail());
            Date createdTime = tenant.getCreatedDate();
            long createdTimeMs = createdTime == null ? System.currentTimeMillis() : createdTime.getTime();
            prepStmt.setTimestamp(3, new Timestamp(createdTimeMs));
            String realmConfigString = RealmConfigXMLProcessor.serialize(tenant.getRealmConfig()).toString();
            ByteArrayInputStream is = new ByteArrayInputStream(realmConfigString.getBytes());
            prepStmt.setBinaryStream(4, (InputStream)is, ((InputStream)is).available());
            if (this.isTenantUniqueIdColumnAvailable()) {
                prepStmt.setString(5, tenantUniqueID);
            }
            prepStmt.executeUpdate();
            result = prepStmt.getGeneratedKeys();
            if (result.next()) {
                id = result.getInt(1);
            }
            dbConnection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully created the tenant, adding tenant domain to cache where tenantDomain: {" + tenantDomain + "}"));
            }
            tenant.setDomain(tenantDomain);
            tenant.setCreatedDate(new Date(createdTimeMs));
            this.tenantDomainNameValidation(tenantDomain);
            this.tenantDomainCache.addToCache(new TenantIdKey(id), new TenantDomainEntry(tenantDomain));
            this.tenantIdCache.addToCache(new TenantDomainKey(tenantDomain), new TenantIdEntry(id));
        }
        catch (Exception e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in adding tenant with tenant domain: " + tenantDomain + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return id;
    }

    public int addTenantWithGivenId(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        if (this.getTenant(tenant.getId()) != null) {
            String errorMsg = "Tenant with tenantId:" + tenant.getId() + " is already created. Tenant creation is aborted for tenant domain:" + tenant.getDomain();
            log.error((Object)errorMsg);
            throw new UserStoreException(errorMsg);
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        int id = 0;
        String tenantDomain = tenant.getDomain().toLowerCase();
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "INSERT INTO UM_TENANT (UM_ID,UM_DOMAIN_NAME,UM_EMAIL, UM_CREATED_DATE, UM_USER_CONFIG) VALUES(?,?,?,?,?)";
            if (this.isTenantUniqueIdColumnAvailable()) {
                sqlStmt = "INSERT INTO UM_TENANT (UM_ID,UM_DOMAIN_NAME,UM_EMAIL, UM_CREATED_DATE, UM_USER_CONFIG, UM_TENANT_UUID) VALUES(?,?,?,?,?,?)";
            }
            String dbProductName = dbConnection.getMetaData().getDatabaseProductName();
            prepStmt = dbConnection.prepareStatement(sqlStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)COLUMN_NAME_UM_ID)});
            prepStmt.setInt(1, tenant.getId());
            prepStmt.setString(2, tenantDomain);
            prepStmt.setString(3, tenant.getEmail());
            Date createdTime = tenant.getCreatedDate();
            long createdTimeMs = createdTime == null ? System.currentTimeMillis() : createdTime.getTime();
            prepStmt.setTimestamp(4, new Timestamp(createdTimeMs));
            String realmConfigString = RealmConfigXMLProcessor.serialize(tenant.getRealmConfig()).toString();
            ByteArrayInputStream is = new ByteArrayInputStream(realmConfigString.getBytes());
            prepStmt.setBinaryStream(5, (InputStream)is, ((InputStream)is).available());
            if (this.isTenantUniqueIdColumnAvailable()) {
                prepStmt.setString(6, tenant.getTenantUniqueID());
            }
            prepStmt.executeUpdate();
            id = tenant.getId();
            dbConnection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully created tenant with the provided id, ID: " + tenant.getId() + ", adding tenant domain to cache where tenantDomain: {" + tenantDomain + "}"));
            }
            tenant.setDomain(tenantDomain);
            tenant.setCreatedDate(new Date(createdTimeMs));
            this.tenantDomainNameValidation(tenantDomain);
            this.tenantDomainCache.addToCache(new TenantIdKey(id), new TenantDomainEntry(tenantDomain));
            this.tenantIdCache.addToCache(new TenantDomainKey(tenantDomain), new TenantIdEntry(id));
            if (this.isTenantUniqueIdColumnAvailable()) {
                this.tenantUniqueIdCache.addToCache(new TenantUniqueIDKey(tenant.getTenantUniqueID()), new TenantCacheEntry<org.wso2.carbon.user.api.Tenant>(tenant));
            }
        }
        catch (Exception e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in adding tenant with tenant domain: " + tenantDomain + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return id;
    }

    public void updateTenant(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        this.clearTenantCache(tenant.getId());
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_DOMAIN_NAME=?, UM_EMAIL=?, UM_CREATED_DATE=? WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenant.getDomain().toLowerCase());
            prepStmt.setString(2, tenant.getEmail());
            Date createdTime = tenant.getCreatedDate();
            long createdTimeMs = createdTime == null ? System.currentTimeMillis() : createdTime.getTime();
            prepStmt.setTimestamp(3, new Timestamp(createdTimeMs));
            prepStmt.setInt(4, tenant.getId());
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in updating tenant with tenant domain: " + tenant.getDomain().toLowerCase() + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenantRealmConfig(org.wso2.carbon.user.api.Tenant tenant) throws UserStoreException {
        PreparedStatement prepStmt;
        Connection dbConnection;
        block17: {
            dbConnection = null;
            prepStmt = null;
            try {
                dbConnection = this.getDBConnection();
                String realmConfigString = null;
                if (tenant.getRealmConfig() == null || (realmConfigString = RealmConfigXMLProcessor.serialize(tenant.getRealmConfig()).toString()) == null || realmConfigString.trim().length() <= 0) break block17;
                String sqlStmt = "UPDATE UM_TENANT SET UM_USER_CONFIG=? WHERE UM_ID=?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                ByteArrayInputStream is = null;
                try {
                    is = new ByteArrayInputStream(realmConfigString.getBytes());
                    prepStmt.setBinaryStream(1, (InputStream)is, ((InputStream)is).available());
                    prepStmt.setInt(2, tenant.getId());
                    prepStmt.executeUpdate();
                    dbConnection.commit();
                    this.clearTenantCache(tenant.getId());
                    RealmCache.getInstance().clearFromCache(tenant.getId(), "primary");
                }
                catch (IOException e) {
                    log.error((Object)"Error occurs while reading realm configuration", (Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
            catch (SQLException e) {
                try {
                    DatabaseUtil.rollBack(dbConnection);
                    String msg = "Error in updating tenant realm configuration with tenant domain: " + tenant.getDomain().toLowerCase() + ".";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                    throw throwable;
                }
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public Tenant getTenant(int tenantId) throws UserStoreException {
        TenantCacheEntry entry = (TenantCacheEntry)this.tenantCacheManager.getValueFromCache(new TenantIdKey(tenantId));
        if (entry != null && entry.getTenant() != null) {
            return (Tenant)((Object)entry.getTenant());
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        Tenant tenant = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_CREATED_DATE, UM_USER_CONFIG FROM UM_TENANT WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            result = prepStmt.executeQuery();
            if (result.next()) {
                int id = result.getInt(COLUMN_NAME_UM_ID);
                String domain = result.getString(COLUMN_NAME_UM_DOMAIN_NAME);
                String email = result.getString(COLUMN_NAME_UM_EMAIL);
                boolean active = result.getBoolean(COLUMN_NAME_UM_ACTIVE);
                Date createdDate = new Date(result.getTimestamp(COLUMN_NAME_UM_CREATED_DATE).getTime());
                InputStream is = result.getBinaryStream(COLUMN_NAME_UM_USER_CONFIG);
                RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
                RealmConfiguration realmConfig = processor.buildTenantRealmConfiguration(is);
                realmConfig.setTenantId(id);
                tenant = new Tenant();
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setCreatedDate(createdDate);
                tenant.setActive(active);
                tenant.setRealmConfig(realmConfig);
                this.setSecondaryUserStoreConfig(realmConfig, tenantId);
                tenant.setAdminName(realmConfig.getAdminUserName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Obtained tenant from database for the given tenant ID: " + tenantId + ", hence adding tenant to cache where tenantDomain: {" + domain + "}"));
                }
                this.tenantDomainNameValidation(domain);
                this.tenantCacheManager.addToCache(new TenantIdKey(id), new TenantCacheEntry<Tenant>(tenant));
                this.tenantDomainCache.addToCache(new TenantIdKey(id), new TenantDomainEntry(domain));
                this.tenantIdCache.addToCache(new TenantDomainKey(domain), new TenantIdEntry(id));
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant with tenant id: " + tenantId + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenant;
    }

    public Tenant[] getAllTenants() throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE FROM UM_TENANT ORDER BY UM_ID";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            result = prepStmt.executeQuery();
            while (result.next()) {
                int id = result.getInt(COLUMN_NAME_UM_ID);
                String domain = result.getString(COLUMN_NAME_UM_DOMAIN_NAME);
                String email = result.getString(COLUMN_NAME_UM_EMAIL);
                boolean active = result.getBoolean(COLUMN_NAME_UM_ACTIVE);
                Date createdDate = new Date(result.getTimestamp(COLUMN_NAME_UM_CREATED_DATE).getTime());
                Tenant tenant = new Tenant();
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setActive(active);
                tenant.setCreatedDate(createdDate);
                tenantList.add(tenant);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenants.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenantList.toArray(new Tenant[tenantList.size()]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public TenantSearchResult listTenants(Integer limit, Integer offset, String sortOrder, String sortBy, String filter) throws UserStoreException {
        TenantSearchResult tenantSearchResult = new TenantSearchResult();
        String sortedOrder = sortBy + " " + sortOrder;
        try (Connection dbConnection = this.getDBConnection();){
            TenantSearchResult tenantSearchResult2;
            block14: {
                ResultSet resultSet = this.getTenantQueryResultSet(dbConnection, sortedOrder, offset, limit);
                try {
                    List<Tenant> tenantList = this.populateTenantList(resultSet);
                    tenantSearchResult.setTenantList(tenantList);
                    tenantSearchResult.setTotalTenantCount(this.getCountOfTenants());
                    tenantSearchResult.setLimit(limit);
                    tenantSearchResult.setOffSet(offset);
                    tenantSearchResult.setSortBy(sortBy);
                    tenantSearchResult.setSortOrder(sortOrder);
                    tenantSearchResult.setFilter(filter);
                    tenantSearchResult2 = tenantSearchResult;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return tenantSearchResult2;
        }
        catch (SQLException e) {
            throw new UserStoreException("Error occurred while listing the tenants.", e);
        }
    }

    public String getDomain(int tenantId) throws UserStoreException {
        if (tenantId == -1234) {
            return "carbon.super";
        }
        if (tenantId == -1) {
            return null;
        }
        TenantIdKey tenantIdKey = new TenantIdKey(tenantId);
        TenantDomainEntry tenantDomainEntry = this.tenantDomainCache.getValueFromCache(tenantIdKey);
        if (tenantDomainEntry != null) {
            if (tenantDomainEntry.getTenantDomainName() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Tenant domain from cache: {" + tenantDomainEntry.getTenantDomainName() + "}"));
                }
                return tenantDomainEntry.getTenantDomainName().trim();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant domain from cache: {NULL}");
            }
            return tenantDomainEntry.getTenantDomainName();
        }
        String tenantDomain = null;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_DOMAIN_NAME FROM UM_TENANT WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            result = prepStmt.executeQuery();
            if (result.next()) {
                tenantDomain = result.getString(COLUMN_NAME_UM_DOMAIN_NAME);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant with tenant id: " + tenantId + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        if (tenantDomain != null && !tenantDomain.isEmpty() && tenantId != -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Obtained tenant domain from database, tenantDomain: {" + tenantDomain + "} for the given tenant ID:" + tenantId + ", hence adding tenant domain and tenant ID to cache."));
            }
            this.tenantDomainNameValidation(tenantDomain);
            this.tenantDomainCache.addToCache(tenantIdKey, new TenantDomainEntry(tenantDomain));
            this.tenantIdCache.addToCache(new TenantDomainKey(tenantDomain), new TenantIdEntry(tenantId));
        }
        if (tenantDomain != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant domain from database : {" + tenantDomain + "}"));
            }
            return tenantDomain.trim();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant domain from database : {NULL}");
        }
        return tenantDomain;
    }

    public Tenant[] getAllTenantsForTenantDomainStr(String tenantDomain) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE FROM UM_TENANT WHERE UM_DOMAIN_NAME like ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, "%" + tenantDomain.toLowerCase() + "%");
            result = prepStmt.executeQuery();
            while (result.next()) {
                int id = result.getInt(COLUMN_NAME_UM_ID);
                String domain = result.getString(COLUMN_NAME_UM_DOMAIN_NAME);
                String email = result.getString(COLUMN_NAME_UM_EMAIL);
                boolean active = result.getBoolean(COLUMN_NAME_UM_ACTIVE);
                Date createdDate = new Date(result.getTimestamp(COLUMN_NAME_UM_CREATED_DATE).getTime());
                Tenant tenant = new Tenant();
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setActive(active);
                tenant.setCreatedDate(createdDate);
                tenantList.add(tenant);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenants.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenantList.toArray(new Tenant[tenantList.size()]);
    }

    public int getTenantId(String tenantDomain) throws UserStoreException {
        if (tenantDomain != null) {
            tenantDomain = tenantDomain.toLowerCase();
        }
        if ("carbon.super".equals(tenantDomain)) {
            return -1234;
        }
        if (tenantDomain == null) {
            return -1;
        }
        TenantDomainKey tenantDomainKey = new TenantDomainKey(tenantDomain);
        TenantIdEntry tenantIdEntry = this.tenantIdCache.getValueFromCache(tenantDomainKey);
        if (tenantIdEntry != null) {
            return tenantIdEntry.getTenantDomainName();
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        int tenantId = -1;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID FROM UM_TENANT WHERE UM_DOMAIN_NAME=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenantDomain);
            result = prepStmt.executeQuery();
            if (result.next()) {
                tenantId = result.getInt(COLUMN_NAME_UM_ID);
            }
            dbConnection.commit();
            if (tenantDomain != null && !tenantDomain.isEmpty() && tenantId != -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Obtained tenant ID: " + tenantId + " from database for the given tenantDomain: {" + tenantDomain + "}, hence adding tenant domain and tenant ID to cache."));
                }
                this.tenantDomainNameValidation(tenantDomain);
                this.tenantIdCache.addToCache(tenantDomainKey, new TenantIdEntry(tenantId));
                this.tenantDomainCache.addToCache(new TenantIdKey(tenantId), new TenantDomainEntry(tenantDomain));
            }
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant id with tenant domain: " + tenantDomain + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenantId;
    }

    @Override
    public Tenant getTenant(String tenantUniqueID) throws UserStoreException {
        TenantCacheEntry entry = (TenantCacheEntry)this.tenantUniqueIdCache.getValueFromCache(new TenantUniqueIDKey(tenantUniqueID));
        if (entry != null && entry.getTenant() != null) {
            return (Tenant)((Object)entry.getTenant());
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet result = null;
        Tenant tenant = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_CREATED_DATE, UM_USER_CONFIG, UM_TENANT_UUID FROM UM_TENANT WHERE UM_TENANT_UUID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenantUniqueID);
            result = prepStmt.executeQuery();
            if (result.next()) {
                int id = result.getInt(COLUMN_NAME_UM_ID);
                String domain = result.getString(COLUMN_NAME_UM_DOMAIN_NAME);
                String email = result.getString(COLUMN_NAME_UM_EMAIL);
                boolean active = result.getBoolean(COLUMN_NAME_UM_ACTIVE);
                Date createdDate = new Date(result.getTimestamp(COLUMN_NAME_UM_CREATED_DATE).getTime());
                InputStream is = result.getBinaryStream(COLUMN_NAME_UM_USER_CONFIG);
                RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
                RealmConfiguration realmConfig = processor.buildTenantRealmConfiguration(is);
                realmConfig.setTenantId(id);
                String uniqueId = result.getString(COLUMN_NAME_UM_TENANT_UUID);
                tenant = new Tenant();
                tenant.setTenantUniqueID(uniqueId);
                tenant.setId(id);
                tenant.setDomain(domain);
                tenant.setEmail(email);
                tenant.setCreatedDate(createdDate);
                tenant.setActive(active);
                tenant.setRealmConfig(realmConfig);
                this.setSecondaryUserStoreConfig(realmConfig, id);
                tenant.setAdminName(realmConfig.getAdminUserName());
                tenant.setAdminUserId(this.getUserId(realmConfig.getAdminUserName(), id));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Obtained tenant from database for the given UUID: " + uniqueId + ", hence adding tenant to cache where tenantDomain: {" + domain + "}"));
                }
                this.tenantDomainNameValidation(domain);
                this.tenantUniqueIdCache.addToCache(new TenantUniqueIDKey(uniqueId), new TenantCacheEntry<Tenant>(tenant));
                this.tenantCacheManager.addToCache(new TenantIdKey(id), new TenantCacheEntry<Tenant>(tenant));
                this.tenantDomainCache.addToCache(new TenantIdKey(id), new TenantDomainEntry(domain));
                this.tenantIdCache.addToCache(new TenantDomainKey(domain), new TenantIdEntry(id));
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in getting the tenant with tenant UUID: " + tenantUniqueID + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, result, prepStmt);
        return tenant;
    }

    public void activateTenant(int tenantId) throws UserStoreException {
        this.clearTenantCache(tenantId);
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_ACTIVE='1' WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in activating the tenant with tenant id: " + tenantId + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public void deactivateTenant(int tenantId) throws UserStoreException {
        this.clearTenantCache(tenantId);
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_ACTIVE='0' WHERE UM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in deactivating the tenant with tenant id: " + tenantId + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void activateTenant(String tenantUniqueID) throws UserStoreException {
        this.clearTenantCaches(tenantUniqueID);
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_ACTIVE='1' WHERE UM_TENANT_UUID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenantUniqueID);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in activating the tenant with tenant UniqueID: " + tenantUniqueID + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    @Override
    public void deactivateTenant(String tenantUniqueID) throws UserStoreException {
        this.clearTenantCaches(tenantUniqueID);
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.getDBConnection();
            String sqlStmt = "UPDATE UM_TENANT SET UM_ACTIVE='0' WHERE UM_TENANT_UUID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, tenantUniqueID);
            prepStmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                DatabaseUtil.rollBack(dbConnection);
                String msg = "Error in deactivating the tenant with tenant UniqueID: " + tenantUniqueID + ".";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg, (Throwable)e);
                }
                throw new UserStoreException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
    }

    public boolean isTenantActive(int tenantId) throws UserStoreException {
        if (tenantId == -1234) {
            return true;
        }
        Tenant tenant = this.getTenant(tenantId);
        return tenant.isActive();
    }

    public void deleteTenant(int tenantId) throws UserStoreException {
        try {
            this.deleteTenant(tenantId, true);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
    }

    public void deleteTenant(int tenantId, boolean removeFromPersistentStorage) throws org.wso2.carbon.user.api.UserStoreException {
        String domain = this.getDomain(tenantId);
        this.clearTenantCache(tenantId);
        this.invalidateCacheManager(domain);
        if (removeFromPersistentStorage) {
            Connection dbConnection = null;
            PreparedStatement prepStmt = null;
            try {
                dbConnection = this.getDBConnection();
                String sqlStmt = "DELETE FROM UM_TENANT WHERE UM_ID=?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, tenantId);
                prepStmt.executeUpdate();
                dbConnection.commit();
            }
            catch (SQLException e) {
                try {
                    DatabaseUtil.rollBack(dbConnection);
                    String msg = "Error in deleting the tenant with tenant id: " + tenantId + ".";
                    if (log.isDebugEnabled()) {
                        log.debug((Object)msg, (Throwable)e);
                    }
                    throw new UserStoreException(msg, e);
                }
                catch (Throwable throwable) {
                    DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                    throw throwable;
                }
            }
            DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
        }
    }

    @Override
    public void deleteTenantUMData(int tenantId) throws UserStoreException {
        ServerConfigurationService serverConfigurationService = UserStoreMgtDSComponent.getServerConfigurationService();
        try (Connection conn = this.getDBConnection();){
            conn.setAutoCommit(false);
            this.executeDeleteQuery(conn, "DELETE FROM UM_USER_PERMISSION WHERE UM_TENANT_ID = ?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_ROLE_PERMISSION WHERE UM_TENANT_ID = ?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_PERMISSION WHERE UM_TENANT_ID=?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_TENANT_ID = ?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_TENANT_ID = ?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_USER_ROLE WHERE UM_TENANT_ID=?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=?", tenantId);
            this.executeDeleteQuery(conn, "DELETE FROM UM_HYBRID_REMEMBER_ME WHERE UM_TENANT_ID = ?", tenantId);
            if (Boolean.parseBoolean(serverConfigurationService.getFirstProperty("Tenant.DeletePrimaryUsersOnTenantDeletion"))) {
                this.executeDeleteQuery(conn, "DELETE FROM UM_ROLE WHERE UM_TENANT_ID=?", tenantId);
                this.executeDeleteQuery(conn, "DELETE FROM UM_USER WHERE UM_TENANT_ID=?", tenantId);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant.DeletePrimaryUsersOnTenantDeletion flag is not enabled in carbon.xml. Users and Roles will not be deleted.");
            }
            conn.commit();
        }
        catch (SQLException e) {
            String errorMsg = "An error occurred while deleting um data for tenant: " + tenantId;
            log.error((Object)e);
            throw new UserStoreException(errorMsg, e);
        }
    }

    private void clearTenantCache(int tenantId) throws UserStoreException {
        String domain = this.getDomain(tenantId);
        this.tenantDomainCache.clearCacheEntry(new TenantIdKey(tenantId));
        this.tenantIdCache.clearCacheEntry(new TenantDomainKey(domain));
        this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenantId));
    }

    private void clearTenantCaches(String tenantUniqueID) throws UserStoreException {
        Tenant tenant = this.getTenant(tenantUniqueID);
        if (tenant != null) {
            int tenantId = tenant.getId();
            this.tenantUniqueIdCache.clearCacheEntry(new TenantUniqueIDKey(tenantUniqueID));
            this.tenantDomainCache.clearCacheEntry(new TenantIdKey(tenantId));
            this.tenantIdCache.clearCacheEntry(new TenantDomainKey(tenant.getDomain()));
            this.tenantCacheManager.clearCacheEntry(new TenantIdKey(tenantId));
        }
    }

    private void invalidateCacheManager(String domain) {
        CacheManagerFactoryImpl cacheManagerFactory = (CacheManagerFactoryImpl)Caching.getCacheManagerFactory();
        cacheManagerFactory.removeCacheManagerMap(domain);
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void initializeExistingPartitions() {
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = DatabaseUtil.getDBConnection(this.dataSource);
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }

    @Override
    public String getSuperTenantDomain() throws UserStoreException {
        return "carbon.super";
    }

    private void setSecondaryUserStoreConfig(RealmConfiguration realmConfiguration, int tenantId) throws UserStoreException {
        RealmConfiguration lastRealm = realmConfiguration;
        if (realmConfiguration != null) {
            while (lastRealm.getSecondaryRealmConfig() != null) {
                lastRealm = lastRealm.getSecondaryRealmConfig();
            }
            String configPath = CarbonUtils.getCarbonTenantsDirPath() + File.separator + tenantId + File.separator + "userstores";
            File userStores = new File(configPath);
            UserStoreDeploymentManager userStoreDeploymentManager = new UserStoreDeploymentManager();
            File[] files = userStores.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File userStores, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            if (files != null) {
                for (File file : files) {
                    RealmConfiguration newRealmConfig = userStoreDeploymentManager.getUserStoreConfiguration(file.getAbsolutePath());
                    if (newRealmConfig != null) {
                        lastRealm.setSecondaryRealmConfig(newRealmConfig);
                        lastRealm = lastRealm.getSecondaryRealmConfig();
                        continue;
                    }
                    log.error((Object)("Error while creating realm configuration from file " + file.getAbsolutePath()));
                }
            }
        }
    }

    private void tenantDomainNameValidation(String tenantDomain) {
        if (tenantDomain.equals(tenantDomain.trim())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant domain doesn't contain any trailing white spaces, tenantDomain: {" + tenantDomain + "}"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Tenant domain contains trailing white spaces, tenantDomain: {" + tenantDomain + "}, current stack trace: \n" + this.printCurrentStackTrace().toString()));
        }
    }

    private StringBuilder printCurrentStackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder currentStackTraceBuilder = new StringBuilder();
        for (int i = 1; i < elements.length; ++i) {
            StackTraceElement s = elements[i];
            currentStackTraceBuilder.append("\tat " + s.getClassName() + "." + s.getMethodName() + "(" + s.getFileName() + ":" + s.getLineNumber() + ") \n");
        }
        return currentStackTraceBuilder;
    }

    private int getCountOfTenants() throws UserStoreException {
        String sqlStmt = "SELECT COUNT(*) FROM UM_TENANT";
        int tenantCount = 0;
        try (Connection dbConnection = this.getDBConnection();
             PreparedStatement prepStmt = dbConnection.prepareStatement(sqlStmt);
             ResultSet rs = prepStmt.executeQuery();){
            if (rs.next()) {
                tenantCount = Integer.parseInt(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new UserStoreException("Error occurred while retrieving tenant count.", e);
        }
        return tenantCount;
    }

    private ResultSet getTenantQueryResultSet(Connection dbConnection, String sortedOrder, Integer offset, Integer limit) throws SQLException, UserStoreException {
        PreparedStatement prepStmt;
        String dbType = dbConnection.getMetaData().getDatabaseProductName();
        String sqlQuery = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_USER_CONFIG, UM_TENANT_UUID FROM UM_TENANT ";
        if (dbType.contains("MySQL") || dbType.contains("H2")) {
            String sqlTail = String.format("ORDER BY %s LIMIT ?, ?", sortedOrder);
            sqlQuery = sqlQuery + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, offset);
            prepStmt.setInt(2, limit);
        } else if (dbType.contains("oracle")) {
            sqlQuery = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_USER_CONFIG, UM_TENANT_UUID FROM (SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_USER_CONFIG, UM_TENANT_UUID, rownum AS rnum FROM (SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_USER_CONFIG, UM_TENANT_UUID FROM UM_TENANT ";
            String sqlTail = String.format("ORDER BY %s) rownum <= ?) WHERE rnum > ?", sortedOrder);
            sqlQuery = sqlQuery + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, offset + limit);
            prepStmt.setInt(2, offset);
        } else if (dbType.contains("Microsoft")) {
            String sqlTail = String.format("ORDER BY %s OFFSET ? ROWS FETCH NEXT ? ROWS ONLY", sortedOrder);
            sqlQuery = sqlQuery + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, offset);
            prepStmt.setInt(2, limit);
        } else if (dbType.contains("db2") || dbType.contains("DB2")) {
            sqlQuery = "SELECT UM_ID, UM_DOMAIN_NAME, UM_EMAIL, UM_CREATED_DATE, UM_ACTIVE, UM_USER_CONFIG, UM_TENANT_UUID FROM (SELECT ROW_NUMBER() OVER";
            String sqlTail = String.format("(ORDER BY %s) AS rn,UM_TENANT.* FROM UM_TENANT)WHERE rn BETWEEN ? AND ?", sortedOrder);
            sqlQuery = sqlQuery + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, offset + 1);
            prepStmt.setInt(2, offset + limit);
        } else if (dbType.contains("PostgreSQL")) {
            String sqlTail = String.format("ORDER BY %s LIMIT ? OFFSET ?", sortedOrder);
            sqlQuery = sqlQuery + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, limit);
            prepStmt.setInt(2, offset);
        } else {
            String message = "Error while loading tenant from DB: Database driver could not be identified or not supported.";
            log.error((Object)message);
            throw new UserStoreException(message);
        }
        return prepStmt.executeQuery();
    }

    private List<Tenant> populateTenantList(ResultSet resultSet) throws SQLException, UserStoreException {
        ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
        while (resultSet.next()) {
            int id = resultSet.getInt(COLUMN_NAME_UM_ID);
            String domain = resultSet.getString(COLUMN_NAME_UM_DOMAIN_NAME);
            String email = resultSet.getString(COLUMN_NAME_UM_EMAIL);
            boolean active = resultSet.getBoolean(COLUMN_NAME_UM_ACTIVE);
            Date createdDate = new Date(resultSet.getTimestamp(COLUMN_NAME_UM_CREATED_DATE).getTime());
            String tenantUniqueId = resultSet.getString(COLUMN_NAME_UM_TENANT_UUID);
            InputStream is = resultSet.getBinaryStream(COLUMN_NAME_UM_USER_CONFIG);
            RealmConfigXMLProcessor processor = new RealmConfigXMLProcessor();
            RealmConfiguration realmConfig = processor.buildTenantRealmConfiguration(is);
            Tenant tenant = new Tenant();
            tenant.setId(id);
            tenant.setDomain(domain);
            tenant.setEmail(email);
            tenant.setActive(active);
            tenant.setTenantUniqueID(tenantUniqueId);
            tenant.setCreatedDate(createdDate);
            String adminUserName = realmConfig.getAdminUserName();
            tenant.setAdminName(adminUserName);
            tenant.setAdminUserId(this.getUserId(adminUserName, id));
            tenantList.add(tenant);
        }
        return tenantList;
    }

    private String getUserId(String userName, int tenantId) throws UserStoreException {
        String claimValue = null;
        RealmService realmService = UserStoreMgtDSComponent.getRealmService();
        try {
            UserStoreManager userStoreManager;
            UserRealm tenantUserRealm = realmService.getTenantUserRealm(tenantId);
            if (tenantUserRealm != null && (userStoreManager = (UserStoreManager)tenantUserRealm.getUserStoreManager()) != null) {
                claimValue = userStoreManager.getUserClaimValue(userName, "http://wso2.org/claims/userid", "default");
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException("Error while getting claim value for the claim: http://wso2.org/claims/userid", e);
        }
        return claimValue;
    }

    private boolean isTenantUniqueIdColumnAvailable() throws UserStoreException {
        if (tenantUniqueIdColumnAvailable == null) {
            tenantUniqueIdColumnAvailable = this.checkUniqueIdColumnInTable();
        }
        return tenantUniqueIdColumnAvailable;
    }

    /*
     * Exception decompiling
     */
    private boolean checkUniqueIdColumnInTable() throws UserStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 22[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeDeleteQuery(Connection conn, String query, int tenantId) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement(query);){
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            String errMsg = "Error executing query " + query + " for tenant: " + tenantId;
            log.error((Object)errMsg, (Throwable)e);
            throw e;
        }
    }
}

