/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.profile.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class ProfileConfigDAO {
    private static Log log = LogFactory.getLog(DatabaseUtil.class);
    private DataSource dataSource = null;
    private int tenantId;

    public ProfileConfigDAO(DataSource dataSource, int tenantId) {
        this.dataSource = dataSource;
        this.tenantId = tenantId;
    }

    public void addProfileConfig(ProfileConfiguration profileConfig) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            this.addProfileConfig(dbConnection, profileConfig);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Database Error - " + e.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public void addProfileConfig(ProfileConfiguration[] profileConfigs) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            for (ProfileConfiguration profileConfig : profileConfigs) {
                this.addProfileConfig(dbConnection, profileConfig);
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Database Error - " + e.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public void updateProfileConfig(ProfileConfiguration profileConfig) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            this.deleteProfileConfig(dbConnection, profileConfig.getProfileName(), profileConfig.getDialectName());
            this.addProfileConfig(dbConnection, profileConfig);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Database Error - " + e.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public void deleteProfileConfig(ProfileConfiguration profileConfig) throws UserStoreException {
        Connection dbConnection = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            this.deleteProfileConfig(dbConnection, profileConfig.getProfileName(), profileConfig.getDialectName());
            dbConnection.commit();
        }
        catch (SQLException e) {
            String errorMessage = "Database Error - " + e.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            DatabaseUtil.closeConnection(dbConnection);
        }
    }

    public Map<String, ProfileConfiguration> loadProfileConfigs() throws UserStoreException {
        Connection dbConnection = null;
        HashMap<String, ProfileConfiguration> map = new HashMap<String, ProfileConfiguration>();
        PreparedStatement prepStmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_CLAIM_URI, UM_PROFILE_NAME,UM_BEHAVIOUR, UM_DIALECT_URI FROM UM_PROFILE_CONFIG, UM_CLAIM, UM_CLAIM_BEHAVIOR, UM_DIALECT WHERE UM_CLAIM_BEHAVIOR.UM_CLAIM_ID=UM_CLAIM.UM_ID AND UM_PROFILE_CONFIG.UM_ID=UM_CLAIM_BEHAVIOR.UM_PROFILE_ID AND UM_PROFILE_CONFIG.UM_DIALECT_ID=UM_DIALECT.UM_ID AND UM_PROFILE_CONFIG.UM_TENANT_ID=? AND UM_CLAIM.UM_TENANT_ID=? AND UM_CLAIM_BEHAVIOR.UM_TENANT_ID=? AND UM_DIALECT.UM_TENANT_ID=?");
            prepStmt.setInt(1, this.tenantId);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setInt(4, this.tenantId);
            ResultSet rs = prepStmt.executeQuery();
            while (rs.next()) {
                String claimUri = rs.getString(1);
                String profileName = rs.getString(2);
                short behavior = rs.getShort(3);
                String dialectUri = rs.getString(4);
                ProfileConfiguration profConfig = (ProfileConfiguration)((Object)map.get(profileName));
                if (profConfig == null) {
                    profConfig = new ProfileConfiguration();
                    map.put(profileName, profConfig);
                }
                profConfig.setDialectName(dialectUri);
                profConfig.setProfileName(profileName);
                if (behavior == 1) {
                    profConfig.addHiddenClaim(claimUri);
                    continue;
                }
                if (behavior == 0) {
                    profConfig.addInheritedClaim(claimUri);
                    continue;
                }
                if (behavior == 2) {
                    profConfig.addOverriddenClaim(claimUri);
                    continue;
                }
                assert (false);
            }
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Database Error - " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, prepStmt);
        return map;
    }

    protected void addProfileConfig(Connection dbConnection, ProfileConfiguration profileConfig) throws UserStoreException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            int dialectId = -1;
            String profileName = profileConfig.getProfileName();
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_DIALECT WHERE UM_DIALECT_URI=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, profileConfig.getDialectName());
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                dialectId = rs.getInt(1);
            }
            rs.close();
            prepStmt.close();
            if (dialectId == -1) {
                throw new UserStoreException("Please add the dialect URI first.");
            }
            prepStmt = dbConnection.prepareStatement("INSERT INTO UM_PROFILE_CONFIG (UM_PROFILE_NAME, UM_DIALECT_ID, UM_TENANT_ID) VALUES(?,?,?)");
            prepStmt.setString(1, profileConfig.getProfileName());
            prepStmt.setInt(2, dialectId);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.executeUpdate();
            prepStmt.close();
            int profileId = -1;
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_PROFILE_CONFIG WHERE UM_PROFILE_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, profileName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                profileId = rs.getInt(1);
            }
            rs.close();
            prepStmt.close();
            Map<String, Integer> ids = this.getClaimUris(dbConnection);
            prepStmt = dbConnection.prepareStatement("INSERT INTO UM_CLAIM_BEHAVIOR (UM_PROFILE_ID, UM_CLAIM_ID, UM_BEHAVIOUR, UM_TENANT_ID) VALUES(?, ?, ?, ?)");
            this.addToAddBatch(profileConfig.getHiddenClaims(), profileId, ids, (short)1, prepStmt);
            this.addToAddBatch(profileConfig.getOverriddenClaims(), profileId, ids, (short)2, prepStmt);
            this.addToAddBatch(profileConfig.getInheritedClaims(), profileId, ids, (short)0, prepStmt);
            prepStmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Database Error - " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    public void deleteProfileConfig(Connection dbConnection, String profileName, String dialect) throws UserStoreException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("DELETE FROM UM_CLAIM_BEHAVIOR WHERE UM_PROFILE_ID=(SELECT UM_ID FROM UM_PROFILE_CONFIG WHERE UM_PROFILE_NAME=? AND UM_DIALECT_ID=(SELECT UM_ID FROM UM_DIALECT WHERE UM_DIALECT_URI=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
            prepStmt.setString(1, profileName);
            prepStmt.setString(2, dialect);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setInt(4, this.tenantId);
            prepStmt.setInt(5, this.tenantId);
            int ival = prepStmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted claim behavior numbers :: " + ival));
            }
            prepStmt.close();
            prepStmt = dbConnection.prepareStatement("DELETE FROM UM_PROFILE_CONFIG WHERE UM_PROFILE_NAME=? AND UM_DIALECT_ID=(SELECT UM_ID FROM UM_DIALECT WHERE UM_DIALECT_URI=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
            prepStmt.setString(1, profileName);
            prepStmt.setString(2, dialect);
            prepStmt.setInt(3, this.tenantId);
            prepStmt.setInt(4, this.tenantId);
            ival = prepStmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted profile names :: " + ival));
            }
            prepStmt.close();
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Database Error - " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
    }

    protected Map<String, Integer> getClaimUris(Connection dbConnection) throws UserStoreException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID, UM_CLAIM_URI FROM UM_CLAIM WHERE UM_TENANT_ID=?");
            prepStmt.setInt(1, this.tenantId);
            ResultSet rs = prepStmt.executeQuery();
            while (rs.next()) {
                int claimid = rs.getInt(1);
                String claimuri = rs.getString(2);
                map.put(claimuri, claimid);
            }
        }
        catch (SQLException e) {
            try {
                String errorMessage = "Database Error - " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(null, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(null, prepStmt);
        return map;
    }

    private void addToAddBatch(List<String> lst, int profileId, Map<String, Integer> ids, short behavior, PreparedStatement prepStmt) throws SQLException {
        for (String claimUri : lst) {
            if (claimUri == null || ids.get(claimUri) == null) continue;
            prepStmt.setInt(1, profileId);
            prepStmt.setInt(2, ids.get(claimUri));
            prepStmt.setShort(3, behavior);
            prepStmt.setInt(4, this.tenantId);
            prepStmt.addBatch();
        }
    }
}

