/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.profile;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.profile.dao.ProfileConfigDAO;

public class DefaultProfileConfigurationManager
implements ProfileConfigurationManager {
    private Map<String, ProfileConfiguration> profileConfigs = new ConcurrentHashMap<String, ProfileConfiguration>();
    private ProfileConfigDAO profileDAO = null;

    public DefaultProfileConfigurationManager(Map<String, ProfileConfiguration> profileConfigs, DataSource dataSource, int tenantId) {
        this.profileConfigs.putAll(profileConfigs);
        this.profileDAO = new ProfileConfigDAO(dataSource, tenantId);
    }

    public ProfileConfiguration getProfileConfig(String profileName) throws UserStoreException {
        if (profileName != null) {
            return this.profileConfigs.get(profileName);
        }
        throw new UserStoreException("profileName value is null.");
    }

    public void addProfileConfig(org.wso2.carbon.user.api.ProfileConfiguration profileConfig) throws UserStoreException {
        if (profileConfig != null && profileConfig.getProfileName() != null) {
            this.profileConfigs.put(profileConfig.getProfileName(), (ProfileConfiguration)profileConfig);
        }
        this.profileDAO.addProfileConfig((ProfileConfiguration)profileConfig);
    }

    public void updateProfileConfig(org.wso2.carbon.user.api.ProfileConfiguration profileConfig) throws UserStoreException {
        if (profileConfig != null && profileConfig.getProfileName() != null) {
            this.profileConfigs.put(profileConfig.getProfileName(), (ProfileConfiguration)profileConfig);
        }
        this.profileDAO.updateProfileConfig((ProfileConfiguration)profileConfig);
    }

    public void deleteProfileConfig(org.wso2.carbon.user.api.ProfileConfiguration profileConfig) throws UserStoreException {
        if (profileConfig != null && profileConfig.getProfileName() != null) {
            this.profileConfigs.remove(profileConfig.getProfileName());
        }
        this.profileDAO.deleteProfileConfig((ProfileConfiguration)profileConfig);
    }

    public ProfileConfiguration[] getAllProfiles() throws UserStoreException {
        return this.profileConfigs.values().toArray(new ProfileConfiguration[this.profileConfigs.size()]);
    }
}

