/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SqlBuilder {
    private static final String START_PARENTHESES = "(";
    private static final String CLOSE_PARENTHESES = ")";
    private List<String> wheres = new ArrayList<String>();
    private StringBuilder sql;
    private StringBuilder tail;
    private int count = 1;
    private Map<Integer, Integer> integerParameters = new HashMap<Integer, Integer>();
    private Map<Integer, String> stringParameters = new HashMap<Integer, String>();
    private Map<Integer, Long> longParameters = new HashMap<Integer, Long>();
    private boolean addedWhereStatement = false;

    public SqlBuilder(StringBuilder sql) {
        this.sql = sql;
    }

    private void appendList(StringBuilder sql, List<String> list) {
        for (String s : list) {
            if (this.addedWhereStatement) {
                sql.append(" AND ");
            } else {
                sql.append(" WHERE ");
                this.addedWhereStatement = true;
            }
            sql.append(s);
        }
    }

    public String getQuery() {
        this.appendList(this.sql, this.wheres);
        this.wheres = new ArrayList<String>();
        this.addedWhereStatement = false;
        if (this.tail != null) {
            return this.buildExecutableSQLStatement(new StringBuilder(this.sql.toString() + this.tail));
        }
        return this.buildExecutableSQLStatement(new StringBuilder(this.sql.toString()));
    }

    public SqlBuilder where(String expr, String value) {
        this.wheres.add(expr);
        this.stringParameters.put(this.count, value);
        ++this.count;
        return this;
    }

    public SqlBuilder where(String expr, int value) {
        this.wheres.add(expr);
        this.integerParameters.put(this.count, value);
        ++this.count;
        return this;
    }

    public SqlBuilder where(String expr, long value) {
        this.wheres.add(expr);
        this.longParameters.put(this.count, value);
        ++this.count;
        return this;
    }

    public Map<Integer, Integer> getIntegerParameters() {
        return this.integerParameters;
    }

    public Map<Integer, String> getStringParameters() {
        return this.stringParameters;
    }

    public Map<Integer, Long> getLongParameters() {
        return this.longParameters;
    }

    public void setTail(String tail, Integer ... placeHolders) {
        if (this.tail == null) {
            this.tail = new StringBuilder(tail);
        } else {
            this.tail.append(tail);
        }
        Integer[] integerArray = placeHolders;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int value = integerArray[i];
            this.integerParameters.put(this.count, value);
            ++this.count;
        }
    }

    public void setTail(String tail, String ... placeHolders) {
        if (this.tail == null) {
            this.tail = new StringBuilder(tail);
        } else {
            this.tail.append(tail);
        }
        for (String value : placeHolders) {
            this.stringParameters.put(this.count, value);
            ++this.count;
        }
    }

    public void setTail(String tail, Long ... placeHolders) {
        if (this.tail == null) {
            this.tail = new StringBuilder(tail);
        } else {
            this.tail.append(tail);
        }
        Long[] longArray = placeHolders;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            this.longParameters.put(this.count, value);
            ++this.count;
        }
    }

    public String getSql() {
        return this.sql.toString();
    }

    public List<String> getWheres() {
        return this.wheres;
    }

    public void updateSql(String append) {
        this.appendList(this.sql, this.wheres);
        this.wheres = new ArrayList<String>();
        this.addedWhereStatement = false;
        this.sql.append(append);
    }

    public void updateSqlWithOROperation(String expr, Object value) {
        this.appendList(this.sql, this.wheres);
        this.wheres = new ArrayList<String>();
        this.sql.append(" OR ").append(expr);
        if (value instanceof String) {
            this.stringParameters.put(this.count, String.valueOf(value));
        } else if (value instanceof Integer) {
            this.integerParameters.put(this.count, (Integer)value);
        } else if (value instanceof Long) {
            this.longParameters.put(this.count, (Long)value);
        }
        ++this.count;
    }

    private String buildExecutableSQLStatement(StringBuilder sqlQueryStringBuilder) {
        int endParenthesesCounts;
        int startParenthesesCounts = StringUtils.countMatches((String)sqlQueryStringBuilder.toString(), (String)START_PARENTHESES);
        int needToBeCloseParenthesesCount = startParenthesesCounts - (endParenthesesCounts = StringUtils.countMatches((String)sqlQueryStringBuilder.toString(), (String)CLOSE_PARENTHESES));
        if (needToBeCloseParenthesesCount > 0) {
            for (int i = 0; i < needToBeCloseParenthesesCount; ++i) {
                sqlQueryStringBuilder.append(CLOSE_PARENTHESES);
            }
        }
        return sqlQueryStringBuilder.toString();
    }
}

