/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.Properties;
import org.wso2.carbon.user.api.Property;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.RoleContext;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.ldap.LDAPRoleContext;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreConstants;
import org.wso2.carbon.user.core.ldap.UniqueIDReadOnlyLDAPUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.user.core.util.JNDIUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class UniqueIDReadWriteLDAPUserStoreManager
extends UniqueIDReadOnlyLDAPUserStoreManager {
    public static final String PASSWORD_HASH_METHOD = "PasswordHashMethod";
    public static final String ATTR_NAME_CN = "cn";
    public static final String ATTR_NAME_SN = "sn";
    protected static final String KRB5_PRINCIPAL_NAME_ATTRIBUTE = "krb5PrincipalName";
    protected static final String KRB5_KEY_VERSION_NUMBER_ATTRIBUTE = "krb5KeyVersionNumber";
    protected static final String EMPTY_ATTRIBUTE_STRING = "";
    private static final String MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION = "This is the separator for multiple claim values";
    private static final String MULTI_ATTRIBUTE_SEPARATOR = "MultiAttributeSeparator";
    private static final List<Property> UNIQUE_ID_RW_LDAP_UM_ADVANCED_PROPERTIES = new ArrayList<Property>();
    private static final String LDAPConnectionTimeout = "LDAPConnectionTimeout";
    private static final String LDAPConnectionTimeoutDescription = "LDAP Connection Timeout";
    private static final String readTimeout = "ReadTimeout";
    private static final String readTimeoutDescription = "Configure this to define the read timeout for LDAP operations";
    private static final String RETRY_ATTEMPTS = "RetryAttempts";
    private static final String LDAPBinaryAttributesDescription = "Configure this to define the LDAP binary attributes seperated by a space. Ex:mpegVideo mySpecialKey";
    protected static boolean isFirstStartup = true;
    private static Log logger = LogFactory.getLog(UniqueIDReadWriteLDAPUserStoreManager.class);
    private static Log log = LogFactory.getLog(UniqueIDReadWriteLDAPUserStoreManager.class);
    private static final String BULK_IMPORT_SUPPORT = "BulkImportSupported";
    protected Random random = new Random();
    protected boolean kdcEnabled = false;

    public UniqueIDReadWriteLDAPUserStoreManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueIDReadWriteLDAPUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read-Write UserStoreManager initialization started " + System.currentTimeMillis()));
        }
        this.realmConfig = realmConfig;
        this.claimManager = claimManager;
        this.userRealm = realm;
        this.tenantId = tenantId;
        this.kdcEnabled = UserCoreUtil.isKdcEnabled(realmConfig);
        this.checkRequiredUserStoreConfigurations();
        this.dataSource = (DataSource)properties.get("um.datasource");
        if (this.dataSource == null) {
            this.dataSource = DatabaseUtil.getRealmDataSource(realmConfig);
        }
        if (this.dataSource == null) {
            throw new UserStoreException("Data Source is null");
        }
        properties.put("um.datasource", this.dataSource);
        isFirstStartup = (Boolean)properties.get("FistStartupCheck");
        this.hybridRoleManager = new HybridRoleManager(this.dataSource, tenantId, realmConfig, this.userRealm);
        this.connectionSource = (LDAPConnectionContext)properties.get("ldapConnectionSource");
        if (this.connectionSource == null) {
            this.connectionSource = new LDAPConnectionContext(realmConfig);
        }
        DirContext dirContext = null;
        try {
            dirContext = this.connectionSource.getContext();
            log.info((Object)"LDAP connection created successfully in read-write mode");
        }
        catch (Exception e) {
            log.error((Object)("Cannot create connection to LDAP server. Connection URL: " + realmConfig.getUserStoreProperty("ConnectionURL") + " Error message: " + e.getMessage()));
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
        this.userRealm = realm;
        this.persistDomain();
        this.doInitialSetup();
        if (realmConfig.isPrimary()) {
            this.addInitialAdminData(Boolean.parseBoolean(realmConfig.getAddAdmin()), !this.isInitSetupDone());
        }
        this.initUserRolesCache();
        this.initUserCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read-Write UserStoreManager initialization ended " + System.currentTimeMillis()));
        }
    }

    public UniqueIDReadWriteLDAPUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected String getRealmName() {
        String defaultRealmName = this.realmConfig.getUserStoreProperty("defaultRealmName");
        if (defaultRealmName != null) {
            return defaultRealmName;
        }
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String[] domainComponents = searchBase.split("dc=");
        StringBuilder builder = new StringBuilder();
        for (String dc : domainComponents) {
            if (dc.contains("=")) continue;
            String trimmedDc = dc.trim();
            if (trimmedDc.endsWith(",")) {
                builder.append(trimmedDc.replace(',', '.'));
                continue;
            }
            builder.append(trimmedDc);
        }
        return builder.toString().toUpperCase(Locale.ENGLISH);
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public User doAddUserWithID(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        String userID = this.getUniqueUserID();
        this.persistUser(userID, userName, credential, roleList, claims);
        return this.getUser(userID, userName);
    }

    protected void persistUser(String userID, String userName, Object credential, String[] roleList, Map<String, String> claims) throws UserStoreException {
        DirContext dirContext = this.getSearchBaseDirectoryContext();
        BasicAttributes basicAttributes = this.getAddUserBasicAttributes(userName);
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
        if (passwordHashMethod == null) {
            passwordHashMethod = this.realmConfig.getUserStoreProperty("passwordHashMethod");
        }
        byte[] passwordToStore = UserCoreUtil.getPasswordToStore(credential, passwordHashMethod, this.kdcEnabled);
        userPassword.add(passwordToStore);
        basicAttributes.put(userPassword);
        this.setUserClaimsWithID(claims, basicAttributes, userID, userName);
        try {
            NameParser ldapParser = dirContext.getNameParser(EMPTY_ATTRIBUTE_STRING);
            Name compoundName = ldapParser.parse(this.realmConfig.getUserStoreProperty("UserNameAttribute") + "=" + this.escapeSpecialCharactersForDN(userName));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Binding user: " + compoundName));
            }
            dirContext.bind(compoundName, null, (Attributes)basicAttributes);
        }
        catch (NamingException e) {
            String errorMessage = "Cannot access the directory context or user already exists in the system for user :" + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
            UserCoreUtil.clearSensitiveBytes(passwordToStore);
        }
        if (roleList != null && roleList.length > 0) {
            try {
                this.doUpdateRoleListOfUserWithID(userID, null, roleList);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Roles are added for user  : " + userName + " successfully."));
                }
            }
            catch (UserStoreException e) {
                String errorMessage = "User is added. But error while updating role list of user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)((Object)e));
                }
                throw new UserStoreException(errorMessage, (Throwable)((Object)e));
            }
        }
    }

    protected void setUserClaimsWithID(Map<String, String> claims, BasicAttributes basicAttributes, String userID, String userName) throws UserStoreException {
        BasicAttribute claim;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing user claims.");
        }
        boolean isSNExists = false;
        boolean isCNExists = false;
        if (claims != null) {
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                String attributeName;
                if (EMPTY_ATTRIBUTE_STRING.equals(entry.getValue())) continue;
                String claimURI = entry.getKey();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Claim URI: " + claimURI));
                }
                try {
                    attributeName = this.getClaimAtrribute(claimURI, userName, null);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    String errorMessage = "Error in obtaining claim mapping.";
                    throw new UserStoreException(errorMessage, e);
                }
                if (ATTR_NAME_CN.equals(attributeName)) {
                    isCNExists = true;
                } else if (ATTR_NAME_SN.equals(attributeName)) {
                    isSNExists = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mapped attribute: " + attributeName));
                    log.debug((Object)("Attribute value: " + claims.get(entry.getKey())));
                }
                claim = new BasicAttribute(attributeName);
                claim.add(claims.get(entry.getKey()));
                basicAttributes.put(claim);
            }
        }
        String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
        claim = new BasicAttribute(userIDAttribute);
        claim.add(userID);
        basicAttributes.put(claim);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapped attribute: " + userIDAttribute));
            log.debug((Object)("Attribute value: " + userID));
        }
        if (!isCNExists) {
            BasicAttribute cn = new BasicAttribute(ATTR_NAME_CN);
            cn.add(userName);
            basicAttributes.put(cn);
        }
        if (!isSNExists) {
            BasicAttribute sn = new BasicAttribute(ATTR_NAME_SN);
            sn.add(userName);
            basicAttributes.put(sn);
        }
    }

    protected DirContext getSearchBaseDirectoryContext() throws UserStoreException {
        DirContext mainDirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase").split("#")[0];
        try {
            DirContext dirContext = (DirContext)mainDirContext.lookup(this.escapeDNForSearch(searchBase));
            return dirContext;
        }
        catch (NamingException e) {
            String errorMessage = "Can not access the directory context oruser already exists in the system";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    protected BasicAttributes getAddUserBasicAttributes(String userName) {
        String[] objectClassHierarchy;
        BasicAttributes basicAttributes = new BasicAttributes(true);
        String userEntryObjectClassProperty = this.realmConfig.getUserStoreProperty("UserEntryObjectClass");
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        for (String userObjectClass : objectClassHierarchy = userEntryObjectClassProperty.split("/")) {
            if (userObjectClass == null || userObjectClass.trim().equals(EMPTY_ATTRIBUTE_STRING)) continue;
            objectClass.add(userObjectClass.trim());
        }
        if (this.kdcEnabled) {
            objectClass.add("krb5principal");
            objectClass.add("krb5kdcentry");
            objectClass.add("subschema");
        }
        basicAttributes.put(objectClass);
        BasicAttribute userNameAttribute = new BasicAttribute(this.realmConfig.getUserStoreProperty("UserNameAttribute"));
        userNameAttribute.add(userName);
        basicAttributes.put(userNameAttribute);
        if (this.kdcEnabled) {
            CarbonContext cc = CarbonContext.getThreadLocalCarbonContext();
            if (cc != null) {
                String tenantDomainName = cc.getTenantDomain();
                userName = !"carbon.super".equals(tenantDomainName) ? userName + "_" + tenantDomainName : userName + "_" + "carbon.super";
            }
            String principal = userName + "@" + this.getRealmName();
            BasicAttribute principalAttribute = new BasicAttribute(KRB5_PRINCIPAL_NAME_ATTRIBUTE);
            principalAttribute.add(principal);
            basicAttributes.put(principalAttribute);
            BasicAttribute versionNumberAttribute = new BasicAttribute(KRB5_KEY_VERSION_NUMBER_ATTRIBUTE);
            versionNumberAttribute.add("0");
            basicAttributes.put(versionNumberAttribute);
        }
        return basicAttributes;
    }

    @Override
    public void doDeleteUser(String userName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doDeleteUserWithID(String userID) throws UserStoreException {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Deleting user: " + userID));
        }
        String userName = this.doGetUserNameFromUserID(userID);
        String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
        String[] returningUserAttributes = new String[]{userNameAttribute};
        DirContext mainDirContext = this.connectionSource.getContext();
        NamingEnumeration<SearchResult> userResults = this.searchInUserBase(searchFilter, returningUserAttributes, 2, mainDirContext);
        NamingEnumeration<SearchResult> groupResults = null;
        DirContext subDirContext = null;
        try {
            String[] rolesOfUser;
            String[] sharedRoles;
            SearchResult userResult = null;
            String userDN = null;
            while (userResults.hasMore()) {
                userResult = userResults.next();
                userDN = userResult.getName();
                log.debug((Object)("User DN: " + userDN));
            }
            ArrayList<String> roles = new ArrayList<String>();
            String[] externalRoles = this.doGetExternalRoleListOfUserWithID(userID, "*");
            roles.addAll(Arrays.asList(externalRoles));
            if (this.isSharedGroupEnabled() && (sharedRoles = this.doGetSharedRolesListOfUser(userName, null, "*")) != null) {
                roles.addAll(Arrays.asList(sharedRoles));
            }
            if ((rolesOfUser = roles.toArray(new String[0])).length != 0) {
                String[] returningGroupAttributes = new String[]{this.realmConfig.getUserStoreProperty("MembershipAttribute")};
                for (String role : rolesOfUser) {
                    RoleContext context = this.createRoleContext(role);
                    String searchBase = ((LDAPRoleContext)context).getSearchBase();
                    searchFilter = ((LDAPRoleContext)context).getSearchFilter();
                    role = context.getRoleName();
                    if (role.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                        role = role.split(CarbonConstants.DOMAIN_SEPARATOR)[1];
                    }
                    String grpSearchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(role));
                    groupResults = this.searchInGroupBase(grpSearchFilter, returningGroupAttributes, 2, mainDirContext, searchBase);
                    SearchResult groupResult = null;
                    while (groupResults.hasMore()) {
                        groupResult = groupResults.next();
                    }
                    if (!this.isOnlyUserInRole(userDN, groupResult) || this.emptyRolesAllowed) continue;
                    String errorMessage = "User: " + userName + " is the only user in " + role + ".There should be at least one user in the role. Hence can not delete the user.";
                    throw new UserStoreException(errorMessage);
                }
                this.doUpdateRoleListOfUserWithID(userID, rolesOfUser, new String[0]);
            }
            if (userResult != null && userResult.getAttributes().get(userNameAttribute).get().toString().toLowerCase().equals(userName.toLowerCase())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + userDN + " with search base " + this.userSearchBase));
                }
                subDirContext = (DirContext)mainDirContext.lookup(this.escapeDNForSearch(this.userSearchBase));
                subDirContext.destroySubcontext(userDN);
            }
            this.removeFromUserCache(userName);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while deleting the user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(groupResults);
            JNDIUtil.closeNamingEnumeration(userResults);
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    private String[] doGetSharedRolesListOfUser(String userName, String tenantDomain, String filter) throws UserStoreException {
        String searchBase = this.getEffectiveSearchBase(true);
        if (tenantDomain != null && tenantDomain.trim().length() > 0 && !"carbon.super".equalsIgnoreCase(tenantDomain.trim())) {
            String groupNameAttributeName = this.realmConfig.getUserStoreProperty("SharedTenantNameAttribute");
            if (groupNameAttributeName == null || groupNameAttributeName.trim().length() == 0) {
                groupNameAttributeName = "ou";
            }
            searchBase = groupNameAttributeName + "=" + tenantDomain + "," + searchBase;
        }
        return this.getLDAPRoleListOfUser(userName, filter, searchBase, true);
    }

    @Override
    public void doUpdateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdateCredentialWithID(String userID, Object newCredential, Object oldCredential) throws UserStoreException {
        String userName = this.doGetUserNameFromUserID(userID);
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"userPassword"});
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<?> passwords = null;
        try {
            namingEnumeration = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchControls);
            NameClassPair searchResult = null;
            String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
            if (passwordHashMethod == null) {
                passwordHashMethod = this.realmConfig.getUserStoreProperty("passwordHashMethod");
            }
            while (namingEnumeration.hasMore()) {
                searchResult = namingEnumeration.next();
                String dnName = searchResult.getName();
                subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(searchBase));
                byte[] passwordToStore = UserCoreUtil.getPasswordToStore(newCredential, passwordHashMethod, this.kdcEnabled);
                try {
                    BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
                    passwordAttribute.add(passwordToStore);
                    BasicAttributes basicAttributes = new BasicAttributes(true);
                    basicAttributes.put(passwordAttribute);
                    subDirContext.modifyAttributes(dnName, 2, (Attributes)basicAttributes);
                }
                finally {
                    UserCoreUtil.clearSensitiveBytes(passwordToStore);
                }
            }
            if (searchResult.getNameInNamespace().equals(this.realmConfig.getUserStoreProperty("ConnectionName"))) {
                this.connectionSource.updateCredential(newCredential);
            }
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Can not access the directory service for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(passwords);
                JNDIUtil.closeNamingEnumeration(namingEnumeration);
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(passwords);
        JNDIUtil.closeNamingEnumeration(namingEnumeration);
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    @Override
    public void doUpdateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdateCredentialByAdminWithID(String userID, Object newCredential) throws UserStoreException {
        String userName = this.doGetUserNameFromUserID(userID);
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
        searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(new String[]{"userPassword"});
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<?> passwords = null;
        try {
            namingEnumeration = dirContext.search(this.escapeDNForSearch(searchBase), searchFilter, searchControls);
            NameClassPair searchResult = null;
            while (namingEnumeration.hasMore()) {
                byte[] byteArray;
                String password;
                Attributes attributes;
                Attribute userPassword;
                searchResult = namingEnumeration.next();
                String passwordHashMethod = this.realmConfig.getUserStoreProperty(PASSWORD_HASH_METHOD);
                if (passwordHashMethod == null) {
                    passwordHashMethod = this.realmConfig.getUserStoreProperty("passwordHashMethod");
                }
                if (!"PLAIN_TEXT".equalsIgnoreCase(passwordHashMethod) && (passwords = (userPassword = (attributes = ((SearchResult)searchResult).getAttributes()).get("userPassword")).getAll()).hasMore() && (password = new String(byteArray = (byte[])passwords.next())).startsWith("{")) {
                    passwordHashMethod = password.substring(password.indexOf(123) + 1, password.indexOf(125));
                }
                String dnName = searchResult.getName();
                subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(searchBase));
                byte[] passwordToStore = UserCoreUtil.getPasswordToStore(newCredential, passwordHashMethod, this.kdcEnabled);
                try {
                    BasicAttribute passwordAttribute = new BasicAttribute("userPassword");
                    passwordAttribute.add(passwordToStore);
                    BasicAttributes basicAttributes = new BasicAttributes(true);
                    basicAttributes.put(passwordAttribute);
                    subDirContext.modifyAttributes(dnName, 2, (Attributes)basicAttributes);
                }
                finally {
                    UserCoreUtil.clearSensitiveBytes(passwordToStore);
                }
            }
            if (searchResult.getNameInNamespace().equals(this.realmConfig.getUserStoreProperty("ConnectionName"))) {
                this.connectionSource.updateCredential(newCredential);
            }
        }
        catch (NamingException e) {
            String errorMessage = "Can not access the directory service for user : " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(passwords);
            JNDIUtil.closeNamingEnumeration(namingEnumeration);
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    public Map<String, String> getProperties(Tenant tenant) throws UserStoreException {
        Map existingProperties = this.realmConfig.getUserStoreProperties();
        String tenantSuffix = this.getTenantSuffix(tenant.getDomain());
        HashMap<String, String> newProperties = new HashMap<String, String>();
        for (Map.Entry iter : existingProperties.entrySet()) {
            String propertyName = (String)iter.getKey();
            if (propertyName.equals("UserSearchBase")) {
                newProperties.put(propertyName, tenantSuffix);
                continue;
            }
            newProperties.put(propertyName, (String)iter.getValue());
        }
        return newProperties;
    }

    private String getTenantSuffix(String domain) {
        String[] domainParts = domain.split("\\.");
        StringBuilder suffixName = new StringBuilder();
        for (String domainPart : domainParts) {
            suffixName.append(",dc=").append(domainPart);
        }
        return suffixName.toString().replaceFirst(",", EMPTY_ATTRIBUTE_STRING);
    }

    @Override
    public void doSetUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetUserAttribute(String userName, String attributeName, String value, String profileName) throws UserStoreException {
        block21: {
            DirContext dirContext = this.connectionSource.getContext();
            DirContext subDirContext = null;
            String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            String[] userNames = userName.split(CarbonConstants.DOMAIN_SEPARATOR);
            if (userNames.length > 1) {
                userName = userNames[1];
            }
            userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(null);
            NamingEnumeration<SearchResult> returnedResultList = null;
            String returnedUserEntry = null;
            try {
                returnedResultList = dirContext.search(this.escapeDNForSearch(userSearchBase), userSearchFilter, searchControls);
                returnedUserEntry = returnedResultList.next().getName();
            }
            catch (NamingException e) {
                String errorMessage = "Results could not be retrieved from the directory context for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(returnedResultList);
            }
            try {
                BasicAttributes updatedAttributes = new BasicAttributes(true);
                BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                if (EMPTY_ATTRIBUTE_STRING.equals(value)) {
                    currentUpdatedAttribute.clear();
                } else if (attributeName.equals("uid") || attributeName.equals(ATTR_NAME_SN)) {
                    currentUpdatedAttribute.add(value);
                } else {
                    String userAttributeSeparator = ",";
                    String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                    if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                        userAttributeSeparator = claimSeparator;
                    }
                    if (value.contains(userAttributeSeparator)) {
                        StringTokenizer st = new StringTokenizer(value, userAttributeSeparator);
                        while (st.hasMoreElements()) {
                            String newVal = st.nextElement().toString();
                            if (newVal == null || newVal.trim().length() <= 0) continue;
                            currentUpdatedAttribute.add(newVal.trim());
                        }
                    } else {
                        currentUpdatedAttribute.add(value);
                    }
                }
                updatedAttributes.put(currentUpdatedAttribute);
                subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
                subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
                JNDIUtil.closeContext(subDirContext);
            }
            catch (Exception e) {
                this.handleException(e, userName);
                break block21;
            }
            finally {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    protected void doSetUserAttributes(String userName, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetUserAttributesWithID(String userID, Map<String, String> processedClaimAttributes, String profileName) throws UserStoreException {
        DirContext dirContext = this.connectionSource.getContext();
        DirContext subDirContext = null;
        String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String userSearchFilter = this.realmConfig.getUserStoreProperty("UserIdSearchFilter");
        String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
        userSearchFilter = userSearchFilter.replace("uid", userIDAttribute);
        if ("objectGUID".equalsIgnoreCase(userIDAttribute) && this.isBinaryUserAttribute(userIDAttribute)) {
            userID = this.transformUUIDToObjectGUID(userID);
            userSearchFilter = userSearchFilter.replace("?", userID);
        } else {
            userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userID));
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(null);
        NamingEnumeration<SearchResult> returnedResultList = null;
        String returnedUserEntry = EMPTY_ATTRIBUTE_STRING;
        try {
            subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
            returnedResultList = dirContext.search(this.escapeDNForSearch(userSearchBase), userSearchFilter, searchControls);
            if (returnedResultList.hasMore()) {
                returnedUserEntry = returnedResultList.next().getName();
                this.handleLdapUserIdAttributeChanges(processedClaimAttributes, subDirContext, returnedUserEntry);
            }
        }
        catch (NamingException e) {
            String errorMessage = "Results could not be retrieved from the directory context for user : " + userID;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeNamingEnumeration(returnedResultList);
        }
        if (processedClaimAttributes.containsKey(this.realmConfig.getUserStoreProperty("UserNameAttribute"))) {
            this.removeFromUserCache(userID);
        }
        BasicAttributes updatedAttributes = new BasicAttributes(true);
        processedClaimAttributes.entrySet().forEach(claimEntry -> {
            BasicAttribute currentUpdatedAttribute = new BasicAttribute((String)claimEntry.getKey());
            if ("profileConfiguration".equals(claimEntry.getKey())) {
                return;
            }
            if (EMPTY_ATTRIBUTE_STRING.equals(claimEntry.getValue())) {
                currentUpdatedAttribute.clear();
            } else {
                String userAttributeSeparator = ",";
                if (claimEntry.getValue() != null && !((String)claimEntry.getKey()).equals("uid") && !((String)claimEntry.getKey()).equals(ATTR_NAME_SN)) {
                    String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                    if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                        userAttributeSeparator = claimSeparator;
                    }
                    if (((String)claimEntry.getValue()).contains(userAttributeSeparator)) {
                        String[] claimValues;
                        for (String claimValue : claimValues = ((String)claimEntry.getValue()).split(Pattern.quote(userAttributeSeparator))) {
                            if (claimValue == null || claimValue.trim().length() <= 0) continue;
                            currentUpdatedAttribute.add(claimValue);
                        }
                    } else {
                        currentUpdatedAttribute.add(claimEntry.getValue());
                    }
                } else {
                    currentUpdatedAttribute.add(claimEntry.getValue());
                }
            }
            updatedAttributes.put(currentUpdatedAttribute);
        });
        try {
            subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
        }
        catch (NamingException e) {
            this.handleException(e, userID);
        }
        finally {
            JNDIUtil.closeContext(subDirContext);
            JNDIUtil.closeContext(dirContext);
        }
    }

    protected void handleLdapUserIdAttributeChanges(Map<String, String> userAttributeValues, DirContext subDirContext, String returnedUserEntry) throws NamingException {
        userAttributeValues.computeIfPresent("uid", (attributeName, attributeValue) -> UserCoreUtil.removeDomainFromName(attributeValue));
    }

    @Override
    public void doSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetUserAttributeWithID(String userID, String attributeName, String value, String profileName) throws UserStoreException {
        block20: {
            String returnedUserEntry;
            DirContext dirContext = this.connectionSource.getContext();
            DirContext subDirContext = null;
            String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userSearchFilter = this.realmConfig.getUserStoreProperty("UserIdSearchFilter");
            String userIDAttribute = this.realmConfig.getUserStoreProperty("UserIDAttribute");
            userSearchFilter = userSearchFilter.replace("uid", userIDAttribute);
            userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userID));
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(null);
            NamingEnumeration<SearchResult> returnedResultList = null;
            try {
                returnedResultList = dirContext.search(this.escapeDNForSearch(userSearchBase), userSearchFilter, searchControls);
                returnedUserEntry = returnedResultList.next().getName();
            }
            catch (NamingException e) {
                String errorMessage = "Results could not be retrieved from the directory context for user : " + userID;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(returnedResultList);
            }
            try {
                BasicAttributes updatedAttributes = new BasicAttributes(true);
                BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                if (EMPTY_ATTRIBUTE_STRING.equals(value)) {
                    currentUpdatedAttribute.clear();
                } else if (attributeName.equals("uid") || attributeName.equals(ATTR_NAME_SN)) {
                    currentUpdatedAttribute.add(value);
                } else {
                    String userAttributeSeparator = ",";
                    String claimSeparator = this.realmConfig.getUserStoreProperty(MULTI_ATTRIBUTE_SEPARATOR);
                    if (claimSeparator != null && !claimSeparator.trim().isEmpty()) {
                        userAttributeSeparator = claimSeparator;
                    }
                    if (value.contains(userAttributeSeparator)) {
                        StringTokenizer st = new StringTokenizer(value, userAttributeSeparator);
                        while (st.hasMoreElements()) {
                            String newVal = st.nextElement().toString();
                            if (newVal == null || newVal.trim().length() <= 0) continue;
                            currentUpdatedAttribute.add(newVal.trim());
                        }
                    } else {
                        currentUpdatedAttribute.add(value);
                    }
                }
                updatedAttributes.put(currentUpdatedAttribute);
                subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
                subDirContext.modifyAttributes(returnedUserEntry, 2, (Attributes)updatedAttributes);
                JNDIUtil.closeContext(subDirContext);
            }
            catch (Exception e) {
                this.handleException(e, userID);
                break block20;
            }
            finally {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    public void doDeleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteUserClaimValueWithID(String userID, String claimURI, String profileName) throws UserStoreException {
        block12: {
            String returnedUserEntry;
            String userName = this.doGetUserNameFromUserID(userID);
            DirContext dirContext = this.connectionSource.getContext();
            DirContext subDirContext = null;
            String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(null);
            NamingEnumeration<SearchResult> returnedResultList = null;
            try {
                returnedResultList = dirContext.search(this.escapeDNForSearch(userSearchBase), userSearchFilter, searchControls);
                returnedUserEntry = returnedResultList.next().getName();
            }
            catch (NamingException e) {
                String errorMessage = "Results could not be retrieved from the directory context for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(returnedResultList);
            }
            try {
                BasicAttributes updatedAttributes = new BasicAttributes(true);
                String attributeName = this.getClaimAtrribute(claimURI, userName, null);
                BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                updatedAttributes.put(currentUpdatedAttribute);
                subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
                subDirContext.modifyAttributes(returnedUserEntry, 3, (Attributes)updatedAttributes);
                JNDIUtil.closeContext(subDirContext);
            }
            catch (Exception e) {
                this.handleException(e, userName);
                break block12;
            }
            finally {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    public void doDeleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteUserClaimValuesWithID(String userID, String[] claims, String profileName) throws UserStoreException {
        block13: {
            String returnedUserEntry;
            String userName = this.doGetUserNameFromUserID(userID);
            DirContext dirContext = this.connectionSource.getContext();
            DirContext subDirContext = null;
            String userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
            String userSearchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
            userSearchFilter = userSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(userName));
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(null);
            NamingEnumeration<SearchResult> returnedResultList = null;
            try {
                returnedResultList = dirContext.search(this.escapeDNForSearch(userSearchBase), userSearchFilter, searchControls);
                returnedUserEntry = returnedResultList.next().getName();
            }
            catch (NamingException e) {
                String errorMessage = "Results could not be retrieved from the directory context for user : " + userName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(returnedResultList);
            }
            try {
                BasicAttributes updatedAttributes = new BasicAttributes(true);
                for (String claimURI : claims) {
                    String attributeName = this.getClaimAtrribute(claimURI, userName, null);
                    BasicAttribute currentUpdatedAttribute = new BasicAttribute(attributeName);
                    updatedAttributes.put(currentUpdatedAttribute);
                }
                subDirContext = (DirContext)dirContext.lookup(this.escapeDNForSearch(userSearchBase));
                subDirContext.modifyAttributes(returnedUserEntry, 3, (Attributes)updatedAttributes);
                JNDIUtil.closeContext(subDirContext);
            }
            catch (Exception e) {
                this.handleException(e, userName);
                break block13;
            }
            finally {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
            }
            JNDIUtil.closeContext(dirContext);
        }
    }

    @Override
    public void doAddRole(String roleName, String[] userList, boolean shared) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doAddRoleWithID(String roleName, String[] userIDList, boolean shared) throws UserStoreException {
        List<String> userList = this.getUserNamesFromUserIDs(Arrays.asList(userIDList));
        String userStoreDomain = this.getMyDomainName();
        boolean containsInvalidUsernames = userList.stream().anyMatch(username -> !UserCoreUtil.extractDomainFromName(username).equalsIgnoreCase(userStoreDomain));
        if (containsInvalidUsernames) {
            throw new UserStoreException("One or more users in the users list: " + userList + " do not belong to the user store: " + userStoreDomain);
        }
        userList = userList.stream().map(UserCoreUtil::removeDomainFromName).collect(Collectors.toList());
        RoleContext roleContext = this.createRoleContext(roleName);
        roleContext.setMembers(userList.toArray(new String[0]));
        this.addLDAPRole(roleContext);
        if (shared && this.isSharedGroupEnabled()) {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            roleName = roleName + "@" + tenantDomain;
            roleContext = this.createRoleContext(roleName);
            this.addLDAPRole(roleContext);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addLDAPRole(RoleContext context) throws UserStoreException {
        String roleName = context.getRoleName();
        Object[] userList = context.getMembers();
        String groupEntryObjectClass = ((LDAPRoleContext)context).getGroupEntryObjectClass();
        String groupNameAttribute = ((LDAPRoleContext)context).getRoleNameProperty();
        String searchBase = ((LDAPRoleContext)context).getSearchBase();
        if (ArrayUtils.isEmpty((Object[])userList) && !this.emptyRolesAllowed) {
            String errorMessage = "Can not create empty role. There should be at least one user for the role.";
            throw new UserStoreException(errorMessage);
        }
        if (!(userList == null && this.emptyRolesAllowed || userList != null && userList.length > 0 && !this.emptyRolesAllowed)) {
            if (!this.emptyRolesAllowed) return;
        }
        DirContext mainDirContext = this.connectionSource.getContext();
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            BasicAttributes groupAttributes = new BasicAttributes(true);
            BasicAttribute objectClassAttribute = new BasicAttribute("objectClass");
            objectClassAttribute.add(groupEntryObjectClass);
            groupAttributes.put(objectClassAttribute);
            BasicAttribute cnAttribute = new BasicAttribute(groupNameAttribute);
            cnAttribute.add(roleName);
            groupAttributes.put(cnAttribute);
            if (userList != null && userList.length > 0) {
                String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                BasicAttribute memberAttribute = new BasicAttribute(memberAttributeName);
                for (Object userName : userList) {
                    if (userName == null || ((String)userName).trim().length() == 0) continue;
                    String searchFilter = this.realmConfig.getUserStoreProperty("UserNameSearchFilter");
                    searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter((String)userName));
                    results = this.searchInUserBase(searchFilter, new String[0], 2, mainDirContext);
                    SearchResult userResult = null;
                    if (!results.hasMore()) {
                        String errorMsg = "There is no user with the user name: " + (String)userName + " to be added to this role.";
                        logger.error((Object)errorMsg);
                        throw new UserStoreException(errorMsg);
                    }
                    userResult = results.next();
                    String userEntryDN = userResult.getNameInNamespace();
                    memberAttribute.add(userEntryDN);
                }
                groupAttributes.put(memberAttribute);
            }
            groupContext = (DirContext)mainDirContext.lookup(this.escapeDNForSearch(searchBase));
            NameParser ldapParser = groupContext.getNameParser(EMPTY_ATTRIBUTE_STRING);
            Name compoundGroupName = ldapParser.parse("cn=" + roleName);
            groupContext.bind(compoundGroupName, null, (Attributes)groupAttributes);
        }
        catch (NamingException e) {
            try {
                String errorMsg = "Role: " + roleName + " could not be added.";
                if (!log.isDebugEnabled()) throw new UserStoreException(errorMsg, e);
                log.debug((Object)errorMsg, (Throwable)e);
                throw new UserStoreException(errorMsg, e);
                catch (Exception e2) {
                    errorMsg = "Role: " + roleName + " could not be added.";
                    if (!log.isDebugEnabled()) throw new UserStoreException(errorMsg, e2);
                    log.debug((Object)errorMsg, (Throwable)e2);
                    throw new UserStoreException(errorMsg, e2);
                }
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(results);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(results);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    @Override
    public void doUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateRoleListOfUserWithID(String userID, String[] deletedRoles, String[] newRoles) throws UserStoreException {
        String userName = this.doGetUserNameFromUserID(userID);
        String userNameDN = this.getNameInSpaceForUserName(userName);
        String membershipAttribute = this.realmConfig.getUserStoreProperty("MembershipAttribute");
        String roleNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
        DirContext mainDirContext = this.connectionSource.getContext();
        try {
            String groupDN;
            SearchResult resultedGroup;
            NamingEnumeration<SearchResult> groupResults;
            String searchBase;
            String[] returningAttributes;
            String roleSearchFilter;
            String searchFilter;
            LDAPRoleContext context;
            if (deletedRoles != null && deletedRoles.length != 0) {
                for (String deletedRole : deletedRoles) {
                    context = (LDAPRoleContext)this.createRoleContext(deletedRole);
                    deletedRole = context.getRoleName();
                    searchFilter = context.getSearchFilter();
                    roleSearchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(deletedRole));
                    returningAttributes = new String[]{membershipAttribute};
                    searchBase = context.getSearchBase();
                    groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
                    resultedGroup = null;
                    if (groupResults.hasMore()) {
                        resultedGroup = groupResults.next();
                    }
                    if (resultedGroup != null && this.isOnlyUserInRole(userNameDN, resultedGroup) && !this.emptyRolesAllowed) {
                        String errorMessage = userName + " is the only user in the role: " + deletedRole + ". Hence can not delete user from role.";
                        throw new UserStoreException(errorMessage);
                    }
                    JNDIUtil.closeNamingEnumeration(groupResults);
                }
                for (String deletedRole : deletedRoles) {
                    if (!StringUtils.isNotEmpty((String)deletedRole)) continue;
                    context = (LDAPRoleContext)this.createRoleContext(deletedRole);
                    deletedRole = context.getRoleName();
                    searchFilter = context.getSearchFilter();
                    if (this.isExistingRole(deletedRole)) {
                        roleSearchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(deletedRole));
                        returningAttributes = new String[]{membershipAttribute, roleNameAttribute};
                        searchBase = context.getSearchBase();
                        groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
                        resultedGroup = null;
                        groupDN = null;
                        if (groupResults.hasMore()) {
                            resultedGroup = groupResults.next();
                            groupDN = this.getGroupName(resultedGroup);
                        }
                        if (resultedGroup == null || !this.isUserInRole(userNameDN, resultedGroup)) {
                            String errorMessage = "User: " + URLEncoder.encode(userName, String.valueOf(StandardCharsets.UTF_8)) + " does not belongs to role: " + URLEncoder.encode(deletedRole, String.valueOf(StandardCharsets.UTF_8));
                            throw new UserStoreException(errorMessage);
                        }
                        this.modifyUserInRole(userNameDN, groupDN, 3, searchBase);
                        JNDIUtil.closeNamingEnumeration(groupResults);
                        String userNameWithDomain = UserCoreUtil.addDomainToName(userName, this.getMyDomainName());
                        this.userRealm.getAuthorizationManager().clearUserAuthorization(userNameWithDomain);
                        continue;
                    }
                    String errorMessage = "The role: " + URLEncoder.encode(deletedRole, String.valueOf(StandardCharsets.UTF_8)) + " does not exist.";
                    throw new UserStoreException(errorMessage);
                }
            }
            if (newRoles != null && newRoles.length != 0) {
                for (String newRole : newRoles) {
                    if (!StringUtils.isNotEmpty((String)newRole)) continue;
                    context = (LDAPRoleContext)this.createRoleContext(newRole);
                    newRole = context.getRoleName();
                    searchFilter = context.getSearchFilter();
                    if (this.isExistingRole(newRole)) {
                        roleSearchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(newRole));
                        returningAttributes = new String[]{membershipAttribute, roleNameAttribute};
                        searchBase = context.getSearchBase();
                        groupResults = this.searchInGroupBase(roleSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
                        resultedGroup = null;
                        groupDN = null;
                        if (groupResults.hasMore()) {
                            resultedGroup = groupResults.next();
                            groupDN = this.getGroupName(resultedGroup);
                        }
                        if (resultedGroup == null || this.isUserInRole(userNameDN, resultedGroup)) {
                            String errorMessage = "User: " + userName + " already belongs to role: " + groupDN;
                            throw new UserStoreException(errorMessage);
                        }
                        this.modifyUserInRole(userNameDN, groupDN, 1, searchBase);
                        JNDIUtil.closeNamingEnumeration(groupResults);
                        continue;
                    }
                    String errorMessage = "The role: " + URLEncoder.encode(newRole, String.valueOf(StandardCharsets.UTF_8)) + " does not exist.";
                    throw new UserStoreException(errorMessage);
                }
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while modifying the role list of user: " + userName;
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        catch (UnsupportedEncodingException e) {
            String errorMessage = "Error occurred while encoding the role value.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(mainDirContext);
        }
    }

    private String getGroupName(SearchResult resultedGroup) throws NamingException {
        Attribute attribute = resultedGroup.getAttributes().get(this.realmConfig.getUserStoreProperty("GroupNameAttribute"));
        if (attribute == null) {
            return resultedGroup.getName();
        }
        String groupNameAttributeValue = (String)attribute.get();
        return this.realmConfig.getUserStoreProperty("GroupNameAttribute") + "=" + groupNameAttributeValue;
    }

    @Override
    public void doUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        throw new UserStoreException("Operation is not supported.");
    }

    @Override
    public void doUpdateUserListOfRoleWithID(String roleName, String[] deletedUserIDs, String[] newUserIDs) throws UserStoreException {
        List<String> deletedUsers = this.getUserNamesFromUserIDs(Arrays.asList(deletedUserIDs));
        List<String> newUsers = this.getUserNamesFromUserIDs(Arrays.asList(newUserIDs));
        NamingEnumeration<SearchResult> groupSearchResults = null;
        LDAPRoleContext ctx = (LDAPRoleContext)this.createRoleContext(roleName);
        roleName = ctx.getRoleName();
        String searchFilter = ctx.getSearchFilter();
        if (this.isExistingLDAPRole(ctx)) {
            DirContext mainDirContext = this.connectionSource.getContext();
            try {
                CharSequence invalidUserList;
                searchFilter = searchFilter.replace("?", this.escapeSpecialCharactersForFilter(roleName));
                String membershipAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                String roleNameAttribute = this.realmConfig.getUserStoreProperty("GroupNameAttribute");
                String[] returningAttributes = new String[]{membershipAttributeName, roleNameAttribute};
                String searchBase = ctx.getSearchBase();
                groupSearchResults = this.searchInGroupBase(searchFilter, returningAttributes, 2, mainDirContext, searchBase);
                SearchResult resultedGroup = null;
                String groupName = null;
                while (groupSearchResults.hasMoreElements()) {
                    resultedGroup = groupSearchResults.next();
                    groupName = this.getGroupName(resultedGroup);
                }
                Attribute returnedMemberAttribute = resultedGroup.getAttributes().get(membershipAttributeName);
                if (!this.emptyRolesAllowed && newUsers.size() - deletedUsers.size() + returnedMemberAttribute.size() == 0) {
                    String errorMessage = "There should be at least one member in the role. Hence can not delete all the members.";
                    throw new UserStoreException(errorMessage);
                }
                ArrayList<String> newUserList = new ArrayList<String>();
                ArrayList<String> deleteUserList = new ArrayList<String>();
                HashMap<String, String> userDnToUserNameMapping = new HashMap<String, String>();
                if (!newUsers.isEmpty()) {
                    invalidUserList = EMPTY_ATTRIBUTE_STRING;
                    Object existingUserList = EMPTY_ATTRIBUTE_STRING;
                    for (String newUser : newUsers) {
                        if (StringUtils.isEmpty((String)newUser)) continue;
                        String userNameDN = this.getNameInSpaceForUserName(newUser);
                        if (userNameDN == null) {
                            invalidUserList = (String)invalidUserList + newUser + " ";
                            continue;
                        }
                        if (this.isUserInRole(userNameDN, resultedGroup)) {
                            existingUserList = (String)existingUserList + userNameDN + ",";
                            continue;
                        }
                        newUserList.add(userNameDN);
                    }
                    if (!StringUtils.isEmpty((String)invalidUserList) || !StringUtils.isEmpty((String)existingUserList)) {
                        String errorMessage = (StringUtils.isEmpty((String)invalidUserList) ? EMPTY_ATTRIBUTE_STRING : "'" + (String)invalidUserList + "' not in the user store. ") + (StringUtils.isEmpty((String)existingUserList) ? EMPTY_ATTRIBUTE_STRING : "'" + (String)existingUserList + "' already belong to the role : " + roleName);
                        throw new UserStoreException(errorMessage);
                    }
                }
                if (!deletedUsers.isEmpty()) {
                    invalidUserList = new StringBuilder();
                    for (String deletedUser : deletedUsers) {
                        if (StringUtils.isEmpty((String)deletedUser)) continue;
                        String userNameDN = this.getNameInSpaceForUserName(deletedUser);
                        if (userNameDN == null) {
                            ((StringBuilder)invalidUserList).append(deletedUser).append(",");
                            continue;
                        }
                        deleteUserList.add(userNameDN);
                        userDnToUserNameMapping.put(userNameDN, deletedUser);
                    }
                    if (!StringUtils.isEmpty((String)((StringBuilder)invalidUserList).toString())) {
                        String errorMessage = "'" + invalidUserList + "' not in the user store.";
                        throw new UserStoreException(errorMessage);
                    }
                }
                for (String userNameDN : newUserList) {
                    this.modifyUserInRole(userNameDN, groupName, 1, searchBase);
                }
                for (String userNameDN : deleteUserList) {
                    this.modifyUserInRole(userNameDN, groupName, 3, searchBase);
                    String deletedUserName = (String)userDnToUserNameMapping.get(userNameDN);
                    String deletedUserNameWithDomain = UserCoreUtil.addDomainToName(deletedUserName, this.getMyDomainName());
                    this.userRealm.getAuthorizationManager().clearUserAuthorization(deletedUserNameWithDomain);
                }
            }
            catch (NamingException e) {
                String errorMessage = "Error occurred while modifying the user list of role: " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            finally {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(mainDirContext);
            }
        } else {
            String errorMessage = "The role: " + roleName + " does not exist.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage);
            }
            throw new UserStoreException(errorMessage);
        }
    }

    protected void modifyUserInRole(String userNameDN, String groupRDN, int modifyType, String searchBase) throws UserStoreException {
        if (log.isDebugEnabled()) {
            logger.debug((Object)("Modifying role: " + groupRDN + " with type: " + modifyType + " user: " + userNameDN + " in search base: " + searchBase));
        }
        DirContext mainDirContext = null;
        DirContext groupContext = null;
        try {
            mainDirContext = this.connectionSource.getContext();
            groupContext = (DirContext)mainDirContext.lookup(this.escapeDNForSearch(searchBase));
            String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
            BasicAttributes modifyingAttributes = new BasicAttributes(true);
            BasicAttribute memberAttribute = new BasicAttribute(memberAttributeName);
            memberAttribute.add(userNameDN);
            modifyingAttributes.put(memberAttribute);
            groupContext.modifyAttributes(groupRDN, modifyType, (Attributes)modifyingAttributes);
            if (log.isDebugEnabled()) {
                logger.debug((Object)("User: " + userNameDN + " was successfully modified in LDAP group: " + groupRDN));
            }
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while modifying user entry: " + userNameDN + " in LDAP role: " + groupRDN;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    protected boolean isUserInRole(String userDN, SearchResult groupEntry) throws UserStoreException {
        boolean isUserInRole = false;
        try {
            Attributes groupAttributes = groupEntry.getAttributes();
            if (groupAttributes != null) {
                NamingEnumeration<? extends Attribute> attributes = groupAttributes.getAll();
                while (attributes.hasMoreElements()) {
                    Attribute memberAttribute = attributes.next();
                    String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                    if (!memberAttributeName.equalsIgnoreCase(memberAttribute.getID())) continue;
                    for (int i = 0; i < memberAttribute.size(); ++i) {
                        if (!userDN.equalsIgnoreCase((String)memberAttribute.get(i))) continue;
                        return true;
                    }
                }
                attributes.close();
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while looping through attributes set of group: " + groupEntry.getNameInNamespace();
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return isUserInRole;
    }

    protected boolean isOnlyUserInRole(String userDN, SearchResult groupEntry) throws UserStoreException {
        boolean isOnlyUserInRole = false;
        try {
            Attributes groupAttributes = groupEntry.getAttributes();
            if (groupAttributes != null) {
                NamingEnumeration<? extends Attribute> attributes = groupAttributes.getAll();
                while (attributes.hasMoreElements()) {
                    String attributeID;
                    Attribute memberAttribute = attributes.next();
                    String memberAttributeName = this.realmConfig.getUserStoreProperty("MembershipAttribute");
                    if (!memberAttributeName.equals(attributeID = memberAttribute.getID()) || memberAttribute.size() != 1 || !userDN.equals(memberAttribute.get())) continue;
                    return true;
                }
                attributes.close();
            }
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while looping through attributes set of group: " + groupEntry.getNameInNamespace();
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return isOnlyUserInRole;
    }

    protected void updateLDAPRoleName(RoleContext context, String newRoleName) throws UserStoreException {
        String roleName = context.getRoleName();
        String groupSearchFilter = ((LDAPRoleContext)context).getSearchFilter();
        String roleNameAttributeName = ((LDAPRoleContext)context).getRoleNameProperty();
        String searchBase = ((LDAPRoleContext)context).getSearchBase();
        DirContext mainContext = this.connectionSource.getContext();
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            groupSearchFilter = groupSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(roleName));
            String[] returningAttributes = new String[]{roleNameAttributeName};
            groupSearchResults = this.searchInGroupBase(groupSearchFilter, returningAttributes, 2, mainContext, searchBase);
            SearchResult resultedGroup = null;
            while (groupSearchResults.hasMoreElements()) {
                resultedGroup = groupSearchResults.next();
            }
            if (resultedGroup == null) {
                throw new UserStoreException("Could not find user role " + roleName + " in LDAP server.");
            }
            String groupNameRDN = resultedGroup.getName();
            String newGroupNameRDN = roleNameAttributeName + "=" + newRoleName;
            groupContext = (DirContext)mainContext.lookup(this.escapeDNForSearch(this.groupSearchBase));
            groupContext.rename(groupNameRDN, newGroupNameRDN);
            String roleNameWithDomain = UserCoreUtil.addDomainToName(roleName, this.getMyDomainName());
            String newRoleNameWithDomain = UserCoreUtil.addDomainToName(newRoleName, this.getMyDomainName());
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleNameWithDomain, newRoleNameWithDomain);
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while modifying the name of role: " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(groupSearchResults);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainContext);
    }

    @Override
    public void doUpdateRoleName(String roleName, String newRoleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        this.updateLDAPRoleName(roleContext, newRoleName);
        if (roleContext.isShared()) {
            roleName = roleName + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            roleContext = this.createRoleContext(roleName);
            this.updateLDAPRoleName(roleContext, newRoleName);
        }
    }

    protected void deleteLDAPRole(RoleContext context) throws UserStoreException {
        String roleName = context.getRoleName();
        String groupSearchFilter = ((LDAPRoleContext)context).getSearchFilter();
        groupSearchFilter = groupSearchFilter.replace("?", this.escapeSpecialCharactersForFilter(context.getRoleName()));
        String[] returningAttributes = new String[]{((LDAPRoleContext)context).getRoleNameProperty()};
        String searchBase = ((LDAPRoleContext)context).getSearchBase();
        DirContext mainDirContext = null;
        DirContext groupContext = null;
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            mainDirContext = this.connectionSource.getContext();
            groupSearchResults = this.searchInGroupBase(groupSearchFilter, returningAttributes, 2, mainDirContext, searchBase);
            SearchResult resultedGroup = null;
            while (groupSearchResults.hasMoreElements()) {
                resultedGroup = groupSearchResults.next();
            }
            if (resultedGroup == null) {
                throw new UserStoreException("Could not find specified group/role - " + roleName);
            }
            groupContext = (DirContext)mainDirContext.lookup(this.escapeDNForSearch(this.groupSearchBase));
            String groupNameAttributeValue = (String)resultedGroup.getAttributes().get(this.realmConfig.getUserStoreProperty("GroupNameAttribute")).get();
            String groupName = this.realmConfig.getUserStoreProperty("GroupNameAttribute") + "=" + groupNameAttributeValue;
            if (groupNameAttributeValue.equals(roleName)) {
                groupContext.destroySubcontext(groupName);
            }
        }
        catch (NamingException e) {
            try {
                String errorMessage = "Error occurred while deleting the role: " + roleName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new UserStoreException(errorMessage, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeNamingEnumeration(groupSearchResults);
                JNDIUtil.closeContext(groupContext);
                JNDIUtil.closeContext(mainDirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeNamingEnumeration(groupSearchResults);
        JNDIUtil.closeContext(groupContext);
        JNDIUtil.closeContext(mainDirContext);
    }

    @Override
    public void doDeleteRole(String roleName) throws UserStoreException {
        RoleContext roleContext = this.createRoleContext(roleName);
        this.deleteLDAPRole(roleContext);
        if (roleContext.isShared()) {
            roleName = roleName + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            roleContext = this.createRoleContext(roleName);
            this.deleteLDAPRole(roleContext);
        }
    }

    private NamingEnumeration<SearchResult> searchInUserBase(String searchFilter, String[] returningAttributes, int searchScope, DirContext rootContext) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching user with " + searchFilter));
        }
        String userBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setReturningAttributes(returningAttributes);
        userSearchControl.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> userSearchResults = null;
        try {
            userSearchResults = rootContext.search(this.escapeDNForSearch(userBase), searchFilter, userSearchControl);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in user base.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return userSearchResults;
    }

    protected NamingEnumeration<SearchResult> searchInGroupBase(String searchFilter, String[] returningAttributes, int searchScope, DirContext rootContext, String searchBase) throws UserStoreException {
        SearchControls userSearchControl = new SearchControls();
        userSearchControl.setReturningAttributes(returningAttributes);
        userSearchControl.setSearchScope(searchScope);
        NamingEnumeration<SearchResult> groupSearchResults = null;
        try {
            groupSearchResults = rootContext.search(this.escapeDNForSearch(searchBase), searchFilter, userSearchControl);
        }
        catch (NamingException e) {
            String errorMessage = "Error occurred while searching in group base.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        return groupSearchResults;
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        super.checkRequiredUserStoreConfigurations();
        String userObjectClass = this.realmConfig.getUserStoreProperty("UserEntryObjectClass");
        if (userObjectClass == null || userObjectClass.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required UserEntryObjectClass property is not set at the LDAP configurations");
        }
        if (this.realmConfig.getUserStoreProperty("WriteGroups") != null) {
            this.writeGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("WriteGroups"));
        }
        if (log.isDebugEnabled()) {
            if (this.writeGroupsEnabled) {
                log.debug((Object)("WriteGroups is enabled for " + this.getMyDomainName()));
            } else {
                log.debug((Object)("WriteGroups is disabled for " + this.getMyDomainName()));
            }
        }
        if (!this.writeGroupsEnabled) {
            if (this.realmConfig.getUserStoreProperty("ReadGroups") != null) {
                this.readGroupsEnabled = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("ReadGroups"));
                log.debug((Object)("Read LDAP groups enabled: " + this.readGroupsEnabled));
            }
        } else {
            this.readGroupsEnabled = true;
            log.debug((Object)"Read LDAP groups enabled: true");
        }
        this.emptyRolesAllowed = Boolean.parseBoolean(this.realmConfig.getUserStoreProperty("EmptyRolesAllowed"));
        String groupEntryObjectClass = this.realmConfig.getUserStoreProperty("GroupEntryObjectClass");
        if (groupEntryObjectClass == null || groupEntryObjectClass.equals(EMPTY_ATTRIBUTE_STRING)) {
            throw new UserStoreException("Required GroupEntryObjectClass property is not set at the LDAP configurations");
        }
        this.userSearchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        this.groupSearchBase = this.realmConfig.getUserStoreProperty("GroupSearchBase");
    }

    private static void setAdvancedProperties() {
        UNIQUE_ID_RW_LDAP_UM_ADVANCED_PROPERTIES.clear();
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty(BULK_IMPORT_SUPPORT, "Bulk Import Support", "true", "Bulk Import Supported");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("EmptyRolesAllowed", "Allow Empty Roles", "true", "Specifies whether the underlying user store allows empty groups to be added");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty(PASSWORD_HASH_METHOD, "Password Hashing Algorithm", "PLAIN_TEXT", "Password Hash method to use when storing user entries");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty(MULTI_ATTRIBUTE_SEPARATOR, "Multiple Attribute Separator", ",", MULTI_ATTRIBUTE_SEPARATOR_DESCRIPTION);
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("MaxUserNameListLength", "Maximum User List Length", "100", "Maximum number of users retrieved at once");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("MaxRoleNameListLength", "Maximum Role List Length", "100", "Maximum number of groups retrieved at once");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("kdcEnabled", "Enable KDC", "false", "Whether key distribution center enabled");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("defaultRealmName", "Default Realm Name", "WSO2.ORG", "Default name for the realm");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("UserRolesCacheEnabled", "Enable User Role Cache", "true", "This is to indicate whether to cache the group list of a user");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("ConnectionPoolingEnabled", "Enable LDAP Connection Pooling", "false", "Set this property to enable LDAP connection pooling.");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty(LDAPConnectionTimeout, LDAPConnectionTimeoutDescription, "5000", LDAPConnectionTimeoutDescription);
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty(readTimeout, "LDAP Read Timeout", "5000", readTimeoutDescription);
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty(RETRY_ATTEMPTS, "Retry Attempts", "0", "Number of retries for authentication in case ldap read timed out.");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("CountRetrieverClass", "Count Implementation", EMPTY_ATTRIBUTE_STRING, "Name of the class that implements the count functionality");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("java.naming.ldap.attributes.binary", "LDAP binary attributes", " ", LDAPBinaryAttributesDescription);
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("ClaimOperationsSupported", "Claim Operations Supported", "true", "Whether the userstore supports claim read and write");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("MembershipAttributeRange", "Membership Attribute Range", String.valueOf(0), "Number of maximum users of role returned by the LDAP");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("UserCacheExpiryMilliseconds", "User Cache Expiry milliseconds", EMPTY_ATTRIBUTE_STRING, "Configure the user cache expiry in milliseconds. Values  {0: expire immediately, -1: never expire, '': i.e. empty, system default}.");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("UserDNCacheEnabled", "Enable User DN Cache", "true", "Enables the user cache. Default true, Unless set to false. Empty value is interpreted as true.");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("StartTLSEnabled", "Enable StartTLS", "false", "Enable secure connection by using StartTLS extended operation in LDAP");
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperty("ConnectionRetryDelay", "Connection Retry Delay", String.valueOf(120000), "Specifies waiting time in milliseconds inorder to establish the connection after couple of failure attempts.");
    }

    @Override
    public Properties getDefaultUserStoreProperties() {
        Properties properties = new Properties();
        properties.setMandatoryProperties((Property[])Stream.concat(ReadWriteLDAPUserStoreConstants.RWLDAP_USERSTORE_PROPERTIES.stream(), ReadWriteLDAPUserStoreConstants.UNIQUE_ID_RWLDAP_USERSTORE_PROPERTIES.stream()).toArray(Property[]::new));
        properties.setOptionalProperties(ReadWriteLDAPUserStoreConstants.OPTINAL_RWLDAP_USERSTORE_PROPERTIES.toArray(new Property[0]));
        properties.setAdvancedProperties(UNIQUE_ID_RW_LDAP_UM_ADVANCED_PROPERTIES.toArray(new Property[0]));
        return properties;
    }

    private void handleException(Exception e, String userName) throws UserStoreException {
        if (e instanceof InvalidAttributeValueException) {
            String errorMessage = "One or more attribute values provided are incompatible for user : " + userName + "Please check and try again.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof InvalidAttributeIdentifierException) {
            String errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof NoSuchAttributeException) {
            String errorMessage = "One or more attributes you are trying to add/update are not supported by underlying LDAP for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof NamingException) {
            String errorMessage = "Profile information could not be updated in LDAP user store for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
        if (e instanceof org.wso2.carbon.user.api.UserStoreException) {
            String errorMessage = "Error in obtaining claim mapping for user : " + userName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)errorMessage, (Throwable)e);
            }
            throw new UserStoreException(errorMessage, e);
        }
    }

    private String escapeSpecialCharactersForDN(String text) {
        boolean replaceEscapeCharacters = true;
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            if (text.length() > 0 && (text.charAt(0) == ' ' || text.charAt(0) == '#')) {
                sb.append('\\');
            }
            block9: for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        if (text.charAt(i + 1) == '*') {
                            sb.append("*");
                            ++i;
                            continue block9;
                        }
                        sb.append("\\\\");
                        continue block9;
                    }
                    case ',': {
                        sb.append("\\,");
                        continue block9;
                    }
                    case '+': {
                        sb.append("\\+");
                        continue block9;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '<': {
                        sb.append("\\<");
                        continue block9;
                    }
                    case '>': {
                        sb.append("\\>");
                        continue block9;
                    }
                    case ';': {
                        sb.append("\\;");
                        continue block9;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            if (text.length() > 1 && text.charAt(text.length() - 1) == ' ') {
                sb.insert(sb.length() - 1, '\\');
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("value after escaping special characters in " + text + " : " + sb.toString()));
            }
            return sb.toString();
        }
        return text;
    }

    private String escapeSpecialCharactersForFilter(String dnPartial) {
        boolean replaceEscapeCharacters = true;
        dnPartial.replace("\\*", "*");
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            replaceEscapeCharacters = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters configured to: " + replaceEscapeCharactersAtUserLoginString));
            }
        }
        if (replaceEscapeCharacters) {
            StringBuilder sb = new StringBuilder();
            block7: for (int i = 0; i < dnPartial.length(); ++i) {
                char currentChar = dnPartial.charAt(i);
                switch (currentChar) {
                    case '\\': {
                        sb.append("\\5c");
                        continue block7;
                    }
                    case '*': {
                        sb.append("\\2a");
                        continue block7;
                    }
                    case '(': {
                        sb.append("\\28");
                        continue block7;
                    }
                    case ')': {
                        sb.append("\\29");
                        continue block7;
                    }
                    case '\u0000': {
                        sb.append("\\00");
                        continue block7;
                    }
                    default: {
                        sb.append(currentChar);
                    }
                }
            }
            return sb.toString();
        }
        return dnPartial;
    }

    private static void setAdvancedProperty(String name, String displayName, String value, String description) {
        Property property = new Property(name, value, displayName + "#" + description, null);
        UNIQUE_ID_RW_LDAP_UM_ADVANCED_PROPERTIES.add(property);
    }

    static {
        UniqueIDReadWriteLDAPUserStoreManager.setAdvancedProperties();
    }
}

