/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.StartTlsResponseWrapper;

public class LdapContextWrapper
implements LdapContext {
    private static Log log = LogFactory.getLog(LdapContextWrapper.class);
    private StartTlsResponse startTlsResponse;
    private LdapContext ldapContext;
    private StartTlsResponseWrapper startTlsResponseWrapper;

    private LdapContextWrapper(LdapContext ldapContext, StartTlsResponse startTlsResponse) {
        this.ldapContext = ldapContext;
        this.startTlsResponse = startTlsResponse;
        this.startTlsResponseWrapper = new StartTlsResponseWrapper(this.startTlsResponse);
        this.startTlsResponseWrapper.incrementReferenceCounter();
    }

    private LdapContextWrapper(LdapContext ldapContext, StartTlsResponseWrapper startTlsResponseWrapper) {
        this.ldapContext = ldapContext;
        this.startTlsResponseWrapper = startTlsResponseWrapper;
        this.startTlsResponseWrapper.incrementReferenceCounter();
    }

    public static LdapContext startTLS(Hashtable<?, ?> environment, Control[] connectionControls) throws NamingException, UserStoreException {
        Hashtable<String, Object> tempEnv = LdapContextWrapper.getEnvironmentForSecuredLdapInitialization(environment);
        InitialLdapContext ldapContext = new InitialLdapContext(tempEnv, connectionControls);
        try {
            StartTlsResponse startTlsResponse = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
            startTlsResponse.negotiate();
            if (log.isDebugEnabled()) {
                log.debug((Object)"StartTLS connection established successfully with LDAP server");
            }
            LdapContextWrapper ldapContextWrapper = new LdapContextWrapper((LdapContext)ldapContext, startTlsResponse);
            ldapContextWrapper.performAuthenticationIfProvided(environment);
            return ldapContextWrapper;
        }
        catch (IOException e) {
            throw new UserStoreException("Unable to establish the StartTLS connection", e);
        }
    }

    private static Hashtable<String, Object> getEnvironmentForSecuredLdapInitialization(Hashtable<?, ?> environment) {
        Hashtable<String, Object> tempEnv = new Hashtable<String, Object>();
        for (Object key : environment.keySet()) {
            if ("java.naming.security.principal".equals(key) || "java.naming.security.credentials".equals(key) || "java.naming.security.authentication".equals(key)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Attribute " + key + " is skip adding to the environment for TLS LDAP initialization"));
                continue;
            }
            tempEnv.put((String)key, environment.get(key));
        }
        return tempEnv;
    }

    private void performAuthenticationIfProvided(Hashtable<?, ?> environment) throws NamingException {
        if (environment.containsKey("java.naming.security.authentication")) {
            this.ldapContext.addToEnvironment("java.naming.security.authentication", environment.get("java.naming.security.authentication"));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attribute java.naming.security.authentication is added to the TLS LdapContext environment");
            }
        }
        if (environment.containsKey("java.naming.security.principal")) {
            this.ldapContext.addToEnvironment("java.naming.security.principal", environment.get("java.naming.security.principal"));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attribute java.naming.security.principal is added to the TLS LdapContext environment");
            }
        }
        if (environment.containsKey("java.naming.security.credentials")) {
            this.ldapContext.addToEnvironment("java.naming.security.credentials", environment.get("java.naming.security.credentials"));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attribute java.naming.security.credentials is added to the TLS LdapContext environment");
            }
        }
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        return this.ldapContext.extendedOperation(request);
    }

    @Override
    public LdapContext newInstance(Control[] requestControls) throws NamingException {
        return new LdapContextWrapper(this.ldapContext.newInstance(requestControls), this.startTlsResponseWrapper);
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        this.ldapContext.reconnect(connCtls);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return this.ldapContext.getConnectControls();
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return this.ldapContext.getRequestControls();
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.ldapContext.setRequestControls(requestControls);
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.ldapContext.getResponseControls();
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.ldapContext.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.ldapContext.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.ldapContext.getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.ldapContext.getAttributes(name, attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.ldapContext.modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.ldapContext.modifyAttributes(name, mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.ldapContext.modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.ldapContext.modifyAttributes(name, mods);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.ldapContext.bind(name, obj, attrs);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.ldapContext.bind(name, obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.ldapContext.rebind(name, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.ldapContext.rebind(name, obj, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.createSubcontext(name, attrs), this.startTlsResponseWrapper);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.createSubcontext(name, attrs), this.startTlsResponseWrapper);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.getSchema(name), this.startTlsResponseWrapper);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.getSchema(name), this.startTlsResponseWrapper);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.getSchemaClassDefinition(name), this.startTlsResponseWrapper);
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.getSchemaClassDefinition(name), this.startTlsResponseWrapper);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.ldapContext.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.ldapContext.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.ldapContext.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.ldapContext.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.ldapContext.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.ldapContext.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.ldapContext.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.ldapContext.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.lookup(name), this.startTlsResponseWrapper);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.lookup(name), this.startTlsResponseWrapper);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.ldapContext.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.ldapContext.bind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.ldapContext.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.ldapContext.rebind(name, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.ldapContext.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.ldapContext.unbind(name);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.ldapContext.rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.ldapContext.rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.ldapContext.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.ldapContext.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.ldapContext.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.ldapContext.listBindings(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.ldapContext.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.ldapContext.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.createSubcontext(name), this.startTlsResponseWrapper);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return new LdapContextWrapper((LdapContext)this.ldapContext.createSubcontext(name), this.startTlsResponseWrapper);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.ldapContext.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.ldapContext.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.ldapContext.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.ldapContext.getNameParser(name);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.ldapContext.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.ldapContext.composeName(name, prefix);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.ldapContext.addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.ldapContext.removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.ldapContext.getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        try {
            this.startTlsResponseWrapper.close();
        }
        finally {
            this.ldapContext.close();
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.ldapContext.getNameInNamespace();
    }
}

